#!/usr/bin/env python

from distutils.core import setup
import glob
import os
import re

# set a default version number, in case we're not in a debianized source tree
version="0.0.1"
# look/set what version we have, this gets executed only if we're a debianized source tree
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)
        f=open("HUBackup/Version.py","w")
        f.write("VERSION=\"%s\"\n" % version)
        f.close()


GETTEXT_NAME="hubackup"
I18NFILES = []
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    I18NFILES.append((targetpath, [filepath]))

os.system("intltool-merge -d po data/hubackup.desktop.in"\
                       " build/hubackup.desktop")
os.system("intltool-merge -d po data/hurestore.desktop.in"\
                       " build/hurestore.desktop")


# HACK: make sure that the mo files are generated and up-to-date
os.system("cd po; make update-po")
    
setup(name='hubackup',
      version=version,
      packages=['HUBackup','HUBackup.GUI','HUBackup.common','HUBackup.backend'],
      scripts=['hubackup','hurestore'],
      data_files=[('share/hubackup/',["data/hubackup.glade"]),
                  ('share/hubackup/',["data/progress-dialog.glade"]),
                  ('share/hubackup/',["data/restore-progress.glade"]),                  
                  ('share/hubackup/',["data/hurestore.glade"]),
                  ('share/applications',["build/hubackup.desktop"]),
                  ('share/applications',["build/hurestore.desktop"])]+I18NFILES,
      )


