/* ------------------------------------------------------------ */
/*
HTTrack Website Copier, Offline Browser for Windows and Unix
Copyright (C) Xavier Roche and other contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


Important notes:

- We hereby ask people using this source NOT to use it in purpose of grabbing
emails addresses, or collecting any other private information on persons.
This would disgrace our work, and spoil the many hours we spent on it.


Please visit our Website: http://www.httrack.com
*/


/* ------------------------------------------------------------ */
/* File: Mini-server                                            */
/* Author: Xavier Roche                                         */
/* ------------------------------------------------------------ */

// Fichier intercepteur d'URL .h

#ifndef HTS_SERVER_DEFH
#define HTS_SERVER_DEFH 

#include "htsbasenet.h"

/* String */
#include "htsstrings.h"


// Fonctions
void socinput(T_SOC soc,char* s,int max);
T_SOC smallserver_init_std(int* port_prox,char* adr_prox);
T_SOC smallserver_init(int* port,char* adr);
int smallserver(T_SOC soc,char* url,char* method,char* data, char* path);

#define CATCH_RESPONSE \
  "HTTP/1.0 200 OK\r\n"\
  "Content-type: text/html\r\n"\
  "\r\n"\
  "<!-- Generated by HTTrack Website Copier -->\r\n"\
  "<HTML><HEAD>\r\n"\
  "<TITLE>Link caught!</TITLE>\r\n"\
  "<SCRIPT LANGUAGE=\"Javascript\">\r\n"\
  "<!--\r\n"\
  "function back() {\r\n"\
  "  history.go(-1);\r\n"\
  "}\r\n"\
  "// -->\r\n"\
  "</SCRIPT>\r\n"\
  "</HEAD>\r\n"\
  "<BODY>\r\n"\
  "<H2>Link captured into HTTrack Website Copier, you can now restore your proxy preferences!</H2>\r\n"\
  "<BR><BR>\r\n"\
  "<H3><A HREF=\"javascript:back();\">Clic here to go back</A></H3>\r\n"\
  "</BODY></HTML>"\
  "<!-- Generated by HTTrack Website Copier -->\r\n"\
  "\r\n"\

extern int NewLangStrSz;
extern inthash NewLangStr;
extern int NewLangStrKeysSz;
extern inthash NewLangStrKeys;
extern int NewLangListSz;
extern inthash NewLangList;

/* Spaces: CR,LF,TAB,FF */
#define  is_space(c)      ( ((c)==' ') || ((c)=='\"') || ((c)==10) || ((c)==13) || ((c)==9) || ((c)==12) || ((c)==11) || ((c)=='\'') )
#define  is_realspace(c)  ( ((c)==' ')                || ((c)==10) || ((c)==13) || ((c)==9) || ((c)==12) || ((c)==11)                )
#define  is_taborspace(c) ( ((c)==' ')                                          || ((c)==9)                             )
#define  is_quote(c)      (               ((c)=='\"')                                                    || ((c)=='\'') )
#define  is_retorsep(c)   (                              ((c)==10) || ((c)==13) || ((c)==9)                                          )

extern int smallserver_setkey(char* key, char* value);
extern int smallserver_setkeyint(char* key, LLint value);
extern int smallserver_setkeyarr(char* key, int id, char* key2, char* value);


/* Language files */
static int htslang_load(char* limit_to, char* apppath);
static void conv_printf(char* from,char* to);
static void LANG_DELETE(void);
static void LANG_INIT(char* path);
static int LANG_T(char* path, int l);
static int QLANG_T(int l);
static char* LANGSEL(char* name);
static char* LANGINTKEY(char* name);
static int LANG_SEARCH(char* path, char* iso);
static int LANG_LIST(char* path, char* buffer);

int htslang_init(void);
int htslang_uninit(void);

/* Static definitions */

static char* gethomedir(void);
static int linput_cpp(FILE* fp,char* s,int max);
static int linput_trim(FILE* fp,char* s,int max);
static char* concat(const char* a,const char* b);
static int fexist(char* s);
static int linput(FILE* fp,char* s,int max);
static int linputsoc_t(T_SOC soc, char* s, int max, int timeout);

static char* gethomedir(void) {
  char* home = getenv( "HOME" );
  if (home)
    return home;
  else
    return ".";
}
static int linput_cpp(FILE* fp,char* s,int max) {
  int rlen=0;
  s[0]='\0';
  do {
    int ret;
    if (rlen>0)
    if (s[rlen-1]=='\\')
      s[--rlen]='\0';      // couper \ final
    // lire ligne
    ret=linput_trim(fp,s+rlen,max-rlen);
    if (ret>0)
      rlen+=ret;
  } while((s[max(rlen-1,0)]=='\\') && (rlen<max));
  return rlen;
}
// copy of concat
typedef struct {
  char buff[16][HTS_URLMAXSIZE*2*2];
  int rol;
} concat_strc;
static char* concat(const char* a,const char* b) {
  static concat_strc* strc = NULL;
  if (strc == NULL) {
    strc = (concat_strc*) calloc(16, sizeof(concat_strc));
  }
  strc->rol=((strc->rol+1)%16);    // roving pointer
  strcpybuff(strc->buff[strc->rol],a);
  if (b) strcatbuff(strc->buff[strc->rol],b);
  return strc->buff[strc->rol];
}

static int fexist(char* s) {
  struct stat st;
  memset(&st, 0, sizeof(st));
  if (stat(s, &st) == 0) {
    if (S_ISREG(st.st_mode)) {
      return 1;
    }
  }
  return 0;
} 
static int linput(FILE* fp,char* s,int max) {
  int c;
  int j=0;
  do {
    c=fgetc(fp);
    if (c!=EOF) {
      switch(c) {
        case 13: break;  // sauter CR
        case 10: c=-1; break;
        case 0: case 9: case 12: break;  // sauter ces caractres
        default: s[j++]=(char) c; break;
      }
    }
  }  while((c!=-1) && (c!=EOF) && (j<(max-1)));
  s[j]='\0';
  return j;
}
static int linput_trim(FILE* fp,char* s,int max) {
  int rlen=0;
  char* ls=(char*) malloct(max+2);
  s[0]='\0';
  if (ls) {
    char* a;
    // lire ligne
    rlen=linput(fp,ls,max);
    if (rlen) {
      // sauter espaces et tabs en fin
      while( (rlen>0) && is_realspace(ls[max(rlen-1,0)]) )
        ls[--rlen]='\0';
      // sauter espaces en dbut
      a=ls;
      while((rlen>0) && ((*a==' ') || (*a=='\t'))) {
        a++;
        rlen--;
      }
      if (rlen>0) {
        memcpy(s,a,rlen);      // can copy \0 chars
        s[rlen]='\0';
      }
    }
    //
    freet(ls);
  }
  return rlen;
}

static void unescapeini(char* s, String* tempo) {
  int i;
  char lastc=0;
  for (i=0;i<(int) strlen(s);i++) {
    if (s[i]=='%' && s[i+1]=='%') {
      i++;
      StringAddchar(*tempo, lastc = '%');
    } else if (s[i]=='%') {
      char hc;
      i++;
      hc = (char) ehex(s+i);
      if (!is_retorsep(hc) || !is_retorsep(lastc)) {
        StringAddchar(*tempo, lastc = (char) hc);
      }
      i++;    // sauter 2 caractres finalement
    }
    else
      StringAddchar(*tempo, lastc = s[i]);
  }
}

#ifndef _WIN32
#define fconv(a) (a)
#define fconcat(a,b) concat(a,b)
#endif

#ifdef _WIN32
static char* __fconv(char* a) {
  int i;
  for(i=0;i<(int) strlen(a);i++)
    if (a[i]=='/')  // convertir
      a[i]='\\';
  return a;
}
static char* fconcat(char* a,char* b) {
  return __fconv(concat(a,b));
}
static char* fconv(char* a) {
  return __fconv(concat(a,""));
}
#endif

#endif



