<?php
/**
 * $Horde: horde/lib/Block/feed/reader.php,v 1.1.2.1 2008/01/14 20:34:48 chuck Exp $
 *
 * PHP 5 specific code for Horde_Block_Horde_feed segregated in a file
 * that isn't included by default to avoid fatal errors on PHP 4.
 *
 * @package Horde_Block
 */
class Horde_Block_Horde_feed_reader {

    public static function read($uri, $interval)
    {
        require_once 'Horde/Loader.php';

        $key = md5($uri);

        $GLOBALS['cache'] = &Horde_Cache::singleton($GLOBALS['conf']['cache']['driver'],
                                                    Horde::getDriverConfig('cache', $GLOBALS['conf']['cache']['driver']));

        $feed = $GLOBALS['cache']->get($key, $interval);
        if (!empty($feed)) {
            return unserialize($feed);
        }

        try {
            $feed = Horde_Feed::readUri($uri);
            $GLOBALS['cache']->set($key, serialize($feed));
            return $feed;
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

}
