/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DetectEq {
    static Pattern[] thm_patterns = new Pattern[]{Pattern.compile("(.*thm.*) (\\*|->) (.*thm.*) -> bool"), Pattern.compile("(.*injust.*) (\\*|->) (.*injust.*) -> bool"), Pattern.compile("(.*lineq.*) (\\*|->) (.*lineq.*) -> bool"), Pattern.compile("(.*goal.*) (\\*|->) (.*goal.*) -> bool")};
    static Pattern typattern = Pattern.compile(".*(thm|injust|lineq|goal).*");
    static String[] thm_funcs = new String[]{"union", "intersect", "subtract", "subset", "set_eq", "unions", "assoc", "rev_assoc", "assoc2", "uniq", "setify", "set_insert", "set_merge", "munion", "msubtract", "assocd", "rev_assocd", "apply", "|->", "dom", "graph"};

    static void skip(StringBuffer s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            s.delete(0, i);
            break;
        }
    }

    static int readnum(StringBuffer s) {
        int i = 0;
        while (true) {
            if (i == s.length() || !Character.isDigit(s.charAt(i))) {
                int num = Integer.parseInt(s.substring(0, i));
                s.delete(0, i);
                return num;
            }
            ++i;
        }
    }

    static void readtype(String s, Annotation a) {
        s = s.trim();
        block0: for (int i = 0; i < thm_patterns.length; ++i) {
            Matcher matcher = thm_patterns[i].matcher(s);
            while (matcher.find()) {
                String t2;
                String t1 = matcher.group(1).trim();
                if (!t1.equals(t2 = matcher.group(3).trim())) continue;
                a.type = t1;
                a.op = matcher.group(2);
                continue block0;
            }
        }
    }

    static Annotation parseAnnotation(LineNumberReader r, MLFile mlfile) throws Exception {
        Annotation annot = new Annotation();
        String line1 = r.readLine();
        if (line1 == null) {
            return null;
        }
        if (r.readLine() == null) {
            return null;
        }
        String line2 = "";
        while (true) {
            String l;
            if ((l = r.readLine()) == null) {
                return null;
            }
            if (")".equals(l = l.trim())) break;
            line2 = line2 + " " + l;
        }
        line2 = line2.trim();
        DetectEq.readtype(line2, annot);
        StringBuffer buf = new StringBuffer(line1);
        DetectEq.skip(buf);
        annot.line = DetectEq.readnum(buf);
        DetectEq.skip(buf);
        DetectEq.readnum(buf);
        DetectEq.skip(buf);
        annot.from = DetectEq.readnum(buf);
        DetectEq.skip(buf);
        DetectEq.readnum(buf);
        DetectEq.skip(buf);
        DetectEq.readnum(buf);
        DetectEq.skip(buf);
        annot.to = DetectEq.readnum(buf);
        annot.code = mlfile.get(annot.from, annot.to);
        annot.true_line = mlfile.line(annot.from);
        Matcher matcher = typattern.matcher(line2);
        if (annot.type == null && matcher.find()) {
            String s = mlfile.get(annot.from, annot.to);
            for (int i = 0; i < thm_funcs.length; ++i) {
                if (!s.equals(thm_funcs[i])) continue;
                annot.type = line2;
                annot.op = thm_funcs[i];
            }
        }
        return annot;
    }

    static Annotation[] readAnnotations(LineNumberReader r, MLFile mlfile) throws Exception {
        Annotation a;
        ArrayList<Annotation> array = new ArrayList<Annotation>(100);
        do {
            if ((a = DetectEq.parseAnnotation(r, mlfile)) == null) continue;
            array.add(a);
            if (a.type == null) continue;
            a.print();
        } while (a != null);
        Annotation[] as = new Annotation[array.size()];
        for (int i = 0; i < as.length; ++i) {
            as[i] = (Annotation)array.get(i);
        }
        return as;
    }

    public static void main(String[] args) throws Exception {
        File annot = new File(args[0], "core.annot");
        File ml = new File(args[0], "core.ml");
        MLFile mlfile = new MLFile(ml);
        LineNumberReader in_annot = new LineNumberReader(new FileReader(annot));
        Annotation[] as = DetectEq.readAnnotations(in_annot, mlfile);
        in_annot.close();
        System.out.println("count: " + as.length);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            String s = reader.readLine();
            int line = Integer.parseInt(s);
            for (int i = 0; i < as.length; ++i) {
                if (as[i].line != line) continue;
                System.out.println(line + " -> " + as[i].true_line);
                continue block0;
            }
            System.out.println("line not found");
        }
    }

    static class MLFile {
        File f;
        byte[] data;
        TreeMap lines;

        MLFile(File f) throws Exception {
            this.f = f;
            this.data = new byte[(int)f.length()];
            FileInputStream in = new FileInputStream(f);
            in.read(this.data);
            in.close();
            this.prepareLineLookup();
        }

        void prepareLineLookup() {
            this.lines = new TreeMap();
            int line = 1;
            int from = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if ((char)this.data[i] != '\n') continue;
                Interval v = new Interval(line, from, i);
                this.lines.put(v, v);
                ++line;
                from = i + 1;
            }
            Interval v = new Interval(line, from, this.data.length);
            this.lines.put(v, v);
        }

        String get(int from, int to) {
            StringBuffer buf = new StringBuffer(to - from);
            for (int i = from; i < to; ++i) {
                int c = this.data[i];
                if (c < 0) {
                    c += 256;
                }
                buf.append((char)c);
            }
            return buf.toString();
        }

        int line(int pos) {
            return ((Interval)this.lines.get((Object)new Interval((int)0, (int)pos, (int)pos))).line;
        }
    }

    static class Interval
    implements Comparable {
        int line;
        int from;
        int to;

        Interval(int l, int f, int t) {
            this.line = l;
            this.from = f;
            this.to = t;
        }

        public int compareTo(Object o) {
            Interval y = (Interval)o;
            if (y.from <= this.from && y.to >= this.to || this.from <= y.from && this.to >= y.from) {
                return 0;
            }
            if (this.from < y.from) {
                return -1;
            }
            if (this.from > y.from) {
                return 1;
            }
            if (this.to < y.to) {
                return -1;
            }
            return 1;
        }
    }

    static class Annotation {
        String type;
        String op;
        String code;
        int from;
        int to;
        int line;
        int true_line;

        Annotation() {
        }

        void print() {
            System.out.println("from: " + this.from + ", to: " + this.to + ", type: " + this.type + ", op: " + this.op);
            System.out.println("line: " + this.true_line + ", code: " + this.code);
            System.out.println("");
        }

        public boolean equals(Annotation a) {
            return a.from == this.from && a.to == this.to;
        }
    }
}

