/* $Id: uint64_table.cc 1350 2006-08-04 16:53:56Z holger $
 *
 * HoiChess/uint64_table.cc
 */

#include "common.h"

/* To share an opening book between different architectures
 * (which are likely to have different rand() implementations),
 * we need some static random numbers for use as hash keys. */
uint64_t uint64_table[] = {
	0xac5372998e7fa920ULL,
	0x8b9287c4f3be1092ULL,
	0x8014fbf5e78fe2b3ULL,
	0xfa00a57c1c8aa786ULL,
	0x2ec1e9271c282cf5ULL,
	0xd0a5c7546ea8bdcULL,
	0x5462e59e577c3634ULL,
	0x12954a162eb91797ULL,
	0xd479ab5d8e694519ULL,
	0xadc24340b231f6e2ULL,
	0x953eaeda3647dbcULL,
	0xd7c3408ed070eddfULL,
	0x9b8a6322dc2b47c3ULL,
	0xd0faf849bbaf3ed7ULL,
	0xe4b3b3d0db51a818ULL,
	0x2929215c946aa57bULL,
	0xe689ed10cf0a3682ULL,
	0xc0266e6d28141f95ULL,
	0x6a9d9698f2e1e3a5ULL,
	0x156293e0e6cfa24bULL,
	0xe88d11dfe0762192ULL,
	0x46ddcd630e88d4a1ULL,
	0x692affd61496e17aULL,
	0x4880cb52b4de0cd4ULL,
	0x7b501aa47553f74eULL,
	0x44f0dc817329bdb9ULL,
	0x789eb9a76a04ac28ULL,
	0xb66d6eaad1873443ULL,
	0x4ff15e00d076527aULL,
	0x40eca4bd9f5476abULL,
	0xdbe1157b7243817eULL,
	0xa424656aa44ff5f4ULL,
	0xf5ab0087f3e0d020ULL,
	0xa6ea55f0b818e805ULL,
	0x7757f048b0dde69fULL,
	0xe54c56a0c373c950ULL,
	0x51e6dd7a2bf4d640ULL,
	0x676e30d7dc599a2ULL,
	0x3ff443601c101e1cULL,
	0x2fee07585e805df2ULL,
	0x71ffed2c655f55d4ULL,
	0xb4587bcc3515768ULL,
	0x9627841b7983d776ULL,
	0x7dac7bb5879a4953ULL,
	0x9da7e26a91519edeULL,
	0x9b8bea01d11f6188ULL,
	0x6ecfd4e75e39d4a8ULL,
	0xb7403b2f32e1a32cULL,
	0x237077c3afc87cbcULL,
	0x46662d01d11bffa9ULL,
	0x3940fa7c7c607dc0ULL,
	0x2cda89b83a2b12d6ULL,
	0xf5ec34ebdb8fb2d9ULL,
	0xa78c48a4bc354e99ULL,
	0x8fc7ba0b3bae7103ULL,
	0xf04f9f4eba78adedULL,
	0xa67856c082f7a10fULL,
	0x71b30fb68d4b40c6ULL,
	0xebda4f499a6d81b1ULL,
	0x6ec85b0295f417fcULL,
	0x7d5aad9c012bb65eULL,
	0x546f62fcd1cd878cULL,
	0x78f1ed06a6211484ULL,
	0xb9aa20022f23a096ULL,
	0x904600857b312733ULL,
	0x54be945cbb9948f2ULL,
	0x382e4fd7cd98fe9cULL,
	0x2b76d9ebdd96afb1ULL,
	0x6c20755ea5762b87ULL,
	0x8d4e08e5a29284e7ULL,
	0xd1fc8727e81b1bf1ULL,
	0xf3b73ea4238dfe6aULL,
	0xe1766208e21d609aULL,
	0xa73a10e4d18cabedULL,
	0x276ab3784ffcaeb4ULL,
	0xdde2ac3f5efaba83ULL,
	0x15b7cc684e390f57ULL,
	0xa12031d1aaaefd1eULL,
	0x23b9a267790b86f2ULL,
	0x518404a0f1a37b0aULL,
	0xf7a8d936733e791ULL,
	0x6e64a5587965373ULL,
	0x377322483db142f1ULL,
	0xc1773cfdd040fe59ULL,
	0xafc8768c0922cc86ULL,
	0xcf0a22358da7adb0ULL,
	0xc0dad99e4579bd83ULL,
	0x64574f8bf13a4869ULL,
	0x9c7d25fc5c850002ULL,
	0x2237d12ab2aec1faULL,
	0x80245d918e361e76ULL,
	0x8a4ba3afd343df65ULL,
	0xf3318982d45f5e30ULL,
	0x14d2bc98598ec56fULL,
	0x67d1385c9458fc6bULL,
	0x1efde9ef5061cff5ULL,
	0x5a7fdebbc82c5bf6ULL,
	0xf33860cbfbd1651fULL,
	0x82c1f18828cdc96cULL,
	0xed309940526f7b03ULL,
	0xf6af35974429d13eULL,
	0x9c4ea24dc2dbaebaULL,
	0xcbf656810b7ce5d5ULL,
	0x6cbb77cacf3c87b0ULL,
	0xce402b39b8d0a2d9ULL,
	0xdc60d993aa019d2aULL,
	0xed074c495fdb83eULL,
	0x1bee7560b4e0f620ULL,
	0xd749bb5053d2a8f4ULL,
	0x1a8f5d3d14c0b173ULL,
	0xca58481cf84c1714ULL,
	0x8dc5c5498189f293ULL,
	0xc60575763e94e795ULL,
	0xc71898b84b4cf409ULL,
	0x84ea3ce6ff5d145fULL,
	0x89c009ff5aa0fcfaULL,
	0xa78213689da359b5ULL,
	0xf2546df550101db8ULL,
	0xe374b642c8780521ULL,
	0x8d1591597f9441c5ULL,
	0xb4ab5568b9a7c5c0ULL,
	0xcc5e6ab793c413eeULL,
	0xd7aba1d174f85de9ULL,
	0xc49323a91f5167bcULL,
	0xe6ea45b184b8e834ULL,
	0xcd7988f6fde8a037ULL,
	0xb694a954c9c0aa23ULL,
	0x1c4a0e3097294621ULL,
	0x4d390d2752044d1bULL,
	0xb553e53b17f539edULL,
	0x9f025cf6a7cc4e78ULL,
	0x50b48ab5c2d2df18ULL,
	0xc62e3dd8e1dc9dacULL,
	0x2f5d9e66b46b113cULL,
	0xdc87db0eeb7b38eaULL,
	0x777a8fefc19c99edULL,
	0x5349d507847cc330ULL,
	0x5a5174c6f67a52faULL,
	0x56f5181e718f7e8cULL,
	0x7cc3c1e98a04df76ULL,
	0xce561b50fc20c342ULL,
	0x558b5af060363aa8ULL,
	0x5f8fae3fa1aa8fddULL,
	0xbc443e60955ca5dcULL,
	0x462f8bb6bf8c6040ULL,
	0x9f968a4920fe1f7fULL,
	0x4e174f12f0bd0c07ULL,
	0x44b134bdc8d40aa5ULL,
	0xdff2c70c7fdb7a90ULL,
	0x51593b600334649dULL,
	0x42586047653e96c0ULL,
	0x8f39d2b91ea503b2ULL,
	0x4b4755a6d95bb573ULL,
	0xbb156584e55f592eULL,
	0x37e4ae4b627c239bULL,
	0x6895b7bdcf5e58f9ULL,
	0x60bdf1ddc0890c09ULL,
	0x638aa6907b9d46bULL,
	0x194e07cab079d67fULL,
	0x805fcf22353aa59bULL,
	0x6d20de966d6f2c51ULL,
	0x7041f49502ab2aa0ULL,
	0x8fea5a1d6a348286ULL,
	0xc56ae110d28ca6d7ULL,
	0x614b5a25c5fbd2d4ULL,
	0xfa7be347bee59b70ULL,
	0x6a1176d3254f89c4ULL,
	0x12508b7e7d8ac8e6ULL,
	0xd6f09ea3fe98c1efULL,
	0xdf679e6f7f691d95ULL,
	0xca4f526560531e9eULL,
	0xfc77cf81d4313f65ULL,
	0x58ee36071cfbd2cdULL,
	0x70d845734d41cbb2ULL,
	0x2ce8c74d1be9edf4ULL,
	0x27e1deb972584f64ULL,
	0xc570744e53994474ULL,
	0x572e19946cf59c49ULL,
	0x47b9f852d4c355ddULL,
	0xb9c5edbde6176769ULL,
	0x7f28a822f0a6a08fULL,
	0x78dd86f04ca32625ULL,
	0xa910d0a06545aa06ULL,
	0x4a95cdc43a11f482ULL,
	0x69809de2707a9e15ULL,
	0xf41652fb4aba4120ULL,
	0x5c9b9cfdd670459dULL,
	0x8646a487380a3489ULL,
	0x18155e2a4377fb3dULL,
	0xa2a4b3233eff191aULL,
	0xc0447e16847589daULL,
	0x188d8cee0d7cc7a6ULL,
	0xfe192bf6dfb0bb1cULL,
	0x43b68f131dcbe766ULL,
	0x1a2d2c6ca017eb12ULL,
	0x69acb746fdcb01b4ULL,
	0xc4426a325ac99471ULL,
	0xfa5c3eacc862516aULL,
	0xe84906f63550ba7cULL,
	0x7cc0c6d909d26fecULL,
	0xdfeffbebba05a9cfULL,
	0xa10d2049c938c77bULL,
	0xe33a35b98ca36d81ULL,
	0xfe584a1ea656c141ULL,
	0xf1bbe2e08e390f2dULL,
	0x157d3f77c77faa5cULL,
	0xb78e46ebe2ee274ULL,
	0xf8d3cfbd1f68e506ULL,
	0x71201edc326d5d5bULL,
	0x6ee560b118473262ULL,
	0x579d848438e2ccfdULL,
	0xd75a0d640ff7a49cULL,
	0xdad0e72689756e75ULL,
	0xce85335de8c1fe07ULL,
	0x7508c8f73f72c32eULL,
	0xad5fd0defcf13fdaULL,
	0x35eebe90270c8547ULL,
	0x7f26dd0af55fe16fULL,
	0x65464e6ddbbb0fc2ULL,
	0x1a06f26eda5f8068ULL,
	0x24bb634a3034df62ULL,
	0x15e86c3b93eea116ULL,
	0x50360c40ab3ed857ULL,
	0xdaeeb8ce1a5f53dULL,
	0xfe00c9bfab0d9772ULL,
	0xbf6d05cca57a6977ULL,
	0xad1f7fd49f89492cULL,
	0xdd810eaff5550b41ULL,
	0x58f1865dc1fecaeULL,
	0xf02fbe30f9218527ULL,
	0xcee6b5a99d52cf56ULL,
	0xc238fb521926b09bULL,
	0xcf80be8634e03790ULL,
	0xe27027580c5b8b9dULL,
	0x714b23e0da4f9038ULL,
	0xa434d1dc1afcb047ULL,
	0x6df2c9e3d7e4170bULL,
	0x9feadea12e8820f4ULL,
	0xde8cd3f8a8c1550eULL,
	0xafc379aa6bada279ULL,
	0x37891e56f9e19baULL,
	0x704dce81e4ce8d5cULL,
	0xfc9e3a27ba433e2ULL,
	0xf54c8a1d22b3295bULL,
	0xdf4b813571d87c0dULL,
	0xb6bfe2be971c6939ULL,
	0x5cc5c839a9098b54ULL,
	0x183c32115359eca7ULL,
	0xcbbc2b6f7197152cULL,
	0x48a2ef572ce10ea8ULL,
	0x9d03358be067e1f9ULL,
	0xbf27d64d700ce911ULL,
	0xcd0acecb2ad09666ULL,
	0x8c034ed1213b9cfULL,
	0x9a8b3df72916c3b3ULL,
	0xfc65f0528bf31a13ULL,
	0x52c8a29bd3d636caULL,
	0xc724cfcd7dd126aeULL,
	0xda05a3cadbfd5485ULL,
	0x3891ba98672d4cbaULL,
	0x65df7426c0774156ULL,
	0xea11d614ed8f25a4ULL,
	0xd7e082172ca89522ULL,
	0x290d1124991f9ea1ULL,
	0x2b7ded73d5cdabaaULL,
	0x116f3d073e1d17bULL,
	0xe77bfdc15d54c98cULL,
	0x83f23aea6ec772cfULL,
	0x62c69efdf790a255ULL,
	0x57eca62a5f00dddbULL,
	0xcd36e014a182c623ULL,
	0x5991a87514e7c7a2ULL,
	0x9bd843d50bdab9abULL,
	0x710fdcb2320fc812ULL,
	0xb507793258cfb99bULL,
	0xe4519f0b2ee94368ULL,
	0xfa7553b0dd3e2b41ULL,
	0x8bbabba53f4360d1ULL,
	0x8cbe9f7e079b84aULL,
	0x9a7af6406ff8bb8ULL,
	0xcbe0efea9067fa2ULL,
	0x4e85f238e0645a49ULL,
	0xb51cd20c9b93225eULL,
	0xeac67e570dbfd22ULL,
	0x95ee95437fa1bf73ULL,
	0x12eee6b0eef0d96aULL,
	0xe5df3143746e1ca1ULL,
	0xe0b527e7bd540510ULL,
	0x4890d509351903fbULL,
	0x8a6d9d699ed8cdc2ULL,
	0x3df8ec2c8a1a4877ULL,
	0xebd57d743b7bc001ULL,
	0x848e91bb52d74ca7ULL,
	0xff08fe8ba93b43b0ULL,
	0xd7fe00434ad5d955ULL,
	0xda10233ff485c8e0ULL,
	0x4b84ea86d5e767e4ULL,
	0x3df62d7979100d04ULL,
	0x5e9b29f250b29a7fULL,
	0x2e8bdc935509fb8eULL,
	0x4457b1fd150ba7c7ULL,
	0x70b8be19230ec317ULL,
	0xb82a8e0f12a5d74bULL,
	0xb5521c9aacf4c3a4ULL,
	0xf882708ade85a47eULL,
	0xc8d37a43e0505433ULL,
	0xa01f0e81780c94cdULL,
	0x89a4e129d06cff31ULL,
	0x3a2adac6ec8c8979ULL,
	0x3e8873d1857f9a06ULL,
	0x43df20ad884cb226ULL,
	0x5b43a8365a19dd0cULL,
	0x1f03cffabb6126fdULL,
	0x317d9a43820a9c03ULL,
	0x3404c29e0ebc3d80ULL,
	0xd10afc9cc494f53dULL,
	0x24ee469b9185fcb0ULL,
	0x948c2b2abf8f2481ULL,
	0xa5ac078824b9bf2eULL,
	0xbafc1548247cda19ULL,
	0x54b2bc1fdddd8465ULL,
	0x5e4dd3ca925a59f2ULL,
	0x48d02066d4c9b82fULL,
	0x15b40b34d1fba5bbULL,
	0x57f0228bc6aaf8ceULL,
	0xf5beb656c47c7776ULL,
	0xdbd23c22758c9faULL,
	0x262048e8a011c252ULL,
	0xa1a097c7d4f8f7acULL,
	0xb067992c60963d05ULL,
	0x23d98b493a5bfe53ULL,
	0xfbc0491433c12b78ULL,
	0x7f7ae08d01d8453bULL,
	0xe78a94ec33b6c19dULL,
	0x36b7447546202034ULL,
	0x3bd73878b576ccb2ULL,
	0x53608d86c5c89181ULL,
	0x62b15038544c9b20ULL,
	0x261e5292f752e46aULL,
	0xb085f1c2962b24c2ULL,
	0xaa76d33850431304ULL,
	0xac7b179a1b5bf3fdULL,
	0xd9ec2a08c51f1b48ULL,
	0x61816237703e98b0ULL,
	0x858bcbb988f03cd7ULL,
	0x66900f7154977533ULL,
	0x1f101d8c14dd6ffULL,
	0x1c686be9e24d5569ULL,
	0x1d6c4ca5c05114ffULL,
	0x79c7932206b0359cULL,
	0xde706d6b0ef5d259ULL,
	0xaced509304bcee2dULL,
	0x96bdeae496f3f089ULL,
	0x5ebc8cf8946cf5beULL,
	0x98c3eec0246770adULL,
	0x22560e48f2b938f2ULL,
	0x73e3d0aa24470c58ULL,
	0xab7ae4b24089c5f7ULL,
	0x9cd95b5b976c97ceULL,
	0xe81cc49fa710d96ULL,
	0xfcf334d5d693db37ULL,
	0xd1968eed815d61e1ULL,
	0x13e136dd35edf1c6ULL,
	0x80b74eeba4e012aaULL,
	0xe10dc820c52f891ULL,
	0x52afb6bb931de98cULL,
	0x2b13420ffc17b735ULL,
	0x3f4524ccc0aab286ULL,
	0x5fc5d9d588b9b421ULL,
	0x694f632e3785eab1ULL,
	0xfbde92fbdc2ee74fULL,
	0x42298b48100c7500ULL,
	0xc6faf190029fd483ULL,
	0xd0d1d9d63d58cd23ULL,
	0x209dbb6254575aecULL,
	0xbf6c54fc62aa12f1ULL,
	0x65a6d550db8bd612ULL,
	0xd89347d629f42afbULL,
	0x15839983dc6f75d4ULL,
	0xcfcbba737a45d0d4ULL,
	0x638e620403504c1aULL,
	0xdbb0cd4984d08132ULL,
	0x72ae7e8fdf0dd3faULL,
	0x9973363a972d20b7ULL,
	0x24a5f2776b8a8bfULL,
	0xcedf0e4886c52f9dULL,
	0xb2dff5e397904d71ULL,
	0x6cf6077837120f00ULL,
	0x2a1e8f7b105f8325ULL,
	0xd591eaf7a5793977ULL,
	0x5b06d6a06dbb0d72ULL,
	0xf107bb2584eaec26ULL,
	0xb89df019a6bceb3eULL,
	0xdce57e686e532063ULL,
	0xaf368c26c039bc9cULL,
	0x7d1cbe311f6bdec1ULL,
	0x56c8f331486d6bf4ULL,
	0xf3eecc086ad92a05ULL,
	0xaf747706d8db2b1eULL,
	0xab2cc59b7efd6329ULL,
	0x3f877b2d260a565cULL,
	0x9acc7249130b192eULL,
	0xcce7c75d7ccb6f1bULL,
	0xa43a825759387427ULL,
	0xfe5016b46711681cULL,
	0xde2ecfa9b46e960cULL,
	0x35cad61235738b8aULL,
	0x148c5dd914505a88ULL,
	0x3448caef18556250ULL,
	0xf34cc4fb7c4b5b7aULL,
	0x1fbf650c882296deULL,
	0x2d70b17cafc5d742ULL,
	0x81afc73b91618d24ULL,
	0x63aaed2a8f9db34eULL,
	0x196747956ff5a98dULL,
	0xe1d0c20e901e444eULL,
	0x959d226339b41fddULL,
	0x3324fb92775aa6f3ULL,
	0x68ce442973d7acdcULL,
	0x4e6fe37fedf9d420ULL,
	0xd717e466fa3348b8ULL,
	0xe216008fe1ee07e0ULL,
	0x5ce336d755730c3aULL,
	0x29e76dbda77ecb44ULL,
	0x8f104ffac3fbb30eULL,
	0xc4ea79b0a60265fcULL,
	0x9c181fc5c944e1eULL,
	0x5ebb203c1ab4bac9ULL,
	0xff07ea0138e61950ULL,
	0x9b9fc36fef46bf2eULL,
	0x13f5a20dd9bd7f3bULL,
	0xace7ac67178a99eeULL,
	0x1b6bfe4ca854fc17ULL,
	0x56ee7accc3abaea5ULL,
	0x659464c0beb308c8ULL,
	0xd517614dd1878232ULL,
	0xb041a2008efbc35fULL,
	0xec0fbcff749d6bf2ULL,
	0x7093b6127db841dULL,
	0xc06094314f1875a3ULL,
	0xca89db8b3249b895ULL,
	0x6a34bb296849bee9ULL,
	0xedcf69eb31bb40eeULL,
	0x54b0386c69314eeULL,
	0xef7e27bf75b3ad92ULL,
	0x38618eca6f874dffULL,
	0x64fddacec1a8afe6ULL,
	0xcbbddfb7ef82100aULL,
	0x89a45a81117763e0ULL,
	0x15704e2cb44d116cULL,
	0xf21b0ebc6b17da46ULL,
	0xede09452e6ac033cULL,
	0xd2815c4f50ab4e20ULL,
	0x76edc034345f1357ULL,
	0x9d5e227b47e55c4bULL,
	0x99fa8badd111e2dfULL,
	0x110937dcdb387acdULL,
	0x4eeb64641f1b60e8ULL,
	0x9eea2b2b9fb32bf8ULL,
	0x1260840127e42721ULL,
	0xbeb159607b23bc30ULL,
	0x543b2528ce5e0692ULL,
	0xbe665dd5ca5095b7ULL,
	0xfb14a3cecb5a9a42ULL,
	0x9fb2e52a32005750ULL,
	0xc08f992a63a9ecc8ULL,
	0x9d6a6358f4a7b027ULL,
	0x4389aaacf41e1a2cULL,
	0x37f9598a151fc84fULL,
	0x7068c3147c814c2fULL,
	0xed7745ddd836afb0ULL,
	0x90b5ffc7f548aebcULL,
	0x9756f0a4372cdf36ULL,
	0xa266c189e7000163ULL,
	0x7343c4caef2c18cULL,
	0xe7cc2d32f61a0fd3ULL,
	0xc2d6f38ac8d54492ULL,
	0x7742a4a71c97647aULL,
	0x424a7b15b13adcb3ULL,
	0x572360cf22943204ULL,
	0x61b0592d3d9d89eaULL,
	0x680c2e306724d49cULL,
	0x40904c57d8d52122ULL,
	0x6dadc11cc6f1a900ULL,
	0xa6af42b44f43e475ULL,
	0x95e3693de303cbe6ULL,
	0x919238a4ae5e8ce3ULL,
	0x28ae5934d4b690e7ULL,
	0x3aac433cb3bfcf56ULL,
	0x6402042baabcb117ULL,
	0x9265156370256db3ULL,
	0xccf8d7b53f8ed7ffULL,
	0x3440f4fed4d04d15ULL,
	0x665074af8486502fULL,
	0x356f97c5ed153e56ULL,
	0x85ef72d012a11a76ULL,
	0xda6c645247ce8e51ULL,
	0xd4c417422f9f317cULL,
	0x4e24a86bbbc776e9ULL,
	0x3e4809f531a7a889ULL,
	0x3aa3f4c71f82026ULL,
	0xc8be58ad47215f21ULL,
	0xdec7fdda1619b97ULL,
	0x6b34034e6aa5262fULL,
	0xf023e2c54904504fULL,
	0x5afd94be7bafedf3ULL,
	0x5f65ae812aaef59fULL,
	0x3d20a9be1ebe9b83ULL,
	0x6e60fc77ec7959b8ULL,
	0xc9310a1734813400ULL,
	0xa9a1f8cabb9bd6bbULL,
	0x7c48821ad003e5cULL,
	0xe1f90ca1009f4882ULL,
	0xffd2952f29d6beecULL,
	0xfb3d9ee314f51662ULL,
	0x68ce6c67774c154ULL,
	0xf276616e7f331928ULL,
	0x4e6dcf36a9edad19ULL,
	0xb283670f18a5a74dULL,
	0x7a923872d08df0e8ULL,
	0x30a0a4bce4adbb71ULL,
	0xfb2b4b8ca85a2128ULL,
	0x434062716432b39fULL,
	0x6038f71158be3875ULL,
	0x3024bead8c9f2c57ULL,
	0x7e86380bd86c5f0aULL,
	0xfbd85377688239bfULL,
	0xcffc3bc92f7cfa32ULL,
	0x2c3d873fd4624670ULL,
	0xba94dfdb8108ec4ULL,
	0x7348c7f753f6c468ULL,
	0x618ecbedb3c36902ULL,
	0x66b344c4911501caULL,
	0xa9cf60162d8cd208ULL,
	0x1ba51e7663bac544ULL,
	0xd402f03d7bac91a5ULL,
	0xc82fce8de56af66dULL,
	0x94e5ee9a05e96a60ULL,
	0x28f3ffd60321e59dULL,
	0x954f7aab66cf2770ULL,
	0x6e2eec9636238ca1ULL,
	0x71bb9a3d3d0bb853ULL,
	0x484916d034e4d092ULL,
	0xdce2ab728c64c40cULL,
	0x355c7692cc13bef7ULL,
	0xc02619da4fbb4cc0ULL,
	0x6b27683910011290ULL,
	0x9cb802d6a3cc33f1ULL,
	0xd68ba38036117ebeULL,
	0x56c5f84f8b0d46abULL,
	0xb04fb89d3dfd6dc8ULL,
	0x3b99d87d1e48cf75ULL,
	0x4fb4551a21db540fULL,
	0x1023f83ceab22775ULL,
	0xa5d2198311c1a217ULL,
	0x4b2be37cf6e76da3ULL,
	0xa94aba6a11f00ab1ULL,
	0xc1ac6604c9e7b248ULL,
	0x4f5c5218a0aaddbeULL,
	0x65ea82f5619e8a9aULL,
	0x68243ab1a9a5d1ebULL,
	0x67d92cd6ecd6b209ULL,
	0x26b0cb1750411c26ULL,
	0x76896ecb1bee6214ULL,
	0xdc0611f945bb66f1ULL,
	0x5d5e3190cb24befbULL,
	0xfa689761051dec82ULL,
	0x60f37c6c45fc27eULL,
	0x82d77ff56d946f83ULL,
	0xb0ec47ba81df1435ULL,
	0xd9e78f07494fac37ULL,
	0x91440890a2470447ULL,
	0x73aa0d596c2c4db5ULL,
	0x649103de5893c612ULL,
	0x2286226838db36f5ULL,
	0xa5d33881c6c457d9ULL,
	0xfbd887f56d301158ULL,
	0x2d88c8d236a150e5ULL,
	0x891c8a6153e98fa1ULL,
	0xe8fd92d135398638ULL,
	0xc4e680098855a34dULL,
	0xe401ed7874452701ULL,
	0x329839241b7463ebULL,
	0xc72e66c49a2b2ea1ULL,
	0xe48a630a638f34c1ULL,
	0x56c8cd3b2a2d991aULL,
	0xef75007d29ea4ULL,
	0x4696f43eed8ce0a8ULL,
	0x2aff68c100c0a343ULL,
	0x7f2eb441561f9456ULL,
	0x3f39d06fafe5908aULL,
	0x81d167a8dd00bf0aULL,
	0xede4f75a2b649511ULL,
	0x243017ad74f1bf91ULL,
	0xa36493b837cff4e1ULL,
	0x77a6a2b0c7d7e68aULL,
	0x7c0294600740001cULL,
	0xe5bd2f850a207f4ULL,
	0x95eea0bde4eeb0c7ULL,
	0xfbda5b998acaae3fULL,
	0x84ab389d2ce8cb34ULL,
	0x37cddfd659260c42ULL,
	0xf43c7dde09d9d0c4ULL,
	0x953384abf3f84622ULL,
	0x62c008e2fd3b913aULL,
	0x3fa59b3935d8b28cULL,
	0x3306408570db576cULL,
	0x14f46859d0f9b059ULL,
	0x991cb4e3ec67fb9dULL,
	0xa6de6fa5e75f1c1bULL,
	0xd076014cdfbb8bdbULL,
	0x8c4bf8bcdde1deffULL,
	0xc02b8c0c56bb0b7aULL,
	0xcdf92d27ef36615bULL,
	0x3d0bf84913b179e8ULL,
	0xe8345c241a26160ULL,
	0x9a6bc6c73191f59eULL,
	0x78428cd060c08701ULL,
	0xe8a09de627ed5c95ULL,
	0x600c110d2902504dULL,
	0x8edf57c268be3425ULL,
	0xbe05e0e5fa030226ULL,
	0xed85c2cf1a1c1c5fULL,
	0xffcc194cc7cc8974ULL,
	0xa03e85dcec55b633ULL,
	0x2948ae3f7b51911fULL,
	0x729666617d8055cULL,
	0x727c5f92dd27d942ULL,
	0x247267a64348d379ULL,
	0xc85757294d5ab800ULL,
	0xc7e247edd10f598fULL,
	0x27f8d82651de24dfULL,
	0xaf77a7c2397b6ad5ULL,
	0xf1075c2637c11263ULL,
	0x820db4715a2d50aeULL,
	0xa78b712be7c97debULL,
	0xed0c94fe16855d33ULL,
	0xa9247a5cb34b1908ULL,
	0x69e2281a6f315e27ULL,
	0xb4c2fa5dc8f21fc0ULL,
	0x1c18d4a516ae7ed3ULL,
	0x5144fe3bf5006c5ULL,
	0xa6db907ac13195daULL,
	0x347b83cd6864c63eULL,
	0x1b1be627e4a3ce73ULL,
	0xc89e67970f0dd049ULL,
	0xeca6db5fc9cd578dULL,
	0x1b3bc14d1077658eULL,
	0x3a383d471cde44c5ULL,
	0xea684ef8bd63ddafULL,
	0x5f26abb2190bb2eaULL,
	0xc12f7d090b8d609ULL,
	0x1e92b60d6e808c01ULL,
	0x3b2aa7b501aed19eULL,
	0xea0f366c12d042f6ULL,
	0xa07669e03d57c1beULL,
	0x4c8a9b08f08895a8ULL,
	0xde264a416fb70d58ULL,
	0x9b1fc7e60276c5a0ULL,
	0xa13ad0bc3fc2a2d5ULL,
	0xd0f327a295570ebdULL,
	0x53d344deddd3ee07ULL,
	0xb932ac93e34cce81ULL,
	0xbbea4eebd5716769ULL,
	0x8b356f293b55b7aULL,
	0x6747db884a1f176eULL,
	0xbc8025ff69e7264cULL,
	0x47b18ba858ddcb12ULL,
	0x61ef9e0fe8fbe954ULL,
	0x3282f040e760a95aULL,
	0xe7fa2c60a4e770baULL,
	0xd9e83eacc5994329ULL,
	0xa0b5f8217be958a6ULL,
	0x80538d8f5574bccbULL,
	0xa5e23a1356fb03a5ULL,
	0x6b8b81717d08c6b8ULL,
	0x19784f6928d15435ULL,
	0x4dd883c1de3fecb7ULL,
	0xe03a37af4b7eb438ULL,
	0x141395327aacca7ULL,
	0xbbb06e8ba95c3e95ULL,
	0xee04035456ddf2e3ULL,
	0x3af3a205524cc23bULL,
	0x7b1c19e599593f5aULL,
	0xb9099a6e35b67d6aULL,
	0xbb0b7f122fe12859ULL,
	0x5628095cfcf7dd6cULL,
	0x91212d3737da35b4ULL,
	0x85da0e439e485e61ULL,
	0x195cdc84bdb9546cULL,
	0x80f30462eb81520eULL,
	0x14b57009e9488e31ULL,
	0x218de98a5cfe0a18ULL,
	0x6e515d0a33437434ULL,
	0x8b592d3ba009b8feULL,
	0xdafe055636a88e17ULL,
	0x55b7cc52b756d680ULL,
	0x9f4312b048b9f6b6ULL,
	0xc4f8498f6a47e4d0ULL,
	0x38792d2f4ae85b0eULL,
	0x979f9c5b37c03132ULL,
	0xeb17263cf26d5a6aULL,
	0xd39ed5af554ab88fULL,
	0x9e6a16a8ef52802aULL,
	0x7ef7116d4c375633ULL,
	0xc01e0fb3ea6c0256ULL,
	0x83d769562d0c7c66ULL,
	0x6a8dfe02b1531eacULL,
	0xb1345cb90b3e8e01ULL,
	0x671ba54bbf449b7fULL,
	0xb5fc71e5a2de26e8ULL,
	0x86197e1cb3a51367ULL,
	0x45ea015872784286ULL,
	0xdcf7ea97cfae1e0ULL,
	0x4f96095f161db49aULL,
	0x5bb361e9996a8f83ULL,
	0x8565093f3783458dULL,
	0x4ca84f5ff15b22b2ULL,
	0xdad770b145ccdbf0ULL,
	0xdb4e91da3b075631ULL,
	0xbbf05db5184fb818ULL,
	0xa9524f006827e5d7ULL,
	0xa46d33b23bf486c6ULL,
	0xc784365020a80502ULL,
	0xaaf6d6eb8222cfbcULL,
	0xa481efa18c724e7eULL,
	0x3c28f50e91c817b1ULL,
	0x4ffa6044c13753bdULL,
	0x5165a99115131fc6ULL,
	0x1df23586c4371867ULL,
	0xb0adc11dd316941ULL,
	0xb77fa479abb0c1e2ULL,
	0xf84102ee7d34936eULL,
	0xa4601d3246f243f2ULL,
	0x83645176f9da4be2ULL,
	0xda31cb15a7dc864ULL,
	0x59892a3cf0dfe3a1ULL,
	0x553376822529d662ULL,
	0x183e80f4202c609eULL,
	0x62961c853f642216ULL,
	0x812963b6c01101a2ULL,
	0xcd458124e25483f6ULL,
	0x1183099325603964ULL,
	0xd881bf090a7ccc53ULL,
	0xb9e4b5831470fa07ULL,
	0x7524ecc616c5d46ULL,
	0xd9b1ae5a3757e142ULL,
	0xbbf2b0f065a18812ULL,
	0xd89d7456270bae2aULL,
	0x6efd05a6708d4d8eULL,
	0xbce2427f7e16033cULL,
	0xed805ea3027b95cULL,
	0x11de12df42b4dc2aULL,
	0x4ccd718fe4979d6fULL,
	0x2276c70c6b1efdf2ULL,
	0x63a71827ac90f3efULL,
	0xa6d23ed200978046ULL,
	0x9f83ff8b2a227281ULL,
	0x520a4c28d55e0aabULL,
	0x9208f49a68af1d1dULL,
	0x994046c8192cfd2ULL,
	0xf0b84444b489fe83ULL,
	0x8853cb95fe70464cULL,
	0x4cdf6ba744c3f663ULL,
	0xb97e0e290a5744a2ULL,
	0xa3e38be2345e2581ULL,
	0x569632d926151cf9ULL,
	0xf950d266137b0b57ULL,
	0x295162e91db30ea4ULL,
	0xd3735f5fe43a9adeULL,
	0x16103228f4d8e7daULL,
	0x1acc2e6cbbfa2012ULL,
	0x11b8e1fe0d530bc7ULL,
	0x3c67d6325990507ULL,
	0x88d0029f8f1da1ceULL,
	0x2c34dee21d103585ULL,
	0x827dc7643c331e7ULL,
	0xc061afa87606fd37ULL,
	0x945af6563190233eULL,
	0x1aaae1598030f02dULL,
	0xa00643e6538d0020ULL,
	0xfab775db41f4599bULL,
	0xc7b100d10ba897cdULL,
	0x1e9ba05edf116aa7ULL,
	0xad57b91ca3f6033cULL,
	0xff2be2216e5f2340ULL,
	0xed46027f12571dbfULL,
	0xf11a6c6572cf2f3aULL,
	0xe19dfeebdcb75017ULL,
	0x54ff2f5ddc36b157ULL,
	0x1b1ec099ce08e7a5ULL,
	0x6e2c13c9261bf9ccULL,
	0x1bb910ceaaa50e3aULL,
	0xe49c82fee0833250ULL,
	0xfd34c291aeba6ed6ULL,
	0x88d3c964a7981c34ULL,
	0x58e62c1ade2c516aULL,
	0x8e3da38d2092872bULL,
	0xe5a384a5eed000b7ULL,
	0x31113c7ccde35296ULL,
	0xe1e99889fb40cd41ULL,
	0xa9ac662be5e781aULL,
	0x52d6166b2719948dULL,
	0x61ec0fda38934694ULL,
	0x7b52c1d14a7fedd6ULL,
	0x459b9dbb8be22a3eULL,
	0xe208090155112bc3ULL,
	0x5c48aafc21400d7eULL,
	0x5f026ffdac39c927ULL,
	0x1463f00c55a05409ULL,
	0xfcbe1153ea53b7c2ULL,
	0xde6d5dd612df0a77ULL,
	0x4c584ef5e4acef1eULL,
	0x50175571762f0e72ULL,
	0x2b14ea3a7a7c696eULL,
	0xaee1a5c2c3478afeULL,
	0x30907fc495fe1da2ULL,
	0xbdd853c1a88c9998ULL,
	0x73a8888da79ad29fULL,
	0x7b0158f8d0f4758dULL,
	0x3332a586ddf6d623ULL,
	0xc577eb29630c9bdeULL,
	0x9f16a4ab47580a0aULL,
	0xf60998a69332d184ULL,
	0xb7ee92ec64025d2eULL,
	0x65b7c21ae267bdb3ULL,
	0xd4fd7a8e38685665ULL,
	0x1cdd56d07daadc2eULL,
	0x19ada51ef41839f4ULL,
	0xf4bd6402ed39e817ULL,
	0xf6944066d6d705fULL,
	0xbfccfb1cbd1a86fbULL,
	0x796dd971ef4c646fULL,
	0xbc9aa06f9800cc5bULL,
	0x2eacc9a4bbbe6a1eULL,
	0x229bd658d433d0abULL,
	0x9cb5ae758c128651ULL,
	// end of original table

	0x60015f27ba684567ULL,
	0xb70634f536c5cffULL,
	0xd8731843d6ced8baULL,
	0x97feb01f757be146ULL,
	0x8c159cf2b6e2231bULL,
	0x6b3d34d68fc5255aULL,
	0x483ccb6dc26ac4c9ULL,
	0x993486809e0357b7ULL,
	0x38ac7d0747c2e125ULL,
	0x8addf984ef325ae9ULL,
	0xd5f018277330d0cdULL,
	0xafaa837bceaf8611ULL,
	0x42ce3d69c0e17521ULL,
	0x501bcd2b6109dde9ULL,
	0x25e1020c55b82dfcULL,
	0x2dcf608680bd2a97ULL,
	0x7d01c880a17d78fULL,
	0xffd0cf198055fcb0ULL,
	0x866b87d73dc78d3cULL,
	0xa50d4b790ac5a45cULL,
	0x760f3a7aaebf40fbULL,
	0x13d206fe862e2529ULL,
	0xcfb50af04751b77cULL,
	0x8b859e2a51f2861ULL,
	0xf7c80592537836a8ULL,
	0xf3839fe145d6b5ebULL,
	0xafe00fe73a270bf7ULL,
	0x303d74055a520ae5ULL,
	0xa379cd1788a9b148ULL,
	0xef9254a501355d23ULL,
	0x2d939a5a2f3b4564ULL,
	0xcce3acab92ac82c5ULL,
	0x716dcbc226da813bULL,
	0xb816ae8212a3f09eULL,
	0x14001327a794d9acULL,
	0xcd54d383e80ff03bULL,
	0x62a1139e87d55648ULL,
	0xccaca1be8ed0016fULL,
	0xb43215e85b20b07dULL,
	0x66c39a1b5807811cULL,
	0x820a2f1c270c18f8ULL,
	0x18dc7e844c012acaULL,
	0x4fad1d41e7599938ULL,
	0xb40e0e9d46511a34ULL,
	0xcff703b7394545faULL,
	0x91aa9082faf65486ULL,
	0x474d7fb42d8e6a55ULL,
	0xd5cd54528bf46373ULL,
	0x3659fa443e3fff36ULL,
	0x8c27056c66affcf0ULL,
	0xddabfa700ee70d15ULL,
	0xff78a5d81542b5a9ULL,
	0x768f5a4678f4058aULL,
	0xc23257deb069e80aULL,
	0xe93f488f761c47a8ULL,
	0x8ffff6d3cf50ab8eULL,
	0xe7793cc39c5e9d09ULL,
	0xb4b3bde93908a233ULL,
	0xd2f208a5971e7fULL,
	0x1700c0a553276e47ULL,
	0xcc4532664fef8c4aULL,
	0x787c8b31d2826823ULL,
	0x98a2bda82adb4807ULL,
	0x6103c4bef88328b9ULL,
	0xbe0e4e660e45763eULL,
	0x635b9635299ce867ULL,
	0x863d0cd51d38b9a3ULL,
	0xcee13c2b0d1bda34ULL,
	0xb553da99008f8110ULL,
	0x177d255848390401ULL,
	0x48f9432f5bcf6e78ULL,
	0xb3e0bc53fc97e23ULL,
	0x60a107159ee1256aULL,
	0xc81f747ffc634f25ULL,
	0xba63040bc0a9413aULL,
	0xd8a3c91e3c061690ULL,
	0xd7ed9fc46514f49bULL,
	0xe87c74225dac8ecfULL,
	0x4a5171d66609ac5eULL,
	0xe64382ea70be8ab2ULL,
	0x51e888694a589d8ULL,
	0x8b4b589f47e14a82ULL,
	0xb6c01d3cd9311a87ULL,
	0x5f9a964b1a8a88aULL,
	0xb1804b714cc67044ULL,
	0xd6a9cd5e0540e74eULL,
	0xba55742f5722bdadULL,
	0x7489b35542c188ecULL,
	0x85d747524da72b8cULL,
	0x45dc426654b397c0ULL,
	0xe7669718192445e4ULL,
	0x6d7d9133feb4e063ULL,
	0x5993b618127ae6b4ULL,
	0xf3730cd9835743afULL,
	0x617b7d0b75d13207ULL,
	0xa9109d2ba1540e34ULL,
	0x90649a709b69d089ULL,
	0x5b1a5b3008d893c1ULL,
	0x59680fa3975c4a67ULL,
	0x2195992a7ab567ecULL,
	0xa7fd7ec3809e45e5ULL,
	0xc696b1756908e509ULL,
	0x787010e8595956f4ULL,
	0xafc34e88b78c8fcaULL,
	0x8fa500e8aa9428cdULL,
	0xb81ac82df63a7c7aULL,
	0xa796ba0285ee6ccaULL,
	0x821b35ddfa5e9f2aULL,
	0x6af033b1c486afc9ULL,
	0x3d7d1c6d332c2503ULL,
	0x87ce98224267bf6aULL,
	0xce6681912d9a7c99ULL,
	0xc6359b2ee935c322ULL,
	0x9bf0b3b3c271a5d1ULL,
	0x71b9eca4e955be45ULL,
	0xd51662df7b4681ffULL,
	0xf361c3fbfa034b01ULL,
	0xb5e36bc110ee0102ULL,
	0xcb13c90f8d5cb662ULL,
	0x84aa2cf34ac78581ULL,
	0x3e27a6b82ea9043eULL,
	0xcc5261df551f284bULL,
	0x233206929d09564fULL,
	0xf3d20d1298cdb1ffULL,
	0xa54ee94ce7f8d1feULL,
	0xc12f7e96ca7add0dULL,
	0x734c5bace6250d32ULL,
	0xb8c617e029b4f56aULL,
	0x7c26b6d222181002ULL,
	0xa83c710f06c49816ULL,
	0x8f0e176605ce91f0ULL,
	0xedb5a326f26d5fcfULL,
	0x759e3a6525f1b29fULL,
	0xda977c3aa55a4f61ULL,
	0xdd0e75e28fc1fb0dULL,
	0x7fb26238f7ec560eULL,
	0x10f5a416d68895e5ULL,
	0x14d12acda45ffa3eULL,
	0x92f5d49c3004202eULL,
	0x4059063e7da66b9ULL,
	0x2db5da30c7f7e770ULL,
	0x3fd1c35e19be3c89ULL,
	0xae107f45bc3c301ULL,
	0x670f45a5270d328bULL,
	0x14a6a13af144aee3ULL,
	0xde4dcabfbd2ce198ULL,
	0xf25ef3d786b8e255ULL,
	0x9f24f29787a262c2ULL,
	0x944bfdb0c8f09613ULL,
	0xf1ffe2cda849b4e2ULL,
	0x20ca5d17c561a81ULL,
	0x7a670ae408a37eeULL,
	0x8aac786c2a63493bULL,
	0x4c0d3305e5945dfbULL,
	0xab2cf4173c1c0446ULL,
	0xf281e6899c2ed80eULL,
	0xa32b2b3a8044261fULL,
	0xaa98242c09c28454ULL,
	0x3cb83f50e7f239f8ULL,
	0x19ca5d85fdec3973ULL,
	0x679de0ea37c7f860ULL,
	0x988ac4c40df89031ULL,
	0xc9902740d73fb70dULL,
	0x97e7bcfa657c67cdULL,
	0x1284afef778f35d5ULL,
	0x77e3ff65d3e5b5eaULL,
	0xfa96013dc2a4359cULL,
	0x87eb0463f57805aULL,
	0x9b97b6f53afd4250ULL,
	0x25f74d707c10655aULL,
	0x368e8a6b551d0ffbULL,
	0xd7a4c11a7698d29aULL,
	0xa38111df85a34e4eULL,
	0x1506ff16a67fba71ULL,
	0x5345d23b34cde228ULL,
	0xf4bf418bd6ba9237ULL,
	0x3d4aaaf087df6e9cULL,
	0xe9fa1f4d851cc6dULL,
	0x21cfb7b3774d5273ULL,
	0x63063d8497af2dc0ULL,
	0x13374c7aab0b0a9cULL,
	0x5d838e3ea418dcbcULL,
	0x71a3eadcd64ecb3dULL,
	0xc45b4bf4aed77ed4ULL,
	0x13a621ea7a0e00c8ULL,
	0x73af3e7ff94d5530ULL,
	0xe4616cec229d1756ULL,
	0x1c57d9286172f671ULL,
	0xb1fa81e50f75e9a8ULL,
	0xb6f6722c566f4a09ULL,
	0xa5477826394fa63bULL,
	0xd3fe973b8771786eULL,
	0x55fc0837202f42e2ULL,
	0x8c6ae8e091c13c47ULL,
	0xfa4c180785a2498ULL,
	0xbbf911730454c122ULL,
	0xfe4f56dc71d5fca2ULL,
	0x9a76c30a8c3ed049ULL,
	0xd7357eb5ac212a96ULL,
	0xc7e9153edee38dcbULL,
	0x294282f233a5d445ULL,
	0x1d5084d15febf83fULL,
	0x13d7f8d17257098aULL,
	0xc4129e928de3a76aULL,
	0xc9b3543c9b09fc02ULL,
	0xa3d14ff986a0cb8cULL,
	0x125dd51bd42bbf5ULL,
	0xdc0c53d9d5f0e690ULL,
	0xa67bfd568bc28302ULL,
	0x245e4128b5ad6cdULL,
	0x917e050c32a8d574ULL,
	0xbd08d9dbba9027a1ULL,
	0xd4257716add7e48fULL,
	0xb70e2f8d0907bfccULL,
	0xac07f17fb77d2b79ULL,
	0x9367eac5841c95deULL,
	0x134c066de986918ULL,
	0x2911abf8010d60ddULL,
	0xac7e0908ed1f3154ULL,
	0xc293f3c6e9fd44aeULL,
	0xb9048a04607da284ULL,
	0x361e6a3d598da596ULL,
	0x47d2245539fd487dULL,
	0x1fe68e7791b97e02ULL,
	0xb9c292e1b56d357aULL,
	0x4bddf8b715d54834ULL,
	0xd607c7f06f58f4c7ULL,
	0xec082d6984e462e4ULL,
	0xb69b7b38f1233267ULL,
	0xf863fe7620c9e8c4ULL,
	0xbf09bba56efdbf76ULL,
	0xa284f788651c7360ULL,
	0x7a8a9282322243cdULL,
	0xa677dd19626cde99ULL,
	0xd10e2e5c2f059e9dULL,
	0xd23627288e9498b7ULL,
	0x40124ff5b62d1c37ULL,
	0x15f4d5bc992ef1c8ULL,
	0x85e237e734bb259cULL,
	0xf0ec1e7dd626a7ffULL,
	0x3a2c29eb8790a0dULL,
	0xe236950641595013ULL,
	0x2ee755eb56287487ULL,
	0xa8342fc541242782ULL,
	0x9e0583e278adddd5ULL,
	0x31946167f39aabefULL,
	0xeb3e6fa98844526bULL,
	0x9590b8c28372a7fbULL,
	0x45ac873605c43aa3ULL,
	0xb806932368af2137ULL,
	0xb72de8c1f9996c3aULL,
	0x8a7ab9755a1c5ebfULL,
	0x5e2caff01e1a63f1ULL,
	0xaba5390e1475c2a3ULL,
	0xff0b7bab9178893dULL,
	0xcb046c27ef98a7faULL,
	0x3bd81feda546f590ULL,
	0xbf656027cd5f7940ULL,
	0x17f17ba65a9503abULL,
	0x9581e72bb7531dcfULL,
	0x384a0a7e281b1da3ULL,
	0x870301a473ffb582ULL,
	0xc9275a0724bde573ULL,
	0x41627b481e374674ULL,
	0xe9c0541e892539abULL,
	0x381e59796d055608ULL,
	0x661ca086b0c0beb4ULL,
	0x68b9b66584b3991eULL,
	0x2a6e6223292ca3e1ULL,
	0x6ed8b6d4ac7cbbadULL,
	0x676c2d6842e99a9fULL,
	0xdbd97e72cd92208cULL,
	0x89ce8964f8f24123ULL,
	0x2e19515e0a70d17dULL,
	0xb3a322ea121a0d1eULL,
	0xdd3ca6c80bac17cfULL,
	0xdc76ee9a18e2911aULL,
	0x5892a5b18422aa44ULL,
	0x2ced436a4e63f30eULL,
	0xb004e91551d3a800ULL,
	0x38bb150ccfaa0ec3ULL,
	0xa417546e0462a23ULL,
	0xbe8c26a7432072bbULL,
	0x7e5b1f34755f6edcULL,
	0x1368393713ce6507ULL,
	0xfe508acaa61b94feULL,
	0x2cec37c52b76ed90ULL,
	0x4418978ca3e56430ULL,
	0xaa1d2506ab7f4f1bULL,
	0x9af1b8ad5890996eULL,
	0xca3210c8f02b92ffULL,
	0xd69f6be102a1d652ULL,
	0x7df4b53610551013ULL,
	0xaf3218426fe2b37ULL,
	0xa4f155f1ccf91346ULL,
	0xe6b3326a7c6dfc58ULL,
	0xfd9795c55167b714ULL,
	0x3cbebb5eaff44a46ULL,
	0x53653c6d293cdd67ULL,
	0x862515a64a612e62ULL,
	0x84226d37c3d94b45ULL,
	0x2bfe92d48b3edba0ULL,
	0x12ebf13a88be2e75ULL,
	0xed561c6e76d9591bULL,
	0xd273ca6f3f697021ULL,
	0x773d13c8b33eff53ULL,
	0x2d10363f51e81c03ULL,
	0x25267bce1a57c986ULL,
	0x607c3e8ba2a20fa8ULL,
	0xca15f48a0999ec9aULL,
	0x6a6489c456fa4d2dULL,
	0xc07572a900ee2ef8ULL,
	0xde91cb170e05af4eULL,
	0xcaeaac0f381f34e0ULL,
	0x9b9ba0e299d77406ULL,
	0x30e2e2df59006c3cULL,
	0xb481eeca88dd5b0ULL,
	0x6cdda35d3bec313dULL,
	0xed1c6492917fceecULL,
	0x3c3426f35ccd1bb2ULL,
	0x1763eb46bb47a6d2ULL,
	0x3db1e47c5b163898ULL,
	0x5087915d22f5524ULL,
	0x8eb3c592022bd5f5ULL,
	0x51d6535db4807b17ULL,
	0x2aac826bc188cb24ULL,
	0x66722dd6dcdb654eULL,
	0x39e849ad6da80c4ULL,
	0xb16ff9400b1ff4b2ULL,
	0x86794176a7848a20ULL,
	0xbefa06a26ee64f0eULL,
	0x786856799ab8785fULL,
	0x4ca1d5b75552d7b0ULL,
	0x481b69aaef493751ULL,
	0x5106d509f30166faULL,
	0xc89cb8fabcbb755bULL,
	0x4881e9aa6c4dabe9ULL,
	0x9acc44c94e361d13ULL,
	0x15580221625c41dbULL,
	0x1ee53f4434328ff3ULL,
	0xec8f14ac520043f1ULL,
	0x8c561f355521eb1aULL,
	0x413c0cbd7271746fULL,
	0x49f07bc41d1494fULL,
	0x2a79bee27e515565ULL,
	0xebe16cf2516d3044ULL,
	0xcced73d58f42136aULL,
	0xecce64365029fdb8ULL,
	0xafaeaac00d4d8000ULL,
	0xdda19d1f63d9d568ULL,
	0x2028739dbd5970f7ULL,
	0x3a505a6de1e45ea6ULL,
	0x5563c6d01c9b08b8ULL,
	0xbff786b383f28b27ULL,
	0xc42e34d5dd1d2d2fULL,
	0xc7472b99136f3e98ULL,
	0xbdf64bd9a733c4d6ULL,
	0x4333618cb817e87eULL,
	0x3be7bbdbaf896585ULL,
	0xecb06404330cf3dbULL,
	0x57e50f7735ca12d3ULL,
	0xd48a981eff866c56ULL,
	0x92a2512c6a0b792fULL,
	0x53954bff6ae2d84eULL,
	0xc23bb530cf385516ULL,
	0x72af682b62d9963dULL,
	0x818152ea9e808108ULL,
	0x16c73f4eb15a2634ULL,
	0x224aecd56ff74a69ULL,
	0x634004f39c5938c2ULL,
	0x7c19f020bf131e8dULL,
	0x278daa1ca6cc437eULL,
	0x7e56753df99e1091ULL,
	0x92e0362c9040604fULL,
	0x5520aa2eaebfafa8ULL,
	0x5542c3b5b4002e8ULL,
	0xd58c32b8c957be2bULL,
	0x1a8a03971891884dULL,
	0x401efa8171730892ULL,
	0xf5f98ded379f94ceULL,
	0x11bba64b02426f90ULL,
	0xcbc289404c4b4f24ULL,
	0xf88c707322a57d8cULL,
	0xa76e9a12bc321f92ULL,
	0x8a136b6c3f3b629dULL,
	0xbf776993432c2714ULL,
	0x969954579e4f6a91ULL,
	0xd93c5cd62b5c7dc6ULL,
	0xec646eb16a31cbedULL,
	0x434dcc15d71792a4ULL,
	0xe31afce748900edeULL,
	0x19e8384dc98da777ULL,
	0x90d937b9ffd1d414ULL,
	0x42e56b0bb2ef7944ULL,
	0x97bcaf4446e4a051ULL,
	0x49b416e044e191c4ULL,
	0x26691c039c60a8fcULL,
	0x2a3348626e2a6ba1ULL,
	0x47086a4bb1bb45b2ULL,
	0xf2f53ed199194d90ULL,
	0xd5a9a9c128a43da8ULL,
	0x85c784b9c0e43e34ULL,
	0xd81da08dac238fdaULL,
	0xae40ee3c3b07f166ULL,
	0x5b5139f1423630c2ULL,
	0x8e04746a249bfe0eULL,
	0xefdf689840082f1eULL,
	0xd2956d9ff1df1453ULL,
	0xf1dd9458b3671379ULL,
	0x7033dc0befdfbba3ULL,
	0xb511c5e028189288ULL,
	0xdbd854da918d9684ULL,
	0xf9fe2c5f6cd20264ULL,
	0x528da307b60fbaa2ULL,
	0x266f6c95c0edd8b5ULL,
	0xbd940d4b3aad19e2ULL,
	0xc70e51fe8906fa14ULL,
	0x8c2b73bffc2d6145ULL,
	0xaf33bf612efc6a98ULL,
	0x62e4bf66077a2230ULL,
	0x8a174746facae57cULL,
	0xf97fa4f8fe5a8002ULL,
	0x1f51af8330292f64ULL,
	0xfac5a803786597a5ULL,
	0x27922542b4b54c41ULL,
	0xbec3ae12cbd54202ULL,
	0xd1a4f1aed47b6391ULL,
	0x76aa16bd824b5bb8ULL,
	0xfd807863331daa7bULL,
	0xe90da40938c08bb4ULL,
	0x65aacb5177fc7c95ULL,
	0x92969e0b5ceff359ULL,
	0x9fef7e7c00e4f21dULL,
	0x95d680694cec51e8ULL,
	0x2c53ea040dde56a1ULL,
	0xc3141604cd8c5a6eULL,
	0xa5841e9574801a9bULL,
	0x19e87716f7b13d88ULL,
	0x3b6cdb3a94bb27b7ULL,
	0x4acd6e6d7d1e0a9ULL,
	0x34568d3137a9fe5aULL,
	0xaf6d354a3324a831ULL,
	0xa49ec70590fe62d6ULL,
	0xbcb737d221bbb3d2ULL,
	0x617f99267b4fa89aULL,
	0x1faf4a0eb5b7a9caULL,
	0x1e8da85cd51dadcfULL,
	0xd1dd959a74bab720ULL,
	0x607b6d303037c6f9ULL,
	0xec3a63c7f1bf6663ULL,
	0x3de572179c12fb2bULL,
	0xc8533108b6157623ULL,
	0x5c5a659a0b0014b5ULL,
	0xe01e216c05f77343ULL,
	0x4ea5889bfad73bc8ULL,
	0x1b70bd89e82962c6ULL,
	0x3568c238abec1b3eULL,
	0xcb21a1e18ad6ea4dULL,
	0xe595f80d3c91f748ULL,
	0xb082c64f44dcf974ULL,
	0x3fd9c0b522e0f12aULL,
	0xd95ea1c049f0170cULL,
	0x6205f7d733c017a9ULL,
	0x1bff0b690387b8ffULL,
	0x3fd985bf4aa1bfdbULL,
	0x8dc83e1940bf6954ULL,
	0xe077d0539d672824ULL,
	0x2095a1e9874664a5ULL,
	0x65dcb6c48e0a4a8fULL,
	0x48ad18592459cb50ULL,
	0xca84e7b173244f1eULL,
	0xbfea78a6af52ba4cULL,
	0xdcfd924307d6920eULL,
	0xd5c88964b4e766dULL,
	0x727480f94dcf2a11ULL,
	0xabf2ff56c1f9a831ULL,
	0x92960acc0f5c3200ULL,
	0x6ddc94ef0abc0fb9ULL,
	0x816d14182623f990ULL,
	0x943b78b938eb652eULL,
	0xd6db388f2100c79eULL,
	0x3006b57b2a55b9acULL,
	0xe80a5dacd002636ULL,
	0x45d6751265c4b0e1ULL,
	0xa1364a2c15db4a6dULL,
	0x53d878622de68ae7ULL,
	0x750a6bca8cc8439bULL,
	0x57ce3c64558031e9ULL,
	0x8d0e7fd549622441ULL,
	0x92083919340553fULL,
	0x122d0ad7d159b90dULL,
	0x27236554f3cb69a0ULL,
	0x6165ab09f77dda57ULL,
	0x8b7d5b6696ebed52ULL,
	0x223eb01348709502ULL,
	0xc0b573e5425dd2d2ULL,
	0x5a6c3a5f32498053ULL,
	0x610f7a98af865b85ULL,
	0x3706f8f2444d0b3eULL,
	0xd2ab6d22817bad0cULL,
	0x356589eeffa2e418ULL,
	0x512f4399d0cbb240ULL,
	0x37c0f03cc33b7aa0ULL,
	0x8365eaffbd973186ULL,
	0x195af698e69f3a72ULL,
	0x33bb11981e07b200ULL,
	0x4e11287798db48aULL,
	0xd53e3d9c6bd036bdULL,
	0x824dccca6b27544eULL,
	0xde7536e52dc92afeULL,
	0xc878637bf1554aa9ULL,
	0x8030514c0e08cbc3ULL,
	0xb8b94dd38c616a22ULL,
	0xfb80a9ecaa95f58ULL,
	0x20cebf470965fe98ULL,
	0xf9a8c6cc40d9ab63ULL,
	0xdabbacb4dff08765ULL,
	0x4f0dc09cdf1a3d63ULL,
	0x6bdfa0ef1dbc4c9cULL,
	0x50103297435e2d28ULL,
	0x68c0514f25463700ULL,
	0x6ea4501b61a807e8ULL,
	0xa80fe82c4121e6b9ULL,
	0x1233ba53c5445f98ULL,
	0xc4c6c4e619679505ULL,
	0x5fb6d8a2421e4159ULL,
	0xfdcbfd9624400e31ULL,
	0xa94df59cc03c701bULL,
	0xa99ebef5e38588d0ULL,
	0xba70437edd1e5f2ULL,
	0x9e1b0d2c612551b6ULL,
	0xea16a8131d0349efULL,
	0x2a71f38cae44e314ULL,
	0x3c75118d5cf82616ULL,
	0x15f531e3c2e569f2ULL,
	0x37146838ae0f4faaULL,
	0xb1caf5c3052ee220ULL,
	0x20c6823259d0552ULL,
	0xa77d155bbae1e5b4ULL,
	0xdb2ef1f1dbd6ef0eULL,
	0xb3c74574e8c6503bULL,
	0x647ad5769ada1adeULL,
	0xa7f459403e59ca4aULL,
	0xe6c13e17c185613dULL,
	0x8141508718005684ULL,
	0x367c5d28a57d2e1ULL,
	0x6d24d37f3ef1c795ULL,
	0xa6bab61e7df41aeeULL,
	0x46f54b8deeecafbdULL,
	0xf476504ce308852dULL,
	0x32311303c6f7d625ULL,
	0x2d2ac3eae67ac977ULL,
	0x5c88796b4ece68f1ULL,
	0x1ddb46aee9126c6aULL,
	0x783fed878e551553ULL,
	0x7522cec4fe49f813ULL,
	0xe42535b1e44482aaULL,
	0xa847c4853bfa6df9ULL,
	0x80f70fea9c4bb54cULL,
	0xacaa5ecf7883e0bcULL,
	0xc8bb05712eef674cULL,
	0x304de62336f513c8ULL,
	0x4f52009b10d62f2dULL,
	0xb5f934346c94d17aULL,
	0xee8a701eaea13688ULL,
	0x83e5d5c929754bb7ULL,
	0x2be0cd661f2a49b5ULL,
	0x2e2c42ce4f61e6f6ULL,
	0x9fab6a7dd5a7ade6ULL,
	0x4ec420cbf1b59fa6ULL,
	0xe483d568c16c67c7ULL,
	0x1ceecfe330672004ULL,
	0xf451ab4596eaaed8ULL,
	0x6e3282dd66843121ULL,
	0xffb7d94dd29dd4b3ULL,
	0x19599ad2d301f40eULL,
	0x80360c9fcf3480e7ULL,
	0x45bde98ec8fc4b2eULL,
	0xa05328e6b2af9075ULL,
	0x4eb8641183f74144ULL,
	0x5e6f032344ad3d64ULL,
	0x364cf67fed02c1bfULL,
	0x477322afee0bd078ULL,
	0x552b458e6eff181ULL,
	0x38053c83c7afd2c3ULL,
	0x8530c2532e7fc7efULL,
	0xeca0021f9e5bb182ULL,
	0x18a364b05676c340ULL,
	0x131cb0efd6d3ad22ULL,
	0x435aeed1f049340fULL,
	0x5b403c0aa3efae3fULL,
	0x497dd1251631e3cULL,
	0xa858476e82142bfaULL,
	0x827fdbf32453f80cULL,
	0x92bcfe4097dab001ULL,
	0x29c30e85f48dc51fULL,
	0x69e5ce79410f5cf4ULL,
	0xf279c6bc4ff81bd2ULL,
	0x8239f83d6ca47afeULL,
	0x5773f1ce38549996ULL,
	0xfffa68a06a10e79fULL,
	0x79404e50a17e9caeULL,
	0x9e3e20ee568b2dedULL,
	0x86ef16022b28d753ULL,
	0x6d79a79c95b435c4ULL,
	0xc61987421e00e9a1ULL,
	0xe80c757a9fce8a93ULL,
	0x8e7d22bc367c269eULL,
	0x4001ab5a67fe148aULL,
	0x3abb9c29edee7b34ULL,
	0x839e99c5789b589fULL,
	0x9750300e3dfaed83ULL,
	0xd5645f2f22d7c9b6ULL,
	0x4968884bf622bf5aULL,
	0xcc6d4d0adbc8a349ULL,
	0xdc69e0dccf2fc330ULL,
	0x8427a32cc9fba29dULL,
	0x5224be3dec5e49a6ULL,
	0x170a1535aec851b3ULL,
	0xbb251e833ca7a830ULL,
	0x60ce4ea76e65af5aULL,
	0x8aaf65099ed2236bULL,
	0x25fe492a6e44dee2ULL,
	0x3666bf1bf5e2e662ULL,
	0x5fc25c13fa7b6c1aULL,
	0xeb0d2b208b3cefb2ULL,
	0xefc1497ee70600c5ULL,
	0x72b63d7d7caac26eULL,
	0xfc8ab02e85bdc836ULL,
	0xbe12259d1d6a59edULL,
	0x858fd6c553eca6b1ULL,
	0x256b8ca076c2483fULL,
	0x4f7bd0d9b1295c0dULL,
	0x8912384f92a56fdaULL,
	0x4fab9cfd0cf5d484ULL,
	0xb1903694c0953864ULL,
	0x16afedd014094275ULL,
	0xca35dc4511443d3dULL,
	0x37fb6954ffd5cef1ULL,
	0xc64d656a2156c414ULL,
	0x5259c35507cbd0dbULL,
	0x3257b62304c13fe3ULL,
	0x647c0b87672b19d1ULL,
	0x5aee1c65bcab75faULL,
	0x670032f8798eb4c4ULL,
	0x59aecc31024b3b8fULL,
	0xc443fd7a8144f321ULL,
	0x34baa455fedc525bULL,
	0xce5853d68d4eb371ULL,
	0xd6d25002de1dd08eULL,
	0x23fa921421112dd4ULL,
	0x8de559aadbd93b62ULL,
	0x495b6cf3d81a5032ULL,
	0xb7d2a5e289d7cacbULL,
	0xd8ed181d392120d8ULL,
	0x5d170e567ca0d92dULL,
	0x31af84bbb920994ULL,
	0x615dbf06eddbc39ULL,
	0xe1abbf6b461caa8cULL,
	0x1182bbe3e757ba59ULL,
	0xee835bc3c1c942eaULL,
	0x3bf9ab461efec869ULL,
	0x3f5634d639adb999ULL,
	0xcc7dfa63abdfc1fdULL,
	0x9a88df893a3f1111ULL,
	0xbe7358fb5a214c37ULL,
	0x621d00de3300c516ULL,
	0xbb6f87c55f129b7eULL,
	0x1118eb27e6f195e9ULL,
	0x43bc6bb1044d2dfbULL,
	0x5b51acdd027c2cafULL,
	0x4d4a310d7fc10574ULL,
	0xdba6a542a2f566f5ULL,
	0x4cf632ac5951228ULL,
	0xe7b6f96cd54b3eeeULL,
	0xe7fcdbb23094452eULL,
	0xcc4e0bb0cef88538ULL,
	0x6cd35d3ab60b6d4dULL,
	0x7681b42f3b277408ULL,
	0xd02db5103f912d5dULL,
	0x8ac187714931ca1dULL,
	0x69dbda145b566a33ULL,
	0x93ffea868b65094cULL,
	0x49fbc1ece76d3a3ULL,
	0x3ff1f1e12ee6a5aULL,
	0x4f7bd8c7bf83cf71ULL,
	0xbe02a0d5ced9cbc0ULL,
	0x2e68b8829dc21168ULL,
	0x14cccadf78d05826ULL,
	0x65b67f3becaaa366ULL,
	0xbe6a4659d1069cc3ULL,
	0xe8c9664c82af0168ULL,
	0x6101bbaabecee267ULL,
	0xd5216d0f78c5d625ULL,
	0xcebd7c3f6a835126ULL,
	0x6cb67c0611d9f8ffULL,
	0x816d57d94924fd4bULL,
	0x284a4e15d7125affULL,
	0xdec9a9ce22f43184ULL,
	0xc95d0fdb11a214fdULL,
	0x3669543122accc08ULL,
	0xa1d821bda03c45adULL,
	0xccaf5bf016ce12fULL,
	0xc296df76a9b9fccULL,
	0xab6cd4061ad65156ULL,
	0x93573dff99d05320ULL,
	0xf01b7dfcec848b4aULL,
	0xe3349615bf2b5540ULL,
	0xc09f20fa71b51993ULL,
	0x51b5ac768efece2cULL,
	0x8be3dd580d092f88ULL,
	0xb1071c823c097a43ULL,
	0xb9b43fd03467b801ULL,
	0x8588bc927679549fULL,
	0xeae9c64b77c8e2b9ULL,
	0x98d7de2c185fb289ULL,
	0x592974762e52c2eeULL,
	0x6beabe6ccc454c08ULL,
	0x2d7ce6304af2d13eULL,
	0xa6d04dcc1c4ab6d8ULL,
	0xfd9ebd49547fb1b6ULL,
	0x543cec633ec51501ULL,
	0xd8a7f313f480acbeULL,
	0x58a1a61d67f87e77ULL,
	0xb43069665e6a9d1dULL,
	0x39d05a53f2e9216ULL,
	0x56b39a4e6b68b4cdULL,
	0x9773a4face199a40ULL,
	0xe3441afff8986253ULL,
	0xd582deff95bc1dfcULL,
	0x31168a7db9a60b1eULL,
	0xd374b43b4d4e3ce9ULL,
	0x34c96b8923d8775ULL,
	0x61d665074afbbf4cULL,
	0xf0ef58847bc44dbbULL,
	0x9174d7d48b413bc4ULL,
	0x6f01587c8fff7663ULL,
	0x44d8729972b40087ULL,
	0xc1b2fb2490ac230aULL,
	0xa30b59c85b83c887ULL,
	0xb2c60b8729ebf73fULL,
	0x6642301e7ce8fab0ULL,
	0xa63bad9a48835d63ULL,
	0x5c7a7108809591abULL,
	0xf81cb13328134fd1ULL,
	0x944d5325e7e9e80bULL,
	0x6a83a6fd4ae52fe5ULL,
	0xa0b41c51fe6f020eULL,
	0x51ac75960f23b325ULL,
	0x9cadf04f0ceeb687ULL,
	0x4f3caa328cac8e7aULL,
	0x54f7a2d2d24e6c66ULL,
	0x76074b35c6b2c543ULL,
	0xe2be45b9764f17adULL,
	0x27da5ead14e33fc9ULL,
	0xf2fdb71f193e3f95ULL,
	0x3c65d218ab9b81d3ULL,
	0x2a529f3867d9451ULL,
	0x1a05e2eeb8b52a71ULL,
	0xc311835d79f6f1a0ULL,
	0xafd570fcf84296e2ULL,
	0x701bfd2953b3aba9ULL,
	0xa09ad92f8e317e1fULL,
	0xae76bb034631a4a7ULL,
	0xf985bef7852f1217ULL,
	0xde8279670628bbeULL,
	0xf9cb9a30b28eab04ULL,
	0xb23f6331fd197f8dULL,
	0x249c0acd2e8d3c9eULL,
	0x61509ab18b7eb17fULL,
	0xcd686b91aba0a444ULL,
	0x7ef8ccb4468d3f5aULL,
	0x65fa22d46db8bec8ULL,
	0x2afab5ac9bb2eccULL,
	0xdcea243632570269ULL,
	0x2302adb8667682f5ULL,
	0xf319264c758dfd33ULL,
	0xf41bf154385b0441ULL,
	0xba892216b5ddf512ULL,
	0x66f69bac317bc430ULL,
	0x21fcf5d179787271ULL,
	0x3f5ccce563d11ca1ULL,
	0x3af35111d05cb421ULL,
	0x56927dd6060b7bd4ULL,
	0x3c9aad3c42c4e311ULL,
	0x58bd6dd289704318ULL,
	0x1185fd73580ceec2ULL,
	0xf00ee21bbac845e4ULL,
	0x7d43a4cf2f0a2269ULL,
	0xcad580573e121a57ULL,
	0xadef138484875171ULL,
	0x9791347679106dcaULL,
	0x8fc83be8c1990a4bULL,
	0xa12c42267be55b40ULL,
	0x165350b73a72cb60ULL,
	0xbbb03fa134637e80ULL,
	0x1d3cf774f3047e32ULL,
	0x5d17bab1a45e6971ULL,
	0x86cc271cbfe464bdULL,
	0x51e3fd31800a898cULL,
	0xb3a8b2ee3fdf2bdeULL,
	0xf86a887823b6fd51ULL,
	0x547b16a8fc4fc57eULL,
	0x90e8d67cf1a67a60ULL,
	0xc2b722ccbfc6c809ULL,
	0x7acfc0f4071b0a96ULL,
	0x38894f9479113d46ULL,
	0x9b2b3d0f0106eddbULL,
	0x42fd316f4232e2b2ULL,
	0x878e9135d8149be7ULL,
	0x417b58ebd1011cbbULL,
	0x4ce21da70ec1b0b7ULL,
	0x1ef24335b29ad074ULL,
	0x247c18d1f9546123ULL,
	0xf759ff9af4cd180ULL,
	0xed8f73138e553445ULL,
	0x7477fb74d28e7598ULL,
	0x91e9a3c4806433f7ULL,
	0x8356b1ed7bd5bec1ULL,
	0xa76d9cd0023d3df5ULL,
	0x5ae3065918fc05daULL,
	0xd4fbc7b6efe3635eULL,
	0xa1383c9477d8cec7ULL,
	0x8d07feb88c412527ULL,
	0x53c441ece6cffe29ULL,
	0x7d0b59f9fb00b041ULL,
	0x407bd04f65e1c31eULL,
	0x217ce881ba849a6ULL,
	0x7354dfe4eb00bc4dULL,
	0x19a42c97052de4a9ULL,
	0x5598ec6ef3cc60ebULL,
	0x7cfd7fbb0260dbb6ULL,
	0x94ecb81ef42e8e90ULL,
	0x99599eaa45fe34f0ULL,
	0x796c9299a0ef9685ULL,
	0x61ac148843dc50bdULL,
	0xae1b46113b1526cfULL,
	0xcaffc9893d98c1e8ULL,
	0x22c7fa938aa91474ULL,
	0xc007bb23ccbca3aaULL,
	0x9561b23745d96e3ULL,
	0xae5748062c8be766ULL,
	0x7e415c2d2aea3c4cULL,
	0xf0bf7ddc9b2dfa1ULL,
	0xf40d136ff94cd527ULL,
	0x93e483467522a02aULL,
	0xc680cc9970ea82dfULL,
	0x4e7e905daa54edafULL,
	0xae42dfe004885a44ULL,
	0x3631728b121188acULL,
	0xf942f2c2648aa2adULL,
	0x3aec24d95e38a48cULL,
	0xca3f04b9ba9bc824ULL,
	0x831a49a720ea04b5ULL,
	0x5fd9723666ed5d0fULL,
	0x39bb8a5e6d2b9839ULL,
	0x823428f4a17c5672ULL,
	0xa44411c7b714754fULL,
	0x41634f1a57fab015ULL,
	0x10a36bfa705f57d9ULL,
	0x58995552e459671aULL,
	0xcb58d5efb9dc6bdfULL,
	0x28a99585fdd13036ULL,
	0x3036c186f8009c2bULL,
	0x8bc1479e340987c6ULL,
	0xac0da1e989aaf9fbULL,
	0x8b49f98a4e5974ddULL,
	0x5b8bdc709d7f371dULL,
	0xa5a027774d63b882ULL,
	0x1ab179c255cdd4e9ULL,
	0x826bf72fb3199663ULL,
	0x54690a377c6dcca5ULL,
	0x349291e76da99a6aULL,
	0x6bf28f4ee4533819ULL,
	0x5fd0187fd5c18ff5ULL,
	0x9b0e634e3e11f435ULL,
	0xc79ab266a8adffa6ULL,
	0x23f9e6d57d0d6240ULL,
	0x6d83a48408e733bdULL,
	0x7144c0877d7fa177ULL,
	0xe816f92104e10291ULL,
	0x4f4433a8f6f68974ULL,
	0x2e55ff284d443e5bULL,
	0xb65a7711d41d7fb2ULL,
	0x9b3f4e4eddee0ba6ULL,
	0x88c94d8873f30abcULL,
	0xba336f2e72bdb31cULL,
	0x73aa3dca2acad936ULL,
	0x20eb9286fa64d1eeULL,
	0xda7d8e45f84f10b8ULL,
	0x409b167674c25419ULL,
	0xae6a42cf20f73a38ULL,
	0x9551ea0783585e28ULL,
	0xedcc7661d25446d5ULL,
	0x8a2376d052560536ULL,
	0x6e697b54ef615bc8ULL,
	0xd88cb14fdb6658f5ULL,
	0x7132b77e538a07e9ULL,
	0x63178aad6f43ed11ULL,
	0x7cabe939826d341eULL,
	0x4f9dceb6ebe0f1adULL,
	0xce0276eb05607f49ULL,
	0x7f49b4e07deee6aULL,
	0x81969b535ef67b7eULL,
	0xbbcf45b05a2a1748ULL,
	0xd8cdfc141d0e7cb7ULL,
	0x75f827d7c003f337ULL,
	0x473ea0c6c151b595ULL,
	0x4822ee1df74fe242ULL,
	0x2ddfb9803e6e02dULL,
	0xd7e314d94de8a6abULL,
	0xea36f3c6e5b6fa4ULL,
	0x6b0cd8974d6a62a2ULL,
	0xb22c218c9ddd0cfaULL,
	0x4d72edced81a2441ULL,
	0x722f7d85cf71d0fdULL,
	0x4938de818e0686efULL,
	0x77b4a66fe172be8fULL,
	0xf1cd58971196b432ULL,
	0xb6c9c7068496e801ULL,
	0xb7ee84f94fe9faabULL,
	0x21871b367247ef2eULL,
	0x6cd7909779e4e26dULL,
	0xdb3d5fcca76b46deULL,
	0xf752ab27a231e919ULL,
	0xbf0e1c4c7d468b33ULL,
	0x6b25d663f51d3c11ULL,
	0xa352b25de4b08b7bULL,
	0xbdd9aeb1d7047146ULL,
	0x7d67bd9c042a015aULL,
	0x7a000f07011ed1b3ULL,
	0x9ff91ffce63c1fedULL,
	0xb77a6e05623737eULL,
	0x6f8c2f047639020fULL,
	0xf80aec6678810741ULL,
	0xafb4e406a8c32913ULL,
	0xa3820ef12884dffeULL,
	0x72da55ce9140a8fULL,
	0x29951bab81d0bb3bULL,
	0x817a09579fcfc685ULL,
	0x9b434da5c3535f4cULL,
	0x4749af9089f8a413ULL,
	0xc1b7a276d38dd68ULL,
	0xb55e8602c60cc207ULL,
	0x9d2f929a44b1b75dULL,
	0x36e9ee702b12f7edULL,
	0x89a65594cfeac579ULL,
	0x3047db6b9762432aULL,
	0xa05b36fb873ae058ULL,
	0x3709fa8004568e03ULL,
	0x2e1e9af0432e3301ULL,
	0x94e92cd3e692cd52ULL,
	0xc0dfa2768c70f29eULL,
	0x782db9321f44498dULL,
	0x9cece49b7d6023f1ULL,
	0x9ac997272c517e96ULL,
	0x8465427beadb809eULL,
	0xa06f561b6b53bae7ULL,
	0x85c43a21ddf360baULL,
	0xe0fad0e81f714fddULL,
	0x551d372cbd38492bULL,
	0xe48649627ee903e9ULL,
	0x385144b1b50fe991ULL,
};

unsigned int uint64_table_size = sizeof(uint64_table) / sizeof(uint64_t);
