{- This module was generated from data in the Kate syntax
   highlighting file xorg.xml, version 1.01, by Jan Janssen (medhefgo@web.de) -}

module Text.Highlighting.Kate.Syntax.Xorg
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "x.org Configuration"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "xorg.conf"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpression

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  (lang,cont) <- currentContext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("x.org Configuration","xorg")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("x.org Configuration","xorg") -> return ()
      ("x.org Configuration","Section") -> return ()
      ("x.org Configuration","Section Content") -> return ()
      ("x.org Configuration","Keyword") -> (popContext) >> pEndLine
      ("x.org Configuration","Comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5cb'5cw'2b'5cb = compileRegex "\\b\\w+\\b"
regex_'5b'5cw'5cd'5d'2b = compileRegex "[\\w\\d]+"

parseRules ("x.org Configuration","xorg") =
  (((pString False "Section" >>= withAttribute FunctionTok) >>~ pushContext ("x.org Configuration","Section"))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext ("x.org Configuration","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("x.org Configuration","xorg")) >> pDefault >>= withAttribute NormalTok))

parseRules ("x.org Configuration","Section") =
  (((pRangeDetect '"' '"' >>= withAttribute StringTok) >>~ pushContext ("x.org Configuration","Section Content"))
   <|>
   ((pRangeDetect '\'' '\'' >>= withAttribute StringTok) >>~ pushContext ("x.org Configuration","Section Content"))
   <|>
   ((pDetectIdentifier >>= withAttribute ErrorTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext ("x.org Configuration","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("x.org Configuration","Section")) >> pDefault >>= withAttribute NormalTok))

parseRules ("x.org Configuration","Section Content") =
  (((pString False "EndSection" >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   ((pString False "EndSubSection" >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   ((pString False "SubSection" >>= withAttribute FunctionTok) >>~ pushContext ("x.org Configuration","Section"))
   <|>
   ((pRegExpr regex_'5cb'5cw'2b'5cb >>= withAttribute NormalTok) >>~ pushContext ("x.org Configuration","Keyword"))
   <|>
   ((pDetectChar False '#' >>= withAttribute NormalTok) >>~ pushContext ("x.org Configuration","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("x.org Configuration","Section Content")) >> pDefault >>= withAttribute NormalTok))

parseRules ("x.org Configuration","Keyword") =
  (((pRangeDetect '"' '"' >>= withAttribute DataTypeTok))
   <|>
   ((pRangeDetect '\'' '\'' >>= withAttribute DataTypeTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b'5cw'5cd'5d'2b >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '#' >>= withAttribute KeywordTok) >>~ pushContext ("x.org Configuration","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("x.org Configuration","Keyword")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("x.org Configuration","Comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("x.org Configuration","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression

parseRules x = parseRules ("x.org Configuration","xorg") <|> fail ("Unknown context" ++ show x)
