{- This module was generated from data in the Kate syntax
   highlighting file javascript.xml, version 1.18, by Anders Lund (anders@alweb.dk), Joseph Wenninger (jowenn@kde.org), Whitehawk Stormchaser (zerokode@gmx.net) -}

module Text.Highlighting.Kate.Syntax.Javascript
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "JavaScript"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.js"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "JavaScript" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("JavaScript",["Normal"])], synStLanguage = "JavaScript", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext) >> pEndLine
    "String 1" -> (popContext) >> pEndLine
    "Comment" -> (popContext) >> pEndLine
    "Multi/inline Comment" -> return ()
    "Regular Expression" -> return ()
    "(Internal regex catch)" -> return ()
    "Regular Expression Character Class" -> return ()
    "(regex caret first check)" -> (popContext) >> pEndLine
    "(charclass caret first check)" -> (popContext) >> pEndLine
    "region_marker" -> (popContext) >> pEndLine
    "ObjectMember" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "if else for in while do continue break with try catch finally switch case new var function return delete true false void throw typeof const default"
list_functions = Set.fromList $ words $ "escape isFinite isNaN Number parseFloat parseInt reload taint unescape untaint write"
list_objects = Set.fromList $ words $ "Anchor Applet Area Array Boolean Button Checkbox Date document window Image FileUpload Form Frame Function Hidden Link MimeType Math Max Min Layer navigator Object Password Plugin Radio RegExp Reset Screen Select String Text Textarea this Window"
list_math = Set.fromList $ words $ "abs acos asin atan atan2 ceil cos ctg E exp floor LN2 LN10 log LOG2E LOG10E PI pow round sin sqrt SQRT1_2 SQRT2 tan"
list_events = Set.fromList $ words $ "onAbort onBlur onChange onClick onError onFocus onLoad onMouseOut onMouseOver onReset onSelect onSubmit onUnload"

regex_'5cb'5b'5cw'5c'2e'5d'2b'5cb'5cs'2a'28'3f'3d'3a'29 = compileRegex "\\b[\\w\\.]+\\b\\s*(?=:)"
regex_'5cb'5b'5cw'5c'2e'5d'2b'28'3f'3d'5c'2e'29 = compileRegex "\\b[\\w\\.]+(?=\\.)"
regex_'5b'3d'3f'3a'5d = compileRegex "[=?:]"
regex_'5c'28 = compileRegex "\\("
regex_'2f'5big'5d'7b0'2c2'7d = compileRegex "/[ig]{0,2}"
regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d = compileRegex "\\{[\\d, ]+\\}"
regex_'5c'5c'5bbB'5d = compileRegex "\\\\[bB]"
regex_'5c'5c'5bnrtvfDdSsWw'5d = compileRegex "\\\\[nrtvfDdSsWw]"
regex_'5c'5c'2e = compileRegex "\\\\."
regex_'5c'24'28'3f'3d'2f'29 = compileRegex "\\$(?=/)"
regex_'2f'2f'28'3f'3d'3b'29 = compileRegex "//(?=;)"
regex_'5c'5c'5b'5c'5b'5c'5d'5d = compileRegex "\\\\[\\[\\]]"

defaultAttributes = [("Normal",NormalTok),("String",StringTok),("String 1",CharTok),("Comment",CommentTok),("Multi/inline Comment",CommentTok),("Regular Expression",OtherTok),("(Internal regex catch)",NormalTok),("Regular Expression Character Class",BaseNTok),("(regex caret first check)",FloatTok),("(charclass caret first check)",FloatTok),("region_marker",RegionMarkerTok),("ObjectMember",NormalTok)]

parseRules "Normal" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext "region_marker")
   <|>
   ((pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext "region_marker")
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'5b'5cw'5c'2e'5d'2b'5cb'5cs'2a'28'3f'3d'3a'29 >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute FunctionTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_objects >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_math >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_events >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '.' >>= withAttribute NormalTok) >>~ pushContext "ObjectMember")
   <|>
   ((pRegExpr regex_'5cb'5b'5cw'5c'2e'5d'2b'28'3f'3d'5c'2e'29 >>= withAttribute KeywordTok) >>~ pushContext "ObjectMember")
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext "String 1")
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Multi/inline Comment")
   <|>
   ((pRegExpr regex_'5b'3d'3f'3a'5d >>= withAttribute NormalTok) >>~ pushContext "(Internal regex catch)")
   <|>
   ((pRegExpr regex_'5c'28 >>= withAttribute NormalTok) >>~ pushContext "(Internal regex catch)")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pAnyChar ":!%&+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok)))

parseRules "String" =
  (((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "String 1" =
  (((pDetectIdentifier >>= withAttribute CharTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext)))

parseRules "Comment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "Multi/inline Comment" =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Regular Expression" =
  (((pRegExpr regex_'2f'5big'5d'7b0'2c2'7d >>= withAttribute OtherTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5c'7b'5b'5cd'2c_'5d'2b'5c'7d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bbB'5d >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'5c'5bnrtvfDdSsWw'5d >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False '[' >>= withAttribute BaseNTok) >>~ pushContext "(charclass caret first check)")
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'24'28'3f'3d'2f'29 >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "?+*()|" >>= withAttribute FloatTok)))

parseRules "(Internal regex catch)" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'2f'2f'28'3f'3d'3b'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "Multi/inline Comment")
   <|>
   ((pDetectChar False '/' >>= withAttribute OtherTok) >>~ pushContext "(regex caret first check)")
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules "Regular Expression Character Class" =
  (((pRegExpr regex_'5c'5c'5b'5c'5b'5c'5d'5d >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5c'5c'2e >>= withAttribute FloatTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute BaseNTok) >>~ (popContext >> popContext)))

parseRules "(regex caret first check)" =
  (((pDetectChar False '^' >>= withAttribute FloatTok) >>~ pushContext "Regular Expression")
   <|>
   (pushContext "Regular Expression" >> currentContext >>= parseRules))

parseRules "(charclass caret first check)" =
  (((pDetectChar False '^' >>= withAttribute FloatTok) >>~ pushContext "Regular Expression Character Class")
   <|>
   (pushContext "Regular Expression Character Class" >> currentContext >>= parseRules))

parseRules "region_marker" =
  (((pDetectIdentifier >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetectSpaces >>= withAttribute RegionMarkerTok)))

parseRules "ObjectMember" =
  (((pDetectChar False '.' >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute FunctionTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((lookAhead (pAnyChar "(){}:!%&+,-/.*<=>?[]|~^;") >> (popContext) >> currentContext >>= parseRules)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
