{- This module was generated from data in the Kate syntax highlighting file java.xml, version 1.19,
   by  Alfredo Luiz Foltran Fialho (alfoltran@ig.com.br) -}

module Text.Highlighting.Kate.Syntax.Java ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Javadoc
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Java"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.java"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Java" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Java",["Normal"])], synStLanguage = "Java", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "InFunctionCall" -> return () >> pHandleEndLine
    "String" -> (popContext) >> pEndLine
    "EnterPrintf" -> return () >> pHandleEndLine
    "Printf" -> return () >> pHandleEndLine
    "PrintfString" -> (popContext) >> pEndLine
    "Member" -> (popContext) >> pEndLine
    "StaticImports" -> (popContext) >> pEndLine
    "Imports" -> (popContext) >> pEndLine
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Function","fu"),("StaticImports","kw"),("Imports","kw"),("Data Type","dt"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Char","ch"),("String","st"),("String Char","ch"),("PrintfString","st"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_java15 = Set.fromList $ words $ "ACTIVE ACTIVITY_COMPLETED ACTIVITY_REQUIRED ARG_IN ARG_INOUT ARG_OUT AWTError AWTEvent AWTEventListener AWTEventListenerProxy AWTEventMulticaster AWTException AWTKeyStroke AWTPermission AbstractAction AbstractBorder AbstractButton AbstractCellEditor AbstractCollection AbstractColorChooserPanel AbstractDocument AbstractDocument.AttributeContext AbstractDocument.Content AbstractDocument.ElementEdit AbstractExecutorService AbstractInterruptibleChannel AbstractLayoutCache AbstractLayoutCache.NodeDimensions AbstractList AbstractListModel AbstractMap AbstractMethodError AbstractPreferences AbstractQueue AbstractQueuedSynchronizer AbstractSelectableChannel AbstractSelectionKey AbstractSelector AbstractSequentialList AbstractSet AbstractSpinnerModel AbstractTableModel AbstractUndoableEdit AbstractWriter AccessControlContext AccessControlException AccessController AccessException Accessible AccessibleAction AccessibleAttributeSequence AccessibleBundle AccessibleComponent AccessibleContext AccessibleEditableText AccessibleExtendedComponent AccessibleExtendedTable AccessibleExtendedText AccessibleHyperlink AccessibleHypertext AccessibleIcon AccessibleKeyBinding AccessibleObject AccessibleRelation AccessibleRelationSet AccessibleResourceBundle AccessibleRole AccessibleSelection AccessibleState AccessibleStateSet AccessibleStreamable AccessibleTable AccessibleTableModelChange AccessibleText AccessibleTextSequence AccessibleValue AccountException AccountExpiredException AccountLockedException AccountNotFoundException Acl AclEntry AclNotFoundException Action ActionEvent ActionListener ActionMap ActionMapUIResource Activatable ActivateFailedException ActivationDesc ActivationException ActivationGroup ActivationGroupDesc ActivationGroupDesc.CommandEnvironment ActivationGroupID ActivationGroup_Stub ActivationID ActivationInstantiator ActivationMonitor ActivationSystem Activator ActiveEvent ActivityCompletedException ActivityRequiredException AdapterActivator AdapterActivatorOperations AdapterAlreadyExists AdapterAlreadyExistsHelper AdapterInactive AdapterInactiveHelper AdapterManagerIdHelper AdapterNameHelper AdapterNonExistent AdapterNonExistentHelper AdapterStateHelper AddressHelper Adjustable AdjustmentEvent AdjustmentListener Adler32 AffineTransform AffineTransformOp AlgorithmParameterGenerator AlgorithmParameterGeneratorSpi AlgorithmParameterSpec AlgorithmParameters AlgorithmParametersSpi AllPermission AlphaComposite AlreadyBound AlreadyBoundException AlreadyBoundHelper AlreadyBoundHolder AlreadyConnectedException AncestorEvent AncestorListener AnnotatedElement Annotation Annotation AnnotationFormatError AnnotationTypeMismatchException Any AnyHolder AnySeqHelper AnySeqHelper AnySeqHolder AppConfigurationEntry AppConfigurationEntry.LoginModuleControlFlag Appendable Applet AppletContext AppletInitializer AppletStub ApplicationException Arc2D Arc2D.Double Arc2D.Float Area AreaAveragingScaleFilter ArithmeticException Array Array ArrayBlockingQueue ArrayIndexOutOfBoundsException ArrayList ArrayStoreException ArrayType Arrays AssertionError AsyncBoxView AsynchronousCloseException AtomicBoolean AtomicInteger AtomicIntegerArray AtomicIntegerFieldUpdater AtomicLong AtomicLongArray AtomicLongFieldUpdater AtomicMarkableReference AtomicReference AtomicReferenceArray AtomicReferenceFieldUpdater AtomicStampedReference Attr Attribute Attribute Attribute AttributeChangeNotification AttributeChangeNotificationFilter AttributeException AttributeInUseException AttributeList AttributeList AttributeList AttributeListImpl AttributeModificationException AttributeNotFoundException AttributeSet AttributeSet AttributeSet.CharacterAttribute AttributeSet.ColorAttribute AttributeSet.FontAttribute AttributeSet.ParagraphAttribute AttributeSetUtilities AttributeValueExp AttributedCharacterIterator AttributedCharacterIterator.Attribute AttributedString Attributes Attributes Attributes Attributes.Name Attributes2 Attributes2Impl AttributesImpl AudioClip AudioFileFormat AudioFileFormat.Type AudioFileReader AudioFileWriter AudioFormat AudioFormat.Encoding AudioInputStream AudioPermission AudioSystem AuthPermission AuthProvider AuthenticationException AuthenticationException AuthenticationNotSupportedException Authenticator Authenticator.RequestorType AuthorizeCallback Autoscroll BAD_CONTEXT BAD_INV_ORDER BAD_OPERATION BAD_PARAM BAD_POLICY BAD_POLICY_TYPE BAD_POLICY_VALUE BAD_QOS BAD_TYPECODE BMPImageWriteParam BackingStoreException BadAttributeValueExpException BadBinaryOpValueExpException BadKind BadLocationException BadPaddingException BadStringOperationException BandCombineOp BandedSampleModel BaseRowSet BasicArrowButton BasicAttribute BasicAttributes BasicBorders BasicBorders.ButtonBorder BasicBorders.FieldBorder BasicBorders.MarginBorder BasicBorders.MenuBarBorder BasicBorders.RadioButtonBorder BasicBorders.RolloverButtonBorder BasicBorders.SplitPaneBorder BasicBorders.ToggleButtonBorder BasicButtonListener BasicButtonUI BasicCheckBoxMenuItemUI BasicCheckBoxUI BasicColorChooserUI BasicComboBoxEditor BasicComboBoxEditor.UIResource BasicComboBoxRenderer BasicComboBoxRenderer.UIResource BasicComboBoxUI BasicComboPopup BasicControl BasicDesktopIconUI BasicDesktopPaneUI BasicDirectoryModel BasicEditorPaneUI BasicFileChooserUI BasicFormattedTextFieldUI BasicGraphicsUtils BasicHTML BasicIconFactory BasicInternalFrameTitlePane BasicInternalFrameUI BasicLabelUI BasicListUI BasicLookAndFeel BasicMenuBarUI BasicMenuItemUI BasicMenuUI BasicOptionPaneUI BasicOptionPaneUI.ButtonAreaLayout BasicPanelUI BasicPasswordFieldUI BasicPermission BasicPopupMenuSeparatorUI BasicPopupMenuUI BasicProgressBarUI BasicRadioButtonMenuItemUI BasicRadioButtonUI BasicRootPaneUI BasicScrollBarUI BasicScrollPaneUI BasicSeparatorUI BasicSliderUI BasicSpinnerUI BasicSplitPaneDivider BasicSplitPaneUI BasicStroke BasicTabbedPaneUI BasicTableHeaderUI BasicTableUI BasicTextAreaUI BasicTextFieldUI BasicTextPaneUI BasicTextUI BasicTextUI.BasicCaret BasicTextUI.BasicHighlighter BasicToggleButtonUI BasicToolBarSeparatorUI BasicToolBarUI BasicToolTipUI BasicTreeUI BasicViewportUI BatchUpdateException BeanContext BeanContextChild BeanContextChildComponentProxy BeanContextChildSupport BeanContextContainerProxy BeanContextEvent BeanContextMembershipEvent BeanContextMembershipListener BeanContextProxy BeanContextServiceAvailableEvent BeanContextServiceProvider BeanContextServiceProviderBeanInfo BeanContextServiceRevokedEvent BeanContextServiceRevokedListener BeanContextServices BeanContextServicesListener BeanContextServicesSupport BeanContextServicesSupport.BCSSServiceProvider BeanContextSupport BeanContextSupport.BCSIterator BeanDescriptor BeanInfo Beans BevelBorder Bidi BigDecimal BigInteger BinaryRefAddr BindException Binding Binding BindingHelper BindingHolder BindingIterator BindingIteratorHelper BindingIteratorHolder BindingIteratorOperations BindingIteratorPOA BindingListHelper BindingListHolder BindingType BindingTypeHelper BindingTypeHolder BitSet Blob BlockView BlockingQueue Book Boolean BooleanControl BooleanControl.Type BooleanHolder BooleanSeqHelper BooleanSeqHolder Border BorderFactory BorderLayout BorderUIResource BorderUIResource.BevelBorderUIResource BorderUIResource.CompoundBorderUIResource BorderUIResource.EmptyBorderUIResource BorderUIResource.EtchedBorderUIResource BorderUIResource.LineBorderUIResource BorderUIResource.MatteBorderUIResource BorderUIResource.TitledBorderUIResource BoundedRangeModel Bounds Bounds Box Box.Filler BoxLayout BoxView BoxedValueHelper BreakIterator BrokenBarrierException Buffer BufferCapabilities BufferCapabilities.FlipContents BufferOverflowException BufferStrategy BufferUnderflowException BufferedImage BufferedImageFilter BufferedImageOp BufferedInputStream BufferedOutputStream BufferedReader BufferedWriter Button ButtonGroup ButtonModel ButtonUI Byte ByteArrayInputStream ByteArrayOutputStream ByteBuffer ByteChannel ByteHolder ByteLookupTable ByteOrder CDATASection CMMException CODESET_INCOMPATIBLE COMM_FAILURE CRC32 CRL CRLException CRLSelector CSS CSS.Attribute CTX_RESTRICT_SCOPE CacheRequest CacheResponse CachedRowSet Calendar Callable CallableStatement Callback CallbackHandler CancelablePrintJob CancellationException CancelledKeyException CannotProceed CannotProceedException CannotProceedHelper CannotProceedHolder CannotRedoException CannotUndoException Canvas CardLayout Caret CaretEvent CaretListener CellEditor CellEditorListener CellRendererPane CertPath CertPath.CertPathRep CertPathBuilder CertPathBuilderException CertPathBuilderResult CertPathBuilderSpi CertPathParameters CertPathTrustManagerParameters CertPathValidator CertPathValidatorException CertPathValidatorResult CertPathValidatorSpi CertSelector CertStore CertStoreException CertStoreParameters CertStoreSpi Certificate Certificate Certificate Certificate.CertificateRep CertificateEncodingException CertificateEncodingException CertificateException CertificateException CertificateExpiredException CertificateExpiredException CertificateFactory CertificateFactorySpi CertificateNotYetValidException CertificateNotYetValidException CertificateParsingException CertificateParsingException ChangeEvent ChangeListener ChangedCharSetException Channel ChannelBinding Channels CharArrayReader CharArrayWriter CharBuffer CharConversionException CharHolder CharSeqHelper CharSeqHolder CharSequence Character Character.Subset Character.UnicodeBlock CharacterCodingException CharacterData CharacterIterator Charset CharsetDecoder CharsetEncoder CharsetProvider Checkbox CheckboxGroup CheckboxMenuItem CheckedInputStream CheckedOutputStream Checksum Choice ChoiceCallback ChoiceFormat Chromaticity Cipher CipherInputStream CipherOutputStream CipherSpi Class ClassCastException ClassCircularityError ClassDefinition ClassDesc ClassFileTransformer ClassFormatError ClassLoader ClassLoaderRepository ClassLoadingMXBean ClassNotFoundException ClientRequestInfo ClientRequestInfoOperations ClientRequestInterceptor ClientRequestInterceptorOperations Clip Clipboard ClipboardOwner Clob CloneNotSupportedException Cloneable Closeable ClosedByInterruptException ClosedChannelException ClosedSelectorException CodeSets CodeSigner CodeSource Codec CodecFactory CodecFactoryHelper CodecFactoryOperations CodecOperations CoderMalfunctionError CoderResult CodingErrorAction CollationElementIterator CollationKey Collator Collection CollectionCertStoreParameters Collections Color ColorChooserComponentFactory ColorChooserUI ColorConvertOp ColorModel ColorSelectionModel ColorSpace ColorSupported ColorType ColorUIResource ComboBoxEditor ComboBoxModel ComboBoxUI ComboPopup Comment CommunicationException Comparable Comparator CompilationMXBean Compiler CompletionService CompletionStatus CompletionStatusHelper Component ComponentAdapter ComponentColorModel ComponentEvent ComponentIdHelper ComponentInputMap ComponentInputMapUIResource ComponentListener ComponentOrientation ComponentSampleModel ComponentUI ComponentView Composite CompositeContext CompositeData CompositeDataSupport CompositeName CompositeType CompositeView CompoundBorder CompoundControl CompoundControl.Type CompoundEdit CompoundName Compression ConcurrentHashMap ConcurrentLinkedQueue ConcurrentMap ConcurrentModificationException Condition Configuration ConfigurationException ConfirmationCallback ConnectException ConnectException ConnectIOException Connection ConnectionEvent ConnectionEventListener ConnectionPendingException ConnectionPoolDataSource ConsoleHandler Constructor Container ContainerAdapter ContainerEvent ContainerListener ContainerOrderFocusTraversalPolicy ContentHandler ContentHandler ContentHandlerFactory ContentModel Context Context ContextList ContextNotEmptyException ContextualRenderedImageFactory Control Control Control.Type ControlFactory ControllerEventListener ConvolveOp CookieHandler CookieHolder Copies CopiesSupported CopyOnWriteArrayList CopyOnWriteArraySet CountDownLatch CounterMonitor CounterMonitorMBean CredentialException CredentialExpiredException CredentialNotFoundException CropImageFilter CubicCurve2D CubicCurve2D.Double CubicCurve2D.Float Currency Current Current Current CurrentHelper CurrentHelper CurrentHelper CurrentHolder CurrentOperations CurrentOperations CurrentOperations Cursor CustomMarshal CustomValue Customizer CyclicBarrier DATA_CONVERSION DESKeySpec DESedeKeySpec DGC DHGenParameterSpec DHKey DHParameterSpec DHPrivateKey DHPrivateKeySpec DHPublicKey DHPublicKeySpec DISCARDING DOMConfiguration DOMError DOMErrorHandler DOMException DOMImplementation DOMImplementationLS DOMImplementationList DOMImplementationRegistry DOMImplementationSource DOMLocator DOMLocator DOMResult DOMSource DOMStringList DSAKey DSAKeyPairGenerator DSAParameterSpec DSAParams DSAPrivateKey DSAPrivateKeySpec DSAPublicKey DSAPublicKeySpec DTD DTDConstants DTDHandler DataBuffer DataBufferByte DataBufferDouble DataBufferFloat DataBufferInt DataBufferShort DataBufferUShort DataFlavor DataFormatException DataInput DataInputStream DataInputStream DataLine DataLine.Info DataOutput DataOutputStream DataOutputStream DataSource DataTruncation DatabaseMetaData DatagramChannel DatagramPacket DatagramSocket DatagramSocketImpl DatagramSocketImplFactory DatatypeConfigurationException DatatypeConstants DatatypeConstants.Field DatatypeFactory Date Date DateFormat DateFormat.Field DateFormatSymbols DateFormatter DateTimeAtCompleted DateTimeAtCreation DateTimeAtProcessing DateTimeSyntax DebugGraphics DecimalFormat DecimalFormatSymbols DeclHandler DefaultBoundedRangeModel DefaultButtonModel DefaultCaret DefaultCellEditor DefaultColorSelectionModel DefaultComboBoxModel DefaultDesktopManager DefaultEditorKit DefaultEditorKit.BeepAction DefaultEditorKit.CopyAction DefaultEditorKit.CutAction DefaultEditorKit.DefaultKeyTypedAction DefaultEditorKit.InsertBreakAction DefaultEditorKit.InsertContentAction DefaultEditorKit.InsertTabAction DefaultEditorKit.PasteAction DefaultFocusManager DefaultFocusTraversalPolicy DefaultFormatter DefaultFormatterFactory DefaultHandler DefaultHandler2 DefaultHighlighter DefaultHighlighter.DefaultHighlightPainter DefaultKeyboardFocusManager DefaultListCellRenderer DefaultListCellRenderer.UIResource DefaultListModel DefaultListSelectionModel DefaultLoaderRepository DefaultLoaderRepository DefaultMenuLayout DefaultMetalTheme DefaultMutableTreeNode DefaultPersistenceDelegate DefaultSingleSelectionModel DefaultStyledDocument DefaultStyledDocument.AttributeUndoableEdit DefaultStyledDocument.ElementSpec DefaultTableCellRenderer DefaultTableCellRenderer.UIResource DefaultTableColumnModel DefaultTableModel DefaultTextUI DefaultTreeCellEditor DefaultTreeCellRenderer DefaultTreeModel DefaultTreeSelectionModel DefinitionKind DefinitionKindHelper Deflater DeflaterOutputStream DelayQueue Delayed Delegate Delegate Delegate DelegationPermission Deprecated Descriptor DescriptorAccess DescriptorSupport DesignMode DesktopIconUI DesktopManager DesktopPaneUI Destination DestroyFailedException Destroyable Dialog Dictionary DigestException DigestInputStream DigestOutputStream Dimension Dimension2D DimensionUIResource DirContext DirObjectFactory DirStateFactory DirStateFactory.Result DirectColorModel DirectoryManager DisplayMode DnDConstants Doc DocAttribute DocAttributeSet DocFlavor DocFlavor.BYTE_ARRAY DocFlavor.CHAR_ARRAY DocFlavor.INPUT_STREAM DocFlavor.READER DocFlavor.SERVICE_FORMATTED DocFlavor.STRING DocFlavor.URL DocPrintJob Document Document DocumentBuilder DocumentBuilderFactory DocumentEvent DocumentEvent.ElementChange DocumentEvent.EventType DocumentFilter DocumentFilter.FilterBypass DocumentFragment DocumentHandler DocumentListener DocumentName DocumentParser DocumentType Documented DomainCombiner DomainManager DomainManagerOperations Double DoubleBuffer DoubleHolder DoubleSeqHelper DoubleSeqHolder DragGestureEvent DragGestureListener DragGestureRecognizer DragSource DragSourceAdapter DragSourceContext DragSourceDragEvent DragSourceDropEvent DragSourceEvent DragSourceListener DragSourceMotionListener Driver DriverManager DriverPropertyInfo DropTarget DropTarget.DropTargetAutoScroller DropTargetAdapter DropTargetContext DropTargetDragEvent DropTargetDropEvent DropTargetEvent DropTargetListener DuplicateFormatFlagsException DuplicateName DuplicateNameHelper Duration DynAny DynAny DynAnyFactory DynAnyFactoryHelper DynAnyFactoryOperations DynAnyHelper DynAnyOperations DynAnySeqHelper DynArray DynArray DynArrayHelper DynArrayOperations DynEnum DynEnum DynEnumHelper DynEnumOperations DynFixed DynFixed DynFixedHelper DynFixedOperations DynSequence DynSequence DynSequenceHelper DynSequenceOperations DynStruct DynStruct DynStructHelper DynStructOperations DynUnion DynUnion DynUnionHelper DynUnionOperations DynValue DynValue DynValueBox DynValueBoxOperations DynValueCommon DynValueCommonOperations DynValueHelper DynValueOperations DynamicImplementation DynamicImplementation DynamicMBean ECField ECFieldF2m ECFieldFp ECGenParameterSpec ECKey ECParameterSpec ECPoint ECPrivateKey ECPrivateKeySpec ECPublicKey ECPublicKeySpec ENCODING_CDR_ENCAPS EOFException EditorKit Element Element Element ElementIterator ElementType Ellipse2D Ellipse2D.Double Ellipse2D.Float EllipticCurve EmptyBorder EmptyStackException EncodedKeySpec Encoder Encoding EncryptedPrivateKeyInfo Entity Entity EntityReference EntityResolver EntityResolver2 Enum EnumConstantNotPresentException EnumControl EnumControl.Type EnumMap EnumSet EnumSyntax Enumeration Environment Error ErrorHandler ErrorListener ErrorManager EtchedBorder Event EventContext EventDirContext EventHandler EventListener EventListenerList EventListenerProxy EventObject EventQueue EventSetDescriptor Exception ExceptionDetailMessage ExceptionInInitializerError ExceptionList ExceptionListener Exchanger ExecutionException Executor ExecutorCompletionService ExecutorService Executors ExemptionMechanism ExemptionMechanismException ExemptionMechanismSpi ExpandVetoException ExportException Expression ExtendedRequest ExtendedResponse Externalizable FREE_MEM FactoryConfigurationError FailedLoginException FeatureDescriptor Fidelity Field FieldNameHelper FieldNameHelper FieldPosition FieldView File FileCacheImageInputStream FileCacheImageOutputStream FileChannel FileChannel.MapMode FileChooserUI FileDescriptor FileDialog FileFilter FileFilter FileHandler FileImageInputStream FileImageOutputStream FileInputStream FileLock FileLockInterruptionException FileNameMap FileNotFoundException FileOutputStream FilePermission FileReader FileSystemView FileView FileWriter FilenameFilter Filter FilterInputStream FilterOutputStream FilterReader FilterWriter FilteredImageSource FilteredRowSet Finishings FixedHeightLayoutCache FixedHolder FlatteningPathIterator FlavorEvent FlavorException FlavorListener FlavorMap FlavorTable Float FloatBuffer FloatControl FloatControl.Type FloatHolder FloatSeqHelper FloatSeqHolder FlowLayout FlowView FlowView.FlowStrategy Flushable FocusAdapter FocusEvent FocusListener FocusManager FocusTraversalPolicy Font FontFormatException FontMetrics FontRenderContext FontUIResource FormSubmitEvent FormSubmitEvent.MethodType FormView Format Format.Field FormatConversionProvider FormatFlagsConversionMismatchException FormatMismatch FormatMismatchHelper Formattable FormattableFlags Formatter Formatter FormatterClosedException ForwardRequest ForwardRequest ForwardRequestHelper ForwardRequestHelper Frame Future FutureTask GSSContext GSSCredential GSSException GSSManager GSSName GZIPInputStream GZIPOutputStream GapContent GarbageCollectorMXBean GatheringByteChannel GaugeMonitor GaugeMonitorMBean GeneralPath GeneralSecurityException GenericArrayType GenericDeclaration GenericSignatureFormatError GlyphJustificationInfo GlyphMetrics GlyphVector GlyphView GlyphView.GlyphPainter GradientPaint GraphicAttribute Graphics Graphics2D GraphicsConfigTemplate GraphicsConfiguration GraphicsDevice GraphicsEnvironment GrayFilter GregorianCalendar GridBagConstraints GridBagLayout GridLayout Group Guard GuardedObject HOLDING HTML HTML.Attribute HTML.Tag HTML.UnknownTag HTMLDocument HTMLDocument.Iterator HTMLEditorKit HTMLEditorKit.HTMLFactory HTMLEditorKit.HTMLTextAction HTMLEditorKit.InsertHTMLTextAction HTMLEditorKit.LinkController HTMLEditorKit.Parser HTMLEditorKit.ParserCallback HTMLFrameHyperlinkEvent HTMLWriter Handler HandlerBase HandshakeCompletedEvent HandshakeCompletedListener HasControls HashAttributeSet HashDocAttributeSet HashMap HashPrintJobAttributeSet HashPrintRequestAttributeSet HashPrintServiceAttributeSet HashSet Hashtable HeadlessException HierarchyBoundsAdapter HierarchyBoundsListener HierarchyEvent HierarchyListener Highlighter Highlighter.Highlight Highlighter.HighlightPainter HostnameVerifier HttpRetryException HttpURLConnection HttpsURLConnection HyperlinkEvent HyperlinkEvent.EventType HyperlinkListener ICC_ColorSpace ICC_Profile ICC_ProfileGray ICC_ProfileRGB IDLEntity IDLType IDLTypeHelper IDLTypeOperations ID_ASSIGNMENT_POLICY_ID ID_UNIQUENESS_POLICY_ID IIOByteBuffer IIOException IIOImage IIOInvalidTreeException IIOMetadata IIOMetadataController IIOMetadataFormat IIOMetadataFormatImpl IIOMetadataNode IIOParam IIOParamController IIOReadProgressListener IIOReadUpdateListener IIOReadWarningListener IIORegistry IIOServiceProvider IIOWriteProgressListener IIOWriteWarningListener IMPLICIT_ACTIVATION_POLICY_ID IMP_LIMIT INACTIVE INITIALIZE INTERNAL INTF_REPOS INVALID_ACTIVITY INVALID_TRANSACTION INV_FLAG INV_IDENT INV_OBJREF INV_POLICY IOException IOR IORHelper IORHolder IORInfo IORInfoOperations IORInterceptor IORInterceptorOperations IORInterceptor_3_0 IORInterceptor_3_0Helper IORInterceptor_3_0Holder IORInterceptor_3_0Operations IRObject IRObjectOperations Icon IconUIResource IconView IdAssignmentPolicy IdAssignmentPolicyOperations IdAssignmentPolicyValue IdUniquenessPolicy IdUniquenessPolicyOperations IdUniquenessPolicyValue IdentifierHelper Identity IdentityHashMap IdentityScope IllegalAccessError IllegalAccessException IllegalArgumentException IllegalBlockSizeException IllegalBlockingModeException IllegalCharsetNameException IllegalClassFormatException IllegalComponentStateException IllegalFormatCodePointException IllegalFormatConversionException IllegalFormatException IllegalFormatFlagsException IllegalFormatPrecisionException IllegalFormatWidthException IllegalMonitorStateException IllegalPathStateException IllegalSelectorException IllegalStateException IllegalThreadStateException Image ImageCapabilities ImageConsumer ImageFilter ImageGraphicAttribute ImageIO ImageIcon ImageInputStream ImageInputStreamImpl ImageInputStreamSpi ImageObserver ImageOutputStream ImageOutputStreamImpl ImageOutputStreamSpi ImageProducer ImageReadParam ImageReader ImageReaderSpi ImageReaderWriterSpi ImageTranscoder ImageTranscoderSpi ImageTypeSpecifier ImageView ImageWriteParam ImageWriter ImageWriterSpi ImagingOpException ImplicitActivationPolicy ImplicitActivationPolicyOperations ImplicitActivationPolicyValue IncompatibleClassChangeError IncompleteAnnotationException InconsistentTypeCode InconsistentTypeCode InconsistentTypeCodeHelper IndexColorModel IndexOutOfBoundsException IndexedPropertyChangeEvent IndexedPropertyDescriptor IndirectionException Inet4Address Inet6Address InetAddress InetSocketAddress Inflater InflaterInputStream InheritableThreadLocal Inherited InitialContext InitialContextFactory InitialContextFactoryBuilder InitialDirContext InitialLdapContext InlineView InputContext InputEvent InputMap InputMapUIResource InputMethod InputMethodContext InputMethodDescriptor InputMethodEvent InputMethodHighlight InputMethodListener InputMethodRequests InputMismatchException InputSource InputStream InputStream InputStream InputStreamReader InputSubset InputVerifier Insets InsetsUIResource InstanceAlreadyExistsException InstanceNotFoundException InstantiationError InstantiationException Instrument Instrumentation InsufficientResourcesException IntBuffer IntHolder Integer IntegerSyntax Interceptor InterceptorOperations InternalError InternalFrameAdapter InternalFrameEvent InternalFrameFocusTraversalPolicy InternalFrameListener InternalFrameUI InternationalFormatter InterruptedException InterruptedIOException InterruptedNamingException InterruptibleChannel IntrospectionException IntrospectionException Introspector Invalid InvalidActivityException InvalidAddress InvalidAddressHelper InvalidAddressHolder InvalidAlgorithmParameterException InvalidApplicationException InvalidAttributeIdentifierException InvalidAttributeValueException InvalidAttributeValueException InvalidAttributesException InvalidClassException InvalidDnDOperationException InvalidKeyException InvalidKeyException InvalidKeySpecException InvalidMarkException InvalidMidiDataException InvalidName InvalidName InvalidName InvalidNameException InvalidNameHelper InvalidNameHelper InvalidNameHolder InvalidObjectException InvalidOpenTypeException InvalidParameterException InvalidParameterSpecException InvalidPolicy InvalidPolicyHelper InvalidPreferencesFormatException InvalidPropertiesFormatException InvalidRelationIdException InvalidRelationServiceException InvalidRelationTypeException InvalidRoleInfoException InvalidRoleValueException InvalidSearchControlsException InvalidSearchFilterException InvalidSeq InvalidSlot InvalidSlotHelper InvalidTargetObjectTypeException InvalidTransactionException InvalidTypeForEncoding InvalidTypeForEncodingHelper InvalidValue InvalidValue InvalidValueHelper InvocationEvent InvocationHandler InvocationTargetException InvokeHandler IstringHelper ItemEvent ItemListener ItemSelectable Iterable Iterator IvParameterSpec JApplet JButton JCheckBox JCheckBoxMenuItem JColorChooser JComboBox JComboBox.KeySelectionManager JComponent JDesktopPane JDialog JEditorPane JFileChooser JFormattedTextField JFormattedTextField.AbstractFormatter JFormattedTextField.AbstractFormatterFactory JFrame JInternalFrame JInternalFrame.JDesktopIcon JLabel JLayeredPane JList JMException JMRuntimeException JMXAuthenticator JMXConnectionNotification JMXConnector JMXConnectorFactory JMXConnectorProvider JMXConnectorServer JMXConnectorServerFactory JMXConnectorServerMBean JMXConnectorServerProvider JMXPrincipal JMXProviderException JMXServerErrorException JMXServiceURL JMenu JMenuBar JMenuItem JOptionPane JPEGHuffmanTable JPEGImageReadParam JPEGImageWriteParam JPEGQTable JPanel JPasswordField JPopupMenu JPopupMenu.Separator JProgressBar JRadioButton JRadioButtonMenuItem JRootPane JScrollBar JScrollPane JSeparator JSlider JSpinner JSpinner.DateEditor JSpinner.DefaultEditor JSpinner.ListEditor JSpinner.NumberEditor JSplitPane JTabbedPane JTable JTable.PrintMode JTableHeader JTextArea JTextComponent JTextComponent.KeyBinding JTextField JTextPane JToggleButton JToggleButton.ToggleButtonModel JToolBar JToolBar.Separator JToolTip JTree JTree.DynamicUtilTreeNode JTree.EmptySelectionModel JViewport JWindow JarEntry JarException JarFile JarInputStream JarOutputStream JarURLConnection JdbcRowSet JobAttributes JobAttributes.DefaultSelectionType JobAttributes.DestinationType JobAttributes.DialogType JobAttributes.MultipleDocumentHandlingType JobAttributes.SidesType JobHoldUntil JobImpressions JobImpressionsCompleted JobImpressionsSupported JobKOctets JobKOctetsProcessed JobKOctetsSupported JobMediaSheets JobMediaSheetsCompleted JobMediaSheetsSupported JobMessageFromOperator JobName JobOriginatingUserName JobPriority JobPrioritySupported JobSheets JobState JobStateReason JobStateReasons JoinRowSet Joinable KerberosKey KerberosPrincipal KerberosTicket Kernel Key KeyAdapter KeyAgreement KeyAgreementSpi KeyAlreadyExistsException KeyEvent KeyEventDispatcher KeyEventPostProcessor KeyException KeyFactory KeyFactorySpi KeyGenerator KeyGeneratorSpi KeyListener KeyManagementException KeyManager KeyManagerFactory KeyManagerFactorySpi KeyPair KeyPairGenerator KeyPairGeneratorSpi KeyRep KeyRep.Type KeySpec KeyStore KeyStore.Builder KeyStore.CallbackHandlerProtection KeyStore.Entry KeyStore.LoadStoreParameter KeyStore.PasswordProtection KeyStore.PrivateKeyEntry KeyStore.ProtectionParameter KeyStore.SecretKeyEntry KeyStore.TrustedCertificateEntry KeyStoreBuilderParameters KeyStoreException KeyStoreSpi KeyStroke KeyboardFocusManager Keymap LDAPCertStoreParameters LIFESPAN_POLICY_ID LOCATION_FORWARD LSException LSInput LSLoadEvent LSOutput LSParser LSParserFilter LSProgressEvent LSResourceResolver LSSerializer LSSerializerFilter Label LabelUI LabelView LanguageCallback LastOwnerException LayeredHighlighter LayeredHighlighter.LayerPainter LayoutFocusTraversalPolicy LayoutManager LayoutManager2 LayoutQueue LdapContext LdapName LdapReferralException Lease Level LexicalHandler LifespanPolicy LifespanPolicyOperations LifespanPolicyValue LimitExceededException Line Line.Info Line2D Line2D.Double Line2D.Float LineBorder LineBreakMeasurer LineEvent LineEvent.Type LineListener LineMetrics LineNumberInputStream LineNumberReader LineUnavailableException LinkException LinkLoopException LinkRef LinkageError LinkedBlockingQueue LinkedHashMap LinkedHashSet LinkedList List List ListCellRenderer ListDataEvent ListDataListener ListIterator ListModel ListResourceBundle ListSelectionEvent ListSelectionListener ListSelectionModel ListUI ListView ListenerNotFoundException LoaderHandler LocalObject Locale LocateRegistry Locator Locator2 Locator2Impl LocatorImpl Lock LockSupport LogManager LogRecord LogStream Logger LoggingMXBean LoggingPermission LoginContext LoginException LoginModule Long LongBuffer LongHolder LongLongSeqHelper LongLongSeqHolder LongSeqHelper LongSeqHolder LookAndFeel LookupOp LookupTable MARSHAL MBeanAttributeInfo MBeanConstructorInfo MBeanException MBeanFeatureInfo MBeanInfo MBeanNotificationInfo MBeanOperationInfo MBeanParameterInfo MBeanPermission MBeanRegistration MBeanRegistrationException MBeanServer MBeanServerBuilder MBeanServerConnection MBeanServerDelegate MBeanServerDelegateMBean MBeanServerFactory MBeanServerForwarder MBeanServerInvocationHandler MBeanServerNotification MBeanServerNotificationFilter MBeanServerPermission MBeanTrustPermission MGF1ParameterSpec MLet MLetMBean Mac MacSpi MalformedInputException MalformedLinkException MalformedObjectNameException MalformedParameterizedTypeException MalformedURLException ManageReferralControl ManagementFactory ManagementPermission ManagerFactoryParameters Manifest Map Map.Entry MappedByteBuffer MarshalException MarshalledObject MaskFormatter MatchResult Matcher Math MathContext MatteBorder Media MediaName MediaPrintableArea MediaSize MediaSize.Engineering MediaSize.ISO MediaSize.JIS MediaSize.NA MediaSize.Other MediaSizeName MediaTracker MediaTray Member MemoryCacheImageInputStream MemoryCacheImageOutputStream MemoryHandler MemoryImageSource MemoryMXBean MemoryManagerMXBean MemoryNotificationInfo MemoryPoolMXBean MemoryType MemoryUsage Menu MenuBar MenuBarUI MenuComponent MenuContainer MenuDragMouseEvent MenuDragMouseListener MenuElement MenuEvent MenuItem MenuItemUI MenuKeyEvent MenuKeyListener MenuListener MenuSelectionManager MenuShortcut MessageDigest MessageDigestSpi MessageFormat MessageFormat.Field MessageProp MetaEventListener MetaMessage MetalBorders MetalBorders.ButtonBorder MetalBorders.Flush3DBorder MetalBorders.InternalFrameBorder MetalBorders.MenuBarBorder MetalBorders.MenuItemBorder MetalBorders.OptionDialogBorder MetalBorders.PaletteBorder MetalBorders.PopupMenuBorder MetalBorders.RolloverButtonBorder MetalBorders.ScrollPaneBorder MetalBorders.TableHeaderBorder MetalBorders.TextFieldBorder MetalBorders.ToggleButtonBorder MetalBorders.ToolBarBorder MetalButtonUI MetalCheckBoxIcon MetalCheckBoxUI MetalComboBoxButton MetalComboBoxEditor MetalComboBoxEditor.UIResource MetalComboBoxIcon MetalComboBoxUI MetalDesktopIconUI MetalFileChooserUI MetalIconFactory MetalIconFactory.FileIcon16 MetalIconFactory.FolderIcon16 MetalIconFactory.PaletteCloseIcon MetalIconFactory.TreeControlIcon MetalIconFactory.TreeFolderIcon MetalIconFactory.TreeLeafIcon MetalInternalFrameTitlePane MetalInternalFrameUI MetalLabelUI MetalLookAndFeel MetalMenuBarUI MetalPopupMenuSeparatorUI MetalProgressBarUI MetalRadioButtonUI MetalRootPaneUI MetalScrollBarUI MetalScrollButton MetalScrollPaneUI MetalSeparatorUI MetalSliderUI MetalSplitPaneUI MetalTabbedPaneUI MetalTextFieldUI MetalTheme MetalToggleButtonUI MetalToolBarUI MetalToolTipUI MetalTreeUI Method MethodDescriptor MidiChannel MidiDevice MidiDevice.Info MidiDeviceProvider MidiEvent MidiFileFormat MidiFileReader MidiFileWriter MidiMessage MidiSystem MidiUnavailableException MimeTypeParseException MinimalHTMLWriter MissingFormatArgumentException MissingFormatWidthException MissingResourceException Mixer Mixer.Info MixerProvider ModelMBean ModelMBeanAttributeInfo ModelMBeanConstructorInfo ModelMBeanInfo ModelMBeanInfoSupport ModelMBeanNotificationBroadcaster ModelMBeanNotificationInfo ModelMBeanOperationInfo ModificationItem Modifier Monitor MonitorMBean MonitorNotification MonitorSettingException MouseAdapter MouseDragGestureRecognizer MouseEvent MouseInfo MouseInputAdapter MouseInputListener MouseListener MouseMotionAdapter MouseMotionListener MouseWheelEvent MouseWheelListener MultiButtonUI MultiColorChooserUI MultiComboBoxUI MultiDesktopIconUI MultiDesktopPaneUI MultiDoc MultiDocPrintJob MultiDocPrintService MultiFileChooserUI MultiInternalFrameUI MultiLabelUI MultiListUI MultiLookAndFeel MultiMenuBarUI MultiMenuItemUI MultiOptionPaneUI MultiPanelUI MultiPixelPackedSampleModel MultiPopupMenuUI MultiProgressBarUI MultiRootPaneUI MultiScrollBarUI MultiScrollPaneUI MultiSeparatorUI MultiSliderUI MultiSpinnerUI MultiSplitPaneUI MultiTabbedPaneUI MultiTableHeaderUI MultiTableUI MultiTextUI MultiToolBarUI MultiToolTipUI MultiTreeUI MultiViewportUI MulticastSocket MultipleComponentProfileHelper MultipleComponentProfileHolder MultipleDocumentHandling MultipleMaster MutableAttributeSet MutableComboBoxModel MutableTreeNode NON_EXISTENT NO_IMPLEMENT NO_MEMORY NO_PERMISSION NO_RESOURCES NO_RESPONSE NVList Name NameAlreadyBoundException NameCallback NameClassPair NameComponent NameComponentHelper NameComponentHolder NameDynAnyPair NameDynAnyPairHelper NameDynAnyPairSeqHelper NameHelper NameHolder NameList NameNotFoundException NameParser NameValuePair NameValuePair NameValuePairHelper NameValuePairHelper NameValuePairSeqHelper NamedNodeMap NamedValue NamespaceChangeListener NamespaceContext NamespaceSupport Naming NamingContext NamingContextExt NamingContextExtHelper NamingContextExtHolder NamingContextExtOperations NamingContextExtPOA NamingContextHelper NamingContextHolder NamingContextOperations NamingContextPOA NamingEnumeration NamingEvent NamingException NamingExceptionEvent NamingListener NamingManager NamingSecurityException NavigationFilter NavigationFilter.FilterBypass NegativeArraySizeException NetPermission NetworkInterface NoClassDefFoundError NoConnectionPendingException NoContext NoContextHelper NoInitialContextException NoPermissionException NoRouteToHostException NoServant NoServantHelper NoSuchAlgorithmException NoSuchAttributeException NoSuchElementException NoSuchFieldError NoSuchFieldException NoSuchMethodError NoSuchMethodException NoSuchObjectException NoSuchPaddingException NoSuchProviderException Node NodeChangeEvent NodeChangeListener NodeList NonReadableChannelException NonWritableChannelException NoninvertibleTransformException NotActiveException NotBoundException NotCompliantMBeanException NotContextException NotEmpty NotEmptyHelper NotEmptyHolder NotFound NotFoundHelper NotFoundHolder NotFoundReason NotFoundReasonHelper NotFoundReasonHolder NotOwnerException NotSerializableException NotYetBoundException NotYetConnectedException Notation Notification NotificationBroadcaster NotificationBroadcasterSupport NotificationEmitter NotificationFilter NotificationFilterSupport NotificationListener NotificationResult NullCipher NullPointerException Number NumberFormat NumberFormat.Field NumberFormatException NumberFormatter NumberOfDocuments NumberOfInterveningJobs NumberUp NumberUpSupported NumericShaper OAEPParameterSpec OBJECT_NOT_EXIST OBJ_ADAPTER OMGVMCID ORB ORB ORBIdHelper ORBInitInfo ORBInitInfoOperations ORBInitializer ORBInitializerOperations ObjID Object Object ObjectAlreadyActive ObjectAlreadyActiveHelper ObjectChangeListener ObjectFactory ObjectFactoryBuilder ObjectHelper ObjectHolder ObjectIdHelper ObjectIdHelper ObjectImpl ObjectImpl ObjectInput ObjectInputStream ObjectInputStream.GetField ObjectInputValidation ObjectInstance ObjectName ObjectNotActive ObjectNotActiveHelper ObjectOutput ObjectOutputStream ObjectOutputStream.PutField ObjectReferenceFactory ObjectReferenceFactoryHelper ObjectReferenceFactoryHolder ObjectReferenceTemplate ObjectReferenceTemplateHelper ObjectReferenceTemplateHolder ObjectReferenceTemplateSeqHelper ObjectReferenceTemplateSeqHolder ObjectStreamClass ObjectStreamConstants ObjectStreamException ObjectStreamField ObjectView Observable Observer OceanTheme OctetSeqHelper OctetSeqHolder Oid OpenDataException OpenMBeanAttributeInfo OpenMBeanAttributeInfoSupport OpenMBeanConstructorInfo OpenMBeanConstructorInfoSupport OpenMBeanInfo OpenMBeanInfoSupport OpenMBeanOperationInfo OpenMBeanOperationInfoSupport OpenMBeanParameterInfo OpenMBeanParameterInfoSupport OpenType OpenType OperatingSystemMXBean Operation OperationNotSupportedException OperationsException Option OptionPaneUI OptionalDataException OrientationRequested OutOfMemoryError OutputDeviceAssigned OutputKeys OutputStream OutputStream OutputStream OutputStreamWriter OverlappingFileLockException OverlayLayout Override Owner PBEKey PBEKeySpec PBEParameterSpec PDLOverrideSupported PERSIST_STORE PKCS8EncodedKeySpec PKIXBuilderParameters PKIXCertPathBuilderResult PKIXCertPathChecker PKIXCertPathValidatorResult PKIXParameters POA POAHelper POAManager POAManagerOperations POAOperations PRIVATE_MEMBER PSSParameterSpec PSource PSource.PSpecified PUBLIC_MEMBER Pack200 Pack200.Packer Pack200.Unpacker Package PackedColorModel PageAttributes PageAttributes.ColorType PageAttributes.MediaType PageAttributes.OrientationRequestedType PageAttributes.OriginType PageAttributes.PrintQualityType PageFormat PageRanges Pageable PagedResultsControl PagedResultsResponseControl PagesPerMinute PagesPerMinuteColor Paint PaintContext PaintEvent Panel PanelUI Paper ParagraphView ParagraphView Parameter ParameterBlock ParameterDescriptor ParameterMetaData ParameterMode ParameterModeHelper ParameterModeHolder ParameterizedType ParseException ParsePosition Parser Parser ParserAdapter ParserConfigurationException ParserDelegator ParserFactory PartialResultException PasswordAuthentication PasswordCallback PasswordView Patch PathIterator Pattern PatternSyntaxException Permission Permission PermissionCollection Permissions PersistenceDelegate PersistentMBean PhantomReference Pipe Pipe.SinkChannel Pipe.SourceChannel PipedInputStream PipedOutputStream PipedReader PipedWriter PixelGrabber PixelInterleavedSampleModel PlainDocument PlainView Point Point2D Point2D.Double Point2D.Float PointerInfo Policy Policy Policy PolicyError PolicyErrorCodeHelper PolicyErrorHelper PolicyErrorHolder PolicyFactory PolicyFactoryOperations PolicyHelper PolicyHolder PolicyListHelper PolicyListHolder PolicyNode PolicyOperations PolicyQualifierInfo PolicyTypeHelper Polygon PooledConnection Popup PopupFactory PopupMenu PopupMenuEvent PopupMenuListener PopupMenuUI Port Port.Info PortUnreachableException PortableRemoteObject PortableRemoteObjectDelegate Position Position.Bias Predicate PreferenceChangeEvent PreferenceChangeListener Preferences PreferencesFactory PreparedStatement PresentationDirection Principal Principal PrincipalHolder PrintEvent PrintException PrintGraphics PrintJob PrintJobAdapter PrintJobAttribute PrintJobAttributeEvent PrintJobAttributeListener PrintJobAttributeSet PrintJobEvent PrintJobListener PrintQuality PrintRequestAttribute PrintRequestAttributeSet PrintService PrintServiceAttribute PrintServiceAttributeEvent PrintServiceAttributeListener PrintServiceAttributeSet PrintServiceLookup PrintStream PrintWriter Printable PrinterAbortException PrinterException PrinterGraphics PrinterIOException PrinterInfo PrinterIsAcceptingJobs PrinterJob PrinterLocation PrinterMakeAndModel PrinterMessageFromOperator PrinterMoreInfo PrinterMoreInfoManufacturer PrinterName PrinterResolution PrinterState PrinterStateReason PrinterStateReasons PrinterURI PriorityBlockingQueue PriorityQueue PrivateClassLoader PrivateCredentialPermission PrivateKey PrivateMLet PrivilegedAction PrivilegedActionException PrivilegedExceptionAction Process ProcessBuilder ProcessingInstruction ProfileDataException ProfileIdHelper ProgressBarUI ProgressMonitor ProgressMonitorInputStream Properties PropertyChangeEvent PropertyChangeListener PropertyChangeListenerProxy PropertyChangeSupport PropertyDescriptor PropertyEditor PropertyEditorManager PropertyEditorSupport PropertyPermission PropertyResourceBundle PropertyVetoException ProtectionDomain ProtocolException Provider Provider.Service ProviderException Proxy Proxy Proxy.Type ProxySelector PublicKey PushbackInputStream PushbackReader QName QuadCurve2D QuadCurve2D.Double QuadCurve2D.Float Query QueryEval QueryExp Queue QueuedJobCount RC2ParameterSpec RC5ParameterSpec REBIND REQUEST_PROCESSING_POLICY_ID RGBImageFilter RMIClassLoader RMIClassLoaderSpi RMIClientSocketFactory RMIConnection RMIConnectionImpl RMIConnectionImpl_Stub RMIConnector RMIConnectorServer RMICustomMaxStreamFormat RMIFailureHandler RMIIIOPServerImpl RMIJRMPServerImpl RMISecurityException RMISecurityManager RMIServer RMIServerImpl RMIServerImpl_Stub RMIServerSocketFactory RMISocketFactory RSAKey RSAKeyGenParameterSpec RSAMultiPrimePrivateCrtKey RSAMultiPrimePrivateCrtKeySpec RSAOtherPrimeInfo RSAPrivateCrtKey RSAPrivateCrtKeySpec RSAPrivateKey RSAPrivateKeySpec RSAPublicKey RSAPublicKeySpec RTFEditorKit Random RandomAccess RandomAccessFile Raster RasterFormatException RasterOp Rdn ReadOnlyBufferException ReadWriteLock Readable ReadableByteChannel Reader RealmCallback RealmChoiceCallback Receiver Rectangle Rectangle2D Rectangle2D.Double Rectangle2D.Float RectangularShape ReentrantLock ReentrantReadWriteLock ReentrantReadWriteLock.ReadLock ReentrantReadWriteLock.WriteLock Ref RefAddr Reference Reference ReferenceQueue ReferenceUriSchemesSupported Referenceable ReferralException ReflectPermission ReflectionException RefreshFailedException Refreshable Region RegisterableService Registry RegistryHandler RejectedExecutionException RejectedExecutionHandler Relation RelationException RelationNotFoundException RelationNotification RelationService RelationServiceMBean RelationServiceNotRegisteredException RelationSupport RelationSupportMBean RelationType RelationTypeNotFoundException RelationTypeSupport RemarshalException Remote RemoteCall RemoteException RemoteObject RemoteObjectInvocationHandler RemoteRef RemoteServer RemoteStub RenderContext RenderableImage RenderableImageOp RenderableImageProducer RenderedImage RenderedImageFactory Renderer RenderingHints RenderingHints.Key RepaintManager ReplicateScaleFilter RepositoryIdHelper Request RequestInfo RequestInfoOperations RequestProcessingPolicy RequestProcessingPolicyOperations RequestProcessingPolicyValue RequestingUserName RequiredModelMBean RescaleOp ResolutionSyntax ResolveResult Resolver ResourceBundle ResponseCache ResponseHandler Result ResultSet ResultSetMetaData Retention RetentionPolicy ReverbType Robot Role RoleInfo RoleInfoNotFoundException RoleList RoleNotFoundException RoleResult RoleStatus RoleUnresolved RoleUnresolvedList RootPaneContainer RootPaneUI RoundRectangle2D RoundRectangle2D.Double RoundRectangle2D.Float RoundingMode RowMapper RowSet RowSetEvent RowSetInternal RowSetListener RowSetMetaData RowSetMetaDataImpl RowSetReader RowSetWarning RowSetWriter RuleBasedCollator RunTime RunTimeOperations Runnable Runtime RuntimeErrorException RuntimeException RuntimeMBeanException RuntimeMXBean RuntimeOperationsException RuntimePermission SAXException SAXNotRecognizedException SAXNotSupportedException SAXParseException SAXParser SAXParserFactory SAXResult SAXSource SAXTransformerFactory SERVANT_RETENTION_POLICY_ID SQLData SQLException SQLInput SQLInputImpl SQLOutput SQLOutputImpl SQLPermission SQLWarning SSLContext SSLContextSpi SSLEngine SSLEngineResult SSLEngineResult.HandshakeStatus SSLEngineResult.Status SSLException SSLHandshakeException SSLKeyException SSLPeerUnverifiedException SSLPermission SSLProtocolException SSLServerSocket SSLServerSocketFactory SSLSession SSLSessionBindingEvent SSLSessionBindingListener SSLSessionContext SSLSocket SSLSocketFactory SUCCESSFUL SYNC_WITH_TRANSPORT SYSTEM_EXCEPTION SampleModel Sasl SaslClient SaslClientFactory SaslException SaslServer SaslServerFactory Savepoint Scanner ScatteringByteChannel ScheduledExecutorService ScheduledFuture ScheduledThreadPoolExecutor Schema SchemaFactory SchemaFactoryLoader SchemaViolationException ScrollBarUI ScrollPane ScrollPaneAdjustable ScrollPaneConstants ScrollPaneLayout ScrollPaneLayout.UIResource ScrollPaneUI Scrollable Scrollbar SealedObject SearchControls SearchResult SecretKey SecretKeyFactory SecretKeyFactorySpi SecretKeySpec SecureCacheResponse SecureClassLoader SecureRandom SecureRandomSpi Security SecurityException SecurityManager SecurityPermission Segment SelectableChannel SelectionKey Selector SelectorProvider Semaphore SeparatorUI Sequence SequenceInputStream Sequencer Sequencer.SyncMode SerialArray SerialBlob SerialClob SerialDatalink SerialException SerialJavaObject SerialRef SerialStruct Serializable SerializablePermission Servant ServantActivator ServantActivatorHelper ServantActivatorOperations ServantActivatorPOA ServantAlreadyActive ServantAlreadyActiveHelper ServantLocator ServantLocatorHelper ServantLocatorOperations ServantLocatorPOA ServantManager ServantManagerOperations ServantNotActive ServantNotActiveHelper ServantObject ServantRetentionPolicy ServantRetentionPolicyOperations ServantRetentionPolicyValue ServerCloneException ServerError ServerException ServerIdHelper ServerNotActiveException ServerRef ServerRequest ServerRequestInfo ServerRequestInfoOperations ServerRequestInterceptor ServerRequestInterceptorOperations ServerRuntimeException ServerSocket ServerSocketChannel ServerSocketFactory ServiceContext ServiceContextHelper ServiceContextHolder ServiceContextListHelper ServiceContextListHolder ServiceDetail ServiceDetailHelper ServiceIdHelper ServiceInformation ServiceInformationHelper ServiceInformationHolder ServiceNotFoundException ServicePermission ServiceRegistry ServiceRegistry.Filter ServiceUI ServiceUIFactory ServiceUnavailableException Set SetOfIntegerSyntax SetOverrideType SetOverrideTypeHelper Severity Shape ShapeGraphicAttribute SheetCollate Short ShortBuffer ShortBufferException ShortHolder ShortLookupTable ShortMessage ShortSeqHelper ShortSeqHolder Sides Signature SignatureException SignatureSpi SignedObject Signer SimpleAttributeSet SimpleBeanInfo SimpleDateFormat SimpleDoc SimpleFormatter SimpleTimeZone SimpleType SinglePixelPackedSampleModel SingleSelectionModel Size2DSyntax SizeLimitExceededException SizeRequirements SizeSequence Skeleton SkeletonMismatchException SkeletonNotFoundException SliderUI Socket SocketAddress SocketChannel SocketException SocketFactory SocketHandler SocketImpl SocketImplFactory SocketOptions SocketPermission SocketSecurityException SocketTimeoutException SoftBevelBorder SoftReference SortControl SortKey SortResponseControl SortedMap SortedSet SortingFocusTraversalPolicy Soundbank SoundbankReader SoundbankResource Source SourceDataLine SourceLocator SpinnerDateModel SpinnerListModel SpinnerModel SpinnerNumberModel SpinnerUI SplitPaneUI Spring SpringLayout SpringLayout.Constraints SslRMIClientSocketFactory SslRMIServerSocketFactory Stack StackOverflowError StackTraceElement StandardMBean StartTlsRequest StartTlsResponse State StateEdit StateEditable StateFactory Statement Statement StreamCorruptedException StreamHandler StreamPrintService StreamPrintServiceFactory StreamResult StreamSource StreamTokenizer Streamable StreamableValue StrictMath String StringBuffer StringBufferInputStream StringBuilder StringCharacterIterator StringContent StringHolder StringIndexOutOfBoundsException StringMonitor StringMonitorMBean StringNameHelper StringReader StringRefAddr StringSelection StringSeqHelper StringSeqHolder StringTokenizer StringValueExp StringValueHelper StringWriter Stroke Struct StructMember StructMemberHelper Stub StubDelegate StubNotFoundException Style StyleConstants StyleConstants.CharacterConstants StyleConstants.ColorConstants StyleConstants.FontConstants StyleConstants.ParagraphConstants StyleContext StyleSheet StyleSheet.BoxPainter StyleSheet.ListPainter StyledDocument StyledEditorKit StyledEditorKit.AlignmentAction StyledEditorKit.BoldAction StyledEditorKit.FontFamilyAction StyledEditorKit.FontSizeAction StyledEditorKit.ForegroundAction StyledEditorKit.ItalicAction StyledEditorKit.StyledTextAction StyledEditorKit.UnderlineAction Subject SubjectDelegationPermission SubjectDomainCombiner SupportedValuesAttribute SuppressWarnings SwingConstants SwingPropertyChangeSupport SwingUtilities SyncFactory SyncFactoryException SyncFailedException SyncProvider SyncProviderException SyncResolver SyncScopeHelper SynchronousQueue SynthConstants SynthContext SynthGraphicsUtils SynthLookAndFeel SynthPainter SynthStyle SynthStyleFactory Synthesizer SysexMessage System SystemColor SystemException SystemFlavorMap TAG_ALTERNATE_IIOP_ADDRESS TAG_CODE_SETS TAG_INTERNET_IOP TAG_JAVA_CODEBASE TAG_MULTIPLE_COMPONENTS TAG_ORB_TYPE TAG_POLICIES TAG_RMI_CUSTOM_MAX_STREAM_FORMAT TCKind THREAD_POLICY_ID TIMEOUT TRANSACTION_MODE TRANSACTION_REQUIRED TRANSACTION_ROLLEDBACK TRANSACTION_UNAVAILABLE TRANSIENT TRANSPORT_RETRY TabExpander TabSet TabStop TabableView TabbedPaneUI TableCellEditor TableCellRenderer TableColumn TableColumnModel TableColumnModelEvent TableColumnModelListener TableHeaderUI TableModel TableModelEvent TableModelListener TableUI TableView TabularData TabularDataSupport TabularType TagElement TaggedComponent TaggedComponentHelper TaggedComponentHolder TaggedProfile TaggedProfileHelper TaggedProfileHolder Target TargetDataLine TargetedNotification Templates TemplatesHandler Text TextAction TextArea TextAttribute TextComponent TextEvent TextField TextHitInfo TextInputCallback TextLayout TextLayout.CaretPolicy TextListener TextMeasurer TextOutputCallback TextSyntax TextUI TexturePaint Thread Thread.State Thread.UncaughtExceptionHandler ThreadDeath ThreadFactory ThreadGroup ThreadInfo ThreadLocal ThreadMXBean ThreadPolicy ThreadPolicyOperations ThreadPolicyValue ThreadPoolExecutor ThreadPoolExecutor.AbortPolicy ThreadPoolExecutor.CallerRunsPolicy ThreadPoolExecutor.DiscardOldestPolicy ThreadPoolExecutor.DiscardPolicy Throwable Tie TileObserver Time TimeLimitExceededException TimeUnit TimeZone TimeoutException Timer Timer Timer TimerAlarmClockNotification TimerMBean TimerNotification TimerTask Timestamp Timestamp TitledBorder TooManyListenersException ToolBarUI ToolTipManager ToolTipUI Toolkit Track TransactionRequiredException TransactionRolledbackException TransactionService TransactionalWriter TransferHandler Transferable TransformAttribute Transformer TransformerConfigurationException TransformerException TransformerFactory TransformerFactoryConfigurationError TransformerHandler Transmitter Transparency TreeCellEditor TreeCellRenderer TreeExpansionEvent TreeExpansionListener TreeMap TreeModel TreeModelEvent TreeModelListener TreeNode TreePath TreeSelectionEvent TreeSelectionListener TreeSelectionModel TreeSet TreeUI TreeWillExpandListener TrustAnchor TrustManager TrustManagerFactory TrustManagerFactorySpi Type TypeCode TypeCodeHolder TypeInfo TypeInfoProvider TypeMismatch TypeMismatch TypeMismatch TypeMismatchHelper TypeMismatchHelper TypeNotPresentException TypeVariable Types UID UIDefaults UIDefaults.ActiveValue UIDefaults.LazyInputMap UIDefaults.LazyValue UIDefaults.ProxyLazyValue UIManager UIManager.LookAndFeelInfo UIResource ULongLongSeqHelper ULongLongSeqHolder ULongSeqHelper ULongSeqHolder UNKNOWN UNKNOWN UNSUPPORTED_POLICY UNSUPPORTED_POLICY_VALUE URI URIException URIResolver URISyntax URISyntaxException URL URLClassLoader URLConnection URLDecoder URLEncoder URLStreamHandler URLStreamHandlerFactory URLStringHelper USER_EXCEPTION UShortSeqHelper UShortSeqHolder UTFDataFormatException UUID UndeclaredThrowableException UndoManager UndoableEdit UndoableEditEvent UndoableEditListener UndoableEditSupport UnexpectedException UnicastRemoteObject UnionMember UnionMemberHelper UnknownEncoding UnknownEncodingHelper UnknownError UnknownException UnknownFormatConversionException UnknownFormatFlagsException UnknownGroupException UnknownHostException UnknownHostException UnknownObjectException UnknownServiceException UnknownUserException UnknownUserExceptionHelper UnknownUserExceptionHolder UnmappableCharacterException UnmarshalException UnmodifiableClassException UnmodifiableSetException UnrecoverableEntryException UnrecoverableKeyException Unreferenced UnresolvedAddressException UnresolvedPermission UnsatisfiedLinkError UnsolicitedNotification UnsolicitedNotificationEvent UnsolicitedNotificationListener UnsupportedAddressTypeException UnsupportedAudioFileException UnsupportedCallbackException UnsupportedCharsetException UnsupportedClassVersionError UnsupportedEncodingException UnsupportedFlavorException UnsupportedLookAndFeelException UnsupportedOperationException UserDataHandler UserException Util UtilDelegate Utilities VMID VM_ABSTRACT VM_CUSTOM VM_NONE VM_TRUNCATABLE Validator ValidatorHandler ValueBase ValueBaseHelper ValueBaseHolder ValueExp ValueFactory ValueHandler ValueHandlerMultiFormat ValueInputStream ValueMember ValueMemberHelper ValueOutputStream VariableHeightLayoutCache Vector VerifyError VersionSpecHelper VetoableChangeListener VetoableChangeListenerProxy VetoableChangeSupport View ViewFactory ViewportLayout ViewportUI VirtualMachineError Visibility VisibilityHelper VoiceStatus Void VolatileImage WCharSeqHelper WCharSeqHolder WStringSeqHelper WStringSeqHolder WStringValueHelper WeakHashMap WeakReference WebRowSet WildcardType Window WindowAdapter WindowConstants WindowEvent WindowFocusListener WindowListener WindowStateListener WrappedPlainView WritableByteChannel WritableRaster WritableRenderedImage WriteAbortedException Writer WrongAdapter WrongAdapterHelper WrongPolicy WrongPolicyHelper WrongTransaction WrongTransactionHelper WrongTransactionHolder X500Principal X500PrivateCredential X509CRL X509CRLEntry X509CRLSelector X509CertSelector X509Certificate X509Certificate X509EncodedKeySpec X509ExtendedKeyManager X509Extension X509KeyManager X509TrustManager XAConnection XADataSource XAException XAResource XMLConstants XMLDecoder XMLEncoder XMLFilter XMLFilterImpl XMLFormatter XMLGregorianCalendar XMLParseException XMLReader XMLReaderAdapter XMLReaderFactory XPath XPathConstants XPathException XPathExpression XPathExpressionException XPathFactory XPathFactoryConfigurationException XPathFunction XPathFunctionException XPathFunctionResolver XPathVariableResolver Xid XmlReader XmlWriter ZipEntry ZipException ZipFile ZipInputStream ZipOutputStream ZoneView _BindingIteratorImplBase _BindingIteratorStub _DynAnyFactoryStub _DynAnyStub _DynArrayStub _DynEnumStub _DynFixedStub _DynSequenceStub _DynStructStub _DynUnionStub _DynValueStub _IDLTypeStub _NamingContextExtStub _NamingContextImplBase _NamingContextStub _PolicyStub _Remote_Stub _ServantActivatorStub _ServantLocatorStub AbstractAnnotationValueVisitor6 AbstractElementVisitor6 AbstractMarshallerImpl AbstractOwnableSynchronizer AbstractProcessor AbstractQueuedLongSynchronizer AbstractScriptEngine AbstractTypeVisitor6 AbstractUnmarshallerImpl ActivationDataFlavor AlgorithmMethod AnnotationMirror AnnotationValue AnnotationValueVisitor ArrayDeque AsyncHandler AttachmentMarshaller AttachmentPart AttachmentUnmarshaller Binder BindingProvider Bindings BlockingDeque BreakIteratorProvider C14NMethodParameterSpec CanonicalizationMethod Characters ClientInfoStatus CollapsedStringAdapter CollatorProvider CommandInfo CommandMap CommandObject CommonDataSource Compilable CompiledScript Completion Completions CompositeDataInvocationHandler CompositeDataView ConcurrentNavigableMap ConcurrentSkipListMap ConcurrentSkipListSet ConfigurationSpi Console ConstructorProperties CookieManager CookiePolicy CookieStore CurrencyNameProvider Data DataContentHandler DataContentHandlerFactory DataHandler DatatypeConverter DatatypeConverterInterface DateFormatProvider DateFormatSymbolsProvider DecimalFormatSymbolsProvider DeclaredType DefaultRowSorter DefaultValidationEventHandler DeflaterInputStream Deque DescriptorKey DescriptorRead Desktop Detail DetailEntry Diagnostic DiagnosticCollector DiagnosticListener DigestMethod DigestMethodParameterSpec Dispatch DOMCryptoContext DomHandler DOMSignContext DOMStructure DOMURIReference DOMValidateContext DropMode ElementFilter ElementKind ElementKindVisitor6 Elements ElementScanner6 ElementVisitor EndDocument EndElement Endpoint EntityDeclaration ErrorType EventException EventFilter EventReaderDelegate EventTarget ExcC14NParameterSpec ExecutableElement ExecutableType FileDataSource FileNameExtensionFilter FileObject Filer FilerException FileTypeMap ForwardingFileObject ForwardingJavaFileManager ForwardingJavaFileObject Generated GridBagLayoutInfo GroupLayout HandlerChain HandlerResolver HexBinaryAdapter HMACParameterSpec Holder HTTPBinding HttpCookie HTTPException IDN ImmutableDescriptor InflaterOutputStream InitParam InterfaceAddress Invocable IOError JavaCompiler JavaFileManager JavaFileObject JAXBContext JAXBElement JAXBException JAXBIntrospector JAXBResult JAXBSource JMX JMXAddressable KeyInfo KeyInfoFactory KeyName KeySelector KeySelectorException KeySelectorResult KeyValue LayoutPath LayoutStyle LinearGradientPaint LinkedBlockingDeque LocaleNameProvider LocaleServiceProvider Location LockInfo LogicalHandler LogicalMessage LogicalMessageContext MailcapCommandMap Marshaller MessageContext MessageFactory Messager MimeHeader MimeHeaders MimeType MimeTypeParameterList MimetypesFileTypeMap MirroredTypeException MirroredTypesException MLetContent MonitorInfo MultipleGradientPaint MutationEvent MXBean Namespace NavigableMap NavigableSet NClob NestingKind NodeSetData NormalizedStringAdapter Normalizer NoSuchMechanismException NotationDeclaration NotIdentifiableEvent NotIdentifiableEventImpl NoType NullType NumberFormatProvider OctetStreamData Oneway OptionChecker PackageElement ParseConversionEvent ParseConversionEventImpl Path2D PGPData PolicySpi PortInfo PostConstruct PreDestroy PrimitiveType PrintConversionEvent PrintConversionEventImpl ProcessingEnvironment Processor PropertyException RadialGradientPaint ReferenceType RequestWrapper Resource Resources Response ResponseWrapper RetrievalMethod RoundEnvironment RowFilter RowId RowIdLifetime RowSorter RowSorterEvent RowSorterListener RunnableFuture RunnableScheduledFuture SAAJMetaFactory SAAJResult SchemaOutputResolver ScriptContext ScriptEngine ScriptEngineFactory ScriptEngineManager ScriptException Service ServiceConfigurationError ServiceDelegate ServiceLoader ServiceMode SignatureMethod SignatureMethodParameterSpec SignatureProperties SignatureProperty SignedInfo SimpleAnnotationValueVisitor6 SimpleBindings SimpleElementVisitor6 SimpleJavaFileObject SimpleScriptContext SimpleTypeVisitor6 SOAPBinding SOAPBinding SOAPBody SOAPBodyElement SOAPConnection SOAPConnectionFactory SOAPConstants SOAPElement SOAPElementFactory SOAPEnvelope SOAPException SOAPFactory SOAPFault SOAPFaultElement SOAPFaultException SOAPHandler SOAPHeader SOAPHeaderElement SOAPMessage SOAPMessageContext SOAPMessageHandler SOAPMessageHandlers SOAPPart SortOrder SourceVersion SplashScreen SQLClientInfoException SQLDataException SQLFeatureNotSupportedException SQLIntegrityConstraintViolationException SQLInvalidAuthorizationSpecException SQLNonTransientConnectionException SQLNonTransientException SQLRecoverableException SQLSyntaxErrorException SQLTimeoutException SQLTransactionRollbackException SQLTransientConnectionException SQLTransientException SQLXML SSLParameters StandardEmitterMBean StandardJavaFileManager StandardLocation StartDocument StartElement StatementEvent StatementEventListener StAXResult StAXSource StreamFilter StreamReaderDelegate SupportedAnnotationTypes SupportedOptions SupportedSourceVersion SwingWorker SystemTray TableRowSorter TableStringConverter TimeZoneNameProvider Tool ToolProvider Transform TransformException TransformParameterSpec TransformService TrayIcon TypeConstraintException TypeElement TypeKind TypeKindVisitor6 TypeMirror TypeParameterElement TypeVisitor UIEvent UnknownAnnotationValueException UnknownElementException UnknownTypeException Unmarshaller UnmarshallerHandler UnsupportedDataTypeException URIDereferencer URIParameter URIReference URIReferenceException URLDataSource ValidationEvent ValidationEventCollector ValidationEventHandler ValidationEventImpl ValidationEventLocator ValidationEventLocatorImpl ValidationException VariableElement W3CDomHandler WebEndpoint WebFault WebMethod WebParam WebResult WebService WebServiceClient WebServiceContext WebServiceException WebServicePermission WebServiceProvider WebServiceRef WebServiceRefs Wrapper X509Data X509IssuerSerial XmlAccessOrder XmlAccessorOrder XmlAccessorType XmlAccessType XmlAdapter XmlAnyAttribute XmlAnyElement XmlAttachmentRef XmlAttribute XMLCryptoContext XmlElement XmlElementDecl XmlElementRef XmlElementRefs XmlElements XmlElementWrapper XmlEnum XmlEnumValue XMLEvent XMLEventAllocator XMLEventConsumer XMLEventFactory XMLEventReader XMLEventWriter XmlID XmlIDREF XmlInlineBinaryData XMLInputFactory XmlJavaTypeAdapter XmlJavaTypeAdapters XmlList XmlMimeType XmlMixed XmlNs XmlNsForm XMLObject XMLOutputFactory XmlRegistry XMLReporter XMLResolver XmlRootElement XmlSchema XmlSchemaType XmlSchemaTypes XMLSignature XMLSignatureException XMLSignatureFactory XMLSignContext XMLStreamConstants XMLStreamException XMLStreamReader XMLStreamWriter XMLStructure XmlTransient XmlType XMLValidateContext XmlValue XPathFilter2ParameterSpec XPathFilterParameterSpec XPathType XSLTTransformParameterSpec ZipError"
list_keywords = Set.fromList $ words $ "abstract break case catch class continue default do else enum extends false finally for goto if implements instanceof @interface interface native new null private protected public return super strictfp switch synchronized this throws throw transient true try volatile while"
list_types = Set.fromList $ words $ "boolean byte char const double final float int long short static void"

regex_'27'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d'27 = compileRegex "'\\\\u[0-9a-fA-F]{4}'"
regex_'2f'2f'5cs'2aBEGIN'2e'2a'24 = compileRegex "//\\s*BEGIN.*$"
regex_'2f'2f'5cs'2aEND'2e'2a'24 = compileRegex "//\\s*END.*$"
regex_'5c'2e'28format'7cprintf'29'5cb = compileRegex "\\.(format|printf)\\b"
regex_'5c'2e'7b3'2c3'7d'5cs'2b = compileRegex "\\.{3,3}\\s+"
regex_'5cb'28import'5cs'2bstatic'29'5cb = compileRegex "\\b(import\\s+static)\\b"
regex_'5cb'28package'7cimport'29'5cb = compileRegex "\\b(package|import)\\b"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'28'2f'5c'2a'5cs'2a'5cd'2b'5cs'2a'5c'2a'2f'5cs'2a'29'3f'5b'28'5d'29 = compileRegex "\\b[_\\w][_\\w\\d]*(?=[\\s]*(/\\*\\s*\\d+\\s*\\*/\\s*)?[(])"
regex_'5b'2e'5d'7b1'2c1'7d = compileRegex "[.]{1,1}"
regex_'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d = compileRegex "\\\\u[0-9a-fA-F]{4}"
regex_'25'28'5cd'2b'5c'24'29'3f'28'2d'7c'23'7c'5c'2b'7c'5c_'7c0'7c'2c'7c'5c'28'29'2a'5cd'2a'28'5c'2e'5cd'2b'29'3f'5ba'2dhosxA'2dCEGHSX'5d = compileRegex "%(\\d+\\$)?(-|#|\\+|\\ |0|,|\\()*\\d*(\\.\\d+)?[a-hosxA-CEGHSX]"
regex_'25'28'5cd'2b'5c'24'29'3f'28'2d'7c'23'7c'5c'2b'7c'5c_'7c0'7c'2c'7c'5c'28'29'2a'5cd'2a'28t'7cT'29'28a'7cA'7cb'7cB'7cc'7cC'7cd'7cD'7ce'7cF'7ch'7cH'7cI'7cj'7ck'7cl'7cL'7cm'7cM'7cN'7cp'7cP'7cQ'7cr'7cR'7cs'7cS'7cT'7cy'7cY'7cz'7cZ'29 = compileRegex "%(\\d+\\$)?(-|#|\\+|\\ |0|,|\\()*\\d*(t|T)(a|A|b|B|c|C|d|D|e|F|h|H|I|j|k|l|L|m|M|N|p|P|Q|r|R|s|S|T|y|Y|z|Z)"
regex_'25'28'25'7cn'29 = compileRegex "%(%|n)"
regex_'5cb'5b'5fa'2dzA'2dZ'5d'5cw'2a'28'3f'3d'5b'5cs'5d'2a'29 = compileRegex "\\b[_a-zA-Z]\\w*(?=[\\s]*)"
regex_'5cs'2a'2e'2a'3b = compileRegex "\\s*.*;"

defaultAttributes = [("Normal","Normal Text"),("InFunctionCall","Normal Text"),("String","String"),("EnterPrintf","Normal Text"),("Printf","Printf"),("PrintfString","PrintfString"),("Member","Normal Text"),("StaticImports","Normal Text"),("Imports","Normal Text"),("Commentar 1","Comment"),("Commentar 2","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((Text.Highlighting.Kate.Syntax.Javadoc.parseExpression))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_java15 >>= withAttribute "Java15"))
                        <|>
                        (withChildren (pFloat >>= withAttribute "Float") ((pAnyChar "fF" >>= withAttribute "Float")))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal"))))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pRegExpr regex_'27'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d'27 >>= withAttribute "Char"))
                        <|>
                        ((pRegExpr regex_'2f'2f'5cs'2aBEGIN'2e'2a'24 >>= withAttribute "Decimal"))
                        <|>
                        ((pRegExpr regex_'2f'2f'5cs'2aEND'2e'2a'24 >>= withAttribute "Decimal"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pRegExpr regex_'5c'2e'28format'7cprintf'29'5cb >>= withAttribute "Function") >>~ pushContext "EnterPrintf")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Symbol"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Symbol"))
                        <|>
                        ((pRegExpr regex_'5c'2e'7b3'2c3'7d'5cs'2b >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28import'5cs'2bstatic'29'5cb >>= withAttribute "Keyword") >>~ pushContext "StaticImports")
                        <|>
                        ((pRegExpr regex_'5cb'28package'7cimport'29'5cb >>= withAttribute "Keyword") >>~ pushContext "Imports")
                        <|>
                        ((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'28'2f'5c'2a'5cs'2a'5cd'2b'5cs'2a'5c'2a'2f'5cs'2a'29'3f'5b'28'5d'29 >>= withAttribute "Function"))
                        <|>
                        ((pRegExpr regex_'5b'2e'5d'7b1'2c1'7d >>= withAttribute "Symbol") >>~ pushContext "Member")
                        <|>
                        ((pDetectChar False '(' >>= withAttribute "Symbol") >>~ pushContext "InFunctionCall")
                        <|>
                        ((pAnyChar ":!%&+,-/.*<=>?[]|~^;" >>= withAttribute "Symbol")))
     return (attr, result)

parseRules "InFunctionCall" = 
  do (attr, result) <- (((parseRules "Normal"))
                        <|>
                        ((pDetectChar False ')' >>= withAttribute "Symbol") >>~ (popContext)))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String"))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pRegExpr regex_'5c'5cu'5b0'2d9a'2dfA'2dF'5d'7b4'7d >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "EnterPrintf" = 
  do (attr, result) <- (((pDetectChar False '(' >>= withAttribute "Symbol") >>~ pushContext "Printf")
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "Printf" = 
  do (attr, result) <- (((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "PrintfString")
                        <|>
                        ((parseRules "InFunctionCall")))
     return (attr, result)

parseRules "PrintfString" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String"))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'25'28'5cd'2b'5c'24'29'3f'28'2d'7c'23'7c'5c'2b'7c'5c_'7c0'7c'2c'7c'5c'28'29'2a'5cd'2a'28'5c'2e'5cd'2b'29'3f'5ba'2dhosxA'2dCEGHSX'5d >>= withAttribute "String Char"))
                        <|>
                        ((pRegExpr regex_'25'28'5cd'2b'5c'24'29'3f'28'2d'7c'23'7c'5c'2b'7c'5c_'7c0'7c'2c'7c'5c'28'29'2a'5cd'2a'28t'7cT'29'28a'7cA'7cb'7cB'7cc'7cC'7cd'7cD'7ce'7cF'7ch'7cH'7cI'7cj'7ck'7cl'7cL'7cm'7cM'7cN'7cp'7cP'7cQ'7cr'7cR'7cs'7cS'7cT'7cy'7cY'7cz'7cZ'29 >>= withAttribute "String Char"))
                        <|>
                        ((pRegExpr regex_'25'28'25'7cn'29 >>= withAttribute "String Char")))
     return (attr, result)

parseRules "Member" = 
  do (attr, result) <- (((pRegExpr regex_'5cb'5b'5fa'2dzA'2dZ'5d'5cw'2a'28'3f'3d'5b'5cs'5d'2a'29 >>= withAttribute "Function") >>~ (popContext))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "StaticImports" = 
  do (attr, result) <- ((pRegExpr regex_'5cs'2a'2e'2a'3b >>= withAttribute "StaticImports") >>~ (popContext))
     return (attr, result)

parseRules "Imports" = 
  do (attr, result) <- ((pRegExpr regex_'5cs'2a'2e'2a'3b >>= withAttribute "Imports") >>~ (popContext))
     return (attr, result)

parseRules "Commentar 1" = 
  pzero

parseRules "Commentar 2" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
