{- This module was generated from data in the Kate syntax highlighting file fstab.xml, version 1.00,
   by  Diego Iastrubni (elcuco@kde.org) -}

module Text.Highlighting.Kate.Syntax.Fstab ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "fstab"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "fstab;mtab"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "fstab" }
  context <- currentContext <|> (pushContext "device" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("fstab",["device"])], synStLanguage = "fstab", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "device" -> return () >> pHandleEndLine
    "mount_point" -> pushContext "device" >> pHandleEndLine
    "_type" -> pushContext "device" >> pHandleEndLine
    "type" -> pushContext "device" >> pHandleEndLine
    "options" -> pushContext "device" >> pHandleEndLine
    "dump" -> pushContext "device" >> pHandleEndLine
    "pass" -> pushContext "device" >> pHandleEndLine
    "__error" -> pushContext "device" >> pHandleEndLine
    "error" -> pushContext "device" >> pHandleEndLine
    "comment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Device","kw"),("Mount Point","dt"),("Type","fu"),("Options","kw"),("Dump","dv"),("Pass","dv"),("Valid FileSystem","dt"),("Comment","co"),("Error","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_valid'5ffs = Set.fromList $ words $ "ext2 ext3 fat vfat reiser proc none sysfs ntfs umsdos swap minix iso9660"

regex_'5b'5cs'5d'2a = compileRegex "[\\s]*"
regex_'5b'5cS'5d'2a = compileRegex "[\\S]*"

defaultAttributes = [("device","Device"),("mount_point","Mount Point"),("_type","Normal"),("type","Type"),("options","Options"),("dump","Dump"),("pass","Pass"),("__error","Pass"),("error","Error"),("comment","Comment")]

parseRules "device" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Device") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cs'5d'2a >>= withAttribute "Device") >>~ pushContext "mount_point"))
     return (attr, result)

parseRules "mount_point" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Mount Point") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cs'5d'2a >>= withAttribute "Mount Point") >>~ pushContext "_type"))
     return (attr, result)

parseRules "_type" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Normal") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cS'5d'2a >>= withAttribute "Normal") >>~ pushContext "type"))
     return (attr, result)

parseRules "type" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Type") >>~ pushContext "comment")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" Set.empty >>= withAttribute "Valid FileSystem"))
                        <|>
                        ((pRegExpr regex_'5b'5cs'5d'2a >>= withAttribute "Type") >>~ pushContext "options"))
     return (attr, result)

parseRules "options" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Options") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cs'5d'2a >>= withAttribute "Options") >>~ pushContext "dump"))
     return (attr, result)

parseRules "dump" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Dump") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cs'5d'2a >>= withAttribute "Dump") >>~ pushContext "pass"))
     return (attr, result)

parseRules "pass" = 
  do (attr, result) <- (((pFirstNonSpace >> pDetectChar False '#' >>= withAttribute "Pass") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cs'5d'2a >>= withAttribute "Pass") >>~ pushContext "__error"))
     return (attr, result)

parseRules "__error" = 
  do (attr, result) <- (((pDetectChar False '#' >>= withAttribute "Pass") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5b'5cS'5d'2a >>= withAttribute "Pass") >>~ pushContext "error"))
     return (attr, result)

parseRules "error" = 
  pzero

parseRules "comment" = 
  pzero

parseRules x = fail $ "Unknown context" ++ x
