{- This module was generated from data in the Kate syntax highlighting file cs.xml, version 1.15,
   by   -}

module Text.Highlighting.Kate.Syntax.Cs ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "C#"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.cs"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "C#" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("C#",["Normal"])], synStLanguage = "C#", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "String" -> (popContext) >> pEndLine
    "Member" -> (popContext) >> pEndLine
    "Commentar 1" -> (popContext) >> pEndLine
    "Commentar 2" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Function","fu"),("Data Type","dt"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Char","ch"),("String","st"),("String Char","ch"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "abstract as base break case catch class checked continue default delegate do else enum event explicit extern false for foreach finally fixed goto if implicit in interface internal is lock namespace new null operator out override params private protected public readonly ref return sealed sizeof stackalloc static struct switch this throw true try typeof unchecked unsafe using virtual while #if #else #elif #endif #define #undef #warning #error #line"
list_types = Set.fromList $ words $ "bool byte char const decimal double float int long object uint ushort ulong sbyte short string void"

regex_'5cbpartial'28'3f'3d'5cs'2b'28class'7cstruct'7cinterface'7cvoid'29'29 = compileRegex "\\bpartial(?=\\s+(class|struct|interface|void))"
regex_'5cbvar'28'3f'3d'5cs'2b'5cw'2b'5cs'2a'3d'5cs'2a'5cw'2b'29 = compileRegex "\\bvar(?=\\s+\\w+\\s*=\\s*\\w+)"
regex_'5cbyield'28'3f'3d'5cs'2b'28return'7cbreak'29'29 = compileRegex "\\byield(?=\\s+(return|break))"
regex_'5cb'28set'7cget'29'28'3f'3d'5cs'2a'5b'3b'7b'5d'29 = compileRegex "\\b(set|get)(?=\\s*[;{])"
regex_'5cbglobal'28'3f'3d'5cs'2a'3a'3a'5cs'2a'5cw'2b'29 = compileRegex "\\bglobal(?=\\s*::\\s*\\w+)"
regex_'23region'2e'2a'24 = compileRegex "#region.*$"
regex_'23endregion'2e'2a'24 = compileRegex "#endregion.*$"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 = compileRegex "\\b[_\\w][_\\w\\d]*(?=[\\s]*[(])"
regex_'5b'2e'5d'7b1'2c1'7d = compileRegex "[.]{1,1}"
regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'29 = compileRegex "\\b[_\\w][_\\w\\d]*(?=[\\s]*)"

defaultAttributes = [("Normal","Normal Text"),("String","String"),("Member","Normal Text"),("Commentar 1","Comment"),("Commentar 2","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        (withChildren (pFloat >>= withAttribute "Float") ((pAnyChar "fF" >>= withAttribute "Float")))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal"))))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Symbol"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Symbol"))
                        <|>
                        ((pRegExpr regex_'5cbpartial'28'3f'3d'5cs'2b'28class'7cstruct'7cinterface'7cvoid'29'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbvar'28'3f'3d'5cs'2b'5cw'2b'5cs'2a'3d'5cs'2a'5cw'2b'29 >>= withAttribute "Data Type"))
                        <|>
                        ((pRegExpr regex_'5cbyield'28'3f'3d'5cs'2b'28return'7cbreak'29'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cb'28set'7cget'29'28'3f'3d'5cs'2a'5b'3b'7b'5d'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbglobal'28'3f'3d'5cs'2a'3a'3a'5cs'2a'5cw'2b'29 >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'23region'2e'2a'24 >>= withAttribute "Decimal"))
                        <|>
                        ((pRegExpr regex_'23endregion'2e'2a'24 >>= withAttribute "Decimal"))
                        <|>
                        ((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'5b'28'5d'29 >>= withAttribute "Function"))
                        <|>
                        ((pRegExpr regex_'5b'2e'5d'7b1'2c1'7d >>= withAttribute "Symbol") >>~ pushContext "Member")
                        <|>
                        ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute "Symbol")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "Member" = 
  do (attr, result) <- (((pRegExpr regex_'5cb'5b'5f'5cw'5d'5b'5f'5cw'5cd'5d'2a'28'3f'3d'5b'5cs'5d'2a'29 >>= withAttribute "Function") >>~ (popContext))
                        <|>
                        ((popContext) >> return ([], "")))
     return (attr, result)

parseRules "Commentar 1" = 
  pzero

parseRules "Commentar 2" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
