/***************************************************************************
                          htmlgenerator.h  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001 by Andre Simon
    email                : andre.simon1@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef HTMLGENERATOR_H
#define HTMLGENERATOR_H

#include <fstream>
#include <iostream>
#include <string>
#include <sstream>

#include "codegenerator.h"
#include "version.h"
#include "stylecolour.h"
#include "elementstyle.h"
#include "platform_fs.h"

namespace highlight {

/**
   \brief This class generates HTML.

   It contains information about the resulting document structure (document
   header and footer), the colour system, white space handling and text
   formatting attributes.

* @author Andre Simon
*/

class HtmlGenerator  : public highlight::CodeGenerator
  {
  public:

    HtmlGenerator();

    /** Destructor*/
    virtual ~HtmlGenerator() {};

    /** insert line number in the beginning of the new line
    */
    virtual void insertLineNumber(bool insertNewLine=true);

    /** Print document header
       \param  title Title of the document
    */
    string getHeader(const string &title);

    /** Print document body*/
    void printBody();

    /** Print document footer*/
    string getFooter();

    /** Print style definitions to external file
     \param outFile Path of external style definition
     */
     bool printExternalStyle(const string &outFile);

    /** Print index file with all input file names
      \param fileList List of output file names
      \param outPath Output path
    */
     bool printIndexFile(const vector<string> & fileList, const string &outPath);

     /**
       \param  b set true if anchors should be attached to line numbers
    */
     void setAttachAnchors(bool b){ attachAnchors = b; }

     /**
       \param  b set true line numbers should be replaced by list items
    */
     void setOrderedList(bool b){ orderedList = b; }

  protected:

    /** some strings which are similar in HTML and XHTML*/
    string brTag, hrTag, idAttr, fileSuffix;

    /** HTML footer */
    //string HTML_FOOTER;

    /** caches style definition */
    string styleDefinitionCache;

    /** test if line count should be replaced by ordered list*/
    bool orderedList;

    /** \return CSS definition */
    string  getStyleDefinition();

    /** \return Content of user defined style file */
    string readUserStyleDef();

    /** \param title Dociment title
        \return Start of file header */
    virtual string getHeaderStart(const string &title);

    string getGeneratorComment();

  private:

    /**  \param styleName Style name
         \return Opening tag of the given style
    */
    string getOpenTag(const string& styleName);

    /** \return escaped character*/
    virtual string maskCharacter(unsigned char );

    /** test if anchors should be appied to line numbers*/
    bool attachAnchors;

    /**\return text formatting attributes in HTML format */
    string  formatStyleAttributes(const string & elemName, const ElementStyle & elem);

    /**  \param styleID Style ID
         \return Opening tag of the given style
    */
    string getMatchingOpenTag(unsigned int styleID);

    /**  \param styleID Style ID
         \return Closing tag of the given style
    */
    string getMatchingCloseTag(unsigned int styleID);

    string getNewLine();
  };

}

#endif
