/*****************************************************************************/

/*
 *      chantab.c  --  calculate tables for the channel simulator.
 *
 *      Copyright (C) 1997  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*****************************************************************************/
      
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/* --------------------------------------------------------------------- */

#define GAUSSLPFLEN     128
#define GAUSSLPFOVER    8
#define GAUSSLPF3DBFREQ 0.01  /* 3dB freq is 0.01*fs */
#define GAUSSLPFSIGMA   (GAUSSLPF3DBFREQ/2.0/sqrt(log(2)))
#define GAUSSLPFOVERGCORR (sqrt(GAUSSLPFOVER))     /* gain correction factor due to oversampling */

/* --------------------------------------------------------------------- */

extern __inline__ float fsqr(float x) __attribute__ ((const));

extern __inline__ float fsqr(float x)
{
        return x*x;
}

/* --------------------------------------------------------------------- */

static void gen_gaussfilt(void)
{
	unsigned int i, j;

	printf("#define GAUSSLPFLEN       %4u\n"
	       "#define GAUSSLPFOVER      %4u\n"
	       "#define GAUSSLPF3DBFDIV   %4u\n"
	       "static const float gaussfilttbl[%u][%u] = {\n", GAUSSLPFLEN, GAUSSLPFOVER, 
	       (int)(1.0 / GAUSSLPF3DBFREQ), GAUSSLPFOVER, GAUSSLPFLEN/GAUSSLPFOVER);
	for (i = 0; i < GAUSSLPFOVER; i++) {
		for (j = i; j < GAUSSLPFLEN; j += GAUSSLPFOVER)
			printf("%s%10.8f", (j < GAUSSLPFOVER) ? "\t{ " : ", ",
			       sqrt(sqrt(2*M_PI)*2*GAUSSLPFSIGMA)*GAUSSLPFOVERGCORR*
			       exp(-fsqr(((int)j-GAUSSLPFLEN/2)*2*M_PI*GAUSSLPFSIGMA)));
		printf(" }%s\n", (i < GAUSSLPFOVER-1) ? "," : "");
	}
	printf("};\n\n");
}

/* --------------------------------------------------------------------- */

#define COSTABBITS 10

static void gen_costab(void)
{
	unsigned int i;

	printf("#define COS(x) (costab[((x)>>%u)&%u])\n"
	       "#define SIN(x) COS((x)+0xc000)\n\n"
	       "static const float costab[%u] = {\n\t", 16-COSTABBITS, (1<<COSTABBITS)-1, 
	       1<<COSTABBITS);
	for (i = 0; i < (1<<COSTABBITS); i++) {
		printf("%10.7f", cos(M_PI * 2.0 / (1<<COSTABBITS) * i));
		if (i >= (1<<COSTABBITS)-1)
			break;
		printf(",%s", (i & 7) != 7 ? " " : "\n\t");
	}
	printf("\n};\n\n");
}

/* --------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	printf("/*\n * automatically generated by %s, DO NOT EDIT\n */\n\n",
	       argv[0]);
	gen_gaussfilt();
	gen_costab();
	exit(0);
}
