/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hwmemobj.h,v 1.1.1.1.42.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _HWMEMOBJ_H_
#define _HWMEMOBJ_H_

// Class to access hardware memory represented by a structre.
// Some video cards return a structure instead of a buffer for
// windows DirectDraw::Lock calls.  This class provides a base
// framework to support any proprietary format.

// Flags for DeviceToRenderer
#define WRITE_VIDEO_TO_STRUCT       (1<<0)

// Flags for QueryOperation
#define PERFORMED_HW_MOTION_COMP    (1<<0)
#define PERFORMED_HW_IDCT           (1<<1)
#define PERFORMED_HW_ALPHA_BLEND    (1<<2)

class CBaseSurface;

class CHWMemObj
{
public:
    CHWMemObj(CBaseSurface* pSurface) : m_pSurface(pSurface),
                                        m_ulOperationFlags(0) {};
    virtual ~CHWMemObj() {};

    // Convert a proprietary surface pointer to something a
    // render plugin can use.
    virtual void*   DeviceToRenderer(UCHAR* pHwMem,
                                     INT32& nPitch,
                                     UINT32 ulFlags=0)
        {return NULL;}

    // Convert the render plugin data back to the device's native format 
    virtual void*   RendererToDevice(UCHAR* pRendPtr) {return NULL;}
    
    // Perform "actions" on the surface.  This must support a bit
    // transfer at a minimum.  Some devices may have hw capabilities
    // that can be used.  Use the generic pParams for any other data
    // the device may need.
    virtual BOOL    ProcessCommand(UCHAR*  pSrcPtr,
                                   INT32   fourCCIn, 
                                   HXxSize *pSrcSize,
                                   HXxRect *prSrcRect,
                                   UCHAR*  pRendPtr,
                                   INT32   fourCCOut,
                                   HXxSize *pDestSize, 
                                   HXxRect *prDestRect, 
                                   void*   pParam1=NULL,
                                   void*   pParam2=NULL,
                                   void*   pParam3=NULL)
        {return FALSE;}

    // Query the actions performed by ProcessCommand.
    virtual UINT32  QueryOperation() {return m_ulOperationFlags;}

protected:
    CBaseSurface*   m_pSurface;
    UINT32          m_ulOperationFlags;
};

#endif //_HWMEMOBJ_H_
