/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: CHXClientBuffer.cpp,v 1.3.18.3 2004/07/09 01:49:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "CHXClientBuffer.h"
#include "hlxclib/stdlib.h"

CHXClientBuffer::CHXClientBuffer( void )
	: m_lCount( 0 )
	, m_pBuffer( NULL )
	, m_BufferSize( 0 )
{
}

CHXClientBuffer::~CHXClientBuffer( void )
{
	( void ) SetSize( 0 );
}

DEFINE_SINGLE_INTERFACE_COMPONENT( CHXClientBuffer, IHXBuffer, m_lCount )

STDMETHODIMP
CHXClientBuffer::Get( REF( UCHAR* ) pData, REF( ULONG32 ) ulLength )
{
	pData = m_pBuffer;
	ulLength = m_BufferSize;
	
	return HXR_OK;
}

STDMETHODIMP
CHXClientBuffer::Set( const UCHAR* pData, ULONG32 ulLength )
{
	if ( !pData ) return HXR_INVALID_PARAMETER;
	if ( ulLength == 0 )
	{
		return SetSize( 0 );
	}
	HX_RESULT result = SetSize( ulLength );
	if ( FAILED( result ) ) return result;
	
	memcpy( m_pBuffer, pData, ulLength );
	return HXR_OK;
}

STDMETHODIMP
CHXClientBuffer::SetSize( ULONG32 ulLength )
{
	if ( ulLength == 0 )
	{
		if ( m_pBuffer )
		{
			free( m_pBuffer );
			m_pBuffer = NULL;
		}
		m_BufferSize = 0;
		return HXR_OK;
	}
	if ( ulLength != m_BufferSize )
	{
		void* pNewBuffer = realloc( m_pBuffer, ulLength );
		if ( !pNewBuffer ) return HXR_OUTOFMEMORY;
		
		m_pBuffer = ( UCHAR* ) pNewBuffer;
		m_BufferSize = ulLength;
		return HXR_OK;
	}
	return HXR_OK;
}

STDMETHODIMP_( ULONG32 )
CHXClientBuffer::GetSize( void )
{
	return m_BufferSize;
}

STDMETHODIMP_( UCHAR* )
CHXClientBuffer::GetBuffer( THIS )
{
	return m_pBuffer;
}

HX_RESULT
CHXClientBuffer::Add( const UCHAR* pData, ULONG32 ulLength )
{
	if ( ulLength == 0 ) return HXR_OK;
	if ( !pData ) return HXR_INVALID_PARAMETER;

	ULONG32 oldSize = m_BufferSize;
	HX_RESULT result = SetSize( oldSize + ulLength );
	if ( FAILED( result ) ) return result;
	
	memcpy( ( m_pBuffer + oldSize ), pData, ulLength );
	return HXR_OK;
}
