/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: wirefmgr.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef WIREFMGR_H
#define WIREFMGR_H

// Forward class declarations
class CHXBaseCountingObject;
class CHXSimpleList;
class CHXMapStringToOb;
class PXEffect;
// Forward interface declarations
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXValues             IHXValues;
typedef _INTERFACE IHXPacket             IHXPacket;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
// Other forward declarations
typedef void* LISTPOSITION;

class PXWireFormatManager : public CHXBaseCountingObject,
                            public IUnknown
{
public:
    enum
    {
        kPacketTypeImageHeader  = 0,
        kPacketTypeImageData    = 1,
        kPacketTypeEffect       = 2,
        kPacketTypeCookie       = 3
    };

    PXWireFormatManager();
    virtual ~PXWireFormatManager();

    static HX_RESULT CreateObject(PXWireFormatManager** ppObj);

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    HX_RESULT      Init(IUnknown* pContext, UINT32 ulStreamVersion);

    HX_RESULT      SetTitle(const char* pszTitle);
    HX_RESULT      SetTitle(IHXBuffer* pTitleStr);
    HX_RESULT      GetTitle(REF(IHXBuffer*) rpTitleStr);

    HX_RESULT      SetAuthor(const char* pszAuthor);
    HX_RESULT      SetAuthor(IHXBuffer* pAuthorStr);
    HX_RESULT      GetAuthor(REF(IHXBuffer*) rpAuthorStr);

    HX_RESULT      SetCopyright(const char* pszCopyright);
    HX_RESULT      SetCopyright(IHXBuffer* pCopyrightStr);
    HX_RESULT      GetCopyright(REF(IHXBuffer*) rpCopyrightStr);

    void           SetStart(UINT32 ulStart)             { m_ulStart = ulStart;              }
    UINT32         GetStart()             const         { return m_ulStart;                 }

    void           SetDuration(UINT32 ulDuration)       { m_ulDuration = ulDuration;        }
    UINT32         GetDuration()          const         { return m_ulDuration;              }

    void           SetLive(BOOL bLive)                  { m_bIsLive = bLive;                }
    BOOL           GetLive()              const         { return m_bIsLive;                 }

    void           SetMinimizeLatency(BOOL bFlag)       { m_bMinimizeLatency = bFlag;       }
    BOOL           GetMinimizeLatency()   const         { return m_bMinimizeLatency;        }

    void           SetPreroll(UINT32 ulPreroll)         { m_ulPreroll = ulPreroll;          }
    UINT32         GetPreroll()           const         { return m_ulPreroll;               }

    void           SetPrerollAfterSeek(BOOL bFlag)      { m_bPrerollAfterSeek = bFlag;      }
    BOOL           GetPrerollAfterSeek()  const         { return m_bPrerollAfterSeek;       }

    void           SetPreData(UINT32 ulPreData)         { m_ulPreData = ulPreData;          }
    UINT32         GetPreData()           const         { return m_ulPreData;               }

    void           SetPreDataAtStart(BOOL bFlag)        { m_bPreDataAtStart = bFlag;        }
    BOOL           GetPreDataAtStart()    const         { return m_bPreDataAtStart;         }

    void           SetBitrate(UINT32 ulBitrate)         { m_ulBitrate = ulBitrate;          }
    UINT32         GetBitrate()           const         { return m_ulBitrate;               }

    void           SetDisplayWidth(UINT32 ulW)          { m_ulDisplayWidth = ulW;           }
    UINT32         GetDisplayWidth()      const         { return m_ulDisplayWidth;          }

    void           SetDisplayHeight(UINT32 ulH)         { m_ulDisplayHeight = ulH;          }
    UINT32         GetDisplayHeight()     const         { return m_ulDisplayHeight;         }

    void           SetDefaultAspectFlag(BOOL bFlag)     { m_bDefaultAspectFlag = bFlag;     }
    BOOL           GetDefaultAspectFlag() const         { return m_bDefaultAspectFlag;      }

    HX_RESULT      SetDefaultURL(const char* pszDefaultURL);
    HX_RESULT      SetDefaultURL(IHXBuffer* pDefaultURLStr);
    HX_RESULT      GetDefaultURL(REF(IHXBuffer*) rpDefaultURLStr);

    void           SetDefaultMaxFps(UINT32 ulFps)       { m_ulDefaultMaxFps = ulFps;        }
    UINT32         GetDefaultMaxFps()     const         { return m_ulDefaultMaxFps;         }

    void           SetContentVersion(UINT32 ulVer)      { m_ulContentVersion = ulVer;       }
    UINT32         GetContentVersion()    const         { return m_ulContentVersion;        }

    void           SetStreamVersion(UINT32 ulVer)       { m_ulStreamVersion = ulVer;        }
    UINT32         GetStreamVersion()    const          { return m_ulStreamVersion;         }

    void           SetBackgroundColor(BYTE ucRed, BYTE ucGreen, BYTE ucBlue);
    void           SetBackgroundColor(UINT32 ulColor);
    void           GetBackgroundColor(REF(BYTE) rucRed, REF(BYTE) rucGreen, REF(BYTE) rucBlue) const;
    UINT32         GetBackgroundColor() const;

    void           SetBackgroundOpacity(UINT32 ulOpacity) { m_ulBackgroundOpacity = (ulOpacity > 255 ? 255 : ulOpacity); }
    UINT32         GetBackgroundOpacity() const           { return m_ulBackgroundOpacity;                                }

    void           SetRealPixAdsFlag(BOOL bFlag);
    BOOL           GetRealPixAdsFlag() const;
    void           SetRPACachingAdFlag(BOOL bFlag);
    BOOL           GetRPACachingAdFlag() const;

    void           SetLiveRealPixFlag(BOOL bFlag);
    BOOL           GetLiveRealPixAds() const;

    HX_RESULT      SetASMRuleBook(const char* pszRuleBook);
    HX_RESULT      SetASMRuleBook(IHXBuffer* pRuleBookStr);
    HX_RESULT      GetASMRuleBook(REF(IHXBuffer*) rpRuleBookStr);

    HX_RESULT      SetStreamMimeType(const char* pszMime);
    HX_RESULT      SetStreamMimeType(IHXBuffer* pMimeStr);
    HX_RESULT      GetStreamMimeType(REF(IHXBuffer*) rpMimeStr);

    HX_RESULT      AddCodecMime(const char* pszMime)    { return AddStringToList(pszMime,  m_pCodecMimeList);           }
    HX_RESULT      AddCodecMime(IHXBuffer* pMimeStr)   { return AddStringToList(pMimeStr, m_pCodecMimeList);           }
    UINT32         GetNumCodecMimes() const;
    HX_RESULT      GetFirstCodecMime(IHXBuffer** ppBuffer) { return GetFirstString(m_pCodecListPos, m_pCodecMimeList, ppBuffer); }
    HX_RESULT      GetNextCodecMime(IHXBuffer** ppBuffer)  { return GetNextString(m_pCodecListPos, m_pCodecMimeList, ppBuffer);  }

    HX_RESULT      AddFXPackageMime(const char* pszMime)  { return AddStringToList(pszMime,  m_pFXPackageMimeList); }
    HX_RESULT      AddFXPackageMime(IHXBuffer* pMimeStr) { return AddStringToList(pMimeStr, m_pFXPackageMimeList); }
    UINT32         GetNumFXPackageMimes() const;
    HX_RESULT      GetFirstFXPackageMime(IHXBuffer** ppBuffer) { return GetFirstString(m_pFXPackageListPos, m_pFXPackageMimeList, ppBuffer); }
    HX_RESULT      GetNextFXPackageMime(IHXBuffer** ppBuffer)  { return GetNextString(m_pFXPackageListPos, m_pFXPackageMimeList, ppBuffer); }

    HX_RESULT      GetFileHeader(REF(IHXValues*) rpFileHeader, const char* pszAcceptMetaInfo = NULL);
    HX_RESULT      GetStreamHeader(REF(IHXValues*) rpStreamHeader);
    HX_RESULT      OnHeader(IHXValues* pHeader);

    HX_RESULT      GetPacketType(IHXPacket* pPacket, REF(UINT32) rulType);
    HX_RESULT      GetImageHeaderInfo(IHXPacket* pPacket, REF(UINT32) rulHandle, REF(UINT32) rulFileLength,
                                      REF(UINT32) rulFlags, IHXBuffer** ppMimeStr, REF(UINT32) rulOpaqueSize);
    HX_RESULT      SetImageHeaderInfo(UINT32 ulHandle, UINT32 ulFileLength, UINT32 ulFlags,
                                      const char* pszMime, UINT32 ulTimeStamp, REF(IHXPacket*) rpPacket);
    HX_RESULT      SetImageHeaderInfo(UINT32 ulHandle, UINT32 ulFileLength, UINT32 ulFlags,
                                      IHXBuffer* pMimeStr, UINT32 ulTimeStamp, REF(IHXPacket*) rpPacket);
    HX_RESULT      GetImageDataHandle(IHXPacket* pPacket, REF(UINT32) rulHandle);
    HX_RESULT      GetImageDataInfo(IHXPacket* pPacket, UINT32 ulOpaqueSize,
                                    REF(IHXBuffer*) rpOpaque, REF(IHXBuffer*) rpData);
    HX_RESULT      SetImageDataInfo(UINT32 ulHandle, IHXBuffer* pData, IHXBuffer* pOpaque,
                                    UINT32 ulPacketIndex, UINT32 ulTimeStamp, BOOL bRequired,
                                    REF(IHXPacket*) rpPacket);
    HX_RESULT      GetEffectType(IHXPacket* pPacket, REF(UINT32) rulType);
    HX_RESULT      GetEffectInfo(IHXPacket* pPacket, PXEffect** ppEffect);
    HX_RESULT      SetEffectInfo(PXEffect* pEffect, UINT32 ulTimeStamp, REF(IHXPacket*) rpPacket);
    HX_RESULT      SetEffectPacketParameters(IHXPacket* pPacket, UINT32 ulEffectType,
                                             UINT32 ulStart, UINT32 ulDuration);
    HX_RESULT      SetCookieInfo(UINT32 ulNumCookies, IHXBuffer** ppURL, IHXBuffer** ppCookie,
                                 UINT32 ulTimeStamp, REF(IHXPacket*) rpPacket);
    HX_RESULT      GetNumCookies(IHXPacket* pPacket, REF(UINT32) rulNumCookies);
    HX_RESULT      GetCookie(IHXPacket* pPacket, UINT32 ulIndex,
                             REF(IHXBuffer*) rpURL, REF(IHXBuffer*) rpBuffer);
    HX_RESULT      SetNoOpInfo(UINT32 ulSize, UINT32 ulTimeStamp, REF(IHXPacket*) rpPacket);
    HX_RESULT      GetBackChannelInfo(IHXPacket* pPacket, REF(UINT32) rulHandle, REF(UINT32) rulTimeStopped);
    HX_RESULT      SetBackChannelInfo(UINT32 ulHandle, UINT32 ulTimeStopped, REF(IHXPacket*) rpPacket);
    UINT32         GetEffectWireSize(PXEffect* pEffect);
    UINT32         GetImageWireSize(IHXBuffer* pStreamMimeStr, UINT32 ulImageFileSize);

    static UINT32  GetPacketSize(IHXPacket* pPacket);
    static UINT32  UnPackUINT32(REF(BYTE*) rpBuffer);
    static UINT32  UnPackUINT16(REF(BYTE*) rpBuffer);
    static UINT32  UnPackBYTE(REF(BYTE*) rpBuffer);
    static UINT32  UnPackUINT32_LE(REF(BYTE*) rpBuffer);
    static UINT32  UnPackUINT16_LE(REF(BYTE*) rpBuffer);
    static UINT32  UnPackVUINT(REF(BYTE*) rpBuffer);
    static void    PackUINT32(REF(BYTE*) rpBuffer, UINT32 ulValue);
    static void    PackUINT16(REF(BYTE*) rpBuffer, UINT32 ulValue);
    static void    PackBYTE(REF(BYTE*) rpBuffer,   UINT32 ulValue);
    static void    PackVUINT(REF(BYTE*) rpBuffer,  UINT32 ulValue);
    static UINT32  GetMask(UINT32 ulBitPos, UINT32 ulNumBits);
    static UINT32  GetUnsignedBits(REF(BYTE*) rpBuf, REF(UINT32) rulBitPos, UINT32 ulNumBits);
    static INT32   GetSignedBits(REF(BYTE*) rpBuf, REF(UINT32) rulBitPos, UINT32 ulNumBits);
protected:
    enum
    {
        kDefaultOpaqueSize      = 8,
        kIHXPacketOverhead     = 20,
        kMinImageDataPacketSize = 320,
        kRealPixAdsFlagMask     = 0x00000001,
        kRPACachingAdFlagMask   = 0x00000002,
        kLiveRealPixMask        = 0x00000004
    };

    INT32                   m_lRefCount;
    IUnknown*               m_pContext;
    IHXCommonClassFactory*  m_pCommonClassFactory;
    UINT32                  m_ulStreamVersion;
    IHXBuffer*              m_pTitleStr;
    IHXBuffer*              m_pAuthorStr;
    IHXBuffer*              m_pCopyrightStr;
    UINT32                  m_ulStart;
    UINT32                  m_ulDuration;
    BOOL                    m_bIsLive;
    BOOL                    m_bMinimizeLatency;
    UINT32                  m_ulPreroll;
    BOOL                    m_bPrerollAfterSeek;
    UINT32                  m_ulPreData;
    BOOL                    m_bPreDataAtStart;
    UINT32                  m_ulBitrate;
    UINT32                  m_ulDisplayWidth;
    UINT32                  m_ulDisplayHeight;
    BOOL                    m_bDefaultAspectFlag;
    IHXBuffer*              m_pDefaultURLStr;
    UINT32                  m_ulDefaultMaxFps;
    UINT32                  m_ulContentVersion;
    UINT32                  m_ulBackgroundColor; // 0x00RRGGBB
    UINT32                  m_ulBackgroundOpacity;
    CHXSimpleList*          m_pCodecMimeList;
    CHXSimpleList*          m_pFXPackageMimeList;
    CHXMapStringToOb*       m_pMapMimeToOpaqueSize;
    LISTPOSITION            m_pCodecListPos;
    LISTPOSITION            m_pFXPackageListPos;
    IHXBuffer*              m_pASMRuleBook;
    IHXBuffer*              m_pStreamMimeType;
    UINT32                  m_ulRendererFlags;

    static const UINT32     m_ulHighestSupportedStreamVersion;

    HX_RESULT AddStringToList(const char* pszStr, CHXSimpleList* pList);
    HX_RESULT AddStringToList(IHXBuffer* pBufferStr, CHXSimpleList* pList);
    HX_RESULT SetString(const char* pszStr, REF(IHXBuffer*) rpBufferStr);
    HX_RESULT SetString(IHXBuffer* pBuffer, REF(IHXBuffer*) rpBufferStr);
    HX_RESULT GetFirstString(REF(LISTPOSITION) rPos, CHXSimpleList* pList, IHXBuffer** ppBuffer);
    HX_RESULT GetNextString(REF(LISTPOSITION) rPos, CHXSimpleList* pList, IHXBuffer** ppBuffer);
    void      Deallocate();
    void      Reset();
    UINT32    GetOpaqueSize(const char* pszMimeType);
    void      ReleaseAllCodecMimes();
    void      ReleaseAllFXPackageMimes();
    UINT32    PackStreamHeader(BYTE*& rpBuf, BOOL bPack);
    void      AddMetaInfo(IHXValues* pAvailableMetaInfo,
                          const char* pszRequestedInfo,
                          IHXValues* pFileHeader);
};

#endif
