/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXErrorCodeStringsMac.c,v 1.4.14.3 2004/07/09 01:49:35 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "HXErrorCodeStringsMac.h"
#include "HXErrorCodeStrings.h"

#include "enter_hx_headers.h"
#include "hxresult.h"
#include "exit_hx_headers.h"

CFStringRef
CreateErrorStringForHXCode( ULONG32 ulHXCode, const char* pErrorString )
{
	CFStringRef errorString = nil;
	
	CFBundleRef hxClientBundleRef = CFBundleGetBundleWithIdentifier( CFSTR( "org.HelixCommunity.HXClientKit" ) );
	if ( !hxClientBundleRef )
	{
		if ( pErrorString )
		{
			errorString = CFStringCreateWithCString( kCFAllocatorDefault, pErrorString, kCFStringEncodingUTF8 );
			return errorString;
		}
		return nil;
	}
	CFStringRef keyString = nil;
	
    // first look in our table for the key to the XML error string table
	const char* errorCodeString = HXErrorCodeToString( ulHXCode );
	if ( errorCodeString )
	{
		keyString = CFStringCreateWithCString( kCFAllocatorDefault, errorCodeString, kCFStringEncodingUTF8 );
    }
	// if we have the key, get the string from the table
	if ( keyString != nil )
	{
		errorString = CFBundleCopyLocalizedString( hxClientBundleRef, keyString, nil, CFSTR( "Helix" ) );
		if ( errorString && 
			 ( CFStringGetLength( errorString ) == 0 || CFStringCompare( errorString, keyString, 0 ) == 0 ) )
		{
			CFRelease( errorString );
			errorString = nil;
		}
	}
    // if necessary, use the core's error string, though we don't think it'll have one
	if ( !errorString && pErrorString )
	{
		errorString = CFStringCreateWithCString( kCFAllocatorDefault, pErrorString, kCFStringEncodingUTF8 );
		if ( errorString && ( CFStringGetLength( errorString ) == 0 ) )
		{
			CFRelease( errorString );
			errorString = nil;
		}
	}
	// if we haven't gotten a string, get the generic "general error" message,
	// and if we know the key, append it to the generic error message
	if ( !errorString )
    {
		if ( ulHXCode != HXR_FAILED )
		{
			// if we know the key string (like IDS_ERR_MEMORY_ERROR), clean it up (like MEMORY ERROR)
			// and show that instead of the hex value
			CFStringRef keyStringCleaned = nil;
			if ( ( keyString != nil ) && ( CFStringGetLength( keyString ) > 0 ) )
			{
				CFMutableStringRef scratchKeyString = CFStringCreateMutableCopy( kCFAllocatorDefault, 0, keyString );
				( void ) CFStringFindAndReplace( scratchKeyString, CFSTR( "HXR_" ), CFSTR( "" ),
												 CFRangeMake( 0, CFStringGetLength( scratchKeyString ) ), kCFCompareCaseInsensitive );
				( void ) CFStringFindAndReplace( scratchKeyString, CFSTR( "_" ), CFSTR( " " ),
												 CFRangeMake( 0, CFStringGetLength( scratchKeyString ) ), 0 );
				CFStringCapitalize( scratchKeyString, NULL );
				
				keyStringCleaned = scratchKeyString;
			}
			else
			{
				CFStringRef formattedString = CFStringCreateWithFormat( kCFAllocatorDefault, nil, CFSTR( "$%lX" ), ulHXCode );
				keyStringCleaned = CFStringCreateMutableCopy( kCFAllocatorDefault, 0, formattedString );
				CFRelease( formattedString );
			}
			if ( keyStringCleaned != nil )
			{
				// "A general error has occurred. (%@)";
				CFStringRef genericErrorString = CFBundleCopyLocalizedString( hxClientBundleRef, CFSTR( "HXR_GENERAL_ERROR_FALLBACK" ), nil, CFSTR( "Helix" ) );
				if ( genericErrorString )
				{
					errorString = CFStringCreateWithFormat( kCFAllocatorDefault, nil, genericErrorString, keyStringCleaned );
					CFRelease( genericErrorString );
				}
				CFRelease( keyStringCleaned );
			}
			else
			{
				// "A general error has occurred.";
				errorString = CFBundleCopyLocalizedString( hxClientBundleRef, CFSTR( "HXR_FAIL" ), nil, CFSTR( "Helix" ) );
			}
		}
	}
	if ( keyString )
	{
		CFRelease( keyString );
	}
	return errorString;
}
