/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: playeripc.h,v 1.2.8.3 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PLAYER_IPC_H_
#define _PLAYER_IPC_H_

#include <glib.h>
//#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "mainapp.h"
#include "hxplayer.h"

#ifdef __cplusplus
extern "C" {
#endif

struct _HXEmbeddedWindow;
typedef struct _HXEmbeddedWindow HXEmbeddedWindow;

/* Use gtk-style enums */
typedef enum _HXCallbackFlags
{
    HX_CALLBACK_ON_AUTHOR_CHANGE        = 1 << 0,
    HX_CALLBACK_ON_BUFFERING            = 1 << 1,
    HX_CALLBACK_ON_CLIP_CLOSED          = 1 << 2,
    HX_CALLBACK_ON_CLIP_OPENED          = 1 << 3,
    HX_CALLBACK_ON_CONTACTING           = 1 << 4,
    HX_CALLBACK_ON_COPYRIGHT_CHANGE     = 1 << 5,
    HX_CALLBACK_ON_ERROR_MESSAGE        = 1 << 6,
    HX_CALLBACK_ON_GOTO_URL             = 1 << 7,
    HX_CALLBACK_ON_KEY_DOWN             = 1 << 8,
    HX_CALLBACK_ON_KEY_PRESS            = 1 << 9,
    HX_CALLBACK_ON_KEY_UP               = 1 << 10,
    HX_CALLBACK_ON_LBUTTON_DOWN         = 1 << 11,
    HX_CALLBACK_ON_LBUTTON_UP           = 1 << 12,
    HX_CALLBACK_ON_MOUSE_MOVE           = 1 << 13,
    HX_CALLBACK_ON_MUTE_CHANGE          = 1 << 14,
    HX_CALLBACK_ON_PLAY_STATE_CHANGE    = 1 << 15,
    HX_CALLBACK_ON_POS_LENGTH           = 1 << 16,
    HX_CALLBACK_ON_POSITION_CHANGE      = 1 << 17,
    HX_CALLBACK_ON_POST_SEEK            = 1 << 18,
    HX_CALLBACK_ON_PREFETCH_COMPLETE    = 1 << 19,
    HX_CALLBACK_ON_PRE_SEEK             = 1 << 20,
    HX_CALLBACK_ON_PRESENTATION_CLOSED  = 1 << 21,
    HX_CALLBACK_ON_PRESENTATION_OPENED  = 1 << 22,
    HX_CALLBACK_ON_RBUTTON_DOWN         = 1 << 23,
    HX_CALLBACK_ON_RBUTTON_UP           = 1 << 24,
    HX_CALLBACK_ON_SHOW_STATUS          = 1 << 25,
    HX_CALLBACK_ON_STATE_CHANGE         = 1 << 26,
    HX_CALLBACK_ON_TITLE_CHANGE         = 1 << 27,
    HX_CALLBACK_ON_VOLUME_CHANGE        = 1 << 28,   
    HX_CALLBACK_ALL                     = 0xffffffff
} HXCallbackFlags;


typedef enum _HXControlFlags
{
    HX_CONTROLS_CONTROL_PANEL          = 1 << 0, 
    HX_CONTROLS_FF_CTRL                = 1 << 1, 
    HX_CONTROLS_HOME                   = 1 << 2, 
    HX_CONTROLS_IMAGE_WINDOW           = 1 << 3, 
    HX_CONTROLS_INFO_PANEL             = 1 << 4, 
    HX_CONTROLS_INFO_VOLUME_PANEL      = 1 << 5, 
    HX_CONTROLS_MUTE_CTRL              = 1 << 6, 
    HX_CONTROLS_MUTE_VOLUME            = 1 << 7, 
    HX_CONTROLS_PAUSE_BUTTON           = 1 << 8, 
    HX_CONTROLS_PLAY_BUTTON            = 1 << 9,  // Play button == Play+Stop
    HX_CONTROLS_PLAY_BUTTON_ONLY       = 1 << 10, // This is just the play button
    HX_CONTROLS_POSITION_FIELD         = 1 << 11,
    HX_CONTROLS_POSITION_SLIDER        = 1 << 12,
    HX_CONTROLS_RW_CTRL                = 1 << 13,
    HX_CONTROLS_STATUS_BAR             = 1 << 14,
    HX_CONTROLS_STATUS_FIELD           = 1 << 15,
    HX_CONTROLS_STOP_BUTTON            = 1 << 16, 
    HX_CONTROLS_TAC                    = 1 << 17,
    HX_CONTROLS_VOLUME_SLIDER          = 1 << 18,
    HX_CONTROLS_ALL                    = 1 << 19, // All does not include an image window
    HX_CONTROLS_UNKNOWN                = 1 << 20
} HXControlFlags;

/* It seems that the name attribute can also be used to determine
   controls layout. This is unspeced behavior, but the official
   RealPlayer Javascript testing page uses it, and the Windows 
   player handles it...
   
   See "Control Attributes" at:
   http://service.real.com/help/library/guides/realonescripting/browse/samples/javaembed/JAVAFrames.htm
*/
typedef enum _HXNameFlags
{
    HX_NAME_NONE,
    HX_NAME_PLAY_CONTROL,
    HX_NAME_PAUSE_CONTROL,
    HX_NAME_STOP_CONTROL
} HXNameFlags;
    
gboolean playeripc_init(int command_fd, int callbacks_fd);

/* Javascript callbacks */
void playeripc_on_author_change       (HXEmbeddedWindow* window,
                                       const gchar*      key,
                                       GValue*           author_value);
void playeripc_on_buffering           (HXEmbeddedWindow* window,
                                       HXBufferingReason reason,
                                       guint             percent_complete);
void playeripc_on_clip_closed         (HXEmbeddedWindow* window);
void playeripc_on_clip_opened         (HXEmbeddedWindow* window,
                                       const gchar*      short_clip_name,
                                       const gchar*      url);
void playeripc_on_contacting          (HXEmbeddedWindow* window,
                                       const gchar*      contacting_text);
void playeripc_on_copyright_change    (HXEmbeddedWindow* window,
                                       const char*       key,
                                       GValue* copyright_value);
void playeripc_on_error_message       (HXEmbeddedWindow* window,
                                       gint rma_code,
                                       gint user_code,
                                       gchar* error,
                                       gchar* user_string,
                                       gchar* more_info_url);
void playeripc_on_goto_url            (HXEmbeddedWindow* window,
                                       gchar*            url,
                                       gchar*            target);
void playeripc_on_mute_change         (HXEmbeddedWindow* window,
                                       gboolean          mute);
void playeripc_on_play_state_change   (HXEmbeddedWindow* window,
                                       HXContentStateType old_state,
                                       HXContentStateType new_state);
void playeripc_on_pos_length          (HXEmbeddedWindow* window,
                                       gint              pos,
                                       gint              len);
void playeripc_on_position_change     (HXEmbeddedWindow* window,
                                       gint              pos,
                                       gint              len);
void playeripc_on_post_seek           (HXEmbeddedWindow* window,
                                       gint              old_time,
                                       gint              new_time);
void playeripc_on_prefetch_complete   (HXEmbeddedWindow* window,
                                       HXBufferingReason reason,
                                       guint             percent_complete);
void playeripc_on_pre_seek            (HXEmbeddedWindow* window,
                                       gint              old_time,
                                       gint              new_time);
void playeripc_on_presentation_opened (HXEmbeddedWindow* window);
void playeripc_on_presentation_closed (HXEmbeddedWindow* window);
void playeripc_on_show_status         (HXEmbeddedWindow* window,
                                       const gchar*      status);
void playeripc_on_state_change        (HXEmbeddedWindow* window,
                                       HXContentStateType old_state,
                                       HXContentStateType new_state);
void playeripc_on_title_change        (HXEmbeddedWindow* window,
                                       const char*       key,
                                       GValue*           title_value);
void playeripc_on_volume_change       (HXEmbeddedWindow* window,
                                       guint             volume);

/* These callbacks are hooked up to event signals */
gboolean playeripc_on_key_down        (HXEmbeddedWindow* window, GdkEventKey* event);
gboolean playeripc_on_key_press       (HXEmbeddedWindow* window, GdkEventKey* event);
gboolean playeripc_on_key_up          (HXEmbeddedWindow* window, GdkEventKey* event);
gboolean playeripc_on_lbutton_down    (HXEmbeddedWindow* window, GdkEventButton* event);
gboolean playeripc_on_lbutton_up      (HXEmbeddedWindow* window, GdkEventButton* event);
gboolean playeripc_on_mouse_move      (HXEmbeddedWindow* window, GdkEventMotion* event);
gboolean playeripc_on_rbutton_down    (HXEmbeddedWindow* window, GdkEventButton* event);
gboolean playeripc_on_rbutton_up      (HXEmbeddedWindow* window, GdkEventButton* event);
void     playeripc_get_url            (HXEmbeddedWindow* window,
                                       const gchar*      url,
                                       const gchar*      target);
    
HXControlFlags  playeripc_control_flags_get_from_string (const gchar* str);
HXCallbackFlags playeripc_callback_flags_get_from_string(const gchar* str);

#ifdef __cplusplus
}
#endif
#endif
