/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: archive.h,v 1.1.2.1 2004/07/09 02:02:33 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _ARCHIVE_H_
#define _ARCHIVE_H_

#ifdef _WIN32
#define OS_SEPARATOR_CHAR '\\'
#define snprintf _snprintf
#else
#define OS_SEPARATOR_CHAR '/'
#endif

#define HXAR_ARCH_DESC_SIZE 6
#define HXAR_ID_SIZE        4
#define HXAR_ID             "hxar"
#define HXAR_VER_MAJOR      0x00
#define HXAR_VER_MINOR      0x01

#define HXAR_FILE_DESC_SIZE 14
#define HXAR_FILE_ID_SIZE   4
#define HXAR_FILE_ID        "hxfd"

#define READ_CHUNK_SIZE     4096
#define DESC_BUF_SIZE       MAX_PATH + 1


enum HXAR_STATE
{
    STATE_ARCH_HEADER   = 0,
    STATE_FILE_HEADER,
    STATE_FILE_NAME,
    STATE_FILE_DATA,
    STATE_CLOSED
};

class Archiver
{
public:
    Archiver();
    ~Archiver();

    HX_RESULT Init(FILE* fTarFile);
    HX_RESULT AddFile(const char* szFileName);

protected:
    FILE* m_fTarFile;
    BYTE* m_pReadBuf;

    HX_RESULT RecurseDirectory(const char* szFileName);
    HX_RESULT WriteArchiveHeader();
    HX_RESULT WriteFileHeader(const char* szFileName, struct stat* pFileInfo);
    HX_RESULT WriteFileData(const char* szFileName, struct stat* pFileInfo);
};

class Dearchiver
{
public:
    Dearchiver();
    ~Dearchiver();

    HX_RESULT Init(const char* pOutDir = NULL);
    HX_RESULT Extract(FILE* fTarFile);
    HX_RESULT Extract(BYTE* pArchData, const UINT32 ulSize, UINT32& ulRead);
    void Close();

private:
    const char* m_szOutDir;
    UINT32 m_State;

    BYTE* m_pReadBuf;

    UINT32 m_ulSaved;
    BYTE* m_pSaveBuf;
    
    FILE* m_fFile;
    UINT32 m_ulFileSize;
    UINT16 m_ulMode;
    UINT32 m_ulWritten;

    HX_RESULT ReadTarHeader(BYTE* pArchData, const UINT32 ulSize,
                            UINT32& ulRead);
    HX_RESULT ReadFileHeader(BYTE* pArchData, const UINT32 ulSize,
                            UINT32& ulRead);
    HX_RESULT ReadFileName(BYTE* pArchData, const UINT32 ulSize,
                            UINT32& ulRead);
    HX_RESULT ReadFileData(BYTE* pArchData, const UINT32 ulSize,
                            UINT32& ulRead);

    HX_RESULT OpenOutFile(const char* szFileName);
    void CloseOutFile();
};

#endif // _ARCHIVE_H_
