/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: plugin.cpp,v 1.34.2.5 2004/07/09 01:48:45 hubbe Exp $
 * 
 * * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "nsHXPlayer.h"
#include "hxbackend.h"
#include "plugin.ver"

#include <sys/types.h>
#include <unistd.h>

#define PLUGIN_NAME         "Helix DNA Plugin: RealPlayer G2 Plug-In Compatible"

char* NPP_GetMIMEDescription(void)
{
    char* szMimeDescription;
    
    szMimeDescription = getenv("HELIX_PLUGIN_MIME_OVERRIDE");
    if(!szMimeDescription)
    {
        szMimeDescription = "audio/x-pn-realaudio-plugin:rpm:RealPlayer Plugin Metafile;";
    }
    
    return szMimeDescription;
}

//////////////////////////////////////
//
// general initialization and shutdown
//

// single, shared instance of the backend
CHXPlayerBackend *g_pBackend = NULL;

NPError NS_PluginInitialize()
{
#if 0
#warning "Do not check in with this loop active"
    char c = 0;
    printf("Attach to %d\n", getpid());
    while(c == 0)
    {
    }
#endif
    /* The backend is now initialized when the first plugin instance
       is created. See NS_NewPluginInstance for details */
    
    return NPERR_NO_ERROR;
}

void NS_PluginShutdown()
{
    if(g_pBackend)
    {
        g_pBackend->Shutdown();

        if(g_pBackend->mRefCnt != 1)
        {
            printf("Warning: CHXPlayerBackend still has %d references\n",
                   g_pBackend->mRefCnt - 1);
        }
        
        NS_RELEASE(g_pBackend);        
        g_pBackend = NULL;        
    }
}

// get values per plugin
NPError NS_PluginGetValue(NPPVariable aVariable, void *aValue)
{
    char* szValue;
    
    NPError err = NPERR_NO_ERROR;
    switch (aVariable)
    {
    case NPPVpluginNameString:
        szValue = getenv("HELIX_PLUGIN_NAME_OVERRIDE");
        if(!szValue)
        {
            szValue = PLUGIN_NAME;
        }
        *((char **)aValue) = szValue;
        break;
        
    case NPPVpluginDescriptionString:
        szValue = getenv("HELIX_PLUGIN_DESCRIPTION_OVERRIDE");
        if(!szValue)
        {
            static char szPluginDescription[1024];
#if defined(__GNUC__) && defined(__GNUC_MINOR__) && defined(__GNUC_PATCHLEVEL__)
            snprintf(szPluginDescription,
                     sizeof(szPluginDescription),
                     "%s version %s built with gcc %d.%d.%d on %s",
                     PLUGIN_NAME,
                     TARVER_STRING_VERSION,
                     __GNUC__,
                     __GNUC_MINOR__,
                     __GNUC_PATCHLEVEL__ ,
                     __DATE__);
#else
            snprintf(szPluginDescription,
                     sizeof(szPluginDescription),
                     "%s version %s built on %s",
                     PLUGIN_NAME,
                     TARVER_STRING_VERSION,
                     __DATE__);
#endif

            szValue = szPluginDescription;
        }
        *((char **)aValue) = szValue;
        break;
        
    default:
        err = NPERR_INVALID_PARAM;
        break;
    }
    return err;
}

/////////////////////////////////////////////////////////////
//
// construction and destruction of our plugin instance object
//
nsPluginInstanceBase * NS_NewPluginInstance(nsPluginCreateData * aCreateDataStruct)
{
    nsresult result;
    PRBool bEmbeddedPlayerOpen;
    
    if(!aCreateDataStruct)
    {
        return NULL;
    }

    if(!g_pBackend)
    {
        /* We used to create the backend in NS_PluginInitialize, but we
           don't have a NPP instance at that point in time. Without a
           NPP instance, we can't display popups. We therefore wait until
           here so we can add a nsHXPlayer to the backend which can be
           used to display popups. */
        g_pBackend = new CHXPlayerBackend;

        NS_ADDREF(g_pBackend);        

        g_pBackend->Init(aCreateDataStruct->instance);
    }

    /* Create the plugin here so the backend will have access to
       a NPP instance if it needs it. */
    nsHXPlayer *pPlugin = new nsHXPlayer(g_pBackend);

    bEmbeddedPlayerOpen = g_pBackend->IsEmbeddedPlayerOpen();
    if(!bEmbeddedPlayerOpen)
    {
        g_pBackend->OpenEmbeddedPlayer();
        bEmbeddedPlayerOpen = g_pBackend->IsEmbeddedPlayerOpen();
    }

    if(bEmbeddedPlayerOpen)
    {
        result = pPlugin->Init(aCreateDataStruct);
    }
    else
    {
        result = NS_ERROR_FAILURE;
    }

    if(NS_FAILED(result))
    {
        delete pPlugin;
        pPlugin = NULL;
    }
    else
    {
        NS_ADDREF(pPlugin);
    }
    
    return pPlugin;
}

void NS_DestroyPluginInstance(nsPluginInstanceBase * aPlugin)
{
    if(aPlugin)
    {
        nsHXPlayer *pPlugin = (nsHXPlayer *)aPlugin;
        pPlugin->Destroy();

        // We release the plugin instead of deleting it as mozilla
        // may (and often does) still have outstanding references on it.
        NS_RELEASE(pPlugin);
    }
}
