/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: nsHXPlayer.h,v 1.3.8.5 2004/07/09 01:48:45 hubbe Exp $
 * 
 * * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __NS_HXPLAYER_H__
#define __NS_HXPLAYER_H__

#include "nsISupports.h"
#include "nsIClassInfo.h"
#include "nsIHXPlayer.h"
#include "nsISupportsImpl.h"
#include "embddef.h"
#include "npapi.h"
#include "pluginbase.h"

class CHXPlayerBackend;

class nsHXPlayer : public nsIHXPlayer,
                   public nsIClassInfo,
                   public nsPluginInstanceBase
{
public:
    NS_DECL_ISUPPORTS
    
    // NS_DECL_ICLASSINFO (Implemented inline below)
    // NS_DECL_IHXPLAYER  (Implemented inline below)

    nsHXPlayer(CHXPlayerBackend *pBackend);
    virtual ~nsHXPlayer();

    nsresult Init(nsPluginCreateData *aCreateDataStruct);
    nsresult Destroy(void);

    // Backend support functions
    const char* GetName(void) { return m_szName; }
    int         GetId(void)   { return m_iPlayerID; }
    NPP         GetInstance(void) { return m_instance; }
    nsresult    OnGetURL(const char *szUrl, const char *szTarget);

    // NPP_* method overrides (via nsPluginInstanceBase) 
    NPError NewStream(NPMIMEType type, NPStream* stream, NPBool /* seekable */, uint16* stype);
    NPError DestroyStream(NPStream *stream, NPError /* reason */);
    int32   Write(NPStream *stream, int32 offset, int32 nDataLen, void *pData);
    NPError GetValue(NPPVariable variable, void *value);
    NPError SetWindow(NPWindow* aWindow);
    void    URLNotify(const char*, NPReason, void *data);

    // other nsPluginInstanceBase pure virtual methods, not particularly useful for us.
    NPBool init(NPWindow*) { m_bIsInitialized = TRUE; return TRUE; }
    void   shut()          { m_bIsInitialized = FALSE; }
    NPBool isInitialized() { return m_bIsInitialized; };

private:
    // ReadGenericResponse reads a boolean using ReadMessage
    char *GetQuotedString(const char *szString);
    nsresult GetGenericResponse(PRBool* result);
    nsresult GetPlayerUINT32Prop(const char *szPropName, PRInt32 *uiValue);
    nsresult GetPlayerStringProp(const char *szPropName, char **pszValue);
    nsresult GetEntryStringProp(const char *szPropName, PRInt32 uIndex, char **pszValue);
    nsresult SetPlayerUINT32Prop(const char *szPropName, PRInt32 uiPropValue, PRBool *retval);
    nsresult SetPlayerStringProp(const char *szPropName, const char *szValue, PRBool *retval);

    nsresult DoCommand(const char *szCommand, PRBool *_retval);
    nsresult ReadGenericResponse(PRBool* retval);
        
    // private data
    int m_iPlayerID;
    NPP m_instance;
    char *m_szName;

    NPBool m_bIsFirstNewStream;
    NPBool m_bReceivedXEmbedQuery;
    NPBool m_bIsInitialized;
    
    // Backend shared between all nsHXPlayer's
    CHXPlayerBackend *m_pBackend;
    
public:
    // nsIHXPlayer implementation
    // Commands
    NS_IMETHOD DoPlayPause(PRBool *_retval)
    {
        return DoCommand("PlayPause", _retval);
    }
    NS_IMETHOD DoPause(PRBool *_retval)
    {
        return DoCommand("Pause", _retval);
    }
    NS_IMETHOD DoPlay(PRBool *_retval)
    {
        return DoCommand("Play", _retval);
    }
    NS_IMETHOD DoStop(PRBool *_retval)
    {
        return DoCommand("Stop", _retval);
    }

    // Seek takes a position argument, unlike the above.
    NS_IMETHOD SetPosition(PRInt32 Position, PRBool *_retval);

    // Property Get/Set's
    NS_IMETHOD DoNextItem(PRBool *_retval)
    {
        return DoNextEntry(_retval);
    }
    NS_IMETHOD DoPrevItem(PRBool *_retval)
    {
        return DoPrevEntry(_retval);
    }
    NS_IMETHOD DoNextEntry(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_DONEXT, 0, _retval);
    }        
    NS_IMETHOD DoPrevEntry(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_DOPREV, 0, _retval);
    }
    NS_IMETHOD SetSource(const char *szSource, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_SOURCE, szSource, _retval);
    }            
    NS_IMETHOD SetControlString(const char *szControls, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_CONTROLS, szControls, _retval);
    }
    NS_IMETHOD SetConsoleName(const char *szConsole, PRBool /* a */, PRBool *_retval)
    {
        // XXXVD,RGG: Same as SetConsole? What is the PRBool?
        return SetPlayerStringProp(EMBD_PROP_CONSOLE, szConsole, _retval);
    }    
    NS_IMETHOD SetConsole(const char *szConsole, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_CONSOLE, szConsole, _retval);        
    }    
    NS_IMETHOD SetAutoStart(PRBool bAutoStart, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_AUTOSTART, bAutoStart, _retval);
    }
    NS_IMETHOD SetNoLabels(PRBool /* bNoLabels */, PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetPosition(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_POSITION, _retval);
    }
    NS_IMETHOD GetLength(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_LENGTH, _retval);
    }
    NS_IMETHOD GetPlayState(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PLAYSTATE, _retval);
    }
    NS_IMETHOD GetStereoState(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_STEREO, _retval);
    }
    NS_IMETHOD GetTitle(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_TITLE, _retval);        
    }
    NS_IMETHOD GetAuthor(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_AUTHOR, _retval);        
    }
    NS_IMETHOD GetCopyright(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_COPYRIGHT, _retval);        
    }
    NS_IMETHOD GetLiveState(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_LIVE, _retval);
    }
    NS_IMETHOD IsZoomed(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_FULLSCR, _retval);
    }
    NS_IMETHOD SetZoomed(PRBool bIsZoomed, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_FULLSCR, bIsZoomed, _retval);
    }
    NS_IMETHOD CanPlayPause(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CANPLAYPAUSE, _retval);
    }
    NS_IMETHOD CanStop(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CANSTOP, _retval);
    }
    NS_IMETHOD HasNextEntry(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_HASNEXTENTRY, _retval);
    }
    NS_IMETHOD HasPrevEntry(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_HASPREVENTRY, _retval);
    }
    NS_IMETHOD HasNextItem(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_HASNEXTENTRY, _retval);        
    }
    NS_IMETHOD HasPrevItem(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_HASPREVENTRY, _retval);
    }
    NS_IMETHOD SetVolume(PRInt32 nNewVolume, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_VOLUME, nNewVolume, _retval);
    }
    NS_IMETHOD SetMute(PRBool bIsMute, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_MUTE, bIsMute, _retval);
    }
    NS_IMETHOD SetEnableContextMenu(PRBool bIsMenuOn, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_CONTEXTMENU, bIsMenuOn, _retval);
    }
    NS_IMETHOD GetEnableContextMenu(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CONTEXTMENU, _retval);
    }
    NS_IMETHOD EnableMessageBox(PRBool /* isMessageBoxOn */, PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD SetEnableMessageBox(PRBool /* isMessageBoxOn */, PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetEnableMessageBox(PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }        
    NS_IMETHOD GetPacketsTotal(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PKTSTOTAL, _retval);
    }
    NS_IMETHOD GetPacketsReceived(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PKTSRECV, _retval);
    }
    NS_IMETHOD GetPacketsOutOfOrder(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PKTSORDER, _retval);
    }
    NS_IMETHOD GetPacketsMissing(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PKTSMISSING, _retval);
    }
    NS_IMETHOD GetPacketsLate(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PKTSLATE, _retval);
    }
    NS_IMETHOD GetBandwidthAverage(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_BWAVG, _retval);
    }
    NS_IMETHOD GetBandwidthCurrent(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_BWCUR, _retval);        
    }
    NS_IMETHOD AboutBox(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ABOUTDLG, PR_TRUE, _retval);
    }
    NS_IMETHOD EditPreferences(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_PREFSDLG, PR_TRUE, _retval);
    }
    NS_IMETHOD SetShowPreferences(PRBool bShowPref, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_PREFSDLG, bShowPref, _retval);
    }
    NS_IMETHOD HideShowStatistics(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_STATSDLG, PR_FALSE, _retval);
    }
    NS_IMETHOD IsStatisticsVisible(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_STATSDLG, _retval);
    }
    NS_IMETHOD IsDone(PRBool *_retval)
    {
        // XXXVD: unsupported!
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD StatusScanStart(PRBool *_retval)
    {        
        // XXXVD: unsupported!
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD StatusScanEnd(PRBool *_retval)
    {
        // XXXVD: unsupported!
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD StatusScan(const char * /* szShowString */, PRBool *_retval)
    {
        // XXXVD: unsupported!
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD SetAutoGoToURL(PRBool bGiveNetscapeURL, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_AUTOGOTOURL, bGiveNetscapeURL, _retval);
    }
    NS_IMETHOD GetAutoGoToURL(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_AUTOGOTOURL, _retval);
    }
    NS_IMETHOD ProcessIdle(PRBool *_retval)
    {
        // XXXVD: unsupported!
        // XXXRGG: If only this was widely done, we could do callbacks without
        // all the dirty hacks. *sigh*.
        *_retval = PR_FALSE;        
        return NS_OK;
    }
    NS_IMETHOD SetControls(const char *szControls, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_CONTROLS, szControls, _retval);
    }
    NS_IMETHOD GetVersionInfo(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_VERSION, _retval);
    }
    NS_IMETHOD GetPreFetch(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PREFETCH, _retval);
    }
    NS_IMETHOD SetPreFetch(PRBool bWantsPrefetch, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_PREFETCH, bWantsPrefetch, _retval);
    }
    NS_IMETHOD SetShuffle(PRBool bShuffleOn, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_SHUFFLE, bShuffleOn, _retval);
    }
    NS_IMETHOD GetShuffle(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_SHUFFLE, _retval);
    }
    NS_IMETHOD GetSource(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_SOURCE, _retval);
    }
    NS_IMETHOD CanPlay(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CANPLAY, _retval);
    }
    NS_IMETHOD CanPause(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CANPAUSE, _retval);
    }
    NS_IMETHOD GetAutoStart(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_AUTOSTART, _retval);
    }
    NS_IMETHOD GetBackgroundColor(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_BGCOLOR, _retval);            
    }
    NS_IMETHOD SetBackgroundColor(const char *szNewColor, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_BGCOLOR, szNewColor, _retval);
    }
    NS_IMETHOD GetCenter(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CENTER, _retval);
    }
    NS_IMETHOD GetClipHeight(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_HEIGHT, _retval);
    }
    NS_IMETHOD GetClipWidth(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_WIDTH, _retval);
    }
    NS_IMETHOD GetConsole(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_CONSOLE, _retval);
    }
    NS_IMETHOD GetEnableDoubleSize(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_DBLSZ, _retval);
    }
    NS_IMETHOD GetEnableFullScreen(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_FULLSCR, _retval);
    }
    NS_IMETHOD GetEnableOriginalSize(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ENABLEORIGSZ, _retval);
    }
    NS_IMETHOD GetControls(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_CONTROLS, _retval);
    }
    NS_IMETHOD GetOriginalSize(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ORIGSZ, _retval);   
    }
    NS_IMETHOD GetFullScreen(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_FULLSCR, _retval);        
    }
    NS_IMETHOD GetDoubleSize(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_DBLSZ, _retval);        
    }
    NS_IMETHOD GetMaintainAspect(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ASPECT, _retval);
    }
    NS_IMETHOD GetMute(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_MUTE, _retval);    
    }
    NS_IMETHOD GetNoLabels(PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetNumLoop(PRInt32 *_retval)
    {        
        return GetPlayerUINT32Prop(EMBD_PROP_NUMLOOPS, _retval);
    }
    NS_IMETHOD GetShowAbout(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ABOUTDLG, _retval);
    }
    NS_IMETHOD GetShowPreferences(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_PREFSDLG, _retval);
    }
    NS_IMETHOD GetShowStatistics(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_STATSDLG, _retval);
    }
    NS_IMETHOD GetVolume(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_VOLUME, _retval);
    }
    NS_IMETHOD SetCenter(PRBool bIsCentered, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_CENTER, bIsCentered, _retval);
    }
    NS_IMETHOD SetMaintainAspect(PRBool bMaintainAspect, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ASPECT, bMaintainAspect, _retval);
    }
    NS_IMETHOD SetEnableOriginalSize(PRBool bIsEnabled, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ENABLEORIGSZ, bIsEnabled, _retval);
    }
    NS_IMETHOD SetEnableDoubleSize(PRBool bIsEnabled, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ENABLEDBLSZ, bIsEnabled, _retval);
    }
    NS_IMETHOD SetEnableFullScreen(PRBool bIsEnabled, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ENABLEFULLSCR, bIsEnabled, _retval);
    }
    NS_IMETHOD SetDoubleSize(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_DBLSZ, PR_TRUE, _retval);
    }
    NS_IMETHOD SetFullScreen(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_FULLSCR, PR_TRUE, _retval);
    }
    NS_IMETHOD SetOriginalSize(PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ORIGSZ, PR_TRUE, _retval);
    }
    NS_IMETHOD SetNoLogo(PRBool bNoLogo, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_NOLOGO, bNoLogo, _retval);
    }
    NS_IMETHOD GetNoLogo(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_NOLOGO, _retval);    
    }
    NS_IMETHOD SetNumLoop(PRInt32 nNumLoops, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_NUMLOOPS, nNumLoops, _retval);
    }
    NS_IMETHOD SetShowAbout(PRBool bShowAbout, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ABOUTDLG, bShowAbout, _retval);
    }
    NS_IMETHOD SetShowStatistics(PRBool bShowStats, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_STATSDLG, bShowStats, _retval);
    }
    NS_IMETHOD SetWantKeyboardEvents(PRBool bDoesWant, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_KEYEVENTS, bDoesWant, _retval);
    }
    NS_IMETHOD SetWantMouseEvents(PRBool bDoesWant, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_MOUSEEVENTS, bDoesWant, _retval);
    }
    NS_IMETHOD SetWantErrors(PRBool bDoesWant, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_ERROREVENTS, bDoesWant, _retval);
    }
    NS_IMETHOD GetWantKeyboardEvents(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_KEYEVENTS, _retval);
    }
    NS_IMETHOD GetWantMouseEvents(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_MOUSEEVENTS, _retval);
    }
    NS_IMETHOD GetWantErrors(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ERROREVENTS, _retval);
    }
    NS_IMETHOD GetNumEntries(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_NUMENTRIES, _retval);
    }
    NS_IMETHOD GetCurrentEntry(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CURENTRY, _retval);
    }
    NS_IMETHOD GetEntryTitle(PRInt32 nIndex, char **_retval)
    {
        return GetEntryStringProp(EMBD_PROP_ENTRYTITLE, nIndex, _retval);
    }
    NS_IMETHOD GetEntryAuthor(PRInt32 nIndex, char **_retval)
    {
        return GetEntryStringProp(EMBD_PROP_ENTRYAUTHOR, nIndex, _retval);
    }
    NS_IMETHOD GetEntryCopyright(PRInt32 nIndex, char **_retval)
    {
        return GetEntryStringProp(EMBD_PROP_ENTRYCOPY, nIndex, _retval);
    }
    NS_IMETHOD GetEntryAbstract(PRInt32 nIndex, char **_retval)
    {
        return GetEntryStringProp(EMBD_PROP_ENTRYABSTRACT, nIndex, _retval);
    }
    NS_IMETHOD SetCanSeek(PRBool bDoesWantSeek, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_CANSEEK, bDoesWantSeek, _retval);
    }
    NS_IMETHOD GetCanSeek(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CANSEEK, _retval);
    }
    NS_IMETHOD GetBufferingTimeElapsed(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_BUFELAPSED, _retval);
    }
    NS_IMETHOD GetBufferingTimeRemaining(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_BUFREMAINING, _retval);
    }
    NS_IMETHOD GetConnectionBandwidth(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_BWCONN, _retval);
    }
    NS_IMETHOD GetPreferedLanguageID(PRInt32 *_retval)
    {
        // XXXRGG: That's not the way you spell Preferred :(
        return GetPlayerUINT32Prop(EMBD_PROP_LANGID, _retval);
    }
    NS_IMETHOD GetPreferedLanguageString(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_LANGSTR, _retval);
    }
    NS_IMETHOD GetUserCountryID(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_COUNTRYID, _retval);
    }
    NS_IMETHOD GetNumSources(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_NUMSOURCES, _retval);        
    }
    NS_IMETHOD GetSourceTransport(PRInt32 nSourceNum, char **_retval)
    {
        return GetEntryStringProp(EMBD_PROP_SOURCETRANS, nSourceNum, _retval);
    }
    NS_IMETHOD SetVideoState(PRInt32 /* nNewVideoState */, PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetVideoState(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;        
    }
    NS_IMETHOD GetContextMenu(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CONTEXTMENU, _retval); 
    }
    NS_IMETHOD SetContextMenu(PRBool bEnabled, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_CONTEXTMENU, bEnabled,_retval);   
    }
    NS_IMETHOD SetContextMenuItem(PRInt32 /* nItemID */, PRBool /* bEnabled */, PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetContextMenuItem(PRInt32 /* nItemID */, PRBool *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD SetImageStatus(PRBool bEnabled, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_IMAGESTATUS, bEnabled, _retval);
    }
    NS_IMETHOD GetImageStatus(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_IMAGESTATUS, _retval);
    }
    NS_IMETHOD GetLastStatus(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_STATUS, _retval);
    }
    NS_IMETHOD GetLastErrorMoreInfoURL(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_ERRORURL, _retval);
    }
    NS_IMETHOD GetLastErrorUserString(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_ERRORUSERSTR, _retval);
    }
    NS_IMETHOD GetLastErrorUserCode(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ERRORUSERCODE, _retval);
    }
    NS_IMETHOD GetLastErrorRMACode(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ERRORRMACODE, _retval);
    }
    NS_IMETHOD GetLastErrorRMACodeString(char **_retval)
    {
        return GetPlayerStringProp(EMBD_PROP_ERRORRMASTR, _retval);        
    }
    NS_IMETHOD GetLastErrorSeverity(PRInt32 *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_ERRORSEVERITY, _retval);
    }
    NS_IMETHOD GetLastLeftButtonDownTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDownKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDownXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDownYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDownTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDownKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDownXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDownYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonUpTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonUpKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonUpXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonUpYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonUpTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonUpKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonUpXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonUpYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDblTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDblKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDblXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastLeftButtonDblYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDblTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDblKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDblXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastRightButtonDblYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastMouseMoveTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastMouseMoveKeyFlags(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastMouseMoveXPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastMouseMoveYPos(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastKeyDownTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastKeyDownKey(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastKeyUpTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastKeyUpKey(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastKeyPressTimeStamp(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetLastKeyPressKey(PRInt32 *_retval)
    {
        // XXXVD unsupported
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD SetAuthor(const char *szNewAuthor, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_AUTHOR, szNewAuthor, _retval);
    }
    NS_IMETHOD SetTitle(const char *szNewTitle, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_TITLE, szNewTitle, _retval);
    }
    NS_IMETHOD SetCopyright(const char *szNewCopyright, PRBool *_retval)
    {
        return SetPlayerStringProp(EMBD_PROP_COPYRIGHT, szNewCopyright, _retval);
    }
    NS_IMETHOD GetLoop(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_LOOP, _retval);
    }
    NS_IMETHOD SetLoop(PRBool bSetLooping, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_LOOP, bSetLooping, _retval);
    }
    NS_IMETHOD GetIsPlus(PRBool *_retval)
    {
        *_retval = PR_FALSE;
        return NS_OK;
    }
    NS_IMETHOD GetConsoleEvents(PRBool *_retval)
    {
        return GetPlayerUINT32Prop(EMBD_PROP_CONSOLEEVENTS, _retval);
    }
    NS_IMETHOD SetConsoleEvents(PRBool bVal, PRBool *_retval)
    {
        return SetPlayerUINT32Prop(EMBD_PROP_CONSOLEEVENTS, bVal, _retval);
    }
    NS_IMETHOD GetDRMInfo(const char *identifier, char **_retval);
    
    // The following methods implement nsIClassInfo -- it signals the
    // Mozilla Security Manager to allow calls from JavaScript. 
    NS_IMETHOD GetFlags(PRUint32 *aFlags)
    {
        *aFlags = nsIClassInfo::PLUGIN_OBJECT | nsIClassInfo::DOM_OBJECT;
        return NS_OK;
    }
    NS_IMETHOD GetImplementationLanguage(PRUint32 *aImplementationLanguage)
    {
        *aImplementationLanguage = nsIProgrammingLanguage::CPLUSPLUS;
        return NS_OK;
    }
    NS_IMETHOD GetInterfaces(PRUint32 *, nsIID * **)
    {
        return NS_ERROR_NOT_IMPLEMENTED;
    }
    NS_IMETHOD GetHelperForLanguage(PRUint32 , nsISupports **)
    {
        return NS_ERROR_NOT_IMPLEMENTED;
    }
    NS_IMETHOD GetContractID(char **)
    {
        return NS_ERROR_NOT_IMPLEMENTED;
    }
    NS_IMETHOD GetClassDescription(char **)
    {
        return NS_ERROR_NOT_IMPLEMENTED;
    }
    NS_IMETHOD GetClassID(nsCID **)
    {
        return NS_ERROR_NOT_IMPLEMENTED;
    }
    NS_IMETHOD GetClassIDNoAlloc(nsCID *)
    {
        return NS_ERROR_NOT_IMPLEMENTED;
    }

};

#endif
