/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: switchboard.cpp,v 1.1.2.1.2.2 2004/09/18 01:58:13 rggammon Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "switchboard.h"
#include "sysinfo.h"

#include "commonapp.h"

#define SWITCHBOARD "https://player.helixcommunity.org/sitecode/redirect/?"

static void
append_param(GString*           str,
             const gchar*       url_name,
             HXSysInfo*         info,
             HXSysInfoParamType type,
             gboolean           escape)
{
    gchar* raw_val;
    gchar* val;

    raw_val = hx_sys_info_get_param(info, type);
    if(raw_val)
    {
        if(escape)
        {
            val = hxcommon_strdup_and_escape_url(raw_val);
            g_string_append_printf(str, "&%s=%s", url_name, val);
            g_free(val);
        }
        else
        {
            g_string_append_printf(str, "&%s=%s", url_name, raw_val);
        }
        g_free(raw_val);
    }        
}

static void
append_player_information (GString* str, HXSysInfo* info)
{
    append_param(str, "playerVersion", info, HX_SYS_INFO_PLAYER_VERSION, FALSE);
    append_param(str, "playerName",    info, HX_SYS_INFO_PLAYER_NAME,    TRUE);

    append_param(str, "playerDistcode",     info, HX_SYS_INFO_PLAYER_DISTCODE,  TRUE);
    append_param(str, "playerOrigcode",     info, HX_SYS_INFO_PLAYER_ORIGCODE,  TRUE);
}

static void
append_language_information (GString* str, HXSysInfo* info)
{
    append_param(str, "language", info, HX_SYS_INFO_GETTEXT_LANGUAGE, TRUE);
}

static void
append_platform_information (GString* str, HXSysInfo* info)
{
    /* Append misc information that we need to do a proper update,
       potentially to RealPlayer. */

    append_param(str, "operatingSystem",    info, HX_SYS_INFO_OPERATING_SYSTEM, TRUE);
    append_param(str, "kernelVersion",      info, HX_SYS_INFO_KERNEL_VERSION,   TRUE);
    append_param(str, "processorType",      info, HX_SYS_INFO_PROCESSOR_TYPE,   TRUE);

    append_param(str, "lsbVersion",         info, HX_SYS_INFO_LSB_VERSION,           TRUE);
    append_param(str, "distribId",          info, HX_SYS_INFO_DISTRIB_ID,            TRUE);
    append_param(str, "distribRelease",     info, HX_SYS_INFO_DISTRIB_RELEASE,       TRUE);
    append_param(str, "distribDescription", info, HX_SYS_INFO_DISTRIB_DESCRIPTION,   TRUE);
    append_param(str, "distribCodename",    info, HX_SYS_INFO_DISTRIB_CODENAME,      TRUE);

    append_param(str, "gccVersion",         info, HX_SYS_INFO_GCC_VERSION,      TRUE);
}

gchar*
hx_switchboard_get_context_help_url (const gchar* context)
{
    GString* str;
    gchar* val;
    HXSysInfo* info;
        
    info = hx_sys_info_new();
    str = g_string_new(SWITCHBOARD);
    
    val = hxcommon_strdup_and_escape_url(context);
    g_string_append_printf(str, "action=ContextHelp&context=%s", val);
    g_free(val);
    
    append_player_information (str, info);
    append_language_information (str, info);

    hx_sys_info_destroy(info);

    /* return the internal c string, free the GString wrapper */
    return g_string_free(str, FALSE);    
}

gchar*
hx_switchboard_get_error_help_url (guint error_code)
{
    GString* str;
    HXSysInfo* info;
        
    info = hx_sys_info_new();

    str = g_string_new(SWITCHBOARD);

    g_string_append_printf(str, "action=ErrorHelp&error=0x%08x", error_code);
    
    append_player_information (str, info);
    append_language_information (str, info);

    hx_sys_info_destroy(info);

    /* return the internal c string, free the GString wrapper */
    return g_string_free(str, FALSE);        
}

gchar*
hx_switchboard_get_upgrade_url (const gchar* components)
{
    GString* str;
    HXSysInfo* info;
        
    info = hx_sys_info_new();

    str = g_string_new(SWITCHBOARD);

    g_string_append_printf(str, "action=CheckUpdate");
    
    if(components)
    {
        gchar* val;
        
        val = hxcommon_strdup_and_escape_url(components);
        g_string_append_printf(str, "&components=%s", val);
        g_free(val);
    }

    append_player_information (str, info);
    append_language_information (str, info);
    append_platform_information (str, info);

    hx_sys_info_destroy(info);

    /* return the internal c string, free the GString wrapper */
    return g_string_free(str, FALSE);        
}

gchar*
hx_switchboard_get_privacy_url(void)
{
    GString* str;
    HXSysInfo* info;
        
    info = hx_sys_info_new();
    str = g_string_new(SWITCHBOARD);
    
    g_string_append_printf(str, "action=PrivacyPolicy");
    
    append_player_information (str, info);
    append_language_information (str, info);

    hx_sys_info_destroy(info);

    /* return the internal c string, free the GString wrapper */
    return g_string_free(str, FALSE);    
}
