/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: filehdlr.h,v 1.1.26.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef FILEHDLR_H
#define FILEHDLR_H

class CRealPixFileFormat;

class PXFileHandler : public CHXBaseCountingObject,
                      public IHXFileSystemManagerResponse,
                      public IHXFileResponse,
                      public IHXFileStatResponse,
                      public IHXFileMimeMapperResponse,
                      public IHXThreadSafeMethods
{
public:
    PXFileHandler();
    virtual ~PXFileHandler();

    // PXFileHandler methods
    STDMETHOD(Init)                      (THIS_ IUnknown*           pContext,
                                                IHXFileObject*     pRPFileObject,
                                                CRealPixFileFormat* pResponse,
						ULONG32		    ulReadChunkSize = 0);
    STDMETHOD(ReadRPFile)                (THIS);
    STDMETHOD(StatImageFile)             (THIS_ UINT32 ulInstance, IHXBuffer* pImageNameStr);
    STDMETHOD(ReadImageFile)             (THIS_ UINT32 ulInstance, IHXBuffer* pImageNameStr);
    STDMETHOD(Shutdown)                  (THIS);
    STDMETHOD_(UINT32,GetInstanceHandle) (THIS);
    STDMETHOD_(BOOL,IsShutdownDone)      (THIS);           	 

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    // IHXFileSystemManagerResponse methods
    STDMETHOD(InitDone)        (THIS_ HX_RESULT  status);
    STDMETHOD(FileObjectReady) (THIS_ HX_RESULT status, IUnknown* pObject);
    STDMETHOD(DirObjectReady)  (THIS_ HX_RESULT status, IUnknown* pDirObject);

    // IHXFileResponse methods
    //STDMETHOD(InitDone)  (THIS_ HX_RESULT status); // duplicated in IHXFileSystemManagerResponse
    STDMETHOD(CloseDone) (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone)  (THIS_ HX_RESULT status, IHXBuffer* pBuffer);
    STDMETHOD(WriteDone) (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone)  (THIS_ HX_RESULT status);

    // IHXFileStatResponse methods
    STDMETHOD(StatDone) (THIS_ HX_RESULT status, UINT32 ulSize, UINT32 ulCreationTime,
                               UINT32 ulAccessTime, UINT32 ulModificationTime, UINT32 ulMode);

    // IHXThreadSafeMethods methods
    STDMETHOD_(UINT32,IsThreadSafe) (THIS);

    // IHXFileMimeMapperResponse methods
    STDMETHOD(MimeTypeFound) (THIS_ HX_RESULT status, const char* pMimeType);
protected:
    enum
    {
        kStateConstructed,
        kStateError,
        kStateInitialized,
        kStateReadRPFileInit,
        kStateReadRPFileRead,
        kStateReadRPFileHold, // XXXMEH - special finished-reading-but-delayed-closing state
        kStateReadRPFileClose,
        kStateReadRPFileDone,
        kStateStatImageFileFSMInit,
        kStateStatImageFileCreate,
        kStateStatImageFileInit,
        kStateStatImageFileFailClose,
        kStateStatImageFileStat,
        kStateStatImageFileMime,
        kStateStatImageFileClose,
        kStateStatImageFileDone,
        kStateReadImageFileFSMInit,
        kStateReadImageFileCreate,
        kStateReadImageFileInit,
        kStateReadImageFileRead,
        kStateReadImageFileClose,
        kStateReadImageFileDone,
        kStateShutdownClose,
        kStateShutdownDone,
        kRPMinFileReadSize = 2048,
        kImageMinFileReadSize = 2048,
	kRPMaxFileReadSize = 0x000FFFFF,
        kImageMaxFileReadSize = 0x000FFFFF
    };

    INT32                   m_lRefCount;
    IUnknown*               m_pContext;
    IHXFileObject*         m_pRPFileObject;
    CRealPixFileFormat*     m_pResponse;
    IHXCommonClassFactory* m_pCommonClassFactory;
    IHXFileSystemManager*  m_pFileSystemManager;
    IHXFileObject*         m_pFileObject;
    IHXFragmentedBuffer*   m_pFragBuffer;
    IHXBuffer*             m_pImageNameStr;
    IHXBuffer*             m_pImageMimeTypeStr;
    IHXFileStat*           m_pFileStat;
    IHXFileMimeMapper*     m_pFileMimeMapper;
    UINT32                  m_ulState;
    UINT32                  m_ulFileBytesRead;
    UINT32                  m_ulInstance;
    UINT32                  m_ulImageFileSize;
    ULONG32		    m_ulReadChunkSize;

    void                    Reset();
    void                    Deallocate();
    HX_RESULT               CreateImageFile(const char* pszImageName);
};

#endif
