#!/bin/sh

# a simple shell script to walk the directories
# hdup backs up. It then prints out the information
# hdup currently doesn't put in the archive.
# (C) Miek Gieben, licensed under the GPL version 2

# SYNOPSIS
# dirinfo.sh -c config <hostname> 

# TODO
# include/exclude
# .nobackup

get_parameters() {
	# parse a bla = foo contruct and return foo
#	echo $@
	if [[ $@ =~ '(.*) *= *(.*)' ]] 
	then
	#	echo $BASH_REMATCH
	#	echo ${BASH_REMATCH[1]}
	#	echo ${BASH_REMATCH[2]}
		param=${BASH_REMATCH[2]}
	fi
}

printf="%m|%u|%g|%h%p\n"
cflag=
host=
config=/etc/hdup/hdup.conf
while getopts c: arg
do
	case $arg in
	c) 	cflag=1
		config="$OPTARG"
		;;
	?)
		echo "Usage: dirinfo.sh [-c config] hostname"
		exit 1
		;;
	esac;
done
shift $(($OPTIND - 1))

host=$1
if [ -z $host ]; then
	echo "Usage: dirinfo.sh [-c config] hostname"
	exit 1
fi

# retrieve the archive dir
date=`date +%Y-%m-%d`	 # americon/iso/etc todo
archivedir=
dir=
datespec=
hostflag=
while read line 
do
	[[ $line =~ '^\#' ]] && continue

	get_parameters $line

	# archive dir
	if [[ $line =~ '^archive dir' ]] 
	then
		archivedir=${param}
	fi
	# date spec
	if [[ $line =~ '^date spec' ]] 
	then
		datespec=${param}
	fi

	# host statement
	if [[ $line =~ "\[$host\]" ]]
	then 
		hostflag=1
	fi

	# check for another host statement
	if [[ $line =~ "\[.*\]" ]]
	then 
		if [[ ! $line =~ "\[$host\]" ]]
		then
			hostflag=
		fi
	fi

	if [[ $line =~ '^dir' ]] && [ ! -z $hostflag ]
	then 
		#echo $host found!
		dir=${param}
	fi

done < $config

# no double slashes logic here...
dirinfofile="$archivedir/$host/$date/$date.dirinfo"
if [ -z $dir ] 
then
	echo "Host $host not found in config file."
	exit 1
fi

if [ -z $archivedir ] 
then
	echo "Archivedir not found in config file."
	exit 1
fi

#echo $archivedir
#echo $dir
dir="/var/www /home/miek/bin"

echo "Compiling into....: $dirinfofile"
rm -f $dirinfofile
for i in $dir
do
	echo "Adding............: $i"
	`find $i -type d -printf $printf >> $dirinfofile`
done
