c testgrid.f
c In this program we create, define and write a simple grid hdfeos file
c using the grid interface
c

      program testgrid
      
      integer*4		index1
      integer*4		index2
      integer*4		dimsizes(2)
      real*4		ray3(250)
      real*4		utmray(60,80), georay(60,80)
      real*4		utmcnt, geocnt
      real*4		fillvalue, ifillv
      real*4		raycnt, ray3cnt
      real*4		tempray(60,80)
      real*4		datbuf(4800)
      
      integer   	status
      integer*4		lstatus, n, one
      integer*4 	gdfid, gdfid2, gdid_utm, gdid2
      integer*4 	zonecode
      integer*4		attr(4), iattr(4)
      integer*4 	spherecode, xdim, ydim, zero
      integer*4		tmpvar1, nt, rk, size, tmpvar2
      integer*4 	start(2)
      integer*4 	stride(2)
      integer*4 	edge(2)
      integer*4 	start1d(1), stride1d(1), edge1d(1)
      real*8		projparm(16), uplft(2), lowrgt(2), pparm(16)
      real*8		iuplft(2), ilrgt(2)

      integer*4		lat(40,50)
      integer*4		latcnt
      integer*4		lon(40,50)
      integer*4		loncnt

      integer   	gddefproj, gddefdim, gddeffld, gddetach 
      integer		gdclose, gdgetfill, gdreginfo
      integer   	gdwrfld, gdwrattr, gdsetfill, gddeforigin
      integer		gdgridinfo, gdprojinfo,gdfldinfo
      integer		gdrdfld, gddefpreg,gdrdattr, gdextreg
      integer		gdattrinfo, gdwrmeta
      integer*4 	gdopen, gdcreate, gdattach, gdinqgrid
      integer*4		gdinqdims, gddiminfo, gdinqflds
      integer*4		gdnentries, gdinqattrs, gddefboxreg
      integer*4		gdorginfo, gdpreginfo

      integer*4		strbufsize, pcode,nflds
      integer		zcode, scode
      character*80	grdnames, dimname, fldlist, attrlist
      integer*4		dims(8), rnk(8), numtype(8)
      real*8		upleftpt(2), lowrtpt(2),corlon(2),corlat(2)
      integer*4		xdimsize, ydimsize, regionid
      
      integer DFACC_CREATE
      parameter (DFACC_CREATE=4)
      integer DFACC_RDWR
      parameter (DFACC_RDWR=3)
      integer DFACC_READ
      parameter (DFACC_READ=1)      
      integer GCTP_UTM
      parameter (GCTP_UTM=1)

      integer DFNT_FLOAT32
      parameter (DFNT_FLOAT32=5)
      integer DFNT_INT32
      parameter (DFNT_INT32=24)      
      
      integer HDFE_NOMERGE
      parameter (HDFE_NOMERGE=0)
      integer HDFE_AUTOMERGE
      parameter (HDFE_AUTOMERGE=1)
      
      integer HDFE_CORNER
      parameter (HDFE_CORNER=1)
      integer HDFE_GD_UL
      parameter (HDFE_GD_UL=0)
      integer HDFE_NENTDIM
      parameter(HDFE_NENTDIM=0)
      integer HDFE_NENTDFLD
      parameter (HDFE_NENTDFLD=4)

      index1 = 0
      index2 = 0
      dimsizes(1) = 40
      dimsizes(2) = 100
      fillvalue = 1996.0
      raycnt = -799.0
      ray3cnt = -19.5
      attr(1) = 11
      attr(2) = 33
      attr(3) = 66
      attr(4) = 99
      utmcnt=-799.0
      geocnt=2001.0

      latcnt = 38.0
      loncnt = 78.0
      zero = 0
      one = 1
      
c
c This section of the program just fills some arrays with data that we will
c use later in the program
c
      do 70 index1=1,60
         do 80 index2=1,80
            utmray(index2,index1) = utmcnt
            georay(index2,index1) = geocnt
            utmcnt = utmcnt + .4
            geocnt = geocnt + .2
 80      continue
 70   continue
  
      
      do 30 index1=1,250
            ray3(index1) = ray3cnt
            ray3cnt = ray3cnt + .1
 30   continue
      

      do 50 index1=1,50
         do 60 index2=1,40      
            lat(index2,index1) = latcnt
            lon(index2,index1) = loncnt
            loncnt = loncnt - 0.1
 60      continue
         latcnt = latcnt + 0.1
         loncnt = 78.0
 50   continue
      

      open(unit=10, file='testgrid_f.txtout')

      write(*,*)'Testing Grid FORTRAN 77 interface '
      write(*,*)'=================================='
      write(10,*)'Testing Grid FORTRAN 77 interface '
      write(10,*)'=================================='
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdopen
c
      write(10,*)'Testing gdopen... '
      write(10,*)'=================='
      write(*,*)'Testing gdopen... '
      write(*,*)'=================='
      gdfid2 = gdopen("Gridf_Test2.hdf", DFACC_READ)
      write(10,*)'gdfid2 = gdopen("Gridf_Test2.hdf", DFACC_READ)'
      write(10,*)'********Error Expected************'
      write(10,*)'Value returned by gdopen ', gdfid2
      write(*,*)'gdfid2 = gdopen("Gridf_Test2.hdf", DFACC_READ)'
      write(*,*)'********Error Expected************'
      write(*,*)'Value returned by gdopen ', gdfid2
      if(gdfid2 .le. zero) call heprnt(0)

      write(*,*)'Opening file Gridf_Test.hdf'
      write(10,*)'Opening file Gridf_Test.hdf'
      gdfid = gdopen('Gridf_Test.hdf', DFACC_CREATE)
      write(10,*) 'gdfid = gdopen("Gridf_Test.hdf", DFACC_CREATE)'
      write(10,*) 'File id returned from gdopen ', gdfid
      write(*,*) 'gdfid = gdopen("Gridf_Test.hdf", DFACC_CREATE)'
      write(*,*) 'File id returned from gdopen ', gdfid
      write(10,*)' '
      write(*,*)' '


c Test Case -- gdcreate
c
      write(10,27)
      write(10,*)'Testing gdcreate... '
      write(10,*)'=================='
      write(*,*)'Testing gdcreate... '
      write(*,*)'=================='

      xdim = 60
      ydim = 80
      uplft(1) = 353299.39125
      uplft(2) = -7100284.64348
      lowrgt(1) = 603434.52148
      lowrgt(2) = -7991341.17870

      gdid2 = gdcreate(gdfid2, 'UTMGrid2', xdim, ydim, uplft, lowrgt)
      write(10,*) 'Create UTMGrid2'
      write(10,*) 'Value returned by gdcreate ', gdid2
      write(*,*) 'Create UTMGrid2'
      write(*,*) 'Value returned by gdcreate ', gdid2
      if(gdid2 .le. zero) call heprnt(0)
    
      write(10,*)'Creating UTMGrid'
      write(*,*)'Creating UTMGrid'
      gdid_utm = gdcreate(gdfid, 'UTMGrid', xdim, ydim, uplft, lowrgt)
      write(*,*)'gdid_utm = gdcreate(gdfid, "UTMGrid", xdim,
     1ydim, uplft, lowrgt)'
      write(10,*)'gdid_utm = gdcreate(gdfid, "UTMGrid", xdim,
     1ydim, uplft, lowrgt)'
      write(10,*)'UTM grid id returned from gdcreate ', gdid_utm
      write(*,*)'UTM grid id returned from gdcreate ', gdid_utm
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddefproj
c
      write(10,27)
      write(10,*)'Testing gddefproj... '
      write(10,*)'=================='
      write(*,*)'Testing gddefproj... '
      write(*,*)'=================='

      zonecode = 10
      spherecode = 0

      do 120 index1=1,16
         projparm(index1)=0
 120  continue
  
      write(10,*)'Defining UTM projection'
      write(*,*)'Defining UTM projection'
      status = gddefproj(gdid_utm, GCTP_UTM, zonecode, 
     1spherecode, projparm)
      write(*,*)'status = gddefproj(gdid_utm, GCTP_UTM, zonecode,
     1spherecode, projparm)'
      write(10,*)'status = gddefproj(gdid_utm, GCTP_UTM, zonecode,
     1spherecode, projparm)'
      write(10,*)'Returned value from gddefproj ', status
      write(*,*)'Returned value from gddefproj ', status

      status = gddefproj(gdid2,GCTP_UTM,zonecode,spherecode,projparm)
      write(10,*)'Defining UTM'
      write(10,*)'Value returned by gddefproj ', status
      write(*,*)'Defining UTM'
      write(*,*)'Value returned by gddefproj ', status
      if(status .lt. zero) call heprnt(0)
      write(10,*)' '
      write(*,*)' '


c Test Case -- gddefpreg
c
      write(10,27)
      write(10,*)'Testing gddefpreg... '
      write(10,*)'=================='
      write(*,*)'Testing gddefpreg... '
      write(*,*)'=================='
      status = gddefpreg(gdid_utm, HDFE_CORNER)
      write(10,*)'Returned from gddefpreg ', status
      write(*,*)'Returned from gddefpreg ', status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddeforigin
c
      write(10,27)
      write(10,*)'Testing gddeforigin... '
      write(10,*)'=================='
      write(*,*)'Testing gddeforigin... '
      write(*,*)'=================='
      status = gddeforigin(gdid_utm, HDFE_GD_UL)
      write(*,*)'status = gddeforigin(gdid_utm, HDFE_GD_UL)'
      write(*,*)'Value of status from gddeforigin ',status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddefdim
c
      write(10,27)
      write(10,*)'Testing gddefdim... '
      write(10,*)'=================='
      write(*,*)'Testing gddefdim... '
      write(*,*)'=================='
      status = gddefdim(gdid2, 'TestDim1', 40)
      write(10,*)'status = gddefdim(gdid2, "TestDim1", 40)'
      write(10,*)'Value returned by gddefdim ', status
      write(*,*)'status = gddefdim(gdid2, "TestDim1", 40)'
      write(*,*)'Value returned by gddefdim ', status
      if(status .lt. zero) call heprnt(0)

      status = gddefdim(gdid2, 'TestDim2', 25)
      write(10,*)'status = gddefdim(gdid2, "TestDim2", 25)'
      write(10,*)'Value returned by gddefdim ', status
      write(*,*)'status = gddefdim(gdid2, "TestDim2", 25)'
      write(*,*)'Value returned by gddefdim ', status
      if(status .lt. zero) call      heprnt(0)


      status = gddefdim(gdid_utm, 'Conduction', 250)
      write(10,*)'status = gddefdim(gdid_utm, "Conduction", 250)'
      write(10,*)'Returned value from gddefdim ', status
      write(*,*)'status = gddefdim(gdid_utm, "Conduction", 250)'
      write(*,*)'Returned value from gddefdim ', status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddetach
c
      write(10,27)
      write(10,*)'Testing gddetach... '
      write(10,*)'=================='
      write(*,*)'Testing gddetach... '
      write(*,*)'=================='
      status = gddetach(gdid2)
      write(10,*)'status = gddetach(gdid2)'
      write(10,*)'Value returned by gddetach ', status
      write(*,*)'status = gddetach(gdid2)'
      write(*,*)'Value returned by gddetach ', status

      status = gddetach(gdid_utm)
      write(10,*)'status = gddetach(gdid_utm)'
      write(10,*)'Returned value from gddetach ', status
      write(*,*)'status = gddetach(gdid_utm)'
      write(*,*)'Returned value from gddetach ', status
      write(10,*)' '
      write(*,*)' '
 
c Test Case -- gdattach
c
      write(10,27)
      write(10,*)'Testing gdattach... '
      write(10,*)'=================='
      write(*,*)'Testing gdattach... '
      write(*,*)'=================='
      gdid_utm = gdattach(gdfid, 'UTMGrid')
      write(10,*)'gdid_utm = gdattach(gdfid, "UTMGrid")'
      write(10,*)'Handle returned from gdattach ', gdid_utm
      write(*,*)'gdid_utm = gdattach(gdfid, "UTMGrid")'
      write(*,*)'Handle returned from gdattach ', gdid_utm

      gdid2 = gdattach(gdfid2, 'UTMGrid2')
      write(10,*)'gdid2 = gdattach(gdfid2, "UTMGrid2")'
      write(10,*)'Value returned by gdattach ', status
      write(*,*)'gdid2 = gdattach(gdfid2, "UTMGrid2")'
      write(*,*)'Value returned by gdattach ', status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddeffld
c
      write(10,27)
      write(10,*)'Testing gddeffld... '
      write(10,*)'=================='
      write(*,*)'Testing gddeffld... '
      write(*,*)'=================='

      status = gddeffld(gdid2, 'tempfield', 'TestDim2,TestDim1', 
     1 DFNT_FLOAT32, HDFE_NOMERGE)
      write(10,*)'Define: "tempfield"'
      write(10,*)'Value returned by gddeffld ', status
      write(*,*)'Define: "tempfield"'
      write(*,*)'Value returned by gddeffld ', status
      if(status .lt. zero) call heprnt(0)


      status = gddeffld(gdid_utm,'Voltage','XDim,YDim',
     1DFNT_FLOAT32,HDFE_AUTOMERGE)
      if(status .lt. zero) call heprnt(0)
      write(10,*)'Define: "Voltage"'
      write(10,*)'Value returned from gddeffld ', status
      write(*,*)'Define: "Voltage"'
      write(*,*)'Value returned from gddeffld ', status

      status = gddeffld(gdid_utm, 'Drift', 'XDim,YDim',DFNT_FLOAT32,
     1HDFE_AUTOMERGE)
      if(status .lt. zero) call heprnt(0)
      write(10,*)'Define: "Drift"'      
      write(10,*)'Value returned from gddeffld ', status
      write(*,*)'Define: "Drift"'      
      write(*,*)'Value returned from gddeffld ', status

      status = gddeffld(gdid_utm, 'Impedance', 'XDim,YDim', 
     1DFNT_FLOAT32,HDFE_AUTOMERGE)
      if(status .lt. zero) call heprnt(0)
      write(10,*)'Define: "Impedance"'            
      write(10,*)'Value returned from gddeffld ', status
      write(*,*)'Define: "Impedance"'            
      write(*,*)'Value returned from gddeffld ', status

      status = gddeffld(gdid_utm, 'Grounding', 'Conduction', 
     1DFNT_FLOAT32, HDFE_NOMERGE)
      write(10,*)'Define: "Grounding"'                  
      write(10,*)'Value returned by gddeffld ', status
      write(*,*)'Define: "Grounding"'                  
      write(*,*)'Value returned by gddeffld ', status
      call heprnt(0)
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdwrmeta
c
      write(10,27)
      write(10,*)'Testing gdwrmeta... '
      write(10,*)'=================='
      write(*,*)'Testing gdwrmeta... '
      write(*,*)'=================='

      status = gdwrmeta(gdid_utm, 'Extern',
     1'XDim,YDim',DFNT_FLOAT32)
      write(*,*)'Value returned by gdwrmeta ',status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdsetfill
c
      write(10,27)
      write(10,*)'Testing gdsetfill... '
      write(10,*)'=================='
      write(*,*)'Testing gdsetfill... '
      write(*,*)'=================='

      status = gdsetfill(gdid_utm, 'Voltage', fillvalue)
      write(10,*)'Testing gdsetfill'
      write(10,*)'Returned from gdsetfill ', status
      write(*,*)'Testing gdsetfill'
      write(*,*)'Returned from gdsetfill ', status
      write(10,*)' '
      write(*,*)' '

      status = gddetach(gdid_utm)
      write(10,*)'status = gddetach(gdid_utm)'
      write(*,*)'status = gddetach(gdid_utm)'
      if(status .lt. zero) call heprnt(0)
      write(10,*)'Returned value from gddetach ', status
      write(*,*)'Returned value from gddetach ', status
      write(10,*)' '
      write(*,*)' '

      gdid_utm = gdattach(gdfid, 'UTMGrid')
      write(10,*)'gdid_utm = gdattach(gdfid, "UTMGrid")'
      write(10,*)'Handle returned from gdattach ', gdid_utm
      write(*,*)'gdid_utm = gdattach(gdfid, "UTMGrid")'
      write(*,*)'Handle returned from gdattach ', gdid_utm
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdwrfld
c
      write(10,27)
      write(10,*)'Testing gdwrfld... '
      write(10,*)'=================='
      write(*,*)'Testing gdwrfld... '
      write(*,*)'=================='

      start(1) = 10
      start(2) = 10
      stride(1) = 1
      stride(2) = 1
      edge(1) = 10
      edge(2) = 10
      
      status = gdwrfld(gdid_utm, 'Voltage', start, stride, edge, utmray)
      write(10,*)
     1'status=gdwrfld(gdid_utm,"Voltage",start,stride,edge,utmray)'
      write(10,*)'Value returned by gdwrietfield ', status
      write(*,*)
     1'status=gdwrfld(gdid_utm,"Voltage",start,stride,edge,utmray)'
      write(*,*)'Value returned by gdwrietfield ', status


      start(1) = 0
      start(2) = 0
      edge(1) = 60
      edge(2) = 80
      status = gdwrfld(gdid_utm, 'Drift', start,stride,edge,utmray)
      write(10,*)
     1'status = gdwrfld(gdid_utm, "Drift", start,stride,edge,utmray)'
      write(10,*)'Returned from gdwrfld ', status
      write(*,*)
     1'status = gdwrfld(gdid_utm, "Drift", start,stride,edge,utmray)'
      write(*,*)'Returned from gdwrfld ', status

      status = gdwrfld(gdid_utm, 'Impedance', start,stride,edge,utmray)
      write(10,*) 
     1'status=gdwrfld(gdid_utm,"Impedance",start,stride,edge,utmray)'
      write(10,*)'Returned from gdwrfld ', status
      write(*,*) 
     1'status=gdwrfld(gdid_utm,"Impedance",start,stride,edge,utmray)'
      write(*,*)'Returned from gdwrfld ', status

      start1d(1)=0
      stride1d(1)=1
      edge1d(1)=250
      status=gdwrfld(gdid_utm,'Grounding',start1d,stride1d,edge1d,ray3)
      call heprnt(0)
      write(10,*)'status=gdwrfld(gdid_utm,"Grounding",start1d,
     1stride1d,edge1d,ray3)'
      write(10,*)'Value returned by gdwrfld ', status
      write(*,*)'status=gdwrfld(gdid_utm,"Grounding",start1d,
     1stride1d,edge1d,ray3)'
      write(*,*)'Value returned by gdwrfld ', status
      write(10,*)' '
      write(*,*)' '


c Test Case -- gdwrattr
c
      write(10,27)
      write(10,*)'Testing gdwrattr... '
      write(10,*)'=================='
      write(*,*)'Testing gdwrattr... '
      write(*,*)'=================='

      status = gdwrattr(gdid_utm, 'Resistance', DFNT_INT32, 4, attr)
      write(10,*)
     1'status = gdwrattr(gdid_utm, "Resistance", DFNT_INT32, 4, attr)'
      write(10,*)'Returned from gdwrattr ', status
      write(*,*)
     1'status = gdwrattr(gdid_utm, "Resistance", DFNT_INT32, 4, attr)'
      write(*,*)'Returned from gdwrattr ', status

      status = gddetach(gdid_utm)
      write(10,*)'status = gddetach(gdid_utm)'
      write(10,*)'Returned from gddetach ', status
      write(*,*)'status = gddetach(gdid_utm)'
      write(*,*)'Returned from gddetach ', status

      status = gddetach(gdid2)
      write(10,*)'status = gddetach(gdid2)'
      write(10,*)'Value returned by gddetach ', status
      write(*,*)'status = gddetach(gdid2)'
      write(*,*)'Value returned by gddetach ', status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdclose
c
      write(10,27)
      write(10,*)'Testing gdclose... '
      write(10,*)'=================='
      write(*,*)'Testing gdclose... '
      write(*,*)'=================='

      status = gdclose(gdfid2)
      write(10,*)'status = gdclose(gdfid2)'
      write(10,*)'Value returned by gdclose ', status
      write(*,*)'status = gdclose(gdfid2)'
      write(*,*)'Value returned by gdclose ', status
      if(status .lt. zero) call heprnt(0)

      status = gdclose(gdfid)
      write(10,*)'status = gdclose(gdfid)'
      write(10,*)'Returned from gdclose ', status
      write(*,*)'status = gdclose(gdfid)'
      write(*,*)'Returned from gdclose ', status
      write(10,*)' '
      write(*,*)' '

      
      gdfid = gdopen('Gridf_Test.hdf', DFACC_RDWR)
      write(*,*)'gdfid = gdopen("Gridf_Test.hdf", DFACC_RDWR)'
      write(10,*)'gdfid = gdopen("Gridf_Test.hdf", DFACC_RDWR)'
      write(*,*)'Grid file id returned by gdopen ',gdfid
      write(10,*)'Grid file id returned by gdopen ',gdfid

      gdid_utm = gdattach(gdfid, 'UTMGrid')
      write(*,*)'gdid_utm = gdattach(gdfid, "UTMGrid")'
      write(10,*)'gdid_utm = gdattach(gdfid, "UTMGrid")'
      write(*,*)'Grid id returned by gdattach ',gdid_utm
      write(10,*)'Grid id returned by gdattach ',gdid_utm
      write(*,*)' '

c Test Case -- gdinqgrid
c
      write(10,27)
      write(10,*)'Testing gdinqgrid... '
      write(10,*)'=================='
      write(*,*)'Testing gdinqgrid... '
      write(*,*)'=================='

      lstatus = gdinqgrid('Gridf_Test.hdf',grdnames,strbufsize)
      write(*,*)'Names of grids ',grdnames
      write(*,*)'Number of grids ',lstatus
      write(*,*)'Size of names of grids ',strbufsize
      write(10,*)'Names of grids ',grdnames
      write(10,*)'Number of grids ',lstatus
      write(10,*)'Size of names of grids ',strbufsize
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdorginfo
c
      write(10,27)
      write(10,*)'Testing gdorginfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdorginfo... '
      write(*,*)'=================='

      lstatus = gdorginfo(gdid_utm, tmpvar1)
      write(*,*)'lstatus = gdorginfo(gdid_utm, tmpvar1)'
      write(10,*)'lstatus = gdorginfo(gdid_utm, tmpvar1)'
      write(*,*)'Value returned by gdorginfo ',lstatus
      write(10,*)'Value returned by gdorginfo ',lstatus
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdpreginfo
c
      write(10,27)
      write(10,*)'Testing gdpreginfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdpreginfo... '
      write(*,*)'=================='

      lstatus = gdpreginfo(gdid_utm, tmpvar1)
      write(*,*)'lstatus = gdpreginfo(gdid_utm, tmpvar1)'
      write(10,*)'lstatus = gdpreginfo(gdid_utm, tmpvar1)'
      write(*,*)'Value returned by gdpreginfo ',lstatus
      write(10,*)'Value returned by gdpreginfo ',lstatus
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdinqdims
c
      write(10,27)
      write(10,*)'Testing gdinqdims... '
      write(10,*)'=================='
      write(*,*)'Testing gdinqdims... '
      write(*,*)'=================='

      lstatus = gdinqdims(gdid_utm, dimname, dims)
      write(*,*)'lstatus = gdinqdims(gdid_utm, dimname, dims)'
      write(*,*)'Number of dimensions ',lstatus
      write(*,*)'Dimensions in grid UTM ',dimname
      write(*,*)'Size of dimensions '
      write(10,*)'lstatus = gdinqdims(gdid_utm, dimname, dims)'
      write(10,*)'Number of dimensions ',lstatus
      write(10,*)'Dimensions in grid UTM ',dimname
      write(10,*)'Size of dimensions '
      do 130 i=1,lstatus
         write(*,*)' ',dims(i)
         write(10,*)' ',dims(i)
 130  continue
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddiminfo
c
      write(10,27)
      write(10,*)'Testing gddiminfo... '
      write(10,*)'=================='
      write(*,*)'Testing gddiminfo... '
      write(*,*)'=================='

      lstatus = gddiminfo(gdid_utm, 'Conduction')
      write(*,*)'lstatus = gddiminfo(gdid_utm, "Conduction")'
      write(*,*)'Size of dimension Conduction ',lstatus
      write(10,*)'lstatus = gddiminfo(gdid_utm, "Conduction")'
      write(10,*)'Size of dimension Conduction ',lstatus
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdgridinfo
c
      write(10,27)
      write(10,*)'Testing gdgridinfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdgridinfo... '
      write(*,*)'=================='

      status = gdgridinfo(gdid_utm,xdimsize,ydimsize,upleftpt,lowrtpt)
      write(*,*)'status = gdgridinfo(gdid_utm,xdimsize,ydimsize,
     1upleftpt,lowrtpt)'
      write(*,*)'Value returned by gdgridinfo ',status
      write(*,*)'X dim size ',xdimsize, ' Y dim size ',ydimsize
      write(*,*)'Upper left pt ',upleftpt(1),upleftpt(2)
      write(*,*)'Lower right pt ',lowrtpt(1),lowrtpt(2)
      write(10,*)'status = gdgridinfo(gdid_utm,xdimsize,ydimsize,
     1upleftpt,lowrtpt)'
      write(10,*)'Value returned by gdgridinfo ',status
      write(10,*)'X dim size ',xdimsize, ' Y dim size ',ydimsize
      write(10,*)'Upper left pt ',upleftpt(1),upleftpt(2)
      write(10,*)'Lower right pt ',lowrtpt(1),lowrtpt(2)
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdprojinfo
c
      write(10,27)
      write(10,*)'Testing gdprojinfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdprojinfo... '
      write(*,*)'=================='

      status = gdprojinfo(gdid_utm,pcode,zcode,scode,pparm)
      write(*,*)'status = gdprojinfo(gdid_utm,pcode,
     1zcode,scode,pparm)'
      write(*,*)'Value returned by gdprojinfo ',status
      write(*,*)'Projection code ',pcode, ' Zone code ',zcode
      write(*,*)'Sphere code ',scode
      write(10,*)'status = gdprojinfo(gdid_utm,pcode,
     1zcode,scode,pparm)'
      write(10,*)'Value returned by gdprojinfo ',status
      write(10,*)'Projection code ',pcode, ' Zone code ',zcode
      write(10,*)'Sphere code ',scode
      do 140 i=1,16
         write(*,*)' ',pparm(i)
         write(10,*)' ',pparm(i)
 140  continue
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdinqflds
c
      write(10,27)
      write(10,*)'Testing gdinqflds... '
      write(10,*)'=================='
      write(*,*)'Testing gdinqflds... '
      write(*,*)'=================='

      nflds = gdinqflds(gdid_utm,fldlist,rnk,numtype)
      write(*,*)'nflds = gdinqflds(gdid_utm,fldlist,rnk,numtype)'
      write(*,*)'Number of fields ',nflds
      write(10,*)'nflds = gdinqflds(gdid_utm,fldlist,rnk,numtype)'
      write(10,*)'Number of fields ',nflds
      if (nflds .ne. 0) then
         write(*,*)'Fields ',fldlist
         write(10,*)'Fields ',fldlist
         do 150 i=1,nflds
            write(*,*)'Rank and type ',rnk(i), ' ', numtype(i)
            write(10,*)'Rank and type ',rnk(i), ' ', numtype(i)
  150    continue
      end if
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdfldinfo
c
      write(10,27)
      write(10,*)'Testing gdfldinfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdfldinfo... '
      write(*,*)'=================='

      status = gdfldinfo(gdid_utm,'Drift',rnk,dims,
     1numtype,dimname)
      write(*,*)'status = gdfldinfo(gdid_utm,"Drift",rnk,dims,
     1numtype,dimname)'
      write(*,*)'Value returned by gdfldinfo for field Drift ',status
      write(*,*)'Drift rank ',rnk(1)
      write(10,*)'status = gdfldinfo(gdid_utm,"Drift",rnk,dims,
     1numtype,dimname)'
      write(10,*)'Value returned by gdfldinfo for field Drift ',status
      write(10,*)'Drift rank ',rnk(1)
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdrdfld
c
      write(10,27)
      write(10,*)'Testing gdrdfld... '
      write(10,*)'=================='
      write(*,*)'Testing gdrdfld... '
      write(*,*)'=================='

      start(1) = 0
      start(2) = 0
      stride(1) = 1
      stride(2) = 1
      edge(1) = 60
      edge(2) = 80
      status = gdrdfld(gdid_utm,'Drift',start,stride,edge,tempray)
      write(*,*)'status = gdrdfld(gdid_utm,"Drift",start,stride,
     1edge,tempray)'
      write(*,*)'Value returned by gdrdfld ',status
      write(10,*)'status = gdrdfld(gdid_utm,"Drift",start,stride,
     1edge,tempray)'
      write(10,*)'Value returned by gdrdfld ',status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdnentries
c
      write(10,27)
      write(10,*)'Testing gdnentries... '
      write(10,*)'=================='
      write(*,*)'Testing gdnentries... '
      write(*,*)'=================='

      n = gdnentries(gdid_utm, HDFE_NENTDIM, strbufsize)
      write(*,*)'n = gdnentries(gdid_utm, HDFE_NENTDIM, strbufsize)'
      write(*,*)'Number of dimensions ', n
      write(*,*)'Dimension ',strbufsize
      write(10,*)'n = gdnentries(gdid_utm, HDFE_NENTDIM, strbufsize)'
      write(10,*)'Number of dimensions ', n
      write(10,*)'Dimension ',strbufsize

      n = gdnentries(gdid_utm,HDFE_NENTDFLD,strbufsize)
      write(*,*)'n = gdnentries(gdid_utm,HDFE_NENTDFLD,strbufsize)'
      write(*,*)'Number of data fields ',n
      write(10,*)'n = gdnentries(gdid_utm,HDFE_NENTDFLD,strbufsize)'
      write(10,*)'Number of data fields ',n
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdattrinfo
c
      write(10,27)
      write(10,*)'Testing gdattrinfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdattrinfo... '
      write(*,*)'=================='

      status = gdattrinfo(gdid_utm,'Resistance',tmpvar1,
     1tmpvar2)
      write(*,*)'status = gdattrinfo(gdid_utm,"Resistance",tmpvar1,
     1tmpvar2)'
      write(*,*)'Value returned by gdattrinfo ',status
      write(10,*)'status = gdattrinfo(gdid_utm,"Resistance",tmpvar1,
     1tmpvar2)'
      write(10,*)'Value returned by gdattrinfo ',status
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdrdattr
c
      write(10,27)
      write(10,*)'Testing gdrdattr... '
      write(10,*)'=================='
      write(*,*)'Testing gdrdattr... '
      write(*,*)'=================='

      status = gdrdattr(gdid_utm,'Resistance',iattr)
      write(*,*)'status = gdrdattr(gdid_utm,"Resistance",iattr)'
      write(*,*)'Value returned by gdrdattr ',status
      write(10,*)'status = gdrdattr(gdid_utm,"Resistance",iattr)'
      write(10,*)'Value returned by gdrdattr ',status
      write(10,*)' '
      write(*,*)' '
  
c Test Case -- gdinqattrs
c
      write(10,27)
      write(10,*)'Testing gdinqattrs... '
      write(10,*)'=================='
      write(*,*)'Testing gdinqattrs... '
      write(*,*)'=================='

      lstatus = gdinqattrs(gdid_utm, attrlist,tmpvar1)
      write(*,*)'lstatus = gdinqattrs(gdid_utm, attrlist,tmpvar1)'
      write(*,*)'Value returned by gdinqattrs ',lstatus
      write(*,*)'List of attributes ',attrlist
      write(10,*)'lstatus = gdinqattrs(gdid_utm, attrlist,tmpvar1)'
      write(10,*)'Value returned by gdinqattrs ',lstatus
      write(10,*)'List of attributes ',attrlist
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdgetfill
c
      write(10,27)
      write(10,*)'Testing gdgetfill... '
      write(10,*)'=================='
      write(*,*)'Testing gdgetfill... '
      write(*,*)'=================='

      status = gdgetfill(gdid_utm,'Voltage',ifillv)
      write(*,*)'status = gdgetfill(gdid_utm,"Voltage",ifillv)'
      write(*,*)'Value returned by gdgetfill ',status
      write(*,*)'Fill value ',ifillv
      write(10,*)'status = gdgetfill(gdid_utm,"Voltage",ifillv)'
      write(10,*)'Value returned by gdgetfill ',status
      write(10,*)'Fill value ',ifillv
      write(10,*)' '
      write(*,*)' '

c Test Case -- gddefboxreg
c
      write(10,27)
      write(10,*)'Testing gddefboxreg... '
      write(10,*)'=================='
      write(*,*)'Testing gddefboxreg... '
      write(*,*)'=================='

      corlon(1)=-126.0
      corlon(2)=-121.5
      corlat(1)=-70.0
      corlat(2)=-65.0

      regionid = gddefboxreg(gdid_utm,corlon,corlat)
      write(*,*)'regionid = gddefboxreg(gdid_utm,corlon,corlat)'
      write(*,*)'Region id returned by gddefboxreg ',regionid
      write(10,*)'regionid = gddefboxreg(gdid_utm,corlon,corlat)'
      write(10,*)'Region id returned by gddefboxreg ',regionid
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdreginfo
c
      write(10,27)
      write(10,*)'Testing gdreginfo... '
      write(10,*)'=================='
      write(*,*)'Testing gdreginfo... '
      write(*,*)'=================='

      status = gdreginfo(gdid_utm,regionid,'Impedance',nt,
     1rk,dims,size,iuplft,ilrgt)
      write(*,*)'status = gdreginfo(gdid_utm,regionid,"Impedance",nt,
     1rk,dims,size,iuplft,ilrgt)'
      write(*,*)'Value returned by gdreginfo ',status
      write(*,*)'Number type of region ',nt
      write(*,*)'Rank of region ',rk
      write(*,*)'Size of region ',size
      write(*,*)'Dimensions of region',dims(1),' ',dims(2)
      write(*,*)'Upper left point of region ',iuplft(1),' ',iuplft(2)
      write(*,*)'Lower right point of region ',ilrgt(1),' ',ilrgt(2)
      write(10,*)'status = gdreginfo(gdid_utm,regionid,"Impedance",nt,
     1rk,dims,size,iuplft,ilrgt)'
      write(10,*)'Value returned by gdreginfo ',status
      write(10,*)'Number type of region ',nt
      write(10,*)'Rank of region ',rk
      write(10,*)'Size of region ',size
      write(10,*)'Dimensions of region',dims(1),' ',dims(2)
      write(10,*)'Upper left point of region ',iuplft(1),' ',iuplft(2)
      write(10,*)'Lower right point of region ',ilrgt(1),' ',ilrgt(2)
      write(10,*)' '
      write(*,*)' '

c Test Case -- gdextreg
c
      write(10,27)
      write(10,*)'Testing gdextreg... '
      write(10,*)'=================='
      write(*,*)'Testing gdextreg... '
      write(*,*)'=================='

      status = gdextreg(gdid_utm,regionid,'Impedance',datbuf)
      write(*,*)'status = gdextreg(gdid_utm,regionid,
     1"Impedance",datbuf)'
      write(*,*)'Value returned by gdextreg ',status
      write(10,*)'status = gdextreg(gdid_utm,regionid,
     1"Impedance",datbuf)'
      write(10,*)'Value returned by gdextreg ',status
      do 175 i=100,150
         write(*,*)'Value of region ',datbuf(i)
         write(10,*)'Value of region ',datbuf(i)
  175 continue


      status = gddetach(gdid_utm)
      write(*,*)'status = gddetach(gdid_utm)'
      write(*,*)'Value returned by gddetach ',status
      write(10,*)'status = gddetach(gdid_utm)'
      write(10,*)'Value returned by gddetach ',status

      status = gdclose(gdfid)
      write(*,*)'status = gdclose(gdfid)'
      write(*,*)'Returned from gdclose ', status
      write(10,*)'status = gdclose(gdfid)'
      write(10,*)'Returned from gdclose ', status

      close(unit=10)
  27  format('')
      stop
      end
