Haskell Mode for Emacs
----------------------

[![Build Status](https://travis-ci.org/haskell/haskell-mode.svg?branch=master)](https://travis-ci.org/haskell/haskell-mode)
[![Melpa Status](http://melpa.org/packages/haskell-mode-badge.svg)](http://melpa.org/#/haskell-mode)
[![Melpa Stable Status](http://stable.melpa.org/packages/haskell-mode-badge.svg)](http://stable.melpa.org/#/haskell-mode)

This is the Haskell mode package for Emacs.

Please see
[the online haskell-mode manual](https://github.com/haskell/haskell-mode/wiki)
for setup and use guide.

To report problems or suggestions, please
[open an issue](https://github.com/haskell/haskell-mode/issues?state=open)
in the issue tracker.

Below is a brief setup guide.

Quick Emacs rundown
--------------------

When Emacs is started up, it normally loads the
[Emacs initialization file](http://www.gnu.org/software/emacs/manual/html_node/emacs/Init-File.html)
usually called `~/.emacs`, `~/.emacs.el`, or `~/.emacs.d/init.el`;
with `~` standing for for your home directory.  This file should
contain all of your personal customisations written as a series of
Emacs Lisp commands.  In the following sections, this file will simply
be referred to as the `.emacs` file.

Installation
------------

GNU Emacs version 23 or later is officially supported.  It may work
with other Emacsen, but we don't have the resources to support other
versions.

There are many ways to install `haskell-mode`. The following sections
describe the most common ones; pick the one that you're most
comfortable with.

### `package.el`-based Installation

*This is the recommended way*

`package.el` is the new
[built-in package manager](http://www.emacswiki.org/emacs/ELPA#toc4)
included in Emacs 24.x. On Emacs 23.x you will need to download
[`package.el`](http://bit.ly/pkg-el23) yourself and place `package.el`
somewhere in your
[`load-path`](http://www.emacswiki.org/emacs/LoadPath).

#### Marmalade

**Stable releases** of `haskell-mode` are available on
[Marmalade](http://marmalade-repo.org/packages/haskell-mode).

If you're not already using Marmalade, add the following snippet to
your `.emacs` and evaluate it with `M-x eval-buffer`:

```el
(require 'package)
(add-to-list 'package-archives
             '("marmalade" . "http://marmalade-repo.org/packages/"))
(package-initialize)
```

Refresh the package index by `M-x package-refresh-contents` and install
`haskell-mode` via `M-x package-install [RET] haskell-mode`.

Alternatively, you can also download the `.tar` file via the
_Download_ link at http://marmalade-repo.org/packages/haskell-mode and
install the package `.tar`-file via `M-x package-install-file`

Note that in this case you will also need to have a sufficiently
recent version of `cl-lib.el`, upon which `haskell-mode` depends.
This is bundled with Emacs 24.3 and later, and a backported version
for use with older Emacs versions can be obtained from
[GNU ELPA](http://elpa.gnu.org/packages/cl-lib.html).

#### MELPA

**Development snapshots** can be installed via the
[MELPA](http://melpa.org) community maintained repository.

For MELPA the code you need to add is:

```lisp
(require 'package)
(add-to-list 'package-archives
             '("melpa" . "http://melpa.org/packages/") t)
(package-initialize)
```

Refresh the package index by `M-x package-refresh-contents` and install
`haskell-mode` via `M-x package-install [RET] haskell-mode`.

### el-get based Installation

[el-get](https://github.com/dimitri/el-get) is another popular package manager for Emacs.
If you're an el-get user just do `M-x el-get-install` to get `haskell-mode` installed.

### Emacs Prelude

`haskell-mode` is bundled with
[Emacs Prelude](https://github.com/bbatsov/prelude). If you're a
Prelude user you can start using it right away.

### Debian

If you are using Debian, you can install an older version (e.g. Wheezy
ships with version 2.8.0) of `haskell-mode` with a command like:

```bash
$ apt-get install haskell-mode
```

### Installation from Git

*This installation method requires more work and recommended for haskell-mode developers/contributors only as it allows to load haskell-mode directly from the checked out Git working copy. If you just want to use bleeding edge versions of haskell-mode please use the MELPA installation method described above.*

-   `git clone https://github.com/haskell/haskell-mode.git` into a
    suitable directory, e.g. `~/lib/emacs/haskell-mode/` where `~`
    stands for your home directory.

-   Assuming you have unpacked the various haskell-mode modules
    (`haskell-mode.el` and the rest) in the directory
    `~/lib/emacs/haskell-mode/`, you need generate the autoloads file
    (`haskell-mode-autoloads.el`) by either

    - Invoking `make haskell-mode-autoloads.el`, or `make all` (use
      this to perform byte-compilation and Info manual generation)

    - From inside Emacs, `M-x update-directory-autoloads` and answering the question for
      the folder with `~/lib/emacs/haskell-mode/` and the question for the output-file with
      `~/lib/emacs/haskell-mode/haskell-mode-autoloads.el`

    and then adding the following command to your `.emacs`:

    ```el
    (add-to-list 'load-path "~/lib/emacs/haskell-mode/")
    (require 'haskell-mode-autoloads)
    (add-to-list 'Info-default-directory-list "~/lib/emacs/haskell-mode/")
    ```

-   After updating your haskell-mode working directory, you need to
    re-run `make all` or `M-x update-directory-autoloads`.

Basic Configuration
-------------------

For setup instructions, please consult the new integrated haskell-mode
[Info](https://www.gnu.org/software/texinfo/manual/info/info.html)
manual which can be accessed after installation via
`M-x info-display-manual [RET] haskell-mode`.
Alternatively, you can also direct your browser to the
[latest online HTML version](http://haskell.github.io/haskell-mode/manual/latest/).

Support
-------

- [Mailing list](http://projects.haskell.org/cgi-bin/mailman/listinfo/haskellmode-emacs)
- [Github homepage](https://github.com/haskell/haskell-mode)

Contributing
------------

For submitting pull requests, please see the wiki
[page on contributing](https://github.com/haskell/haskell-mode/wiki/Contributing). You
don't have to follow this guide, but please make sure your pull
requests are at least properly rebased and up to date.
