/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <sqlite.h>
#include "callbacks.h"
#include "support.h"
#include "db.h"
#include "interface.h"
#include "preferences.h"
#include "gui_utils.h"

extern GtkWidget *window;
extern preferencestype preferences;
extern sqlite *db;

/* TOOLBAR */
void
on_firstbutton_clicked (GtkButton *button,	gpointer user_data)
{
	GtkWidget *entry;
	
	if (max_db () > 0)
	{
		clearall ();
		load_from_db (1);
		entry = lookup_widget (window, "entry");
		gtk_entry_set_text (GTK_ENTRY(entry), "1");
	}
}


void
on_previousbutton_clicked	(GtkButton *button, gpointer user_data)
{
	GtkWidget *entry;
	gchar *line, *newline;
	gint nr;
	
	entry = lookup_widget (window, "entry");
	line = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	nr = atoi (line);
	if (nr > 1)
	{
		nr--;
		clearall ();
		load_from_db (nr);
		newline = g_strdup_printf ("%d", nr);
		gtk_entry_set_text (GTK_ENTRY(entry), newline);
		g_free (newline);
	}
	g_free (line);
}


void
on_nextbutton_clicked	(GtkButton	*button, gpointer user_data)
{
	GtkWidget *entry;
	gchar *line, *newline;
	gint nr;

	entry = lookup_widget (window, "entry");
	line = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	nr = atoi (line);
	if (nr < max_db ())
	{
		nr++;
		clearall ();
		load_from_db (nr);
		newline = g_strdup_printf ("%d", nr);
		gtk_entry_set_text (GTK_ENTRY(entry), newline);
		g_free (newline);
	}
	g_free (line);
}

void
on_rewindbutton_clicked (GtkButton *button,	gpointer user_data)
{
	GtkWidget *entry;
	gchar *line, *newline;
	gint nr;
	
	entry = lookup_widget (window, "entry");
	line = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	nr = atoi (line);
	if (nr > 5)
	{
		nr = nr - 5;
		clearall ();
		load_from_db (nr);
		newline = g_strdup_printf ("%d", nr);
		gtk_entry_set_text (GTK_ENTRY(entry), newline);
		g_free (newline);
	}
	g_free (line);
}


void
on_ffbutton_clicked	 (GtkButton	 *button, gpointer user_data)
{
	GtkWidget *entry;
	gchar *line, *newline;
	gint nr;
	
	entry = lookup_widget (window, "entry");
	line = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
	nr = atoi (line);
	if (nr <= max_db () - 5)
	{
		nr = nr + 5;
		clearall ();
		load_from_db (nr);
		newline = g_strdup_printf ("%d", nr);
		gtk_entry_set_text (GTK_ENTRY(entry), newline);
		g_free (newline);
	}
	g_free (line);
}

void
on_lastbutton_clicked (GtkButton *button, gpointer user_data)
{
	GtkWidget *entry;
	gchar *str;
	
	clearall ();
	load_from_db (max_db ());
	entry = lookup_widget (window, "entry");
	str = g_strdup_printf ("%d", max_db ());
	gtk_entry_set_text (GTK_ENTRY(entry), str);
	g_free (str);
}

void
on_applybutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *identry;
	gchar *id;
	gint findnr;

	identry = lookup_widget (window, "identry");
	id = gtk_editable_get_chars (GTK_EDITABLE(identry), 0, -1);
	findnr = atoi (id);
	update_db (findnr);
	g_free (id);
}


void
on_removebutton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *entry, *identry;
	gchar *id;
	gint findnr, nr, max;

	entry = lookup_widget (window, "entry");
	identry = lookup_widget (window, "identry");
	id = gtk_editable_get_chars (GTK_EDITABLE(identry), 0, -1);
	findnr = atoi (id);
	delete_from_db (findnr);
	clearall ();
	max = max_db ();

	if (max == 0)
	{
		findnr = add_to_db ();
		id = g_strdup_printf("%d", findnr);
		gtk_entry_set_text (GTK_ENTRY(identry), id);
		gtk_entry_set_text (GTK_ENTRY(entry), "1");
	}
	else
	{
		id = gtk_editable_get_chars (GTK_EDITABLE(entry), 0, -1);
		nr = atoi (id);
		if (nr > 1)	nr --;
		load_from_db (nr);
		id = g_strdup_printf("%d", nr);
		gtk_entry_set_text (GTK_ENTRY(entry), id);
	}
	g_free (id);
}


void
on_newbutton_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *entry, *identry;
	gchar *line;
	gint max, id;

	entry = lookup_widget (window, "entry");
	identry = lookup_widget (window, "identry");
	clearall ();
	max = max_db () + 1;
	line = g_strdup_printf ("%d", max);
	gtk_entry_set_text (GTK_ENTRY(entry), line);
	id = add_to_db ();
	line = g_strdup_printf ("%d", id);
	gtk_entry_set_text (GTK_ENTRY(identry), line);
	g_free (line);
}

static int list_callback (void *store, int argc, char **argv, char **columnNames)
{
	GtkTreeIter iter;

	gtk_tree_store_append (store, &iter, NULL);
	gtk_tree_store_set (store, &iter, 0, argv[0], 1, argv[1], 2, argv[2], 3, argv[3], 
		4, argv[4], 5, argv[5], 6, argv[6], 7, argv[7], 8, argv[8], 9, argv[9], 
		10, argv[10], 11, argv[11], 12, argv[12], 13, argv[13], 14, argv[14], 15, argv[15], -1);
	return 0;
}

void
on_listbutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *listwindow, *listscrolledwindow, *treeview;
	GtkTreeStore *store;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	gchar **split, *query, *err;
	gint i, ret;

	listwindow = create_listwindow ();
	listscrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(listscrolledwindow),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (listscrolledwindow);
	gtk_container_add (GTK_CONTAINER (listwindow), listscrolledwindow);

	store = gtk_tree_store_new (16, G_TYPE_STRING,
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, 
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, 
		G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
  treeview = gtk_tree_view_new_with_model (GTK_TREE_MODEL(store));
  g_object_unref (G_OBJECT (store));

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Id"), renderer, "text", 0, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Number"), renderer, "text", 1, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Description"), renderer, "text", 2, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Type"), renderer, "text", 3, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Material"), renderer, "text", 4, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Period"), renderer, "text", 5, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Findnotes"), renderer, "text", 6, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Date"), renderer, "text", 7, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Value"), renderer, "text", 8, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Reference"), renderer, "text", 9, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Find date"), renderer, "text", 10, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes (_("Location"), renderer, "text", 11, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes (_("Coordinates"), renderer, "text", 12, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes (_("Spotnotes"), renderer, "text", 13, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes (_("Image1"), renderer, "text", 14, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	renderer = gtk_cell_renderer_text_new ();

	column = gtk_tree_view_column_new_with_attributes (_("Image2"), renderer, "text", 15, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

	/* column with ID is hidden, other depend on preferences */
	column = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), 0);
	gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), FALSE);
	split = g_strsplit(preferences.colvisible, ",", 0);
	for (i = 0; i < 15; i++)
	{       
		column = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i + 1);
		gtk_tree_view_column_set_visible (GTK_TREE_VIEW_COLUMN(column), atoi(split[i]) ? TRUE : FALSE);
	}
	g_strfreev(split);

  gtk_widget_show (treeview);
  gtk_container_add (GTK_CONTAINER (listscrolledwindow), treeview);
					
	query = g_strdup_printf ("SELECT * from finds;");
	ret = sqlite_exec (db, query, list_callback, store, &err);
	if (ret != SQLITE_OK)
		g_print ("Error on SELECT: %s\n", err);
	g_free (query);

	gtk_widget_set_sensitive (window, 0);
	gtk_widget_show (listwindow);
}

void
on_prefsbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *preferencesdialog, *ptypesentry, *pmaterialsentry, *pperiodsentry;
	GtkWidget *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10, *p11, *p12, *p13, *p14, *p15;
	gchar **split;

	preferencesdialog = create_preferencesdialog ();
	ptypesentry = lookup_widget (preferencesdialog, "ptypesentry");
	pmaterialsentry = lookup_widget (preferencesdialog, "pmaterialsentry");
	pperiodsentry = lookup_widget (preferencesdialog, "pperiodsentry");
	gtk_entry_set_text (GTK_ENTRY(ptypesentry), preferences.types);
	gtk_entry_set_text (GTK_ENTRY(pmaterialsentry), preferences.materials);
	gtk_entry_set_text (GTK_ENTRY(pperiodsentry), preferences.periods);
	
	split = g_strsplit(preferences.colvisible, ",", 0);
	p1 = lookup_widget (preferencesdialog, "p1");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p1), atoi(split[0]));
	p2 = lookup_widget (preferencesdialog, "p2");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p2), atoi(split[1]));
	p3 = lookup_widget (preferencesdialog, "p3");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p3), atoi(split[2]));
	p4 = lookup_widget (preferencesdialog, "p4");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p4), atoi(split[3]));
	p5 = lookup_widget (preferencesdialog, "p5");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p5), atoi(split[4]));
	p6 = lookup_widget (preferencesdialog, "p6");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p6), atoi(split[5]));
	p7 = lookup_widget (preferencesdialog, "p7");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p7), atoi(split[6]));
	p8 = lookup_widget (preferencesdialog, "p8");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p8), atoi(split[7]));
	p9 = lookup_widget (preferencesdialog, "p9");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p9), atoi(split[8]));
	p10 = lookup_widget (preferencesdialog, "p10");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p10), atoi(split[9]));
	p11 = lookup_widget (preferencesdialog, "p11");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p11), atoi(split[10]));
	p12 = lookup_widget (preferencesdialog, "p12");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p12), atoi(split[11]));
	p13 = lookup_widget (preferencesdialog, "p13");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p13), atoi(split[12]));
	p14 = lookup_widget (preferencesdialog, "p14");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p14), atoi(split[13]));
	p15 = lookup_widget (preferencesdialog, "p15");
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (p15), atoi(split[14]));
	g_strfreev(split);

	gtk_widget_set_sensitive (window, 0);
	gtk_widget_show (preferencesdialog);
}

void
on_helpbutton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *helpwindow, *helptextview;
	gchar *helpfile, buf[80];
	FILE *in;
	GtkTextBuffer *buffer;
	GtkTextIter iter;

	helpwindow = create_helpwindow ();
	helptextview = lookup_widget (helpwindow, "helptextview");
	helpfile = g_strdup_printf ("%s%s%s", PACKAGE_DATA_DIR, G_DIR_SEPARATOR_S, _("README"));
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(helptextview));
	gtk_text_buffer_get_start_iter (buffer, &iter);
	in = fopen (helpfile, "r");
	if (in)
	{
		do 
		{
			if (fgets (buf, 80, in) == NULL) 
				break;
			else 
				gtk_text_buffer_insert (buffer, &iter, buf, -1);
		} 
		while (!feof (in));
		fclose (in);
	}
	g_free (helpfile);
	gtk_widget_show (helpwindow);
}

