//
// A virtual class modelling connections.
//
// Written by: Mick Dwyer, 21 Jan, 2001
//
#ifndef _CONNECTION_H
#define _CONNECTION_H

#include <stdio.h>

#include "String.h"
#include "session.h"
#include "../config.h"

#ifdef HAVE_SSL
#include <openssl/ssl.h>
#endif /* HAVE_SSL */

class Connection;

class Connection {


protected:
	String *name;
	Session *sess;

	int Connection::fdConnect(void);

public:
	virtual int connect(void) = 0;
	virtual char *gets(char *, int) = 0;
	virtual int read(char *, int) = 0;
	virtual int write(const char *, int) = 0;
	virtual void flush(void) = 0;
	String getName(void) { return *name; }
	virtual ~Connection() {}

};

#ifdef HAVE_SSL

class SSL_Connection : public Connection {

	SSL_METHOD *method;
    X509 *server_certificate;
    SSL_CTX *context;
	SSL *ssl;

	/* these are for the the gets method. */
	char gets_buf[4096];
	char *gets_b;
	int gets_len;

public:
	int connect(void);
	char *gets(char *, int);
	int read(char *, int);
	int write(const char *, int);
	void flush(void);
	SSL_Connection(Session *s);
	~SSL_Connection();
};

#endif /* HAVE_SSL */

class Clear_Connection : public Connection {

	Clear_Connection() {};
	FILE *f;

public:
	int connect(void);
	char *gets(char *, int);
	int read(char *, int);
	int write(const char *, int);
	void flush(void);
	Clear_Connection(Session *s);
	~Clear_Connection();
};
#endif
