#ifndef GWORLDCLOCK_MAIN
#define GWORLDCLOCK_MAIN

#include "zones.h"
#include "rendezvous.h"
#include "options.h"

#define MAIN_WINDOW "main_window"

/* two display columns: Name of zone, and time/date.
   This could be adjusted later to separate time from date.
   Also, store the TZ name here.
*/
enum
{
   TZ_NAME,
   TZ_DESCRIPTION,
   TZ_TIMEDATE,
   LIST_COLUMNS
};


void GetOptions( int argc, char **argv );

void get_main_menu( GtkWidget  *window,
		    GtkWidget **menubar,
		    gpointer clocklist);

void AboutDialog( gpointer clocklist );

/* ensure we go through the same save routine when quitting from the menu (C-Q)
   or by pressing the window's 'close' button */
void send_clock_quit( gpointer clocklist );

/* save the config data when quitting, if necessary */
gint worldclock_quit(GtkWidget *widget,
		     GdkEvent  *event,
		     gpointer   clocklist );

/* Process mouse click when a zone in the list is selected.
   Double-click with left mouse button (button 1) pops up the 
   "Change Description" dialog box.
   Single-click with right button (button 3) pops up the menu of actions.
*/
static gboolean ButtonPressedInList (GtkWidget *clocklist, 
				     GdkEventButton *event,
				     gpointer selection);

#define N_(A) A

static GtkItemFactoryEntry mainmenu_items[] = {
  { N_("/_File"),         NULL,         NULL, 0, "<Branch>" },
  /*  { "/File/_Open Zones",     NULL, NULL, 0, NULL },*/
  /* don't allow zones to be saved via Ctrl-S, in order to keep accidental
     changes from being saved */
  { N_("/File/_Save Zones"),     NULL, (void *)SaveZones, 0, NULL },
  /*  { "/File/Save Zones _As",     NULL, NULL, 0, NULL },*/
  { N_("/File/_Preferences"),  NULL,  ChangePreferences, 0, NULL},
  { N_("/File/_Quit"),     "<control>Q", send_clock_quit, 0, NULL },
  { N_("/_Options"),      NULL,         NULL, 0, "<Branch>" },
  { N_("/Options/_Add Timezone"),  "<control>A", AddZone, 0, NULL },
  { N_("/Options/_Delete Timezone"),  "<control>D", DeleteZone, 0, NULL },
  { N_("/Options/_Change Description"),  NULL,  ChangeZoneDescription, 0, NULL},
  { N_("/Options/_Rendezvous"),  NULL,  Rendezvous, 0, NULL},
  { N_("/_Help"),         NULL,         NULL, 0, "<LastBranch>" },
  { N_("/_Help/About"),   NULL,         AboutDialog, 0, NULL }
};

static GtkItemFactoryEntry popupmenu_items[] = {
  { N_("/Rendezvous"),  NULL,  Rendezvous, 0, NULL},
  /* setup "add zone" here to add at selected row! */
  { N_("/Add Timezone"),  NULL, AddZone, 0, NULL },
  { N_("/Delete Timezone"),  NULL,  DeleteZone, 0, NULL},
  { N_("/Change Description"),  NULL,  ChangeZoneDescription, 0, NULL}
};

#endif
