/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "gwsupport.h"
#include "gwsearchengine.h"

#include <gtk/gtk.h>

#include <string.h> /* strcmp */

#include "data/gwdata.h"
#include "tools/gwtools.h"
#include "res/gwres.h"
#include "gui/gwgui.h"

#include "gwapplicationmanager.h"
#include "gwguimanager.h"
#include "gwcatalogstats.h"


gulong search_engine_search_in_disk ( GtkWindow *w, struct user_quick_search *uqs)
{
	GtkCList *clist_result;
	GtkCTree *ctree = gw_gui_manager_main_interface_get_tree ( );
	GtkCTreeNode *root = gw_gui_manager_main_interface_get_tree_root ( );
	GtkCTreeNode *node;
	struct disk_data *disk_data;
	struct disk_info *disk_info;
	struct engine_quick_search *engine_qs = NULL;
	gulong result = 0;
	gboolean all_words = FALSE;
	GWRegex regex;


	engine_qs = user_quick_search_to_engine_quick_search ( uqs);
	if ( (all_words = gw_application_manager_get_settings_tol ( GW_VALUE_APP_SEARCH_TYPE_KEY_WORDS_MODE)) == -1 )
	{
		all_words = GW_VALUE_APP_SEARCH_TYPE_KEY_WORDS_MODE_DEFAULT;
	}
	engine_quick_search_set_match_all_key_words ( engine_qs, !all_words);
	clist_result = gw_notebook_search_get_clist_search ( w);

	memset ( &regex, '\0', sizeof ( GWRegex));
	if ( engine_quick_search_get_type ( engine_qs) != SEARCH_TYPE_KEY_WORDS ) {
		if ( regcomp ( &(regex.r), engine_quick_search_get_pattern ( engine_qs), (engine_quick_search_get_case_sensitive ( engine_qs)==FALSE?REG_ICASE:0)|REG_NOSUB) != 0) {
			/* Regcomp error!! */
		}
	}

	if ( (root != NULL) && ( ((engine_quick_search_get_type ( engine_qs) == SEARCH_TYPE_KEY_WORDS) && (engine_quick_search_get_key_words ( engine_qs) != NULL)) || (engine_quick_search_get_pattern ( engine_qs) != NULL)) )
	{
		/* Clears the old search result */
		gtk_clist_clear ( clist_result);

		/* Browses all disks of catalog */
		node = GTK_CTREE_ROW ( root)->children;
		while ( node != NULL )
		{
			/* Gets disks information */
			disk_data = gtk_ctree_node_get_row_data ( ctree, node);

			if ( ( disk_info = disk_data_get_info ( disk_data)) != NULL )
			{
				if ( search_engine_check_disk_match ( disk_info, engine_qs, &regex) == 0 )
				{
					search_engine_add_disk ( clist_result, ctree, root, disk_info);
					result++;
				}
			}

			result += search_engine_search_in_dir ( ctree, node, engine_qs, &regex);

			/* Goes to the next disk */
			node = GTK_CTREE_ROW ( node)->sibling;
		}
	}

	if ( engine_quick_search_get_type ( engine_qs) != SEARCH_TYPE_KEY_WORDS ) {
		regfree ( &(regex.r));
	}

	return result;
}


gulong search_engine_search_in_dir ( GtkCTree *ctree, GtkCTreeNode *parent, struct engine_quick_search *eqs, GWRegex *regex)
{
	GtkCList *clist_result;
	struct disk_data *disk_data = NULL;
	struct dir_data *dir_data = NULL;
	struct file_info *file_info = NULL;
	GList *dir = NULL;
	GtkCTreeNode *root = gw_gui_manager_main_interface_get_tree_root ( );
	GtkCTreeNode *node = NULL;
	GtkWindow *window = gw_gui_manager_main_interface_get_main_window ( );
	gchar *word = NULL;
	gboolean case_sensitive;
	gulong result = 0;


	clist_result = gw_notebook_search_get_clist_search ( window);

	if ( GTK_CTREE_ROW ( parent)->parent == root)
	{
		/* If its a disk */
		disk_data = gtk_ctree_node_get_row_data ( ctree, parent);
		dir = disk_data_get_child ( disk_data);
	}
	else
	{
		/* If it's a folder */
		dir_data = gtk_ctree_node_get_row_data ( ctree, parent);
		dir = dir_data_get_child ( dir_data);
	}

	/* Gets the files list of disk/folder */
	dir = g_list_first ( dir);

	word = engine_quick_search_get_pattern ( eqs);
	case_sensitive = engine_quick_search_get_case_sensitive ( eqs);

	while ( dir != g_list_last ( dir) )
	{
		/* Gets file information */
		if ( (file_info = dir->data) != NULL )
		{
			file_info = dir->data;

			if ( search_engine_check_file_match ( file_info, eqs, regex) == 0 )
			{
				search_engine_add_item ( clist_result, ctree, parent, file_info);
				result++;
			}
		}

		dir = g_list_next ( dir);
	}

	if ( dir != NULL )
	{
		if ( (file_info = dir->data) != NULL )
		{
			file_info = dir->data;

			if ( search_engine_check_file_match ( file_info, eqs, regex) == 0 )
			{
				search_engine_add_item ( clist_result, ctree, parent, file_info);
				result++;
			}
		}
	}


	/* Browses all subfolders */
	node = GTK_CTREE_ROW ( parent)->children;

	while ( node != NULL )
	{
		/* Gets folder information */
		dir_data = gtk_ctree_node_get_row_data ( ctree, node);
		file_info = dir_data_get_info ( dir_data);

		if ( file_info != NULL )
		{
			if ( search_engine_check_file_match ( file_info, eqs, regex) == 0 )
			{
				search_engine_add_item ( clist_result, ctree, node, file_info);
				result++;
			}
		}

		result += search_engine_search_in_dir ( ctree, node, eqs, regex);

		/* Goes to the next folder */
		node = GTK_CTREE_ROW ( node)->sibling;
	}

	return result;
}


gint search_engine_check_disk_match ( struct disk_info *disk, struct engine_quick_search *eqs, GWRegex *regex)
{
	gint result = -1;
	gchar *word = NULL;
	gchar **words = NULL;
	gint i = 0;
	gint all_words = -1;
	gboolean case_sensitive;


	if ( ( disk != NULL ) || ( eqs != NULL ) )
	{
		if ( engine_quick_search_get_match_disk ( eqs) )
		{
			case_sensitive = engine_quick_search_get_case_sensitive ( eqs);

			if ( engine_quick_search_get_type ( eqs) == SEARCH_TYPE_KEY_WORDS )
			{
				words = engine_quick_search_get_key_words ( eqs);
				all_words = !engine_quick_search_get_match_all_key_words ( eqs);

				if ( all_words == 0)
				{
					result = -1;

					for ( i = 0; ((words[i] != NULL) && ( result == -1)); i++)
					{
						if ( gw_strcmp_strregex ( disk_info_get_name ( disk), words[i], case_sensitive) == 0 )
						{
							result = 0;
						}
					}

					if ( engine_quick_search_get_match_category ( eqs) )
					{
						for ( i = 0; ((words[i] != NULL) && ( result == -1)); i++)
						{
							if ( gw_strcmp_strregex ( disk_info_get_category_name ( disk), words[i], case_sensitive) == 0 )
							{
								result = 0;
							}
						}
					}

					if ( engine_quick_search_get_match_description ( eqs) )
					{
						for ( i = 0; ((words[i] != NULL) && ( result == -1)); i++)
						{
							if ( gw_strcmp_strregex ( disk_info_get_description ( disk), words[i], case_sensitive) == 0 )
							{
								result = 0;
							}
						}
					}
				}
				else
				{
					result = 0;

					for ( i = 0; ((words[i] != NULL) && ( result == 0)); i++)
					{
						if ( gw_strcmp_strregex ( disk_info_get_name ( disk), words[i], case_sensitive) != 0 )
						{
							result = -1;
						}
					}

					if ( result != 0)
					{
						if ( engine_quick_search_get_match_category ( eqs) )
						{
							result = 0;

							for ( i = 0; ((words[i] != NULL) && ( result == 0)); i++)
							{
								if ( gw_strcmp_strregex ( disk_info_get_category_name ( disk), words[i], case_sensitive) != 0 )
								{
									result = -1;
								}
							}
						}

						if ( result != 0 )
						{
							if ( engine_quick_search_get_match_description ( eqs) )
							{
								result = 0;

								for ( i = 0; ((words[i] != NULL) && ( result == 0)); i++)
								{
									if ( gw_strcmp_strregex ( disk_info_get_description ( disk), words[i], case_sensitive) != 0 )
									{
										result = -1;
									}
								}
							}
						}
					}
				}
			}
			else
			{
				word = engine_quick_search_get_pattern ( eqs);

				if ( regexec ( &(regex->r), disk_info_get_name ( disk), 0, NULL, 0) == 0 )
				{
					result = 0;
				}

				if ( result!=0 && engine_quick_search_get_match_category ( eqs) )
				{
					if ( regexec ( &(regex->r), disk_info_get_category_name ( disk), 0, NULL, 0) == 0 )
					{
						result = 0;
					}
				}

				if ( result!=0 && engine_quick_search_get_match_description ( eqs) )
				{
					if ( regexec ( &(regex->r), disk_info_get_description ( disk), 0, NULL, 0) == 0 )
					{
						result = 0;
					}
 				}
 			}

		}
	}

	return result;
}


gint search_engine_check_file_match ( struct file_info *file, struct engine_quick_search *eqs, GWRegex *regex)
{
	gint result = -1;
	gchar *word = NULL;
	gchar **words = NULL;
	gint i = 0;
	gint all_words = -1;
	gboolean case_sensitive;


	if ( ( file != NULL ) || ( eqs != NULL ) )
	{
		if ( ( engine_quick_search_get_match_file ( eqs) && !file_info_get_isdirectory ( file) ) || ( engine_quick_search_get_match_folder ( eqs) && file_info_get_isdirectory ( file) ) )
		{
			case_sensitive = engine_quick_search_get_case_sensitive ( eqs);
			if ( engine_quick_search_get_type ( eqs) == SEARCH_TYPE_KEY_WORDS )
			{
				words = engine_quick_search_get_key_words ( eqs);
				all_words = !engine_quick_search_get_match_all_key_words ( eqs);

				if ( all_words == 0)
				{
					result = -1;

					for ( i = 0; ((words[i] != NULL) && ( result == -1)); i++)
					{
						if ( gw_strcmp_strregex ( file_info_get_name ( file), words[i], case_sensitive) == 0 )
						{
							result = 0;
						}
					}

					if ( engine_quick_search_get_match_category ( eqs) )
					{
						for ( i = 0; ((words[i] != NULL) && ( result == -1)); i++)
						{
							if ( gw_strcmp_strregex ( file_info_get_category_name ( file), words[i], case_sensitive) == 0 )
							{
								result = 0;
							}
						}
					}

					if ( engine_quick_search_get_match_description ( eqs) )
					{
						for ( i = 0; ((words[i] != NULL) && ( result == -1)); i++)
						{
							if ( gw_strcmp_strregex ( file_info_get_description ( file), words[i], case_sensitive) == 0 )
							{
								result = 0;
							}
						}
					}
				}
				else
				{
					result = 0;

					for ( i = 0; ((words[i] != NULL) && ( result == 0)); i++)
					{
						if ( gw_strcmp_strregex ( file_info_get_name ( file), words[i], case_sensitive) != 0 )
						{
							result = -1;
						}
					}

					if ( result != 0 )
					{
						if ( engine_quick_search_get_match_category ( eqs) )
						{
							result = 0;

							for ( i = 0; ((words[i] != NULL) && ( result == 0)); i++)
							{
								if ( gw_strcmp_strregex ( file_info_get_category_name ( file), words[i], case_sensitive) != 0 )
								{
									result = -1;
								}
							}
						}

						if ( result != 0 )
						{
							if ( engine_quick_search_get_match_description ( eqs) )
							{
								result = 0;

								for ( i = 0; ((words[i] != NULL) && ( result == 0)); i++)
								{
									if ( gw_strcmp_strregex ( file_info_get_description ( file), words[i], case_sensitive) != 0 )
									{
										result = -1;
									}
								}
							}
						}
					}
				}
			}
			else
			{
				word = engine_quick_search_get_pattern ( eqs);

				if ( regexec ( &(regex->r), file_info_get_name ( file), 0, NULL, 0) == 0 )
				{
					result = 0;
				}

				if ( result!=0 && engine_quick_search_get_match_category ( eqs) )
				{
					if ( regexec ( &(regex->r), file_info_get_category_name ( file), 0, NULL, 0) == 0 )
					{
						result = 0;
					}
				}

				if ( result!=0 && engine_quick_search_get_match_description ( eqs) )
				{
					if ( regexec ( &(regex->r), file_info_get_description ( file), 0, NULL, 0) == 0 )
					{
						result = 0;
					}
 				}
 			}
		}
	}

	return result;
}


gint search_engine_add_item ( GtkCList *clist, GtkCTree *ctree, GtkCTreeNode *node, struct file_info *file_info)
{
        gint result = -1;
        gchar *info[7];
        gint row, i;
        gchar *text_utf8 = NULL;
        gchar *tmp = NULL;
        struct search_item_info *search_item = NULL;


        if ( file_info != NULL )
        {
                g_strdup_to_gtk_text ( file_info_get_name ( file_info), info[0]);
                g_strdup_to_gtk_text ( (tmp = gw_folder_get_disk_name ( ctree, node)), info[1]);
                g_free ( tmp);
                tmp = NULL;
                g_strdup_to_gtk_text ( (tmp = gw_folder_get_location_on_disk ( ctree, node)), info[2]);
                g_free ( tmp);
                tmp = NULL;
                text_utf8 = gw_l_byte_to_str_format ( file_info_get_size ( file_info));
                g_strdup_to_gtk_text ( text_utf8, info[3]);
                g_free ( text_utf8);
                tmp = file_info_get_cdate_to_gchar ( file_info);
                g_strdup_to_gtk_text ( tmp, info[4]);
                g_free ( tmp);
                g_strdup_to_gtk_text ( file_info_get_category_name ( file_info), info[5]);
                g_strdup_to_gtk_text ( file_info_get_description ( file_info), info[6]);
		gw_str_replace_char ( info[6], '\n', ' ');

                row = gtk_clist_append ( clist, info);

		search_item = search_item_info_new ( );
                if ( file_info_get_isdirectory ( file_info ))
                {
			search_item_info_set_type ( search_item, SEARCH_ITEM_TYPE_FOLDER);
                }
                else
                {
			search_item_info_set_type ( search_item, SEARCH_ITEM_TYPE_FILE);
                }
		search_item_info_set_name ( search_item, file_info_get_name ( file_info));
		search_item_info_set_disk ( search_item, gw_folder_get_disk_name ( ctree, node));
		search_item_info_set_path ( search_item, gw_folder_get_location_on_disk ( ctree, node));
		search_item_info_set_size ( search_item, file_info_get_size ( file_info));
		search_item_info_set_date ( search_item, file_info_get_cdate ( file_info));
		search_item_info_set_category ( search_item, file_info_get_category ( file_info));
		search_item_info_set_description ( search_item, file_info_get_description ( file_info));

                /* Note : doesn't give the free function else data will be destroy from database */
		gtk_clist_set_row_data_full ( clist, row, (struct search_item_info*)search_item, (GtkDestroyNotify)search_item_info_free);

                if ( file_info_get_isdirectory ( file_info ))
                {
                        gtk_clist_set_pixtext ( clist, row, 0, info[0], 5, PixFolder, MskFolder);
                }
                else
                {
                        gtk_clist_set_pixtext ( clist, row, 0, info[0], 5, PixFile, MskFile);
                }

                for ( i = 0; i <= 6; i++)
                {
                        g_free ( info[i]);
                }

                result = 0;
        }

        return result;
}


gint search_engine_add_disk ( GtkCList *clist, GtkCTree *ctree, GtkCTreeNode *node, struct disk_info *disk_info)
{
        gint result = -1;
        gchar *info[7];
        gint row, i; 
        gchar *text_utf8 = NULL;
        gchar *tmp = NULL;
        struct search_item_info *search_item = NULL;


        if ( disk_info != NULL )
        {
                g_strdup_to_gtk_text ( disk_info_get_name ( disk_info), info[0]);
                g_strdup_to_gtk_text ( disk_info_get_name ( disk_info), info[1]);
                g_strdup_to_gtk_text ( "", info[2]);
                text_utf8 = gw_ui64_byte_to_str_format ( disk_info_get_full ( disk_info));
                g_strdup_to_gtk_text ( text_utf8, info[3]);
                g_free ( text_utf8);
                tmp = disk_info_get_date_to_gchar ( disk_info);
                g_strdup_to_gtk_text ( tmp, info[4]);
                g_free ( tmp);
                g_strdup_to_gtk_text ( disk_info_get_category_name ( disk_info), info[5]);
                g_strdup_to_gtk_text ( disk_info_get_description ( disk_info), info[6]);
		gw_str_replace_char ( info[6], '\n', ' ');

                row = gtk_clist_append ( clist, info); 

		search_item = search_item_info_new ( );
		search_item_info_set_type ( search_item, SEARCH_ITEM_TYPE_DISK);
		search_item_info_set_name ( search_item, disk_info_get_name ( disk_info));
		search_item_info_set_disk ( search_item, g_strdup ( disk_info_get_name ( disk_info)));
		search_item_info_set_size ( search_item, disk_info_get_full ( disk_info));
		search_item_info_set_date ( search_item, disk_info_get_date ( disk_info));
		search_item_info_set_category ( search_item, disk_info_get_category ( disk_info));
		search_item_info_set_description ( search_item, disk_info_get_description ( disk_info));

                /* Note : doesn't give the free function else data will be destroy from database */
		gtk_clist_set_row_data_full ( clist, row, (struct search_item_info*)search_item, (GtkDestroyNotify) search_item_info_free);

                gtk_clist_set_pixtext ( clist, row, 0, info[0], 5, disk_info_get_pixmap ( disk_info), disk_info_get_bitmap ( disk_info));

                for ( i = 0; i <= 6; i++)
                {
                        g_free ( info[i]);
                }

                result = 0;
        }

        return result;
}
