# -*- coding: latin-1 -*-

# Copyright (c) 2005 Stas Zykiewicz <stasz@linux.isbeter.nl>
#
#           Rwld2Gwld.py
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

DEBUG = 0
import sys,os,re
import gvrparser
from utils import L2U
from wxPython.wx import *
class IO:
    """This handles all save and load actions."""
    def __init__(self):
        """This handles only gvr files for now"""
        self.filePath = os.path.join(os.getcwd(),'NewGvR')
        self.ext = '.wld'
        self.wxext = "World files (*.wld)|*.wld| All files (*.*)|*.*"
    def SaveTextAs(self,lines):
        dlg = wxFileDialog(None,\
                           "Choose a filename for your world file",\
                            os.path.dirname(self.filePath),\
                            os.path.basename(self.filePath+self.ext),\
                            self.wxext,\
                            wxSAVE | wxOVERWRITE_PROMPT)
        if dlg.ShowModal() == wxID_OK:
            path = dlg.GetPath()
            base, ext = os.path.splitext(path)
            if ext != self.ext:
                path = base+self.ext
            dlg.Destroy()
            self._save_file(path,lines)
        else:
            dlg.Destroy()
                
    def _save_file(self,path,lines):
        try:
            f = open(path, 'w')
            f.writelines(lines)
            f.close()
        except IOError:
            wxMessageBox("Can't save the file to chosen location,\nmake sure you have the proper permissions.","GvR-ERROR")
        else:
            wxMessageBox("File saved succesfully.","Info")
    
    def _load_gvrworld(self):
        lines = [""]
        dlg = wxFileDialog(None,\
                           "Choose a GvR worldfile to import",\
                            os.getcwd(),\
                            '',\
                            self.wxext,\
                            wxOPEN | wxOVERWRITE_PROMPT)
        if dlg.ShowModal() == wxID_OK:
            path = dlg.GetPath()
            base, ext = os.path.splitext(path)
            dlg.Destroy()
            if not os.path.exists(path):
                wxMessageBox("The File doesn't exists.","GvR error")
            elif ext != self.ext:
                wxMessageBox("The file is not a GvR worldfile","GvR Error")
            else:
                newlines = []
                try:
                    lines = open(path,'r').readlines()
                    print lines
                    for line in lines:
                        line = re.sub('\r\n', '\n', line)# normalize line breaks
                        line = line[:-1]# strip line break
                        newlines.append(line)
                except IOError,info:
                    wxMessageBox("%s\nCan't load from the chosen location,\nmake sure that the path is correct." % info,"GvR-ERROR")
        else:
            dlg.Destroy()
        print path,newlines
        return newlines
    
class Rur2Gvr(IO):
    """Converts a RUR wld string into a GvR wld string.
    This is meant to be imported by WorldBuilder."""
    def __init__(self,RURwld):
        """RURwld must be the WorldDisplay.WorldGui.Visible_world() instance from 
        WorldCreation.py, eg the 'self.world' attribute from WorldGui"""
        IO.__init__(self)
        self._walls_dict = {}#used to sort walls definitions
        self.Rwld = RURwld
        self.Rwalls = RURwld.walls_list
        self.Rbeepers = RURwld.beepers_dict
        name = 'robot'
        self.Rrobot = RURwld.robot_dict[name]
        self.Convert()
                
    def Convert(self):
        Glines = ["# This is a autogenerated world\n",\
                  "# description file for GvR.\n"]
        _robot = L2U(_("ROBOT")).title()
        (_avenue, _street, _orientation, _beepers) = self.Rrobot._getInfoTuple()
        _orientation = L2U(_(_orientation))
        Glines.append("%s %s %s %s %s\n" % (_robot, _avenue, _street, _orientation, _beepers))
        for k,v in self.Rbeepers.items():
            line = "%s %s %s %s\n" % (L2U(_("BEEPERS")).title(), k[0],k[1],v)
            Glines.append(line)
        for x,y in self.Rwalls:
            if x % 2:
                Gdir = L2U(_('N'))
                Gx = x/2 + 1
                Gy = y/2
            else:
                Gdir = L2U(_('E'))
                Gx = x/2
                Gy = y/2 + 1
            line = "%s %s %s %s\n" % (L2U(_("WALL")).title(), Gx,Gy,Gdir)
            Glines.append(line)
        if DEBUG: print Glines
        
        return Glines
        #self.SaveTextAs(Glines)
        
class Gvr2Rur(IO):
    """Converts a GvR world file into a RUR wld string.
    This is meant to be imported by WorldBuilder.
    This is work in progress and doesn't work yet"""
    def __init__(self):
        """GvRwld must be the filename of the GvR worldfile"""
        IO.__init__(self)
        self.Gwld = self._load_gvrworld()
        self.Rwalls = []
        self.Rbeepers = {}
        Gdict = {}
        walls,beepers = [],[]
        for line in self.Gwld:
            if "Robot" in line:
                Gdict['robot'] = line
            elif "Wall" in line:
                walls.append(line)
            elif "Beeper" in line:
                beepers.append(line)
        Gdict['walls'] = walls
        Gdict['beepers'] = beepers
        self.Gdict = Gdict
        self.Convert()
        
    def Convert(self):
        ## Just a place holder
        l = self.Gdict['robot'].split(' ')
        if len(l) < 5:# we assume there's no beeper argument
            l.append('0')
        print l[1:]
        Rlines = ["robot = (%s, %s, '%s', %s)\n" % tuple(l[1:])]
        
        Rlines.append("beepers = {\n")
        for line in self.Gdict['beepers']:
            Rlines.append("(%s, %s):%s\n" % tuple(line.split(' ')[1:]))
        Rlines.append("          }\n")
        
##        for x,y in self.Rwalls:
##            if x % 2:
##                Gdir = 'N'
##                Gx = x/2 + 1
##                Gy = y/2
##            else:
##                Gdir = 'E'
##                Gx = x/2
##                Gy = y/2 + 1
##            line = "Wall %s %s %s\n" % (Gx,Gy,Gdir)
##            Glines.append(line)
        print Rlines
        #self.SaveTextAs(Rlines)# just for testing
        
        
