/* Copyright (C) 2009-2018 Greenbone Networks GmbH
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * @file  manage_ranges_iana_tcp_udp_2012.c
 * @brief GVM management layer: Predefined port range
 *
 * This file defines the ranges for a predefined port list.
 */

#include "manage_sql.h"

#undef G_LOG_DOMAIN
/**
 * @brief GLib log domain.
 */
#define G_LOG_DOMAIN "md   main"

/**
 * @brief Insert a port range.
 */
#define RANGE(type, start, end)                                      \
  insert_port_range (list, type, start, end)

/**
 * @brief Make port ranges for IANA TCP and UDP 2012.
 *
 * Caller must lock the db.
 *
 * @param[in]  list  Port list.
 */
void
make_port_ranges_iana_tcp_udp_2012 (port_list_t list)
{
  RANGE (PORT_PROTOCOL_TCP, 1, 80);
  RANGE (PORT_PROTOCOL_TCP, 82, 113);
  RANGE (PORT_PROTOCOL_TCP, 115, 224);
  RANGE (PORT_PROTOCOL_TCP, 242, 248);
  RANGE (PORT_PROTOCOL_TCP, 256, 257);
  RANGE (PORT_PROTOCOL_TCP, 259, 269);
  RANGE (PORT_PROTOCOL_TCP, 280, 284);
  RANGE (PORT_PROTOCOL_TCP, 286, 287);
  RANGE (PORT_PROTOCOL_TCP, 308, 322);
  RANGE (PORT_PROTOCOL_TCP, 333, 333);
  RANGE (PORT_PROTOCOL_TCP, 344, 584);
  RANGE (PORT_PROTOCOL_TCP, 586, 658);
  RANGE (PORT_PROTOCOL_TCP, 660, 702);
  RANGE (PORT_PROTOCOL_TCP, 704, 707);
  RANGE (PORT_PROTOCOL_TCP, 709, 715);
  RANGE (PORT_PROTOCOL_TCP, 729, 731);
  RANGE (PORT_PROTOCOL_TCP, 741, 742);
  RANGE (PORT_PROTOCOL_TCP, 744, 744);
  RANGE (PORT_PROTOCOL_TCP, 747, 754);
  RANGE (PORT_PROTOCOL_TCP, 758, 765);
  RANGE (PORT_PROTOCOL_TCP, 767, 767);
  RANGE (PORT_PROTOCOL_TCP, 769, 777);
  RANGE (PORT_PROTOCOL_TCP, 780, 780);
  RANGE (PORT_PROTOCOL_TCP, 800, 801);
  RANGE (PORT_PROTOCOL_TCP, 810, 810);
  RANGE (PORT_PROTOCOL_TCP, 828, 833);
  RANGE (PORT_PROTOCOL_TCP, 847, 848);
  RANGE (PORT_PROTOCOL_TCP, 860, 862);
  RANGE (PORT_PROTOCOL_TCP, 873, 873);
  RANGE (PORT_PROTOCOL_TCP, 886, 888);
  RANGE (PORT_PROTOCOL_TCP, 900, 903);
  RANGE (PORT_PROTOCOL_TCP, 910, 913);
  RANGE (PORT_PROTOCOL_TCP, 989, 993);
  RANGE (PORT_PROTOCOL_TCP, 995, 1000);
  RANGE (PORT_PROTOCOL_TCP, 1010, 1010);
  RANGE (PORT_PROTOCOL_TCP, 1021, 1022);
  RANGE (PORT_PROTOCOL_TCP, 1025, 1027);
  RANGE (PORT_PROTOCOL_TCP, 1029, 1108);
  RANGE (PORT_PROTOCOL_TCP, 1110, 1490);
  RANGE (PORT_PROTOCOL_TCP, 1492, 1527);
  RANGE (PORT_PROTOCOL_TCP, 1529, 1782);
  RANGE (PORT_PROTOCOL_TCP, 1784, 2193);
  RANGE (PORT_PROTOCOL_TCP, 2197, 2258);
  RANGE (PORT_PROTOCOL_TCP, 2260, 2368);
  RANGE (PORT_PROTOCOL_TCP, 2370, 2374);
  RANGE (PORT_PROTOCOL_TCP, 2381, 2425);
  RANGE (PORT_PROTOCOL_TCP, 2427, 2681);
  RANGE (PORT_PROTOCOL_TCP, 2683, 2793);
  RANGE (PORT_PROTOCOL_TCP, 2795, 2824);
  RANGE (PORT_PROTOCOL_TCP, 2826, 2872);
  RANGE (PORT_PROTOCOL_TCP, 2874, 2924);
  RANGE (PORT_PROTOCOL_TCP, 2926, 3000);
  RANGE (PORT_PROTOCOL_TCP, 3002, 3091);
  RANGE (PORT_PROTOCOL_TCP, 3093, 3096);
  RANGE (PORT_PROTOCOL_TCP, 3098, 3120);
  RANGE (PORT_PROTOCOL_TCP, 3122, 3125);
  RANGE (PORT_PROTOCOL_TCP, 3127, 3299);
  RANGE (PORT_PROTOCOL_TCP, 3302, 3321);
  RANGE (PORT_PROTOCOL_TCP, 3326, 3366);
  RANGE (PORT_PROTOCOL_TCP, 3372, 3402);
  RANGE (PORT_PROTOCOL_TCP, 3405, 3545);
  RANGE (PORT_PROTOCOL_TCP, 3547, 3692);
  RANGE (PORT_PROTOCOL_TCP, 3695, 3765);
  RANGE (PORT_PROTOCOL_TCP, 3767, 3993);
  RANGE (PORT_PROTOCOL_TCP, 3995, 4047);
  RANGE (PORT_PROTOCOL_TCP, 4049, 4076);
  RANGE (PORT_PROTOCOL_TCP, 4078, 4083);
  RANGE (PORT_PROTOCOL_TCP, 4085, 4085);
  RANGE (PORT_PROTOCOL_TCP, 4087, 4119);
  RANGE (PORT_PROTOCOL_TCP, 4121, 4143);
  RANGE (PORT_PROTOCOL_TCP, 4145, 4172);
  RANGE (PORT_PROTOCOL_TCP, 4174, 4190);
  RANGE (PORT_PROTOCOL_TCP, 4192, 4193);
  RANGE (PORT_PROTOCOL_TCP, 4199, 4199);
  RANGE (PORT_PROTOCOL_TCP, 4300, 4313);
  RANGE (PORT_PROTOCOL_TCP, 4320, 4329);
  RANGE (PORT_PROTOCOL_TCP, 4340, 4360);
  RANGE (PORT_PROTOCOL_TCP, 4368, 4379);
  RANGE (PORT_PROTOCOL_TCP, 4389, 4393);
  RANGE (PORT_PROTOCOL_TCP, 4395, 4396);
  RANGE (PORT_PROTOCOL_TCP, 4400, 4410);
  RANGE (PORT_PROTOCOL_TCP, 4425, 4431);
  RANGE (PORT_PROTOCOL_TCP, 4433, 4433);
  RANGE (PORT_PROTOCOL_TCP, 4442, 4458);
  RANGE (PORT_PROTOCOL_TCP, 4484, 4488);
  RANGE (PORT_PROTOCOL_TCP, 4500, 4500);
  RANGE (PORT_PROTOCOL_TCP, 4535, 4538);
  RANGE (PORT_PROTOCOL_TCP, 4545, 4556);
  RANGE (PORT_PROTOCOL_TCP, 4559, 4559);
  RANGE (PORT_PROTOCOL_TCP, 4566, 4569);
  RANGE (PORT_PROTOCOL_TCP, 4590, 4591);
  RANGE (PORT_PROTOCOL_TCP, 4593, 4603);
  RANGE (PORT_PROTOCOL_TCP, 4658, 4692);
  RANGE (PORT_PROTOCOL_TCP, 4700, 4704);
  RANGE (PORT_PROTOCOL_TCP, 4725, 4725);
  RANGE (PORT_PROTOCOL_TCP, 4727, 4728);
  RANGE (PORT_PROTOCOL_TCP, 4730, 4731);
  RANGE (PORT_PROTOCOL_TCP, 4733, 4733);
  RANGE (PORT_PROTOCOL_TCP, 4737, 4745);
  RANGE (PORT_PROTOCOL_TCP, 4749, 4752);
  RANGE (PORT_PROTOCOL_TCP, 4784, 4784);
  RANGE (PORT_PROTOCOL_TCP, 4786, 4788);
  RANGE (PORT_PROTOCOL_TCP, 4800, 4803);
  RANGE (PORT_PROTOCOL_TCP, 4827, 4827);
  RANGE (PORT_PROTOCOL_TCP, 4837, 4851);
  RANGE (PORT_PROTOCOL_TCP, 4867, 4871);
  RANGE (PORT_PROTOCOL_TCP, 4876, 4877);
  RANGE (PORT_PROTOCOL_TCP, 4879, 4880);
  RANGE (PORT_PROTOCOL_TCP, 4883, 4885);
  RANGE (PORT_PROTOCOL_TCP, 4894, 4894);
  RANGE (PORT_PROTOCOL_TCP, 4899, 4902);
  RANGE (PORT_PROTOCOL_TCP, 4912, 4915);
  RANGE (PORT_PROTOCOL_TCP, 4940, 4942);
  RANGE (PORT_PROTOCOL_TCP, 4949, 4953);
  RANGE (PORT_PROTOCOL_TCP, 4969, 4970);
  RANGE (PORT_PROTOCOL_TCP, 4984, 4991);
  RANGE (PORT_PROTOCOL_TCP, 4999, 5013);
  RANGE (PORT_PROTOCOL_TCP, 5015, 5015);
  RANGE (PORT_PROTOCOL_TCP, 5020, 5030);
  RANGE (PORT_PROTOCOL_TCP, 5032, 5032);
  RANGE (PORT_PROTOCOL_TCP, 5042, 5045);
  RANGE (PORT_PROTOCOL_TCP, 5048, 5057);
  RANGE (PORT_PROTOCOL_TCP, 5059, 5074);
  RANGE (PORT_PROTOCOL_TCP, 5080, 5086);
  RANGE (PORT_PROTOCOL_TCP, 5093, 5094);
  RANGE (PORT_PROTOCOL_TCP, 5099, 5103);
  RANGE (PORT_PROTOCOL_TCP, 5111, 5112);
  RANGE (PORT_PROTOCOL_TCP, 5114, 5115);
  RANGE (PORT_PROTOCOL_TCP, 5117, 5117);
  RANGE (PORT_PROTOCOL_TCP, 5133, 5135);
  RANGE (PORT_PROTOCOL_TCP, 5137, 5137);
  RANGE (PORT_PROTOCOL_TCP, 5145, 5146);
  RANGE (PORT_PROTOCOL_TCP, 5150, 5157);
  RANGE (PORT_PROTOCOL_TCP, 5161, 5168);
  RANGE (PORT_PROTOCOL_TCP, 5190, 5194);
  RANGE (PORT_PROTOCOL_TCP, 5200, 5203);
  RANGE (PORT_PROTOCOL_TCP, 5221, 5228);
  RANGE (PORT_PROTOCOL_TCP, 5232, 5237);
  RANGE (PORT_PROTOCOL_TCP, 5245, 5245);
  RANGE (PORT_PROTOCOL_TCP, 5248, 5253);
  RANGE (PORT_PROTOCOL_TCP, 5264, 5265);
  RANGE (PORT_PROTOCOL_TCP, 5269, 5272);
  RANGE (PORT_PROTOCOL_TCP, 5280, 5282);
  RANGE (PORT_PROTOCOL_TCP, 5298, 5310);
  RANGE (PORT_PROTOCOL_TCP, 5312, 5318);
  RANGE (PORT_PROTOCOL_TCP, 5320, 5321);
  RANGE (PORT_PROTOCOL_TCP, 5343, 5344);
  RANGE (PORT_PROTOCOL_TCP, 5349, 5363);
  RANGE (PORT_PROTOCOL_TCP, 5397, 5435);
  RANGE (PORT_PROTOCOL_TCP, 5443, 5443);
  RANGE (PORT_PROTOCOL_TCP, 5453, 5456);
  RANGE (PORT_PROTOCOL_TCP, 5461, 5465);
  RANGE (PORT_PROTOCOL_TCP, 5500, 5506);
  RANGE (PORT_PROTOCOL_TCP, 5553, 5557);
  RANGE (PORT_PROTOCOL_TCP, 5566, 5568);
  RANGE (PORT_PROTOCOL_TCP, 5573, 5575);
  RANGE (PORT_PROTOCOL_TCP, 5579, 5585);
  RANGE (PORT_PROTOCOL_TCP, 5597, 5605);
  RANGE (PORT_PROTOCOL_TCP, 5627, 5638);
  RANGE (PORT_PROTOCOL_TCP, 5646, 5646);
  RANGE (PORT_PROTOCOL_TCP, 5671, 5681);
  RANGE (PORT_PROTOCOL_TCP, 5688, 5689);
  RANGE (PORT_PROTOCOL_TCP, 5693, 5693);
  RANGE (PORT_PROTOCOL_TCP, 5696, 5696);
  RANGE (PORT_PROTOCOL_TCP, 5713, 5730);
  RANGE (PORT_PROTOCOL_TCP, 5741, 5748);
  RANGE (PORT_PROTOCOL_TCP, 5750, 5750);
  RANGE (PORT_PROTOCOL_TCP, 5755, 5755);
  RANGE (PORT_PROTOCOL_TCP, 5757, 5757);
  RANGE (PORT_PROTOCOL_TCP, 5766, 5771);
  RANGE (PORT_PROTOCOL_TCP, 5777, 5777);
  RANGE (PORT_PROTOCOL_TCP, 5780, 5783);
  RANGE (PORT_PROTOCOL_TCP, 5785, 5785);
  RANGE (PORT_PROTOCOL_TCP, 5793, 5793);
  RANGE (PORT_PROTOCOL_TCP, 5813, 5814);
  RANGE (PORT_PROTOCOL_TCP, 5842, 5842);
  RANGE (PORT_PROTOCOL_TCP, 5859, 5859);
  RANGE (PORT_PROTOCOL_TCP, 5863, 5863);
  RANGE (PORT_PROTOCOL_TCP, 5883, 5883);
  RANGE (PORT_PROTOCOL_TCP, 5900, 5900);
  RANGE (PORT_PROTOCOL_TCP, 5910, 5913);
  RANGE (PORT_PROTOCOL_TCP, 5963, 5963);
  RANGE (PORT_PROTOCOL_TCP, 5968, 5969);
  RANGE (PORT_PROTOCOL_TCP, 5984, 5992);
  RANGE (PORT_PROTOCOL_TCP, 5999, 6066);
  RANGE (PORT_PROTOCOL_TCP, 6068, 6076);
  RANGE (PORT_PROTOCOL_TCP, 6084, 6087);
  RANGE (PORT_PROTOCOL_TCP, 6099, 6117);
  RANGE (PORT_PROTOCOL_TCP, 6121, 6124);
  RANGE (PORT_PROTOCOL_TCP, 6133, 6133);
  RANGE (PORT_PROTOCOL_TCP, 6140, 6149);
  RANGE (PORT_PROTOCOL_TCP, 6159, 6163);
  RANGE (PORT_PROTOCOL_TCP, 6200, 6200);
  RANGE (PORT_PROTOCOL_TCP, 6222, 6222);
  RANGE (PORT_PROTOCOL_TCP, 6241, 6244);
  RANGE (PORT_PROTOCOL_TCP, 6251, 6253);
  RANGE (PORT_PROTOCOL_TCP, 6267, 6269);
  RANGE (PORT_PROTOCOL_TCP, 6300, 6301);
  RANGE (PORT_PROTOCOL_TCP, 6306, 6306);
  RANGE (PORT_PROTOCOL_TCP, 6315, 6316);
  RANGE (PORT_PROTOCOL_TCP, 6320, 6322);
  RANGE (PORT_PROTOCOL_TCP, 6324, 6324);
  RANGE (PORT_PROTOCOL_TCP, 6343, 6343);
  RANGE (PORT_PROTOCOL_TCP, 6346, 6347);
  RANGE (PORT_PROTOCOL_TCP, 6350, 6350);
  RANGE (PORT_PROTOCOL_TCP, 6355, 6355);
  RANGE (PORT_PROTOCOL_TCP, 6360, 6360);
  RANGE (PORT_PROTOCOL_TCP, 6370, 6370);
  RANGE (PORT_PROTOCOL_TCP, 6382, 6382);
  RANGE (PORT_PROTOCOL_TCP, 6389, 6390);
  RANGE (PORT_PROTOCOL_TCP, 6417, 6421);
  RANGE (PORT_PROTOCOL_TCP, 6432, 6432);
  RANGE (PORT_PROTOCOL_TCP, 6443, 6446);
  RANGE (PORT_PROTOCOL_TCP, 6455, 6455);
  RANGE (PORT_PROTOCOL_TCP, 6471, 6471);
  RANGE (PORT_PROTOCOL_TCP, 6480, 6489);
  RANGE (PORT_PROTOCOL_TCP, 6500, 6503);
  RANGE (PORT_PROTOCOL_TCP, 6505, 6510);
  RANGE (PORT_PROTOCOL_TCP, 6513, 6515);
  RANGE (PORT_PROTOCOL_TCP, 6543, 6544);
  RANGE (PORT_PROTOCOL_TCP, 6547, 6551);
  RANGE (PORT_PROTOCOL_TCP, 6558, 6558);
  RANGE (PORT_PROTOCOL_TCP, 6566, 6566);
  RANGE (PORT_PROTOCOL_TCP, 6568, 6568);
  RANGE (PORT_PROTOCOL_TCP, 6579, 6583);
  RANGE (PORT_PROTOCOL_TCP, 6600, 6602);
  RANGE (PORT_PROTOCOL_TCP, 6619, 6628);
  RANGE (PORT_PROTOCOL_TCP, 6632, 6632);
  RANGE (PORT_PROTOCOL_TCP, 6655, 6656);
  RANGE (PORT_PROTOCOL_TCP, 6665, 6673);
  RANGE (PORT_PROTOCOL_TCP, 6678, 6679);
  RANGE (PORT_PROTOCOL_TCP, 6687, 6689);
  RANGE (PORT_PROTOCOL_TCP, 6701, 6703);
  RANGE (PORT_PROTOCOL_TCP, 6714, 6715);
  RANGE (PORT_PROTOCOL_TCP, 6767, 6771);
  RANGE (PORT_PROTOCOL_TCP, 6785, 6791);
  RANGE (PORT_PROTOCOL_TCP, 6801, 6801);
  RANGE (PORT_PROTOCOL_TCP, 6817, 6817);
  RANGE (PORT_PROTOCOL_TCP, 6831, 6831);
  RANGE (PORT_PROTOCOL_TCP, 6841, 6842);
  RANGE (PORT_PROTOCOL_TCP, 6850, 6850);
  RANGE (PORT_PROTOCOL_TCP, 6868, 6868);
  RANGE (PORT_PROTOCOL_TCP, 6888, 6888);
  RANGE (PORT_PROTOCOL_TCP, 6901, 6901);
  RANGE (PORT_PROTOCOL_TCP, 6935, 6936);
  RANGE (PORT_PROTOCOL_TCP, 6946, 6946);
  RANGE (PORT_PROTOCOL_TCP, 6951, 6951);
  RANGE (PORT_PROTOCOL_TCP, 6961, 6966);
  RANGE (PORT_PROTOCOL_TCP, 6969, 6969);
  RANGE (PORT_PROTOCOL_TCP, 6997, 7015);
  RANGE (PORT_PROTOCOL_TCP, 7018, 7025);
  RANGE (PORT_PROTOCOL_TCP, 7030, 7030);
  RANGE (PORT_PROTOCOL_TCP, 7070, 7071);
  RANGE (PORT_PROTOCOL_TCP, 7080, 7080);
  RANGE (PORT_PROTOCOL_TCP, 7099, 7101);
  RANGE (PORT_PROTOCOL_TCP, 7121, 7121);
  RANGE (PORT_PROTOCOL_TCP, 7128, 7129);
  RANGE (PORT_PROTOCOL_TCP, 7161, 7171);
  RANGE (PORT_PROTOCOL_TCP, 7173, 7174);
  RANGE (PORT_PROTOCOL_TCP, 7200, 7201);
  RANGE (PORT_PROTOCOL_TCP, 7227, 7229);
  RANGE (PORT_PROTOCOL_TCP, 7237, 7237);
  RANGE (PORT_PROTOCOL_TCP, 7262, 7262);
  RANGE (PORT_PROTOCOL_TCP, 7272, 7283);
  RANGE (PORT_PROTOCOL_TCP, 7365, 7365);
  RANGE (PORT_PROTOCOL_TCP, 7391, 7395);
  RANGE (PORT_PROTOCOL_TCP, 7397, 7397);
  RANGE (PORT_PROTOCOL_TCP, 7400, 7402);
  RANGE (PORT_PROTOCOL_TCP, 7410, 7410);
  RANGE (PORT_PROTOCOL_TCP, 7421, 7421);
  RANGE (PORT_PROTOCOL_TCP, 7426, 7431);
  RANGE (PORT_PROTOCOL_TCP, 7437, 7437);
  RANGE (PORT_PROTOCOL_TCP, 7443, 7443);
  RANGE (PORT_PROTOCOL_TCP, 7473, 7473);
  RANGE (PORT_PROTOCOL_TCP, 7491, 7491);
  RANGE (PORT_PROTOCOL_TCP, 7500, 7501);
  RANGE (PORT_PROTOCOL_TCP, 7508, 7511);
  RANGE (PORT_PROTOCOL_TCP, 7542, 7549);
  RANGE (PORT_PROTOCOL_TCP, 7560, 7560);
  RANGE (PORT_PROTOCOL_TCP, 7563, 7563);
  RANGE (PORT_PROTOCOL_TCP, 7566, 7566);
  RANGE (PORT_PROTOCOL_TCP, 7569, 7570);
  RANGE (PORT_PROTOCOL_TCP, 7588, 7588);
  RANGE (PORT_PROTOCOL_TCP, 7624, 7624);
  RANGE (PORT_PROTOCOL_TCP, 7626, 7631);
  RANGE (PORT_PROTOCOL_TCP, 7633, 7633);
  RANGE (PORT_PROTOCOL_TCP, 7648, 7648);
  RANGE (PORT_PROTOCOL_TCP, 7672, 7677);
  RANGE (PORT_PROTOCOL_TCP, 7680, 7680);
  RANGE (PORT_PROTOCOL_TCP, 7689, 7689);
  RANGE (PORT_PROTOCOL_TCP, 7697, 7697);
  RANGE (PORT_PROTOCOL_TCP, 7700, 7700);
  RANGE (PORT_PROTOCOL_TCP, 7707, 7708);
  RANGE (PORT_PROTOCOL_TCP, 7720, 7720);
  RANGE (PORT_PROTOCOL_TCP, 7724, 7727);
  RANGE (PORT_PROTOCOL_TCP, 7734, 7734);
  RANGE (PORT_PROTOCOL_TCP, 7738, 7738);
  RANGE (PORT_PROTOCOL_TCP, 7741, 7744);
  RANGE (PORT_PROTOCOL_TCP, 7747, 7747);
  RANGE (PORT_PROTOCOL_TCP, 7777, 7779);
  RANGE (PORT_PROTOCOL_TCP, 7781, 7781);
  RANGE (PORT_PROTOCOL_TCP, 7786, 7787);
  RANGE (PORT_PROTOCOL_TCP, 7789, 7789);
  RANGE (PORT_PROTOCOL_TCP, 7794, 7794);
  RANGE (PORT_PROTOCOL_TCP, 7797, 7801);
  RANGE (PORT_PROTOCOL_TCP, 7810, 7810);
  RANGE (PORT_PROTOCOL_TCP, 7845, 7846);
  RANGE (PORT_PROTOCOL_TCP, 7869, 7871);
  RANGE (PORT_PROTOCOL_TCP, 7880, 7880);
  RANGE (PORT_PROTOCOL_TCP, 7887, 7887);
  RANGE (PORT_PROTOCOL_TCP, 7900, 7903);
  RANGE (PORT_PROTOCOL_TCP, 7913, 7913);
  RANGE (PORT_PROTOCOL_TCP, 7932, 7933);
  RANGE (PORT_PROTOCOL_TCP, 7967, 7967);
  RANGE (PORT_PROTOCOL_TCP, 7979, 7982);
  RANGE (PORT_PROTOCOL_TCP, 7997, 7997);
  RANGE (PORT_PROTOCOL_TCP, 7999, 8003);
  RANGE (PORT_PROTOCOL_TCP, 8005, 8005);
  RANGE (PORT_PROTOCOL_TCP, 8008, 8008);
  RANGE (PORT_PROTOCOL_TCP, 8019, 8022);
  RANGE (PORT_PROTOCOL_TCP, 8025, 8026);
  RANGE (PORT_PROTOCOL_TCP, 8032, 8034);
  RANGE (PORT_PROTOCOL_TCP, 8040, 8040);
  RANGE (PORT_PROTOCOL_TCP, 8042, 8044);
  RANGE (PORT_PROTOCOL_TCP, 8051, 8059);
  RANGE (PORT_PROTOCOL_TCP, 8074, 8074);
  RANGE (PORT_PROTOCOL_TCP, 8080, 8083);
  RANGE (PORT_PROTOCOL_TCP, 8086, 8088);
  RANGE (PORT_PROTOCOL_TCP, 8091, 8091);
  RANGE (PORT_PROTOCOL_TCP, 8097, 8097);
  RANGE (PORT_PROTOCOL_TCP, 8100, 8101);
  RANGE (PORT_PROTOCOL_TCP, 8115, 8116);
  RANGE (PORT_PROTOCOL_TCP, 8118, 8118);
  RANGE (PORT_PROTOCOL_TCP, 8121, 8122);
  RANGE (PORT_PROTOCOL_TCP, 8128, 8132);
  RANGE (PORT_PROTOCOL_TCP, 8148, 8148);
  RANGE (PORT_PROTOCOL_TCP, 8160, 8161);
  RANGE (PORT_PROTOCOL_TCP, 8181, 8184);
  RANGE (PORT_PROTOCOL_TCP, 8192, 8192);
  RANGE (PORT_PROTOCOL_TCP, 8194, 8195);
  RANGE (PORT_PROTOCOL_TCP, 8199, 8201);
  RANGE (PORT_PROTOCOL_TCP, 8204, 8208);
  RANGE (PORT_PROTOCOL_TCP, 8230, 8230);
  RANGE (PORT_PROTOCOL_TCP, 8243, 8243);
  RANGE (PORT_PROTOCOL_TCP, 8276, 8276);
  RANGE (PORT_PROTOCOL_TCP, 8280, 8280);
  RANGE (PORT_PROTOCOL_TCP, 8292, 8294);
  RANGE (PORT_PROTOCOL_TCP, 8300, 8301);
  RANGE (PORT_PROTOCOL_TCP, 8320, 8321);
  RANGE (PORT_PROTOCOL_TCP, 8351, 8351);
  RANGE (PORT_PROTOCOL_TCP, 8376, 8380);
  RANGE (PORT_PROTOCOL_TCP, 8383, 8383);
  RANGE (PORT_PROTOCOL_TCP, 8400, 8405);
  RANGE (PORT_PROTOCOL_TCP, 8416, 8417);
  RANGE (PORT_PROTOCOL_TCP, 8442, 8444);
  RANGE (PORT_PROTOCOL_TCP, 8450, 8450);
  RANGE (PORT_PROTOCOL_TCP, 8470, 8474);
  RANGE (PORT_PROTOCOL_TCP, 8500, 8501);
  RANGE (PORT_PROTOCOL_TCP, 8554, 8555);
  RANGE (PORT_PROTOCOL_TCP, 8567, 8567);
  RANGE (PORT_PROTOCOL_TCP, 8600, 8600);
  RANGE (PORT_PROTOCOL_TCP, 8610, 8615);
  RANGE (PORT_PROTOCOL_TCP, 8686, 8686);
  RANGE (PORT_PROTOCOL_TCP, 8699, 8699);
  RANGE (PORT_PROTOCOL_TCP, 8733, 8733);
  RANGE (PORT_PROTOCOL_TCP, 8763, 8765);
  RANGE (PORT_PROTOCOL_TCP, 8770, 8770);
  RANGE (PORT_PROTOCOL_TCP, 8786, 8787);
  RANGE (PORT_PROTOCOL_TCP, 8793, 8793);
  RANGE (PORT_PROTOCOL_TCP, 8800, 8800);
  RANGE (PORT_PROTOCOL_TCP, 8804, 8804);
  RANGE (PORT_PROTOCOL_TCP, 8873, 8873);
  RANGE (PORT_PROTOCOL_TCP, 8880, 8880);
  RANGE (PORT_PROTOCOL_TCP, 8883, 8883);
  RANGE (PORT_PROTOCOL_TCP, 8888, 8894);
  RANGE (PORT_PROTOCOL_TCP, 8899, 8901);
  RANGE (PORT_PROTOCOL_TCP, 8910, 8913);
  RANGE (PORT_PROTOCOL_TCP, 8937, 8937);
  RANGE (PORT_PROTOCOL_TCP, 8953, 8954);
  RANGE (PORT_PROTOCOL_TCP, 8989, 8991);
  RANGE (PORT_PROTOCOL_TCP, 8999, 9002);
  RANGE (PORT_PROTOCOL_TCP, 9008, 9010);
  RANGE (PORT_PROTOCOL_TCP, 9020, 9026);
  RANGE (PORT_PROTOCOL_TCP, 9050, 9051);
  RANGE (PORT_PROTOCOL_TCP, 9080, 9080);
  RANGE (PORT_PROTOCOL_TCP, 9083, 9092);
  RANGE (PORT_PROTOCOL_TCP, 9100, 9107);
  RANGE (PORT_PROTOCOL_TCP, 9119, 9119);
  RANGE (PORT_PROTOCOL_TCP, 9131, 9131);
  RANGE (PORT_PROTOCOL_TCP, 9160, 9164);
  RANGE (PORT_PROTOCOL_TCP, 9191, 9191);
  RANGE (PORT_PROTOCOL_TCP, 9200, 9217);
  RANGE (PORT_PROTOCOL_TCP, 9222, 9222);
  RANGE (PORT_PROTOCOL_TCP, 9255, 9255);
  RANGE (PORT_PROTOCOL_TCP, 9278, 9285);
  RANGE (PORT_PROTOCOL_TCP, 9287, 9287);
  RANGE (PORT_PROTOCOL_TCP, 9292, 9295);
  RANGE (PORT_PROTOCOL_TCP, 9300, 9300);
  RANGE (PORT_PROTOCOL_TCP, 9306, 9306);
  RANGE (PORT_PROTOCOL_TCP, 9312, 9312);
  RANGE (PORT_PROTOCOL_TCP, 9318, 9318);
  RANGE (PORT_PROTOCOL_TCP, 9321, 9321);
  RANGE (PORT_PROTOCOL_TCP, 9343, 9344);
  RANGE (PORT_PROTOCOL_TCP, 9346, 9346);
  RANGE (PORT_PROTOCOL_TCP, 9374, 9374);
  RANGE (PORT_PROTOCOL_TCP, 9380, 9380);
  RANGE (PORT_PROTOCOL_TCP, 9387, 9390);
  RANGE (PORT_PROTOCOL_TCP, 9396, 9397);
  RANGE (PORT_PROTOCOL_TCP, 9400, 9402);
  RANGE (PORT_PROTOCOL_TCP, 9418, 9418);
  RANGE (PORT_PROTOCOL_TCP, 9443, 9445);
  RANGE (PORT_PROTOCOL_TCP, 9450, 9450);
  RANGE (PORT_PROTOCOL_TCP, 9500, 9500);
  RANGE (PORT_PROTOCOL_TCP, 9535, 9536);
  RANGE (PORT_PROTOCOL_TCP, 9555, 9555);
  RANGE (PORT_PROTOCOL_TCP, 9592, 9600);
  RANGE (PORT_PROTOCOL_TCP, 9612, 9612);
  RANGE (PORT_PROTOCOL_TCP, 9614, 9614);
  RANGE (PORT_PROTOCOL_TCP, 9616, 9618);
  RANGE (PORT_PROTOCOL_TCP, 9628, 9631);
  RANGE (PORT_PROTOCOL_TCP, 9640, 9640);
  RANGE (PORT_PROTOCOL_TCP, 9667, 9668);
  RANGE (PORT_PROTOCOL_TCP, 9694, 9695);
  RANGE (PORT_PROTOCOL_TCP, 9700, 9700);
  RANGE (PORT_PROTOCOL_TCP, 9747, 9747);
  RANGE (PORT_PROTOCOL_TCP, 9750, 9750);
  RANGE (PORT_PROTOCOL_TCP, 9753, 9753);
  RANGE (PORT_PROTOCOL_TCP, 9762, 9762);
  RANGE (PORT_PROTOCOL_TCP, 9800, 9802);
  RANGE (PORT_PROTOCOL_TCP, 9875, 9876);
  RANGE (PORT_PROTOCOL_TCP, 9888, 9889);
  RANGE (PORT_PROTOCOL_TCP, 9898, 9900);
  RANGE (PORT_PROTOCOL_TCP, 9909, 9909);
  RANGE (PORT_PROTOCOL_TCP, 9911, 9911);
  RANGE (PORT_PROTOCOL_TCP, 9950, 9954);
  RANGE (PORT_PROTOCOL_TCP, 9966, 9966);
  RANGE (PORT_PROTOCOL_TCP, 9987, 9988);
  RANGE (PORT_PROTOCOL_TCP, 9990, 10005);
  RANGE (PORT_PROTOCOL_TCP, 10007, 10010);
  RANGE (PORT_PROTOCOL_TCP, 10050, 10051);
  RANGE (PORT_PROTOCOL_TCP, 10055, 10055);
  RANGE (PORT_PROTOCOL_TCP, 10080, 10081);
  RANGE (PORT_PROTOCOL_TCP, 10100, 10104);
  RANGE (PORT_PROTOCOL_TCP, 10107, 10107);
  RANGE (PORT_PROTOCOL_TCP, 10110, 10110);
  RANGE (PORT_PROTOCOL_TCP, 10113, 10117);
  RANGE (PORT_PROTOCOL_TCP, 10128, 10129);
  RANGE (PORT_PROTOCOL_TCP, 10160, 10162);
  RANGE (PORT_PROTOCOL_TCP, 10200, 10201);
  RANGE (PORT_PROTOCOL_TCP, 10252, 10252);
  RANGE (PORT_PROTOCOL_TCP, 10260, 10260);
  RANGE (PORT_PROTOCOL_TCP, 10288, 10288);
  RANGE (PORT_PROTOCOL_TCP, 10321, 10321);
  RANGE (PORT_PROTOCOL_TCP, 10540, 10544);
  RANGE (PORT_PROTOCOL_TCP, 10631, 10631);
  RANGE (PORT_PROTOCOL_TCP, 10800, 10800);
  RANGE (PORT_PROTOCOL_TCP, 10805, 10805);
  RANGE (PORT_PROTOCOL_TCP, 10809, 10809);
  RANGE (PORT_PROTOCOL_TCP, 10860, 10860);
  RANGE (PORT_PROTOCOL_TCP, 10990, 10990);
  RANGE (PORT_PROTOCOL_TCP, 11000, 11001);
  RANGE (PORT_PROTOCOL_TCP, 11104, 11106);
  RANGE (PORT_PROTOCOL_TCP, 11111, 11112);
  RANGE (PORT_PROTOCOL_TCP, 11161, 11165);
  RANGE (PORT_PROTOCOL_TCP, 11172, 11172);
  RANGE (PORT_PROTOCOL_TCP, 11174, 11175);
  RANGE (PORT_PROTOCOL_TCP, 11201, 11201);
  RANGE (PORT_PROTOCOL_TCP, 11208, 11208);
  RANGE (PORT_PROTOCOL_TCP, 11211, 11211);
  RANGE (PORT_PROTOCOL_TCP, 11319, 11321);
  RANGE (PORT_PROTOCOL_TCP, 11367, 11367);
  RANGE (PORT_PROTOCOL_TCP, 11371, 11371);
  RANGE (PORT_PROTOCOL_TCP, 11489, 11489);
  RANGE (PORT_PROTOCOL_TCP, 11600, 11600);
  RANGE (PORT_PROTOCOL_TCP, 11720, 11720);
  RANGE (PORT_PROTOCOL_TCP, 11751, 11751);
  RANGE (PORT_PROTOCOL_TCP, 11876, 11876);
  RANGE (PORT_PROTOCOL_TCP, 11967, 11967);
  RANGE (PORT_PROTOCOL_TCP, 12000, 12008);
  RANGE (PORT_PROTOCOL_TCP, 12010, 12010);
  RANGE (PORT_PROTOCOL_TCP, 12012, 12013);
  RANGE (PORT_PROTOCOL_TCP, 12109, 12109);
  RANGE (PORT_PROTOCOL_TCP, 12121, 12121);
  RANGE (PORT_PROTOCOL_TCP, 12168, 12168);
  RANGE (PORT_PROTOCOL_TCP, 12172, 12172);
  RANGE (PORT_PROTOCOL_TCP, 12300, 12300);
  RANGE (PORT_PROTOCOL_TCP, 12321, 12322);
  RANGE (PORT_PROTOCOL_TCP, 12345, 12345);
  RANGE (PORT_PROTOCOL_TCP, 12753, 12753);
  RANGE (PORT_PROTOCOL_TCP, 13160, 13160);
  RANGE (PORT_PROTOCOL_TCP, 13216, 13218);
  RANGE (PORT_PROTOCOL_TCP, 13223, 13224);
  RANGE (PORT_PROTOCOL_TCP, 13400, 13400);
  RANGE (PORT_PROTOCOL_TCP, 13720, 13722);
  RANGE (PORT_PROTOCOL_TCP, 13724, 13724);
  RANGE (PORT_PROTOCOL_TCP, 13782, 13783);
  RANGE (PORT_PROTOCOL_TCP, 13785, 13786);
  RANGE (PORT_PROTOCOL_TCP, 13818, 13823);
  RANGE (PORT_PROTOCOL_TCP, 13929, 13930);
  RANGE (PORT_PROTOCOL_TCP, 14000, 14001);
  RANGE (PORT_PROTOCOL_TCP, 14033, 14034);
  RANGE (PORT_PROTOCOL_TCP, 14141, 14142);
  RANGE (PORT_PROTOCOL_TCP, 14145, 14145);
  RANGE (PORT_PROTOCOL_TCP, 14149, 14150);
  RANGE (PORT_PROTOCOL_TCP, 14154, 14154);
  RANGE (PORT_PROTOCOL_TCP, 14250, 14250);
  RANGE (PORT_PROTOCOL_TCP, 14414, 14414);
  RANGE (PORT_PROTOCOL_TCP, 14936, 14937);
  RANGE (PORT_PROTOCOL_TCP, 15000, 15000);
  RANGE (PORT_PROTOCOL_TCP, 15345, 15345);
  RANGE (PORT_PROTOCOL_TCP, 15363, 15363);
  RANGE (PORT_PROTOCOL_TCP, 15555, 15555);
  RANGE (PORT_PROTOCOL_TCP, 15660, 15660);
  RANGE (PORT_PROTOCOL_TCP, 15740, 15740);
  RANGE (PORT_PROTOCOL_TCP, 15999, 16002);
  RANGE (PORT_PROTOCOL_TCP, 16020, 16021);
  RANGE (PORT_PROTOCOL_TCP, 16161, 16162);
  RANGE (PORT_PROTOCOL_TCP, 16309, 16311);
  RANGE (PORT_PROTOCOL_TCP, 16360, 16361);
  RANGE (PORT_PROTOCOL_TCP, 16367, 16368);
  RANGE (PORT_PROTOCOL_TCP, 16384, 16384);
  RANGE (PORT_PROTOCOL_TCP, 16619, 16619);
  RANGE (PORT_PROTOCOL_TCP, 16900, 16900);
  RANGE (PORT_PROTOCOL_TCP, 16950, 16950);
  RANGE (PORT_PROTOCOL_TCP, 16991, 16995);
  RANGE (PORT_PROTOCOL_TCP, 17007, 17007);
  RANGE (PORT_PROTOCOL_TCP, 17185, 17185);
  RANGE (PORT_PROTOCOL_TCP, 17219, 17219);
  RANGE (PORT_PROTOCOL_TCP, 17221, 17221);
  RANGE (PORT_PROTOCOL_TCP, 17234, 17235);
  RANGE (PORT_PROTOCOL_TCP, 17500, 17500);
  RANGE (PORT_PROTOCOL_TCP, 17729, 17729);
  RANGE (PORT_PROTOCOL_TCP, 17754, 17756);
  RANGE (PORT_PROTOCOL_TCP, 17777, 17777);
  RANGE (PORT_PROTOCOL_TCP, 18000, 18000);
  RANGE (PORT_PROTOCOL_TCP, 18104, 18104);
  RANGE (PORT_PROTOCOL_TCP, 18136, 18136);
  RANGE (PORT_PROTOCOL_TCP, 18181, 18187);
  RANGE (PORT_PROTOCOL_TCP, 18241, 18241);
  RANGE (PORT_PROTOCOL_TCP, 18262, 18262);
  RANGE (PORT_PROTOCOL_TCP, 18463, 18463);
  RANGE (PORT_PROTOCOL_TCP, 18634, 18635);
  RANGE (PORT_PROTOCOL_TCP, 18769, 18769);
  RANGE (PORT_PROTOCOL_TCP, 18881, 18881);
  RANGE (PORT_PROTOCOL_TCP, 18888, 18888);
  RANGE (PORT_PROTOCOL_TCP, 19000, 19000);
  RANGE (PORT_PROTOCOL_TCP, 19020, 19020);
  RANGE (PORT_PROTOCOL_TCP, 19191, 19191);
  RANGE (PORT_PROTOCOL_TCP, 19194, 19194);
  RANGE (PORT_PROTOCOL_TCP, 19283, 19283);
  RANGE (PORT_PROTOCOL_TCP, 19315, 19315);
  RANGE (PORT_PROTOCOL_TCP, 19398, 19398);
  RANGE (PORT_PROTOCOL_TCP, 19410, 19412);
  RANGE (PORT_PROTOCOL_TCP, 19539, 19541);
  RANGE (PORT_PROTOCOL_TCP, 19998, 20003);
  RANGE (PORT_PROTOCOL_TCP, 20005, 20005);
  RANGE (PORT_PROTOCOL_TCP, 20013, 20014);
  RANGE (PORT_PROTOCOL_TCP, 20034, 20034);
  RANGE (PORT_PROTOCOL_TCP, 20046, 20046);
  RANGE (PORT_PROTOCOL_TCP, 20048, 20049);
  RANGE (PORT_PROTOCOL_TCP, 20167, 20167);
  RANGE (PORT_PROTOCOL_TCP, 20202, 20202);
  RANGE (PORT_PROTOCOL_TCP, 20222, 20222);
  RANGE (PORT_PROTOCOL_TCP, 20480, 20480);
  RANGE (PORT_PROTOCOL_TCP, 20670, 20670);
  RANGE (PORT_PROTOCOL_TCP, 20999, 21000);
  RANGE (PORT_PROTOCOL_TCP, 21553, 21554);
  RANGE (PORT_PROTOCOL_TCP, 21590, 21590);
  RANGE (PORT_PROTOCOL_TCP, 21800, 21800);
  RANGE (PORT_PROTOCOL_TCP, 21845, 21849);
  RANGE (PORT_PROTOCOL_TCP, 22000, 22005);
  RANGE (PORT_PROTOCOL_TCP, 22125, 22125);
  RANGE (PORT_PROTOCOL_TCP, 22128, 22128);
  RANGE (PORT_PROTOCOL_TCP, 22273, 22273);
  RANGE (PORT_PROTOCOL_TCP, 22305, 22305);
  RANGE (PORT_PROTOCOL_TCP, 22343, 22343);
  RANGE (PORT_PROTOCOL_TCP, 22347, 22347);
  RANGE (PORT_PROTOCOL_TCP, 22350, 22350);
  RANGE (PORT_PROTOCOL_TCP, 22537, 22537);
  RANGE (PORT_PROTOCOL_TCP, 22555, 22555);
  RANGE (PORT_PROTOCOL_TCP, 22763, 22763);
  RANGE (PORT_PROTOCOL_TCP, 22800, 22800);
  RANGE (PORT_PROTOCOL_TCP, 22951, 22951);
  RANGE (PORT_PROTOCOL_TCP, 23000, 23005);
  RANGE (PORT_PROTOCOL_TCP, 23053, 23053);
  RANGE (PORT_PROTOCOL_TCP, 23333, 23333);
  RANGE (PORT_PROTOCOL_TCP, 23400, 23402);
  RANGE (PORT_PROTOCOL_TCP, 23456, 23457);
  RANGE (PORT_PROTOCOL_TCP, 24000, 24006);
  RANGE (PORT_PROTOCOL_TCP, 24242, 24242);
  RANGE (PORT_PROTOCOL_TCP, 24249, 24249);
  RANGE (PORT_PROTOCOL_TCP, 24321, 24321);
  RANGE (PORT_PROTOCOL_TCP, 24386, 24386);
  RANGE (PORT_PROTOCOL_TCP, 24465, 24465);
  RANGE (PORT_PROTOCOL_TCP, 24554, 24554);
  RANGE (PORT_PROTOCOL_TCP, 24676, 24678);
  RANGE (PORT_PROTOCOL_TCP, 24680, 24680);
  RANGE (PORT_PROTOCOL_TCP, 24754, 24754);
  RANGE (PORT_PROTOCOL_TCP, 24922, 24922);
  RANGE (PORT_PROTOCOL_TCP, 25000, 25009);
  RANGE (PORT_PROTOCOL_TCP, 25576, 25576);
  RANGE (PORT_PROTOCOL_TCP, 25604, 25604);
  RANGE (PORT_PROTOCOL_TCP, 25793, 25793);
  RANGE (PORT_PROTOCOL_TCP, 25900, 25903);
  RANGE (PORT_PROTOCOL_TCP, 26000, 26000);
  RANGE (PORT_PROTOCOL_TCP, 26133, 26133);
  RANGE (PORT_PROTOCOL_TCP, 26208, 26208);
  RANGE (PORT_PROTOCOL_TCP, 26260, 26263);
  RANGE (PORT_PROTOCOL_TCP, 26486, 26487);
  RANGE (PORT_PROTOCOL_TCP, 26489, 26489);
  RANGE (PORT_PROTOCOL_TCP, 27345, 27345);
  RANGE (PORT_PROTOCOL_TCP, 27442, 27442);
  RANGE (PORT_PROTOCOL_TCP, 27504, 27504);
  RANGE (PORT_PROTOCOL_TCP, 27782, 27782);
  RANGE (PORT_PROTOCOL_TCP, 27999, 28001);
  RANGE (PORT_PROTOCOL_TCP, 28240, 28240);
  RANGE (PORT_PROTOCOL_TCP, 29167, 29167);
  RANGE (PORT_PROTOCOL_TCP, 30001, 30002);
  RANGE (PORT_PROTOCOL_TCP, 30260, 30260);
  RANGE (PORT_PROTOCOL_TCP, 30999, 30999);
  RANGE (PORT_PROTOCOL_TCP, 31020, 31020);
  RANGE (PORT_PROTOCOL_TCP, 31416, 31416);
  RANGE (PORT_PROTOCOL_TCP, 31457, 31457);
  RANGE (PORT_PROTOCOL_TCP, 31620, 31620);
  RANGE (PORT_PROTOCOL_TCP, 31685, 31685);
  RANGE (PORT_PROTOCOL_TCP, 31765, 31765);
  RANGE (PORT_PROTOCOL_TCP, 31948, 31949);
  RANGE (PORT_PROTOCOL_TCP, 32034, 32034);
  RANGE (PORT_PROTOCOL_TCP, 32249, 32249);
  RANGE (PORT_PROTOCOL_TCP, 32483, 32483);
  RANGE (PORT_PROTOCOL_TCP, 32635, 32636);
  RANGE (PORT_PROTOCOL_TCP, 32767, 32777);
  RANGE (PORT_PROTOCOL_TCP, 32801, 32801);
  RANGE (PORT_PROTOCOL_TCP, 32811, 32811);
  RANGE (PORT_PROTOCOL_TCP, 32896, 32896);
  RANGE (PORT_PROTOCOL_TCP, 33123, 33123);
  RANGE (PORT_PROTOCOL_TCP, 33331, 33331);
  RANGE (PORT_PROTOCOL_TCP, 33333, 33334);
  RANGE (PORT_PROTOCOL_TCP, 33434, 33434);
  RANGE (PORT_PROTOCOL_TCP, 33656, 33656);
  RANGE (PORT_PROTOCOL_TCP, 34249, 34249);
  RANGE (PORT_PROTOCOL_TCP, 34378, 34379);
  RANGE (PORT_PROTOCOL_TCP, 34567, 34567);
  RANGE (PORT_PROTOCOL_TCP, 34962, 34964);
  RANGE (PORT_PROTOCOL_TCP, 34980, 34980);
  RANGE (PORT_PROTOCOL_TCP, 35354, 35357);
  RANGE (PORT_PROTOCOL_TCP, 36001, 36001);
  RANGE (PORT_PROTOCOL_TCP, 36524, 36524);
  RANGE (PORT_PROTOCOL_TCP, 36865, 36865);
  RANGE (PORT_PROTOCOL_TCP, 37475, 37475);
  RANGE (PORT_PROTOCOL_TCP, 37654, 37654);
  RANGE (PORT_PROTOCOL_TCP, 38201, 38203);
  RANGE (PORT_PROTOCOL_TCP, 39681, 39681);
  RANGE (PORT_PROTOCOL_TCP, 40000, 40000);
  RANGE (PORT_PROTOCOL_TCP, 40841, 40843);
  RANGE (PORT_PROTOCOL_TCP, 41111, 41111);
  RANGE (PORT_PROTOCOL_TCP, 41121, 41121);
  RANGE (PORT_PROTOCOL_TCP, 41794, 41795);
  RANGE (PORT_PROTOCOL_TCP, 42508, 42510);
  RANGE (PORT_PROTOCOL_TCP, 43188, 43191);
  RANGE (PORT_PROTOCOL_TCP, 43439, 43441);
  RANGE (PORT_PROTOCOL_TCP, 44321, 44322);
  RANGE (PORT_PROTOCOL_TCP, 44553, 44553);
  RANGE (PORT_PROTOCOL_TCP, 44818, 44818);
  RANGE (PORT_PROTOCOL_TCP, 45000, 45001);
  RANGE (PORT_PROTOCOL_TCP, 45054, 45054);
  RANGE (PORT_PROTOCOL_TCP, 45678, 45678);
  RANGE (PORT_PROTOCOL_TCP, 45825, 45825);
  RANGE (PORT_PROTOCOL_TCP, 45966, 45966);
  RANGE (PORT_PROTOCOL_TCP, 46999, 47001);
  RANGE (PORT_PROTOCOL_TCP, 47557, 47557);
  RANGE (PORT_PROTOCOL_TCP, 47624, 47624);
  RANGE (PORT_PROTOCOL_TCP, 47806, 47806);
  RANGE (PORT_PROTOCOL_TCP, 47808, 47808);
  RANGE (PORT_PROTOCOL_TCP, 48000, 48005);
  RANGE (PORT_PROTOCOL_TCP, 48049, 48049);
  RANGE (PORT_PROTOCOL_TCP, 48128, 48129);
  RANGE (PORT_PROTOCOL_TCP, 48556, 48556);
  RANGE (PORT_PROTOCOL_TCP, 48619, 48619);

  RANGE (PORT_PROTOCOL_UDP, 1, 80);
  RANGE (PORT_PROTOCOL_UDP, 82, 99);
  RANGE (PORT_PROTOCOL_UDP, 101, 113);
  RANGE (PORT_PROTOCOL_UDP, 115, 224);
  RANGE (PORT_PROTOCOL_UDP, 242, 248);
  RANGE (PORT_PROTOCOL_UDP, 256, 257);
  RANGE (PORT_PROTOCOL_UDP, 259, 270);
  RANGE (PORT_PROTOCOL_UDP, 280, 284);
  RANGE (PORT_PROTOCOL_UDP, 286, 287);
  RANGE (PORT_PROTOCOL_UDP, 308, 322);
  RANGE (PORT_PROTOCOL_UDP, 333, 333);
  RANGE (PORT_PROTOCOL_UDP, 344, 584);
  RANGE (PORT_PROTOCOL_UDP, 586, 658);
  RANGE (PORT_PROTOCOL_UDP, 660, 702);
  RANGE (PORT_PROTOCOL_UDP, 704, 707);
  RANGE (PORT_PROTOCOL_UDP, 709, 716);
  RANGE (PORT_PROTOCOL_UDP, 729, 731);
  RANGE (PORT_PROTOCOL_UDP, 741, 742);
  RANGE (PORT_PROTOCOL_UDP, 744, 744);
  RANGE (PORT_PROTOCOL_UDP, 747, 754);
  RANGE (PORT_PROTOCOL_UDP, 758, 765);
  RANGE (PORT_PROTOCOL_UDP, 767, 767);
  RANGE (PORT_PROTOCOL_UDP, 769, 777);
  RANGE (PORT_PROTOCOL_UDP, 780, 780);
  RANGE (PORT_PROTOCOL_UDP, 800, 801);
  RANGE (PORT_PROTOCOL_UDP, 810, 810);
  RANGE (PORT_PROTOCOL_UDP, 828, 833);
  RANGE (PORT_PROTOCOL_UDP, 847, 848);
  RANGE (PORT_PROTOCOL_UDP, 860, 862);
  RANGE (PORT_PROTOCOL_UDP, 873, 873);
  RANGE (PORT_PROTOCOL_UDP, 886, 888);
  RANGE (PORT_PROTOCOL_UDP, 900, 903);
  RANGE (PORT_PROTOCOL_UDP, 910, 913);
  RANGE (PORT_PROTOCOL_UDP, 989, 993);
  RANGE (PORT_PROTOCOL_UDP, 995, 1000);
  RANGE (PORT_PROTOCOL_UDP, 1008, 1008);
  RANGE (PORT_PROTOCOL_UDP, 1010, 1010);
  RANGE (PORT_PROTOCOL_UDP, 1021, 1022);
  RANGE (PORT_PROTOCOL_UDP, 1025, 1026);
  RANGE (PORT_PROTOCOL_UDP, 1029, 1108);
  RANGE (PORT_PROTOCOL_UDP, 1110, 1490);
  RANGE (PORT_PROTOCOL_UDP, 1492, 1527);
  RANGE (PORT_PROTOCOL_UDP, 1529, 1643);
  RANGE (PORT_PROTOCOL_UDP, 1645, 1752);
  RANGE (PORT_PROTOCOL_UDP, 1754, 1774);
  RANGE (PORT_PROTOCOL_UDP, 1776, 1782);
  RANGE (PORT_PROTOCOL_UDP, 1784, 2187);
  RANGE (PORT_PROTOCOL_UDP, 2190, 2193);
  RANGE (PORT_PROTOCOL_UDP, 2197, 2224);
  RANGE (PORT_PROTOCOL_UDP, 2226, 2258);
  RANGE (PORT_PROTOCOL_UDP, 2260, 2368);
  RANGE (PORT_PROTOCOL_UDP, 2370, 2372);
  RANGE (PORT_PROTOCOL_UDP, 2381, 2425);
  RANGE (PORT_PROTOCOL_UDP, 2427, 2563);
  RANGE (PORT_PROTOCOL_UDP, 2565, 2681);
  RANGE (PORT_PROTOCOL_UDP, 2683, 2793);
  RANGE (PORT_PROTOCOL_UDP, 2795, 2824);
  RANGE (PORT_PROTOCOL_UDP, 2826, 2872);
  RANGE (PORT_PROTOCOL_UDP, 2874, 2924);
  RANGE (PORT_PROTOCOL_UDP, 2926, 3000);
  RANGE (PORT_PROTOCOL_UDP, 3002, 3091);
  RANGE (PORT_PROTOCOL_UDP, 3093, 3096);
  RANGE (PORT_PROTOCOL_UDP, 3098, 3120);
  RANGE (PORT_PROTOCOL_UDP, 3122, 3125);
  RANGE (PORT_PROTOCOL_UDP, 3127, 3299);
  RANGE (PORT_PROTOCOL_UDP, 3302, 3321);
  RANGE (PORT_PROTOCOL_UDP, 3326, 3366);
  RANGE (PORT_PROTOCOL_UDP, 3372, 3402);
  RANGE (PORT_PROTOCOL_UDP, 3405, 3453);
  RANGE (PORT_PROTOCOL_UDP, 3455, 3545);
  RANGE (PORT_PROTOCOL_UDP, 3547, 3564);
  RANGE (PORT_PROTOCOL_UDP, 3567, 3692);
  RANGE (PORT_PROTOCOL_UDP, 3695, 3736);
  RANGE (PORT_PROTOCOL_UDP, 3738, 3765);
  RANGE (PORT_PROTOCOL_UDP, 3767, 3863);
  RANGE (PORT_PROTOCOL_UDP, 3865, 3867);
  RANGE (PORT_PROTOCOL_UDP, 3869, 3993);
  RANGE (PORT_PROTOCOL_UDP, 3995, 4047);
  RANGE (PORT_PROTOCOL_UDP, 4049, 4077);
  RANGE (PORT_PROTOCOL_UDP, 4079, 4084);
  RANGE (PORT_PROTOCOL_UDP, 4086, 4086);
  RANGE (PORT_PROTOCOL_UDP, 4089, 4119);
  RANGE (PORT_PROTOCOL_UDP, 4121, 4143);
  RANGE (PORT_PROTOCOL_UDP, 4145, 4169);
  RANGE (PORT_PROTOCOL_UDP, 4172, 4174);
  RANGE (PORT_PROTOCOL_UDP, 4177, 4185);
  RANGE (PORT_PROTOCOL_UDP, 4188, 4188);
  RANGE (PORT_PROTOCOL_UDP, 4191, 4192);
  RANGE (PORT_PROTOCOL_UDP, 4199, 4199);
  RANGE (PORT_PROTOCOL_UDP, 4300, 4310);
  RANGE (PORT_PROTOCOL_UDP, 4320, 4328);
  RANGE (PORT_PROTOCOL_UDP, 4340, 4359);
  RANGE (PORT_PROTOCOL_UDP, 4361, 4362);
  RANGE (PORT_PROTOCOL_UDP, 4368, 4373);
  RANGE (PORT_PROTOCOL_UDP, 4375, 4379);
  RANGE (PORT_PROTOCOL_UDP, 4389, 4390);
  RANGE (PORT_PROTOCOL_UDP, 4394, 4395);
  RANGE (PORT_PROTOCOL_UDP, 4400, 4406);
  RANGE (PORT_PROTOCOL_UDP, 4425, 4426);
  RANGE (PORT_PROTOCOL_UDP, 4430, 4430);
  RANGE (PORT_PROTOCOL_UDP, 4441, 4458);
  RANGE (PORT_PROTOCOL_UDP, 4484, 4484);
  RANGE (PORT_PROTOCOL_UDP, 4486, 4486);
  RANGE (PORT_PROTOCOL_UDP, 4488, 4488);
  RANGE (PORT_PROTOCOL_UDP, 4500, 4500);
  RANGE (PORT_PROTOCOL_UDP, 4535, 4538);
  RANGE (PORT_PROTOCOL_UDP, 4545, 4552);
  RANGE (PORT_PROTOCOL_UDP, 4554, 4559);
  RANGE (PORT_PROTOCOL_UDP, 4566, 4569);
  RANGE (PORT_PROTOCOL_UDP, 4591, 4601);
  RANGE (PORT_PROTOCOL_UDP, 4658, 4692);
  RANGE (PORT_PROTOCOL_UDP, 4700, 4702);
  RANGE (PORT_PROTOCOL_UDP, 4725, 4730);
  RANGE (PORT_PROTOCOL_UDP, 4732, 4732);
  RANGE (PORT_PROTOCOL_UDP, 4737, 4745);
  RANGE (PORT_PROTOCOL_UDP, 4749, 4752);
  RANGE (PORT_PROTOCOL_UDP, 4784, 4785);
  RANGE (PORT_PROTOCOL_UDP, 4800, 4804);
  RANGE (PORT_PROTOCOL_UDP, 4827, 4827);
  RANGE (PORT_PROTOCOL_UDP, 4837, 4851);
  RANGE (PORT_PROTOCOL_UDP, 4867, 4871);
  RANGE (PORT_PROTOCOL_UDP, 4876, 4878);
  RANGE (PORT_PROTOCOL_UDP, 4881, 4882);
  RANGE (PORT_PROTOCOL_UDP, 4884, 4885);
  RANGE (PORT_PROTOCOL_UDP, 4894, 4894);
  RANGE (PORT_PROTOCOL_UDP, 4899, 4900);
  RANGE (PORT_PROTOCOL_UDP, 4914, 4914);
  RANGE (PORT_PROTOCOL_UDP, 4937, 4937);
  RANGE (PORT_PROTOCOL_UDP, 4940, 4942);
  RANGE (PORT_PROTOCOL_UDP, 4949, 4952);
  RANGE (PORT_PROTOCOL_UDP, 4969, 4970);
  RANGE (PORT_PROTOCOL_UDP, 4986, 4991);
  RANGE (PORT_PROTOCOL_UDP, 4999, 5014);
  RANGE (PORT_PROTOCOL_UDP, 5020, 5027);
  RANGE (PORT_PROTOCOL_UDP, 5029, 5031);
  RANGE (PORT_PROTOCOL_UDP, 5042, 5044);
  RANGE (PORT_PROTOCOL_UDP, 5046, 5047);
  RANGE (PORT_PROTOCOL_UDP, 5049, 5052);
  RANGE (PORT_PROTOCOL_UDP, 5055, 5062);
  RANGE (PORT_PROTOCOL_UDP, 5064, 5067);
  RANGE (PORT_PROTOCOL_UDP, 5069, 5074);
  RANGE (PORT_PROTOCOL_UDP, 5079, 5085);
  RANGE (PORT_PROTOCOL_UDP, 5092, 5094);
  RANGE (PORT_PROTOCOL_UDP, 5099, 5102);
  RANGE (PORT_PROTOCOL_UDP, 5104, 5105);
  RANGE (PORT_PROTOCOL_UDP, 5111, 5112);
  RANGE (PORT_PROTOCOL_UDP, 5116, 5116);
  RANGE (PORT_PROTOCOL_UDP, 5133, 5133);
  RANGE (PORT_PROTOCOL_UDP, 5136, 5137);
  RANGE (PORT_PROTOCOL_UDP, 5145, 5145);
  RANGE (PORT_PROTOCOL_UDP, 5150, 5152);
  RANGE (PORT_PROTOCOL_UDP, 5154, 5155);
  RANGE (PORT_PROTOCOL_UDP, 5164, 5168);
  RANGE (PORT_PROTOCOL_UDP, 5190, 5193);
  RANGE (PORT_PROTOCOL_UDP, 5200, 5203);
  RANGE (PORT_PROTOCOL_UDP, 5223, 5227);
  RANGE (PORT_PROTOCOL_UDP, 5234, 5237);
  RANGE (PORT_PROTOCOL_UDP, 5245, 5252);
  RANGE (PORT_PROTOCOL_UDP, 5264, 5265);
  RANGE (PORT_PROTOCOL_UDP, 5270, 5272);
  RANGE (PORT_PROTOCOL_UDP, 5282, 5282);
  RANGE (PORT_PROTOCOL_UDP, 5298, 5310);
  RANGE (PORT_PROTOCOL_UDP, 5312, 5316);
  RANGE (PORT_PROTOCOL_UDP, 5343, 5344);
  RANGE (PORT_PROTOCOL_UDP, 5349, 5363);
  RANGE (PORT_PROTOCOL_UDP, 5397, 5437);
  RANGE (PORT_PROTOCOL_UDP, 5443, 5443);
  RANGE (PORT_PROTOCOL_UDP, 5453, 5456);
  RANGE (PORT_PROTOCOL_UDP, 5461, 5465);
  RANGE (PORT_PROTOCOL_UDP, 5500, 5506);
  RANGE (PORT_PROTOCOL_UDP, 5553, 5556);
  RANGE (PORT_PROTOCOL_UDP, 5567, 5568);
  RANGE (PORT_PROTOCOL_UDP, 5573, 5573);
  RANGE (PORT_PROTOCOL_UDP, 5580, 5585);
  RANGE (PORT_PROTOCOL_UDP, 5597, 5605);
  RANGE (PORT_PROTOCOL_UDP, 5627, 5634);
  RANGE (PORT_PROTOCOL_UDP, 5671, 5683);
  RANGE (PORT_PROTOCOL_UDP, 5688, 5689);
  RANGE (PORT_PROTOCOL_UDP, 5713, 5724);
  RANGE (PORT_PROTOCOL_UDP, 5728, 5730);
  RANGE (PORT_PROTOCOL_UDP, 5741, 5748);
  RANGE (PORT_PROTOCOL_UDP, 5750, 5750);
  RANGE (PORT_PROTOCOL_UDP, 5755, 5755);
  RANGE (PORT_PROTOCOL_UDP, 5757, 5757);
  RANGE (PORT_PROTOCOL_UDP, 5766, 5771);
  RANGE (PORT_PROTOCOL_UDP, 5777, 5777);
  RANGE (PORT_PROTOCOL_UDP, 5781, 5787);
  RANGE (PORT_PROTOCOL_UDP, 5793, 5794);
  RANGE (PORT_PROTOCOL_UDP, 5813, 5814);
  RANGE (PORT_PROTOCOL_UDP, 5859, 5859);
  RANGE (PORT_PROTOCOL_UDP, 5863, 5863);
  RANGE (PORT_PROTOCOL_UDP, 5900, 5900);
  RANGE (PORT_PROTOCOL_UDP, 5910, 5913);
  RANGE (PORT_PROTOCOL_UDP, 5963, 5963);
  RANGE (PORT_PROTOCOL_UDP, 5968, 5969);
  RANGE (PORT_PROTOCOL_UDP, 5984, 5992);
  RANGE (PORT_PROTOCOL_UDP, 5999, 6000);
  RANGE (PORT_PROTOCOL_UDP, 6061, 6066);
  RANGE (PORT_PROTOCOL_UDP, 6069, 6074);
  RANGE (PORT_PROTOCOL_UDP, 6082, 6083);
  RANGE (PORT_PROTOCOL_UDP, 6085, 6087);
  RANGE (PORT_PROTOCOL_UDP, 6100, 6112);
  RANGE (PORT_PROTOCOL_UDP, 6122, 6124);
  RANGE (PORT_PROTOCOL_UDP, 6133, 6133);
  RANGE (PORT_PROTOCOL_UDP, 6140, 6149);
  RANGE (PORT_PROTOCOL_UDP, 6160, 6163);
  RANGE (PORT_PROTOCOL_UDP, 6200, 6200);
  RANGE (PORT_PROTOCOL_UDP, 6222, 6222);
  RANGE (PORT_PROTOCOL_UDP, 6241, 6244);
  RANGE (PORT_PROTOCOL_UDP, 6251, 6253);
  RANGE (PORT_PROTOCOL_UDP, 6268, 6269);
  RANGE (PORT_PROTOCOL_UDP, 6300, 6301);
  RANGE (PORT_PROTOCOL_UDP, 6306, 6306);
  RANGE (PORT_PROTOCOL_UDP, 6315, 6316);
  RANGE (PORT_PROTOCOL_UDP, 6320, 6322);
  RANGE (PORT_PROTOCOL_UDP, 6324, 6324);
  RANGE (PORT_PROTOCOL_UDP, 6343, 6343);
  RANGE (PORT_PROTOCOL_UDP, 6346, 6347);
  RANGE (PORT_PROTOCOL_UDP, 6350, 6350);
  RANGE (PORT_PROTOCOL_UDP, 6355, 6355);
  RANGE (PORT_PROTOCOL_UDP, 6360, 6360);
  RANGE (PORT_PROTOCOL_UDP, 6370, 6370);
  RANGE (PORT_PROTOCOL_UDP, 6382, 6382);
  RANGE (PORT_PROTOCOL_UDP, 6389, 6390);
  RANGE (PORT_PROTOCOL_UDP, 6417, 6417);
  RANGE (PORT_PROTOCOL_UDP, 6420, 6421);
  RANGE (PORT_PROTOCOL_UDP, 6443, 6446);
  RANGE (PORT_PROTOCOL_UDP, 6456, 6456);
  RANGE (PORT_PROTOCOL_UDP, 6471, 6471);
  RANGE (PORT_PROTOCOL_UDP, 6480, 6489);
  RANGE (PORT_PROTOCOL_UDP, 6500, 6503);
  RANGE (PORT_PROTOCOL_UDP, 6505, 6510);
  RANGE (PORT_PROTOCOL_UDP, 6514, 6515);
  RANGE (PORT_PROTOCOL_UDP, 6543, 6544);
  RANGE (PORT_PROTOCOL_UDP, 6547, 6551);
  RANGE (PORT_PROTOCOL_UDP, 6558, 6558);
  RANGE (PORT_PROTOCOL_UDP, 6566, 6566);
  RANGE (PORT_PROTOCOL_UDP, 6568, 6568);
  RANGE (PORT_PROTOCOL_UDP, 6579, 6583);
  RANGE (PORT_PROTOCOL_UDP, 6619, 6623);
  RANGE (PORT_PROTOCOL_UDP, 6626, 6628);
  RANGE (PORT_PROTOCOL_UDP, 6657, 6657);
  RANGE (PORT_PROTOCOL_UDP, 6670, 6673);
  RANGE (PORT_PROTOCOL_UDP, 6678, 6679);
  RANGE (PORT_PROTOCOL_UDP, 6689, 6689);
  RANGE (PORT_PROTOCOL_UDP, 6696, 6696);
  RANGE (PORT_PROTOCOL_UDP, 6701, 6703);
  RANGE (PORT_PROTOCOL_UDP, 6714, 6715);
  RANGE (PORT_PROTOCOL_UDP, 6767, 6771);
  RANGE (PORT_PROTOCOL_UDP, 6785, 6791);
  RANGE (PORT_PROTOCOL_UDP, 6801, 6801);
  RANGE (PORT_PROTOCOL_UDP, 6831, 6831);
  RANGE (PORT_PROTOCOL_UDP, 6841, 6842);
  RANGE (PORT_PROTOCOL_UDP, 6850, 6850);
  RANGE (PORT_PROTOCOL_UDP, 6868, 6868);
  RANGE (PORT_PROTOCOL_UDP, 6888, 6888);
  RANGE (PORT_PROTOCOL_UDP, 6935, 6936);
  RANGE (PORT_PROTOCOL_UDP, 6946, 6946);
  RANGE (PORT_PROTOCOL_UDP, 6951, 6951);
  RANGE (PORT_PROTOCOL_UDP, 6961, 6966);
  RANGE (PORT_PROTOCOL_UDP, 6969, 6969);
  RANGE (PORT_PROTOCOL_UDP, 6997, 7015);
  RANGE (PORT_PROTOCOL_UDP, 7019, 7025);
  RANGE (PORT_PROTOCOL_UDP, 7030, 7030);
  RANGE (PORT_PROTOCOL_UDP, 7070, 7071);
  RANGE (PORT_PROTOCOL_UDP, 7080, 7080);
  RANGE (PORT_PROTOCOL_UDP, 7099, 7101);
  RANGE (PORT_PROTOCOL_UDP, 7107, 7107);
  RANGE (PORT_PROTOCOL_UDP, 7121, 7121);
  RANGE (PORT_PROTOCOL_UDP, 7128, 7129);
  RANGE (PORT_PROTOCOL_UDP, 7161, 7166);
  RANGE (PORT_PROTOCOL_UDP, 7169, 7171);
  RANGE (PORT_PROTOCOL_UDP, 7174, 7174);
  RANGE (PORT_PROTOCOL_UDP, 7200, 7201);
  RANGE (PORT_PROTOCOL_UDP, 7227, 7227);
  RANGE (PORT_PROTOCOL_UDP, 7262, 7262);
  RANGE (PORT_PROTOCOL_UDP, 7272, 7282);
  RANGE (PORT_PROTOCOL_UDP, 7365, 7365);
  RANGE (PORT_PROTOCOL_UDP, 7391, 7395);
  RANGE (PORT_PROTOCOL_UDP, 7397, 7397);
  RANGE (PORT_PROTOCOL_UDP, 7400, 7402);
  RANGE (PORT_PROTOCOL_UDP, 7410, 7410);
  RANGE (PORT_PROTOCOL_UDP, 7421, 7421);
  RANGE (PORT_PROTOCOL_UDP, 7426, 7431);
  RANGE (PORT_PROTOCOL_UDP, 7437, 7437);
  RANGE (PORT_PROTOCOL_UDP, 7443, 7443);
  RANGE (PORT_PROTOCOL_UDP, 7473, 7473);
  RANGE (PORT_PROTOCOL_UDP, 7491, 7491);
  RANGE (PORT_PROTOCOL_UDP, 7500, 7501);
  RANGE (PORT_PROTOCOL_UDP, 7510, 7511);
  RANGE (PORT_PROTOCOL_UDP, 7542, 7550);
  RANGE (PORT_PROTOCOL_UDP, 7560, 7560);
  RANGE (PORT_PROTOCOL_UDP, 7566, 7566);
  RANGE (PORT_PROTOCOL_UDP, 7570, 7570);
  RANGE (PORT_PROTOCOL_UDP, 7588, 7588);
  RANGE (PORT_PROTOCOL_UDP, 7624, 7624);
  RANGE (PORT_PROTOCOL_UDP, 7626, 7629);
  RANGE (PORT_PROTOCOL_UDP, 7633, 7633);
  RANGE (PORT_PROTOCOL_UDP, 7648, 7648);
  RANGE (PORT_PROTOCOL_UDP, 7674, 7677);
  RANGE (PORT_PROTOCOL_UDP, 7680, 7680);
  RANGE (PORT_PROTOCOL_UDP, 7689, 7689);
  RANGE (PORT_PROTOCOL_UDP, 7697, 7697);
  RANGE (PORT_PROTOCOL_UDP, 7707, 7708);
  RANGE (PORT_PROTOCOL_UDP, 7720, 7720);
  RANGE (PORT_PROTOCOL_UDP, 7724, 7727);
  RANGE (PORT_PROTOCOL_UDP, 7734, 7734);
  RANGE (PORT_PROTOCOL_UDP, 7738, 7738);
  RANGE (PORT_PROTOCOL_UDP, 7741, 7741);
  RANGE (PORT_PROTOCOL_UDP, 7743, 7744);
  RANGE (PORT_PROTOCOL_UDP, 7747, 7747);
  RANGE (PORT_PROTOCOL_UDP, 7777, 7779);
  RANGE (PORT_PROTOCOL_UDP, 7781, 7781);
  RANGE (PORT_PROTOCOL_UDP, 7786, 7787);
  RANGE (PORT_PROTOCOL_UDP, 7789, 7789);
  RANGE (PORT_PROTOCOL_UDP, 7794, 7794);
  RANGE (PORT_PROTOCOL_UDP, 7797, 7801);
  RANGE (PORT_PROTOCOL_UDP, 7810, 7810);
  RANGE (PORT_PROTOCOL_UDP, 7845, 7846);
  RANGE (PORT_PROTOCOL_UDP, 7880, 7880);
  RANGE (PORT_PROTOCOL_UDP, 7887, 7887);
  RANGE (PORT_PROTOCOL_UDP, 7900, 7903);
  RANGE (PORT_PROTOCOL_UDP, 7913, 7913);
  RANGE (PORT_PROTOCOL_UDP, 7932, 7933);
  RANGE (PORT_PROTOCOL_UDP, 7967, 7967);
  RANGE (PORT_PROTOCOL_UDP, 7979, 7980);
  RANGE (PORT_PROTOCOL_UDP, 7982, 7982);
  RANGE (PORT_PROTOCOL_UDP, 7998, 8003);
  RANGE (PORT_PROTOCOL_UDP, 8005, 8005);
  RANGE (PORT_PROTOCOL_UDP, 8008, 8008);
  RANGE (PORT_PROTOCOL_UDP, 8019, 8022);
  RANGE (PORT_PROTOCOL_UDP, 8025, 8026);
  RANGE (PORT_PROTOCOL_UDP, 8032, 8034);
  RANGE (PORT_PROTOCOL_UDP, 8040, 8040);
  RANGE (PORT_PROTOCOL_UDP, 8052, 8059);
  RANGE (PORT_PROTOCOL_UDP, 8074, 8074);
  RANGE (PORT_PROTOCOL_UDP, 8080, 8083);
  RANGE (PORT_PROTOCOL_UDP, 8086, 8088);
  RANGE (PORT_PROTOCOL_UDP, 8097, 8097);
  RANGE (PORT_PROTOCOL_UDP, 8100, 8100);
  RANGE (PORT_PROTOCOL_UDP, 8115, 8116);
  RANGE (PORT_PROTOCOL_UDP, 8118, 8118);
  RANGE (PORT_PROTOCOL_UDP, 8121, 8122);
  RANGE (PORT_PROTOCOL_UDP, 8128, 8132);
  RANGE (PORT_PROTOCOL_UDP, 8148, 8149);
  RANGE (PORT_PROTOCOL_UDP, 8160, 8161);
  RANGE (PORT_PROTOCOL_UDP, 8182, 8182);
  RANGE (PORT_PROTOCOL_UDP, 8184, 8184);
  RANGE (PORT_PROTOCOL_UDP, 8192, 8192);
  RANGE (PORT_PROTOCOL_UDP, 8194, 8195);
  RANGE (PORT_PROTOCOL_UDP, 8199, 8202);
  RANGE (PORT_PROTOCOL_UDP, 8204, 8208);
  RANGE (PORT_PROTOCOL_UDP, 8230, 8230);
  RANGE (PORT_PROTOCOL_UDP, 8243, 8243);
  RANGE (PORT_PROTOCOL_UDP, 8276, 8276);
  RANGE (PORT_PROTOCOL_UDP, 8280, 8280);
  RANGE (PORT_PROTOCOL_UDP, 8292, 8292);
  RANGE (PORT_PROTOCOL_UDP, 8294, 8294);
  RANGE (PORT_PROTOCOL_UDP, 8300, 8301);
  RANGE (PORT_PROTOCOL_UDP, 8320, 8321);
  RANGE (PORT_PROTOCOL_UDP, 8351, 8351);
  RANGE (PORT_PROTOCOL_UDP, 8376, 8380);
  RANGE (PORT_PROTOCOL_UDP, 8383, 8383);
  RANGE (PORT_PROTOCOL_UDP, 8400, 8403);
  RANGE (PORT_PROTOCOL_UDP, 8416, 8417);
  RANGE (PORT_PROTOCOL_UDP, 8442, 8444);
  RANGE (PORT_PROTOCOL_UDP, 8450, 8450);
  RANGE (PORT_PROTOCOL_UDP, 8472, 8474);
  RANGE (PORT_PROTOCOL_UDP, 8500, 8501);
  RANGE (PORT_PROTOCOL_UDP, 8554, 8555);
  RANGE (PORT_PROTOCOL_UDP, 8567, 8567);
  RANGE (PORT_PROTOCOL_UDP, 8600, 8600);
  RANGE (PORT_PROTOCOL_UDP, 8610, 8614);
  RANGE (PORT_PROTOCOL_UDP, 8686, 8686);
  RANGE (PORT_PROTOCOL_UDP, 8699, 8699);
  RANGE (PORT_PROTOCOL_UDP, 8732, 8733);
  RANGE (PORT_PROTOCOL_UDP, 8763, 8765);
  RANGE (PORT_PROTOCOL_UDP, 8770, 8770);
  RANGE (PORT_PROTOCOL_UDP, 8786, 8787);
  RANGE (PORT_PROTOCOL_UDP, 8793, 8793);
  RANGE (PORT_PROTOCOL_UDP, 8800, 8800);
  RANGE (PORT_PROTOCOL_UDP, 8804, 8804);
  RANGE (PORT_PROTOCOL_UDP, 8873, 8873);
  RANGE (PORT_PROTOCOL_UDP, 8880, 8880);
  RANGE (PORT_PROTOCOL_UDP, 8883, 8883);
  RANGE (PORT_PROTOCOL_UDP, 8888, 8894);
  RANGE (PORT_PROTOCOL_UDP, 8899, 8901);
  RANGE (PORT_PROTOCOL_UDP, 8910, 8913);
  RANGE (PORT_PROTOCOL_UDP, 8954, 8954);
  RANGE (PORT_PROTOCOL_UDP, 8989, 8991);
  RANGE (PORT_PROTOCOL_UDP, 8999, 9002);
  RANGE (PORT_PROTOCOL_UDP, 9007, 9007);
  RANGE (PORT_PROTOCOL_UDP, 9009, 9009);
  RANGE (PORT_PROTOCOL_UDP, 9020, 9026);
  RANGE (PORT_PROTOCOL_UDP, 9080, 9080);
  RANGE (PORT_PROTOCOL_UDP, 9084, 9092);
  RANGE (PORT_PROTOCOL_UDP, 9100, 9106);
  RANGE (PORT_PROTOCOL_UDP, 9119, 9119);
  RANGE (PORT_PROTOCOL_UDP, 9131, 9131);
  RANGE (PORT_PROTOCOL_UDP, 9160, 9164);
  RANGE (PORT_PROTOCOL_UDP, 9191, 9191);
  RANGE (PORT_PROTOCOL_UDP, 9200, 9217);
  RANGE (PORT_PROTOCOL_UDP, 9222, 9222);
  RANGE (PORT_PROTOCOL_UDP, 9255, 9255);
  RANGE (PORT_PROTOCOL_UDP, 9278, 9287);
  RANGE (PORT_PROTOCOL_UDP, 9292, 9295);
  RANGE (PORT_PROTOCOL_UDP, 9300, 9300);
  RANGE (PORT_PROTOCOL_UDP, 9318, 9318);
  RANGE (PORT_PROTOCOL_UDP, 9321, 9321);
  RANGE (PORT_PROTOCOL_UDP, 9343, 9344);
  RANGE (PORT_PROTOCOL_UDP, 9346, 9346);
  RANGE (PORT_PROTOCOL_UDP, 9374, 9374);
  RANGE (PORT_PROTOCOL_UDP, 9380, 9380);
  RANGE (PORT_PROTOCOL_UDP, 9396, 9397);
  RANGE (PORT_PROTOCOL_UDP, 9400, 9402);
  RANGE (PORT_PROTOCOL_UDP, 9418, 9418);
  RANGE (PORT_PROTOCOL_UDP, 9443, 9444);
  RANGE (PORT_PROTOCOL_UDP, 9450, 9450);
  RANGE (PORT_PROTOCOL_UDP, 9500, 9500);
  RANGE (PORT_PROTOCOL_UDP, 9522, 9522);
  RANGE (PORT_PROTOCOL_UDP, 9535, 9536);
  RANGE (PORT_PROTOCOL_UDP, 9555, 9555);
  RANGE (PORT_PROTOCOL_UDP, 9592, 9600);
  RANGE (PORT_PROTOCOL_UDP, 9612, 9612);
  RANGE (PORT_PROTOCOL_UDP, 9618, 9618);
  RANGE (PORT_PROTOCOL_UDP, 9628, 9629);
  RANGE (PORT_PROTOCOL_UDP, 9632, 9632);
  RANGE (PORT_PROTOCOL_UDP, 9667, 9668);
  RANGE (PORT_PROTOCOL_UDP, 9694, 9695);
  RANGE (PORT_PROTOCOL_UDP, 9700, 9700);
  RANGE (PORT_PROTOCOL_UDP, 9747, 9747);
  RANGE (PORT_PROTOCOL_UDP, 9750, 9750);
  RANGE (PORT_PROTOCOL_UDP, 9753, 9753);
  RANGE (PORT_PROTOCOL_UDP, 9762, 9762);
  RANGE (PORT_PROTOCOL_UDP, 9800, 9802);
  RANGE (PORT_PROTOCOL_UDP, 9875, 9876);
  RANGE (PORT_PROTOCOL_UDP, 9888, 9889);
  RANGE (PORT_PROTOCOL_UDP, 9898, 9901);
  RANGE (PORT_PROTOCOL_UDP, 9903, 9903);
  RANGE (PORT_PROTOCOL_UDP, 9909, 9909);
  RANGE (PORT_PROTOCOL_UDP, 9911, 9911);
  RANGE (PORT_PROTOCOL_UDP, 9950, 9953);
  RANGE (PORT_PROTOCOL_UDP, 9956, 9956);
  RANGE (PORT_PROTOCOL_UDP, 9966, 9966);
  RANGE (PORT_PROTOCOL_UDP, 9987, 9987);
  RANGE (PORT_PROTOCOL_UDP, 9990, 10003);
  RANGE (PORT_PROTOCOL_UDP, 10007, 10009);
  RANGE (PORT_PROTOCOL_UDP, 10050, 10051);
  RANGE (PORT_PROTOCOL_UDP, 10080, 10081);
  RANGE (PORT_PROTOCOL_UDP, 10100, 10104);
  RANGE (PORT_PROTOCOL_UDP, 10107, 10107);
  RANGE (PORT_PROTOCOL_UDP, 10110, 10111);
  RANGE (PORT_PROTOCOL_UDP, 10113, 10117);
  RANGE (PORT_PROTOCOL_UDP, 10128, 10128);
  RANGE (PORT_PROTOCOL_UDP, 10160, 10162);
  RANGE (PORT_PROTOCOL_UDP, 10200, 10201);
  RANGE (PORT_PROTOCOL_UDP, 10252, 10252);
  RANGE (PORT_PROTOCOL_UDP, 10260, 10260);
  RANGE (PORT_PROTOCOL_UDP, 10288, 10288);
  RANGE (PORT_PROTOCOL_UDP, 10500, 10500);
  RANGE (PORT_PROTOCOL_UDP, 10540, 10544);
  RANGE (PORT_PROTOCOL_UDP, 10800, 10800);
  RANGE (PORT_PROTOCOL_UDP, 10805, 10805);
  RANGE (PORT_PROTOCOL_UDP, 10810, 10810);
  RANGE (PORT_PROTOCOL_UDP, 10860, 10860);
  RANGE (PORT_PROTOCOL_UDP, 10990, 10990);
  RANGE (PORT_PROTOCOL_UDP, 11000, 11001);
  RANGE (PORT_PROTOCOL_UDP, 11106, 11106);
  RANGE (PORT_PROTOCOL_UDP, 11111, 11112);
  RANGE (PORT_PROTOCOL_UDP, 11161, 11165);
  RANGE (PORT_PROTOCOL_UDP, 11171, 11171);
  RANGE (PORT_PROTOCOL_UDP, 11201, 11201);
  RANGE (PORT_PROTOCOL_UDP, 11208, 11208);
  RANGE (PORT_PROTOCOL_UDP, 11211, 11211);
  RANGE (PORT_PROTOCOL_UDP, 11319, 11321);
  RANGE (PORT_PROTOCOL_UDP, 11367, 11367);
  RANGE (PORT_PROTOCOL_UDP, 11371, 11371);
  RANGE (PORT_PROTOCOL_UDP, 11600, 11600);
  RANGE (PORT_PROTOCOL_UDP, 11720, 11720);
  RANGE (PORT_PROTOCOL_UDP, 11751, 11751);
  RANGE (PORT_PROTOCOL_UDP, 11876, 11877);
  RANGE (PORT_PROTOCOL_UDP, 11967, 11967);
  RANGE (PORT_PROTOCOL_UDP, 12000, 12009);
  RANGE (PORT_PROTOCOL_UDP, 12012, 12013);
  RANGE (PORT_PROTOCOL_UDP, 12109, 12109);
  RANGE (PORT_PROTOCOL_UDP, 12121, 12121);
  RANGE (PORT_PROTOCOL_UDP, 12168, 12168);
  RANGE (PORT_PROTOCOL_UDP, 12172, 12172);
  RANGE (PORT_PROTOCOL_UDP, 12300, 12300);
  RANGE (PORT_PROTOCOL_UDP, 12321, 12322);
  RANGE (PORT_PROTOCOL_UDP, 12345, 12345);
  RANGE (PORT_PROTOCOL_UDP, 12753, 12753);
  RANGE (PORT_PROTOCOL_UDP, 13160, 13160);
  RANGE (PORT_PROTOCOL_UDP, 13216, 13218);
  RANGE (PORT_PROTOCOL_UDP, 13223, 13224);
  RANGE (PORT_PROTOCOL_UDP, 13400, 13400);
  RANGE (PORT_PROTOCOL_UDP, 13720, 13722);
  RANGE (PORT_PROTOCOL_UDP, 13724, 13724);
  RANGE (PORT_PROTOCOL_UDP, 13782, 13783);
  RANGE (PORT_PROTOCOL_UDP, 13785, 13786);
  RANGE (PORT_PROTOCOL_UDP, 13818, 13822);
  RANGE (PORT_PROTOCOL_UDP, 13929, 13929);
  RANGE (PORT_PROTOCOL_UDP, 14000, 14001);
  RANGE (PORT_PROTOCOL_UDP, 14033, 14034);
  RANGE (PORT_PROTOCOL_UDP, 14141, 14142);
  RANGE (PORT_PROTOCOL_UDP, 14145, 14145);
  RANGE (PORT_PROTOCOL_UDP, 14149, 14149);
  RANGE (PORT_PROTOCOL_UDP, 14154, 14154);
  RANGE (PORT_PROTOCOL_UDP, 14250, 14250);
  RANGE (PORT_PROTOCOL_UDP, 14414, 14414);
  RANGE (PORT_PROTOCOL_UDP, 14936, 14937);
  RANGE (PORT_PROTOCOL_UDP, 15000, 15000);
  RANGE (PORT_PROTOCOL_UDP, 15118, 15118);
  RANGE (PORT_PROTOCOL_UDP, 15345, 15345);
  RANGE (PORT_PROTOCOL_UDP, 15363, 15363);
  RANGE (PORT_PROTOCOL_UDP, 15555, 15555);
  RANGE (PORT_PROTOCOL_UDP, 15660, 15660);
  RANGE (PORT_PROTOCOL_UDP, 15740, 15740);
  RANGE (PORT_PROTOCOL_UDP, 15998, 15998);
  RANGE (PORT_PROTOCOL_UDP, 16003, 16003);
  RANGE (PORT_PROTOCOL_UDP, 16161, 16161);
  RANGE (PORT_PROTOCOL_UDP, 16309, 16311);
  RANGE (PORT_PROTOCOL_UDP, 16360, 16361);
  RANGE (PORT_PROTOCOL_UDP, 16367, 16368);
  RANGE (PORT_PROTOCOL_UDP, 16384, 16384);
  RANGE (PORT_PROTOCOL_UDP, 16666, 16666);
  RANGE (PORT_PROTOCOL_UDP, 16900, 16900);
  RANGE (PORT_PROTOCOL_UDP, 16950, 16950);
  RANGE (PORT_PROTOCOL_UDP, 16991, 16995);
  RANGE (PORT_PROTOCOL_UDP, 17007, 17007);
  RANGE (PORT_PROTOCOL_UDP, 17185, 17185);
  RANGE (PORT_PROTOCOL_UDP, 17219, 17219);
  RANGE (PORT_PROTOCOL_UDP, 17221, 17222);
  RANGE (PORT_PROTOCOL_UDP, 17234, 17235);
  RANGE (PORT_PROTOCOL_UDP, 17500, 17500);
  RANGE (PORT_PROTOCOL_UDP, 17729, 17729);
  RANGE (PORT_PROTOCOL_UDP, 17754, 17756);
  RANGE (PORT_PROTOCOL_UDP, 18000, 18000);
  RANGE (PORT_PROTOCOL_UDP, 18181, 18187);
  RANGE (PORT_PROTOCOL_UDP, 18241, 18241);
  RANGE (PORT_PROTOCOL_UDP, 18262, 18262);
  RANGE (PORT_PROTOCOL_UDP, 18463, 18463);
  RANGE (PORT_PROTOCOL_UDP, 18634, 18635);
  RANGE (PORT_PROTOCOL_UDP, 18769, 18769);
  RANGE (PORT_PROTOCOL_UDP, 18881, 18881);
  RANGE (PORT_PROTOCOL_UDP, 18888, 18888);
  RANGE (PORT_PROTOCOL_UDP, 19000, 19000);
  RANGE (PORT_PROTOCOL_UDP, 19191, 19191);
  RANGE (PORT_PROTOCOL_UDP, 19194, 19194);
  RANGE (PORT_PROTOCOL_UDP, 19283, 19283);
  RANGE (PORT_PROTOCOL_UDP, 19315, 19315);
  RANGE (PORT_PROTOCOL_UDP, 19398, 19398);
  RANGE (PORT_PROTOCOL_UDP, 19410, 19412);
  RANGE (PORT_PROTOCOL_UDP, 19539, 19541);
  RANGE (PORT_PROTOCOL_UDP, 19999, 20003);
  RANGE (PORT_PROTOCOL_UDP, 20005, 20005);
  RANGE (PORT_PROTOCOL_UDP, 20012, 20012);
  RANGE (PORT_PROTOCOL_UDP, 20014, 20014);
  RANGE (PORT_PROTOCOL_UDP, 20034, 20034);
  RANGE (PORT_PROTOCOL_UDP, 20046, 20046);
  RANGE (PORT_PROTOCOL_UDP, 20048, 20049);
  RANGE (PORT_PROTOCOL_UDP, 20167, 20167);
  RANGE (PORT_PROTOCOL_UDP, 20202, 20202);
  RANGE (PORT_PROTOCOL_UDP, 20222, 20222);
  RANGE (PORT_PROTOCOL_UDP, 20480, 20480);
  RANGE (PORT_PROTOCOL_UDP, 20670, 20670);
  RANGE (PORT_PROTOCOL_UDP, 20999, 21000);
  RANGE (PORT_PROTOCOL_UDP, 21554, 21554);
  RANGE (PORT_PROTOCOL_UDP, 21590, 21590);
  RANGE (PORT_PROTOCOL_UDP, 21800, 21800);
  RANGE (PORT_PROTOCOL_UDP, 21845, 21849);
  RANGE (PORT_PROTOCOL_UDP, 22000, 22005);
  RANGE (PORT_PROTOCOL_UDP, 22273, 22273);
  RANGE (PORT_PROTOCOL_UDP, 22305, 22305);
  RANGE (PORT_PROTOCOL_UDP, 22343, 22343);
  RANGE (PORT_PROTOCOL_UDP, 22347, 22347);
  RANGE (PORT_PROTOCOL_UDP, 22350, 22350);
  RANGE (PORT_PROTOCOL_UDP, 22555, 22555);
  RANGE (PORT_PROTOCOL_UDP, 22763, 22763);
  RANGE (PORT_PROTOCOL_UDP, 22800, 22800);
  RANGE (PORT_PROTOCOL_UDP, 22951, 22951);
  RANGE (PORT_PROTOCOL_UDP, 23000, 23005);
  RANGE (PORT_PROTOCOL_UDP, 23272, 23272);
  RANGE (PORT_PROTOCOL_UDP, 23333, 23333);
  RANGE (PORT_PROTOCOL_UDP, 23400, 23402);
  RANGE (PORT_PROTOCOL_UDP, 24000, 24006);
  RANGE (PORT_PROTOCOL_UDP, 24242, 24242);
  RANGE (PORT_PROTOCOL_UDP, 24249, 24249);
  RANGE (PORT_PROTOCOL_UDP, 24321, 24321);
  RANGE (PORT_PROTOCOL_UDP, 24386, 24386);
  RANGE (PORT_PROTOCOL_UDP, 24465, 24465);
  RANGE (PORT_PROTOCOL_UDP, 24554, 24554);
  RANGE (PORT_PROTOCOL_UDP, 24676, 24678);
  RANGE (PORT_PROTOCOL_UDP, 24680, 24680);
  RANGE (PORT_PROTOCOL_UDP, 24922, 24922);
  RANGE (PORT_PROTOCOL_UDP, 25000, 25009);
  RANGE (PORT_PROTOCOL_UDP, 25793, 25793);
  RANGE (PORT_PROTOCOL_UDP, 25900, 25903);
  RANGE (PORT_PROTOCOL_UDP, 26000, 26000);
  RANGE (PORT_PROTOCOL_UDP, 26133, 26133);
  RANGE (PORT_PROTOCOL_UDP, 26208, 26208);
  RANGE (PORT_PROTOCOL_UDP, 26260, 26263);
  RANGE (PORT_PROTOCOL_UDP, 26486, 26487);
  RANGE (PORT_PROTOCOL_UDP, 26489, 26489);
  RANGE (PORT_PROTOCOL_UDP, 27345, 27345);
  RANGE (PORT_PROTOCOL_UDP, 27442, 27442);
  RANGE (PORT_PROTOCOL_UDP, 27504, 27504);
  RANGE (PORT_PROTOCOL_UDP, 27782, 27782);
  RANGE (PORT_PROTOCOL_UDP, 27999, 28000);
  RANGE (PORT_PROTOCOL_UDP, 28240, 28240);
  RANGE (PORT_PROTOCOL_UDP, 29167, 29167);
  RANGE (PORT_PROTOCOL_UDP, 30001, 30002);
  RANGE (PORT_PROTOCOL_UDP, 30260, 30260);
  RANGE (PORT_PROTOCOL_UDP, 30999, 30999);
  RANGE (PORT_PROTOCOL_UDP, 31029, 31029);
  RANGE (PORT_PROTOCOL_UDP, 31416, 31416);
  RANGE (PORT_PROTOCOL_UDP, 31457, 31457);
  RANGE (PORT_PROTOCOL_UDP, 31620, 31620);
  RANGE (PORT_PROTOCOL_UDP, 31765, 31765);
  RANGE (PORT_PROTOCOL_UDP, 31948, 31949);
  RANGE (PORT_PROTOCOL_UDP, 32034, 32034);
  RANGE (PORT_PROTOCOL_UDP, 32249, 32249);
  RANGE (PORT_PROTOCOL_UDP, 32483, 32483);
  RANGE (PORT_PROTOCOL_UDP, 32635, 32636);
  RANGE (PORT_PROTOCOL_UDP, 32767, 32777);
  RANGE (PORT_PROTOCOL_UDP, 32801, 32801);
  RANGE (PORT_PROTOCOL_UDP, 32896, 32896);
  RANGE (PORT_PROTOCOL_UDP, 33123, 33123);
  RANGE (PORT_PROTOCOL_UDP, 33331, 33331);
  RANGE (PORT_PROTOCOL_UDP, 33334, 33334);
  RANGE (PORT_PROTOCOL_UDP, 33434, 33434);
  RANGE (PORT_PROTOCOL_UDP, 33656, 33656);
  RANGE (PORT_PROTOCOL_UDP, 34249, 34249);
  RANGE (PORT_PROTOCOL_UDP, 34378, 34379);
  RANGE (PORT_PROTOCOL_UDP, 34962, 34964);
  RANGE (PORT_PROTOCOL_UDP, 34980, 34980);
  RANGE (PORT_PROTOCOL_UDP, 35355, 35355);
  RANGE (PORT_PROTOCOL_UDP, 36001, 36001);
  RANGE (PORT_PROTOCOL_UDP, 36865, 36865);
  RANGE (PORT_PROTOCOL_UDP, 37475, 37475);
  RANGE (PORT_PROTOCOL_UDP, 37654, 37654);
  RANGE (PORT_PROTOCOL_UDP, 38201, 38203);
  RANGE (PORT_PROTOCOL_UDP, 39681, 39681);
  RANGE (PORT_PROTOCOL_UDP, 40000, 40000);
  RANGE (PORT_PROTOCOL_UDP, 40841, 40843);
  RANGE (PORT_PROTOCOL_UDP, 40853, 40853);
  RANGE (PORT_PROTOCOL_UDP, 41111, 41111);
  RANGE (PORT_PROTOCOL_UDP, 41794, 41795);
  RANGE (PORT_PROTOCOL_UDP, 42508, 42510);
  RANGE (PORT_PROTOCOL_UDP, 43188, 43190);
  RANGE (PORT_PROTOCOL_UDP, 43439, 43441);
  RANGE (PORT_PROTOCOL_UDP, 44321, 44323);
  RANGE (PORT_PROTOCOL_UDP, 44544, 44544);
  RANGE (PORT_PROTOCOL_UDP, 44553, 44553);
  RANGE (PORT_PROTOCOL_UDP, 44600, 44600);
  RANGE (PORT_PROTOCOL_UDP, 44818, 44818);
  RANGE (PORT_PROTOCOL_UDP, 45000, 45000);
  RANGE (PORT_PROTOCOL_UDP, 45054, 45054);
  RANGE (PORT_PROTOCOL_UDP, 45678, 45678);
  RANGE (PORT_PROTOCOL_UDP, 45825, 45825);
  RANGE (PORT_PROTOCOL_UDP, 45966, 45966);
  RANGE (PORT_PROTOCOL_UDP, 46999, 47000);
  RANGE (PORT_PROTOCOL_UDP, 47557, 47557);
  RANGE (PORT_PROTOCOL_UDP, 47624, 47624);
  RANGE (PORT_PROTOCOL_UDP, 47806, 47806);
  RANGE (PORT_PROTOCOL_UDP, 47808, 47808);
  RANGE (PORT_PROTOCOL_UDP, 48000, 48003);
  RANGE (PORT_PROTOCOL_UDP, 48128, 48129);
  RANGE (PORT_PROTOCOL_UDP, 48556, 48556);
}
