/* Copyright (C) 2009-2018 Greenbone Networks GmbH
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * @file  manage_ranges_all_tcp_nmap_5_51_top_1000.c
 * @brief GVM management layer: Predefined port range
 *
 * This file defines the ranges for a predefined port list.
 */

#include "manage_sql.h"

#undef G_LOG_DOMAIN
/**
 * @brief GLib log domain.
 */
#define G_LOG_DOMAIN "md   main"

/**
 * @brief Insert a port range.
 */
#define RANGE(type, start, end)                                      \
  insert_port_range (list, type, start, end)

/**
 * @brief Make port ranges for IANA TCP 2012.
 *
 * Caller must lock the db.
 *
 * @param[in]  list  Port list.
 */
void
make_port_ranges_all_tcp_nmap_5_51_top_1000 (port_list_t list)
{
  RANGE (PORT_PROTOCOL_TCP, 1, 65535);

  RANGE (PORT_PROTOCOL_UDP, 2, 3);
  RANGE (PORT_PROTOCOL_UDP, 7, 7);
  RANGE (PORT_PROTOCOL_UDP, 9, 9);
  RANGE (PORT_PROTOCOL_UDP, 13, 13);
  RANGE (PORT_PROTOCOL_UDP, 17, 17);
  RANGE (PORT_PROTOCOL_UDP, 19, 23);
  RANGE (PORT_PROTOCOL_UDP, 37, 38);
  RANGE (PORT_PROTOCOL_UDP, 42, 42);
  RANGE (PORT_PROTOCOL_UDP, 49, 49);
  RANGE (PORT_PROTOCOL_UDP, 53, 53);
  RANGE (PORT_PROTOCOL_UDP, 67, 69);
  RANGE (PORT_PROTOCOL_UDP, 80, 80);
  RANGE (PORT_PROTOCOL_UDP, 88, 88);
  RANGE (PORT_PROTOCOL_UDP, 111, 113);
  RANGE (PORT_PROTOCOL_UDP, 120, 120);
  RANGE (PORT_PROTOCOL_UDP, 123, 123);
  RANGE (PORT_PROTOCOL_UDP, 135, 139);
  RANGE (PORT_PROTOCOL_UDP, 158, 158);
  RANGE (PORT_PROTOCOL_UDP, 161, 162);
  RANGE (PORT_PROTOCOL_UDP, 177, 177);
  RANGE (PORT_PROTOCOL_UDP, 192, 192);
  RANGE (PORT_PROTOCOL_UDP, 199, 199);
  RANGE (PORT_PROTOCOL_UDP, 207, 207);
  RANGE (PORT_PROTOCOL_UDP, 217, 217);
  RANGE (PORT_PROTOCOL_UDP, 363, 363);
  RANGE (PORT_PROTOCOL_UDP, 389, 389);
  RANGE (PORT_PROTOCOL_UDP, 402, 402);
  RANGE (PORT_PROTOCOL_UDP, 407, 407);
  RANGE (PORT_PROTOCOL_UDP, 427, 427);
  RANGE (PORT_PROTOCOL_UDP, 434, 434);
  RANGE (PORT_PROTOCOL_UDP, 443, 443);
  RANGE (PORT_PROTOCOL_UDP, 445, 445);
  RANGE (PORT_PROTOCOL_UDP, 464, 464);
  RANGE (PORT_PROTOCOL_UDP, 497, 497);
  RANGE (PORT_PROTOCOL_UDP, 500, 500);
  RANGE (PORT_PROTOCOL_UDP, 502, 502);
  RANGE (PORT_PROTOCOL_UDP, 512, 515);
  RANGE (PORT_PROTOCOL_UDP, 517, 518);
  RANGE (PORT_PROTOCOL_UDP, 520, 520);
  RANGE (PORT_PROTOCOL_UDP, 539, 539);
  RANGE (PORT_PROTOCOL_UDP, 559, 559);
  RANGE (PORT_PROTOCOL_UDP, 593, 593);
  RANGE (PORT_PROTOCOL_UDP, 623, 623);
  RANGE (PORT_PROTOCOL_UDP, 626, 626);
  RANGE (PORT_PROTOCOL_UDP, 631, 631);
  RANGE (PORT_PROTOCOL_UDP, 639, 639);
  RANGE (PORT_PROTOCOL_UDP, 643, 643);
  RANGE (PORT_PROTOCOL_UDP, 657, 657);
  RANGE (PORT_PROTOCOL_UDP, 664, 664);
  RANGE (PORT_PROTOCOL_UDP, 682, 689);
  RANGE (PORT_PROTOCOL_UDP, 764, 764);
  RANGE (PORT_PROTOCOL_UDP, 767, 767);
  RANGE (PORT_PROTOCOL_UDP, 772, 776);
  RANGE (PORT_PROTOCOL_UDP, 780, 782);
  RANGE (PORT_PROTOCOL_UDP, 786, 786);
  RANGE (PORT_PROTOCOL_UDP, 789, 789);
  RANGE (PORT_PROTOCOL_UDP, 800, 800);
  RANGE (PORT_PROTOCOL_UDP, 814, 814);
  RANGE (PORT_PROTOCOL_UDP, 826, 826);
  RANGE (PORT_PROTOCOL_UDP, 829, 829);
  RANGE (PORT_PROTOCOL_UDP, 838, 838);
  RANGE (PORT_PROTOCOL_UDP, 902, 903);
  RANGE (PORT_PROTOCOL_UDP, 944, 944);
  RANGE (PORT_PROTOCOL_UDP, 959, 959);
  RANGE (PORT_PROTOCOL_UDP, 965, 965);
  RANGE (PORT_PROTOCOL_UDP, 983, 983);
  RANGE (PORT_PROTOCOL_UDP, 989, 990);
  RANGE (PORT_PROTOCOL_UDP, 996, 1001);
  RANGE (PORT_PROTOCOL_UDP, 1007, 1008);
  RANGE (PORT_PROTOCOL_UDP, 1012, 1014);
  RANGE (PORT_PROTOCOL_UDP, 1019, 1051);
  RANGE (PORT_PROTOCOL_UDP, 1053, 1060);
  RANGE (PORT_PROTOCOL_UDP, 1064, 1070);
  RANGE (PORT_PROTOCOL_UDP, 1072, 1072);
  RANGE (PORT_PROTOCOL_UDP, 1080, 1081);
  RANGE (PORT_PROTOCOL_UDP, 1087, 1088);
  RANGE (PORT_PROTOCOL_UDP, 1090, 1090);
  RANGE (PORT_PROTOCOL_UDP, 1100, 1101);
  RANGE (PORT_PROTOCOL_UDP, 1105, 1105);
  RANGE (PORT_PROTOCOL_UDP, 1124, 1124);
  RANGE (PORT_PROTOCOL_UDP, 1200, 1200);
  RANGE (PORT_PROTOCOL_UDP, 1214, 1214);
  RANGE (PORT_PROTOCOL_UDP, 1234, 1234);
  RANGE (PORT_PROTOCOL_UDP, 1346, 1346);
  RANGE (PORT_PROTOCOL_UDP, 1419, 1419);
  RANGE (PORT_PROTOCOL_UDP, 1433, 1434);
  RANGE (PORT_PROTOCOL_UDP, 1455, 1455);
  RANGE (PORT_PROTOCOL_UDP, 1457, 1457);
  RANGE (PORT_PROTOCOL_UDP, 1484, 1485);
  RANGE (PORT_PROTOCOL_UDP, 1524, 1524);
  RANGE (PORT_PROTOCOL_UDP, 1645, 1646);
  RANGE (PORT_PROTOCOL_UDP, 1701, 1701);
  RANGE (PORT_PROTOCOL_UDP, 1718, 1719);
  RANGE (PORT_PROTOCOL_UDP, 1761, 1761);
  RANGE (PORT_PROTOCOL_UDP, 1782, 1782);
  RANGE (PORT_PROTOCOL_UDP, 1804, 1804);
  RANGE (PORT_PROTOCOL_UDP, 1812, 1813);
  RANGE (PORT_PROTOCOL_UDP, 1885, 1886);
  RANGE (PORT_PROTOCOL_UDP, 1900, 1901);
  RANGE (PORT_PROTOCOL_UDP, 1993, 1993);
  RANGE (PORT_PROTOCOL_UDP, 2000, 2000);
  RANGE (PORT_PROTOCOL_UDP, 2002, 2002);
  RANGE (PORT_PROTOCOL_UDP, 2048, 2049);
  RANGE (PORT_PROTOCOL_UDP, 2051, 2051);
  RANGE (PORT_PROTOCOL_UDP, 2148, 2148);
  RANGE (PORT_PROTOCOL_UDP, 2160, 2161);
  RANGE (PORT_PROTOCOL_UDP, 2222, 2223);
  RANGE (PORT_PROTOCOL_UDP, 2343, 2343);
  RANGE (PORT_PROTOCOL_UDP, 2345, 2345);
  RANGE (PORT_PROTOCOL_UDP, 2362, 2362);
  RANGE (PORT_PROTOCOL_UDP, 2967, 2967);
  RANGE (PORT_PROTOCOL_UDP, 3052, 3052);
  RANGE (PORT_PROTOCOL_UDP, 3130, 3130);
  RANGE (PORT_PROTOCOL_UDP, 3283, 3283);
  RANGE (PORT_PROTOCOL_UDP, 3296, 3296);
  RANGE (PORT_PROTOCOL_UDP, 3343, 3343);
  RANGE (PORT_PROTOCOL_UDP, 3389, 3389);
  RANGE (PORT_PROTOCOL_UDP, 3401, 3401);
  RANGE (PORT_PROTOCOL_UDP, 3456, 3457);
  RANGE (PORT_PROTOCOL_UDP, 3659, 3659);
  RANGE (PORT_PROTOCOL_UDP, 3664, 3664);
  RANGE (PORT_PROTOCOL_UDP, 3702, 3703);
  RANGE (PORT_PROTOCOL_UDP, 4000, 4000);
  RANGE (PORT_PROTOCOL_UDP, 4008, 4008);
  RANGE (PORT_PROTOCOL_UDP, 4045, 4045);
  RANGE (PORT_PROTOCOL_UDP, 4444, 4444);
  RANGE (PORT_PROTOCOL_UDP, 4500, 4500);
  RANGE (PORT_PROTOCOL_UDP, 4666, 4666);
  RANGE (PORT_PROTOCOL_UDP, 4672, 4672);
  RANGE (PORT_PROTOCOL_UDP, 5000, 5003);
  RANGE (PORT_PROTOCOL_UDP, 5010, 5010);
  RANGE (PORT_PROTOCOL_UDP, 5050, 5050);
  RANGE (PORT_PROTOCOL_UDP, 5060, 5060);
  RANGE (PORT_PROTOCOL_UDP, 5093, 5093);
  RANGE (PORT_PROTOCOL_UDP, 5351, 5351);
  RANGE (PORT_PROTOCOL_UDP, 5353, 5353);
  RANGE (PORT_PROTOCOL_UDP, 5355, 5355);
  RANGE (PORT_PROTOCOL_UDP, 5500, 5500);
  RANGE (PORT_PROTOCOL_UDP, 5555, 5555);
  RANGE (PORT_PROTOCOL_UDP, 5632, 5632);
  RANGE (PORT_PROTOCOL_UDP, 6000, 6002);
  RANGE (PORT_PROTOCOL_UDP, 6004, 6004);
  RANGE (PORT_PROTOCOL_UDP, 6050, 6050);
  RANGE (PORT_PROTOCOL_UDP, 6346, 6347);
  RANGE (PORT_PROTOCOL_UDP, 6970, 6971);
  RANGE (PORT_PROTOCOL_UDP, 7000, 7000);
  RANGE (PORT_PROTOCOL_UDP, 7938, 7938);
  RANGE (PORT_PROTOCOL_UDP, 8000, 8001);
  RANGE (PORT_PROTOCOL_UDP, 8010, 8010);
  RANGE (PORT_PROTOCOL_UDP, 8181, 8181);
  RANGE (PORT_PROTOCOL_UDP, 8193, 8193);
  RANGE (PORT_PROTOCOL_UDP, 8900, 8900);
  RANGE (PORT_PROTOCOL_UDP, 9000, 9001);
  RANGE (PORT_PROTOCOL_UDP, 9020, 9020);
  RANGE (PORT_PROTOCOL_UDP, 9103, 9103);
  RANGE (PORT_PROTOCOL_UDP, 9199, 9200);
  RANGE (PORT_PROTOCOL_UDP, 9370, 9370);
  RANGE (PORT_PROTOCOL_UDP, 9876, 9877);
  RANGE (PORT_PROTOCOL_UDP, 9950, 9950);
  RANGE (PORT_PROTOCOL_UDP, 10000, 10000);
  RANGE (PORT_PROTOCOL_UDP, 10080, 10080);
  RANGE (PORT_PROTOCOL_UDP, 11487, 11487);
  RANGE (PORT_PROTOCOL_UDP, 16086, 16086);
  RANGE (PORT_PROTOCOL_UDP, 16402, 16402);
  RANGE (PORT_PROTOCOL_UDP, 16420, 16420);
  RANGE (PORT_PROTOCOL_UDP, 16430, 16430);
  RANGE (PORT_PROTOCOL_UDP, 16433, 16433);
  RANGE (PORT_PROTOCOL_UDP, 16449, 16449);
  RANGE (PORT_PROTOCOL_UDP, 16498, 16498);
  RANGE (PORT_PROTOCOL_UDP, 16503, 16503);
  RANGE (PORT_PROTOCOL_UDP, 16545, 16545);
  RANGE (PORT_PROTOCOL_UDP, 16548, 16548);
  RANGE (PORT_PROTOCOL_UDP, 16573, 16573);
  RANGE (PORT_PROTOCOL_UDP, 16674, 16674);
  RANGE (PORT_PROTOCOL_UDP, 16680, 16680);
  RANGE (PORT_PROTOCOL_UDP, 16697, 16697);
  RANGE (PORT_PROTOCOL_UDP, 16700, 16700);
  RANGE (PORT_PROTOCOL_UDP, 16708, 16708);
  RANGE (PORT_PROTOCOL_UDP, 16711, 16711);
  RANGE (PORT_PROTOCOL_UDP, 16739, 16739);
  RANGE (PORT_PROTOCOL_UDP, 16766, 16766);
  RANGE (PORT_PROTOCOL_UDP, 16779, 16779);
  RANGE (PORT_PROTOCOL_UDP, 16786, 16786);
  RANGE (PORT_PROTOCOL_UDP, 16816, 16816);
  RANGE (PORT_PROTOCOL_UDP, 16829, 16829);
  RANGE (PORT_PROTOCOL_UDP, 16832, 16832);
  RANGE (PORT_PROTOCOL_UDP, 16838, 16839);
  RANGE (PORT_PROTOCOL_UDP, 16862, 16862);
  RANGE (PORT_PROTOCOL_UDP, 16896, 16896);
  RANGE (PORT_PROTOCOL_UDP, 16912, 16912);
  RANGE (PORT_PROTOCOL_UDP, 16918, 16919);
  RANGE (PORT_PROTOCOL_UDP, 16938, 16939);
  RANGE (PORT_PROTOCOL_UDP, 16947, 16948);
  RANGE (PORT_PROTOCOL_UDP, 16970, 16970);
  RANGE (PORT_PROTOCOL_UDP, 16972, 16972);
  RANGE (PORT_PROTOCOL_UDP, 16974, 16974);
  RANGE (PORT_PROTOCOL_UDP, 17006, 17006);
  RANGE (PORT_PROTOCOL_UDP, 17018, 17018);
  RANGE (PORT_PROTOCOL_UDP, 17077, 17077);
  RANGE (PORT_PROTOCOL_UDP, 17091, 17091);
  RANGE (PORT_PROTOCOL_UDP, 17101, 17101);
  RANGE (PORT_PROTOCOL_UDP, 17146, 17146);
  RANGE (PORT_PROTOCOL_UDP, 17184, 17185);
  RANGE (PORT_PROTOCOL_UDP, 17205, 17205);
  RANGE (PORT_PROTOCOL_UDP, 17207, 17207);
  RANGE (PORT_PROTOCOL_UDP, 17219, 17219);
  RANGE (PORT_PROTOCOL_UDP, 17236, 17237);
  RANGE (PORT_PROTOCOL_UDP, 17282, 17282);
  RANGE (PORT_PROTOCOL_UDP, 17302, 17302);
  RANGE (PORT_PROTOCOL_UDP, 17321, 17321);
  RANGE (PORT_PROTOCOL_UDP, 17331, 17332);
  RANGE (PORT_PROTOCOL_UDP, 17338, 17338);
  RANGE (PORT_PROTOCOL_UDP, 17359, 17359);
  RANGE (PORT_PROTOCOL_UDP, 17417, 17417);
  RANGE (PORT_PROTOCOL_UDP, 17423, 17424);
  RANGE (PORT_PROTOCOL_UDP, 17455, 17455);
  RANGE (PORT_PROTOCOL_UDP, 17459, 17459);
  RANGE (PORT_PROTOCOL_UDP, 17468, 17468);
  RANGE (PORT_PROTOCOL_UDP, 17487, 17487);
  RANGE (PORT_PROTOCOL_UDP, 17490, 17490);
  RANGE (PORT_PROTOCOL_UDP, 17494, 17494);
  RANGE (PORT_PROTOCOL_UDP, 17505, 17505);
  RANGE (PORT_PROTOCOL_UDP, 17533, 17533);
  RANGE (PORT_PROTOCOL_UDP, 17549, 17549);
  RANGE (PORT_PROTOCOL_UDP, 17573, 17573);
  RANGE (PORT_PROTOCOL_UDP, 17580, 17580);
  RANGE (PORT_PROTOCOL_UDP, 17585, 17585);
  RANGE (PORT_PROTOCOL_UDP, 17592, 17592);
  RANGE (PORT_PROTOCOL_UDP, 17605, 17605);
  RANGE (PORT_PROTOCOL_UDP, 17615, 17616);
  RANGE (PORT_PROTOCOL_UDP, 17629, 17629);
  RANGE (PORT_PROTOCOL_UDP, 17638, 17638);
  RANGE (PORT_PROTOCOL_UDP, 17663, 17663);
  RANGE (PORT_PROTOCOL_UDP, 17673, 17674);
  RANGE (PORT_PROTOCOL_UDP, 17683, 17683);
  RANGE (PORT_PROTOCOL_UDP, 17726, 17726);
  RANGE (PORT_PROTOCOL_UDP, 17754, 17754);
  RANGE (PORT_PROTOCOL_UDP, 17762, 17762);
  RANGE (PORT_PROTOCOL_UDP, 17787, 17787);
  RANGE (PORT_PROTOCOL_UDP, 17814, 17814);
  RANGE (PORT_PROTOCOL_UDP, 17823, 17824);
  RANGE (PORT_PROTOCOL_UDP, 17836, 17836);
  RANGE (PORT_PROTOCOL_UDP, 17845, 17845);
  RANGE (PORT_PROTOCOL_UDP, 17888, 17888);
  RANGE (PORT_PROTOCOL_UDP, 17939, 17939);
  RANGE (PORT_PROTOCOL_UDP, 17946, 17946);
  RANGE (PORT_PROTOCOL_UDP, 17989, 17989);
  RANGE (PORT_PROTOCOL_UDP, 18004, 18004);
  RANGE (PORT_PROTOCOL_UDP, 18081, 18081);
  RANGE (PORT_PROTOCOL_UDP, 18113, 18113);
  RANGE (PORT_PROTOCOL_UDP, 18134, 18134);
  RANGE (PORT_PROTOCOL_UDP, 18156, 18156);
  RANGE (PORT_PROTOCOL_UDP, 18228, 18228);
  RANGE (PORT_PROTOCOL_UDP, 18234, 18234);
  RANGE (PORT_PROTOCOL_UDP, 18250, 18250);
  RANGE (PORT_PROTOCOL_UDP, 18255, 18255);
  RANGE (PORT_PROTOCOL_UDP, 18258, 18258);
  RANGE (PORT_PROTOCOL_UDP, 18319, 18319);
  RANGE (PORT_PROTOCOL_UDP, 18331, 18331);
  RANGE (PORT_PROTOCOL_UDP, 18360, 18360);
  RANGE (PORT_PROTOCOL_UDP, 18373, 18373);
  RANGE (PORT_PROTOCOL_UDP, 18449, 18449);
  RANGE (PORT_PROTOCOL_UDP, 18485, 18485);
  RANGE (PORT_PROTOCOL_UDP, 18543, 18543);
  RANGE (PORT_PROTOCOL_UDP, 18582, 18582);
  RANGE (PORT_PROTOCOL_UDP, 18605, 18605);
  RANGE (PORT_PROTOCOL_UDP, 18617, 18617);
  RANGE (PORT_PROTOCOL_UDP, 18666, 18666);
  RANGE (PORT_PROTOCOL_UDP, 18669, 18669);
  RANGE (PORT_PROTOCOL_UDP, 18676, 18676);
  RANGE (PORT_PROTOCOL_UDP, 18683, 18683);
  RANGE (PORT_PROTOCOL_UDP, 18807, 18807);
  RANGE (PORT_PROTOCOL_UDP, 18818, 18818);
  RANGE (PORT_PROTOCOL_UDP, 18821, 18821);
  RANGE (PORT_PROTOCOL_UDP, 18830, 18830);
  RANGE (PORT_PROTOCOL_UDP, 18832, 18832);
  RANGE (PORT_PROTOCOL_UDP, 18835, 18835);
  RANGE (PORT_PROTOCOL_UDP, 18869, 18869);
  RANGE (PORT_PROTOCOL_UDP, 18883, 18883);
  RANGE (PORT_PROTOCOL_UDP, 18888, 18888);
  RANGE (PORT_PROTOCOL_UDP, 18958, 18958);
  RANGE (PORT_PROTOCOL_UDP, 18980, 18980);
  RANGE (PORT_PROTOCOL_UDP, 18985, 18985);
  RANGE (PORT_PROTOCOL_UDP, 18987, 18987);
  RANGE (PORT_PROTOCOL_UDP, 18991, 18991);
  RANGE (PORT_PROTOCOL_UDP, 18994, 18994);
  RANGE (PORT_PROTOCOL_UDP, 18996, 18996);
  RANGE (PORT_PROTOCOL_UDP, 19017, 19017);
  RANGE (PORT_PROTOCOL_UDP, 19022, 19022);
  RANGE (PORT_PROTOCOL_UDP, 19039, 19039);
  RANGE (PORT_PROTOCOL_UDP, 19047, 19047);
  RANGE (PORT_PROTOCOL_UDP, 19075, 19075);
  RANGE (PORT_PROTOCOL_UDP, 19096, 19096);
  RANGE (PORT_PROTOCOL_UDP, 19120, 19120);
  RANGE (PORT_PROTOCOL_UDP, 19130, 19130);
  RANGE (PORT_PROTOCOL_UDP, 19140, 19141);
  RANGE (PORT_PROTOCOL_UDP, 19154, 19154);
  RANGE (PORT_PROTOCOL_UDP, 19161, 19161);
  RANGE (PORT_PROTOCOL_UDP, 19165, 19165);
  RANGE (PORT_PROTOCOL_UDP, 19181, 19181);
  RANGE (PORT_PROTOCOL_UDP, 19193, 19193);
  RANGE (PORT_PROTOCOL_UDP, 19197, 19197);
  RANGE (PORT_PROTOCOL_UDP, 19222, 19222);
  RANGE (PORT_PROTOCOL_UDP, 19227, 19227);
  RANGE (PORT_PROTOCOL_UDP, 19273, 19273);
  RANGE (PORT_PROTOCOL_UDP, 19283, 19283);
  RANGE (PORT_PROTOCOL_UDP, 19294, 19294);
  RANGE (PORT_PROTOCOL_UDP, 19315, 19315);
  RANGE (PORT_PROTOCOL_UDP, 19322, 19322);
  RANGE (PORT_PROTOCOL_UDP, 19332, 19332);
  RANGE (PORT_PROTOCOL_UDP, 19374, 19374);
  RANGE (PORT_PROTOCOL_UDP, 19415, 19415);
  RANGE (PORT_PROTOCOL_UDP, 19482, 19482);
  RANGE (PORT_PROTOCOL_UDP, 19489, 19489);
  RANGE (PORT_PROTOCOL_UDP, 19500, 19500);
  RANGE (PORT_PROTOCOL_UDP, 19503, 19504);
  RANGE (PORT_PROTOCOL_UDP, 19541, 19541);
  RANGE (PORT_PROTOCOL_UDP, 19600, 19600);
  RANGE (PORT_PROTOCOL_UDP, 19605, 19605);
  RANGE (PORT_PROTOCOL_UDP, 19616, 19616);
  RANGE (PORT_PROTOCOL_UDP, 19624, 19625);
  RANGE (PORT_PROTOCOL_UDP, 19632, 19632);
  RANGE (PORT_PROTOCOL_UDP, 19639, 19639);
  RANGE (PORT_PROTOCOL_UDP, 19647, 19647);
  RANGE (PORT_PROTOCOL_UDP, 19650, 19650);
  RANGE (PORT_PROTOCOL_UDP, 19660, 19660);
  RANGE (PORT_PROTOCOL_UDP, 19662, 19663);
  RANGE (PORT_PROTOCOL_UDP, 19682, 19683);
  RANGE (PORT_PROTOCOL_UDP, 19687, 19687);
  RANGE (PORT_PROTOCOL_UDP, 19695, 19695);
  RANGE (PORT_PROTOCOL_UDP, 19707, 19707);
  RANGE (PORT_PROTOCOL_UDP, 19717, 19719);
  RANGE (PORT_PROTOCOL_UDP, 19722, 19722);
  RANGE (PORT_PROTOCOL_UDP, 19728, 19728);
  RANGE (PORT_PROTOCOL_UDP, 19789, 19789);
  RANGE (PORT_PROTOCOL_UDP, 19792, 19792);
  RANGE (PORT_PROTOCOL_UDP, 19933, 19933);
  RANGE (PORT_PROTOCOL_UDP, 19935, 19936);
  RANGE (PORT_PROTOCOL_UDP, 19956, 19956);
  RANGE (PORT_PROTOCOL_UDP, 19995, 19995);
  RANGE (PORT_PROTOCOL_UDP, 19998, 19998);
  RANGE (PORT_PROTOCOL_UDP, 20003, 20004);
  RANGE (PORT_PROTOCOL_UDP, 20019, 20019);
  RANGE (PORT_PROTOCOL_UDP, 20031, 20031);
  RANGE (PORT_PROTOCOL_UDP, 20082, 20082);
  RANGE (PORT_PROTOCOL_UDP, 20117, 20117);
  RANGE (PORT_PROTOCOL_UDP, 20120, 20120);
  RANGE (PORT_PROTOCOL_UDP, 20126, 20126);
  RANGE (PORT_PROTOCOL_UDP, 20129, 20129);
  RANGE (PORT_PROTOCOL_UDP, 20146, 20146);
  RANGE (PORT_PROTOCOL_UDP, 20154, 20154);
  RANGE (PORT_PROTOCOL_UDP, 20164, 20164);
  RANGE (PORT_PROTOCOL_UDP, 20206, 20206);
  RANGE (PORT_PROTOCOL_UDP, 20217, 20217);
  RANGE (PORT_PROTOCOL_UDP, 20249, 20249);
  RANGE (PORT_PROTOCOL_UDP, 20262, 20262);
  RANGE (PORT_PROTOCOL_UDP, 20279, 20279);
  RANGE (PORT_PROTOCOL_UDP, 20288, 20288);
  RANGE (PORT_PROTOCOL_UDP, 20309, 20309);
  RANGE (PORT_PROTOCOL_UDP, 20313, 20313);
  RANGE (PORT_PROTOCOL_UDP, 20326, 20326);
  RANGE (PORT_PROTOCOL_UDP, 20359, 20360);
  RANGE (PORT_PROTOCOL_UDP, 20366, 20366);
  RANGE (PORT_PROTOCOL_UDP, 20380, 20380);
  RANGE (PORT_PROTOCOL_UDP, 20389, 20389);
  RANGE (PORT_PROTOCOL_UDP, 20409, 20409);
  RANGE (PORT_PROTOCOL_UDP, 20411, 20411);
  RANGE (PORT_PROTOCOL_UDP, 20423, 20425);
  RANGE (PORT_PROTOCOL_UDP, 20445, 20445);
  RANGE (PORT_PROTOCOL_UDP, 20449, 20449);
  RANGE (PORT_PROTOCOL_UDP, 20464, 20465);
  RANGE (PORT_PROTOCOL_UDP, 20518, 20518);
  RANGE (PORT_PROTOCOL_UDP, 20522, 20522);
  RANGE (PORT_PROTOCOL_UDP, 20525, 20525);
  RANGE (PORT_PROTOCOL_UDP, 20540, 20540);
  RANGE (PORT_PROTOCOL_UDP, 20560, 20560);
  RANGE (PORT_PROTOCOL_UDP, 20665, 20665);
  RANGE (PORT_PROTOCOL_UDP, 20678, 20679);
  RANGE (PORT_PROTOCOL_UDP, 20710, 20710);
  RANGE (PORT_PROTOCOL_UDP, 20717, 20717);
  RANGE (PORT_PROTOCOL_UDP, 20742, 20742);
  RANGE (PORT_PROTOCOL_UDP, 20752, 20752);
  RANGE (PORT_PROTOCOL_UDP, 20762, 20762);
  RANGE (PORT_PROTOCOL_UDP, 20791, 20791);
  RANGE (PORT_PROTOCOL_UDP, 20817, 20817);
  RANGE (PORT_PROTOCOL_UDP, 20842, 20842);
  RANGE (PORT_PROTOCOL_UDP, 20848, 20848);
  RANGE (PORT_PROTOCOL_UDP, 20851, 20851);
  RANGE (PORT_PROTOCOL_UDP, 20865, 20865);
  RANGE (PORT_PROTOCOL_UDP, 20872, 20872);
  RANGE (PORT_PROTOCOL_UDP, 20876, 20876);
  RANGE (PORT_PROTOCOL_UDP, 20884, 20884);
  RANGE (PORT_PROTOCOL_UDP, 20919, 20919);
  RANGE (PORT_PROTOCOL_UDP, 21000, 21000);
  RANGE (PORT_PROTOCOL_UDP, 21016, 21016);
  RANGE (PORT_PROTOCOL_UDP, 21060, 21060);
  RANGE (PORT_PROTOCOL_UDP, 21083, 21083);
  RANGE (PORT_PROTOCOL_UDP, 21104, 21104);
  RANGE (PORT_PROTOCOL_UDP, 21111, 21111);
  RANGE (PORT_PROTOCOL_UDP, 21131, 21131);
  RANGE (PORT_PROTOCOL_UDP, 21167, 21167);
  RANGE (PORT_PROTOCOL_UDP, 21186, 21186);
  RANGE (PORT_PROTOCOL_UDP, 21206, 21207);
  RANGE (PORT_PROTOCOL_UDP, 21212, 21212);
  RANGE (PORT_PROTOCOL_UDP, 21247, 21247);
  RANGE (PORT_PROTOCOL_UDP, 21261, 21261);
  RANGE (PORT_PROTOCOL_UDP, 21282, 21282);
  RANGE (PORT_PROTOCOL_UDP, 21298, 21298);
  RANGE (PORT_PROTOCOL_UDP, 21303, 21303);
  RANGE (PORT_PROTOCOL_UDP, 21318, 21318);
  RANGE (PORT_PROTOCOL_UDP, 21320, 21320);
  RANGE (PORT_PROTOCOL_UDP, 21333, 21333);
  RANGE (PORT_PROTOCOL_UDP, 21344, 21344);
  RANGE (PORT_PROTOCOL_UDP, 21354, 21354);
  RANGE (PORT_PROTOCOL_UDP, 21358, 21358);
  RANGE (PORT_PROTOCOL_UDP, 21360, 21360);
  RANGE (PORT_PROTOCOL_UDP, 21364, 21364);
  RANGE (PORT_PROTOCOL_UDP, 21366, 21366);
  RANGE (PORT_PROTOCOL_UDP, 21383, 21383);
  RANGE (PORT_PROTOCOL_UDP, 21405, 21405);
  RANGE (PORT_PROTOCOL_UDP, 21454, 21454);
  RANGE (PORT_PROTOCOL_UDP, 21468, 21468);
  RANGE (PORT_PROTOCOL_UDP, 21476, 21476);
  RANGE (PORT_PROTOCOL_UDP, 21514, 21514);
  RANGE (PORT_PROTOCOL_UDP, 21524, 21525);
  RANGE (PORT_PROTOCOL_UDP, 21556, 21556);
  RANGE (PORT_PROTOCOL_UDP, 21566, 21566);
  RANGE (PORT_PROTOCOL_UDP, 21568, 21568);
  RANGE (PORT_PROTOCOL_UDP, 21576, 21576);
  RANGE (PORT_PROTOCOL_UDP, 21609, 21609);
  RANGE (PORT_PROTOCOL_UDP, 21621, 21621);
  RANGE (PORT_PROTOCOL_UDP, 21625, 21625);
  RANGE (PORT_PROTOCOL_UDP, 21644, 21644);
  RANGE (PORT_PROTOCOL_UDP, 21649, 21649);
  RANGE (PORT_PROTOCOL_UDP, 21655, 21655);
  RANGE (PORT_PROTOCOL_UDP, 21663, 21663);
  RANGE (PORT_PROTOCOL_UDP, 21674, 21674);
  RANGE (PORT_PROTOCOL_UDP, 21698, 21698);
  RANGE (PORT_PROTOCOL_UDP, 21702, 21702);
  RANGE (PORT_PROTOCOL_UDP, 21710, 21710);
  RANGE (PORT_PROTOCOL_UDP, 21742, 21742);
  RANGE (PORT_PROTOCOL_UDP, 21780, 21780);
  RANGE (PORT_PROTOCOL_UDP, 21784, 21784);
  RANGE (PORT_PROTOCOL_UDP, 21800, 21800);
  RANGE (PORT_PROTOCOL_UDP, 21803, 21803);
  RANGE (PORT_PROTOCOL_UDP, 21834, 21834);
  RANGE (PORT_PROTOCOL_UDP, 21842, 21842);
  RANGE (PORT_PROTOCOL_UDP, 21847, 21847);
  RANGE (PORT_PROTOCOL_UDP, 21868, 21868);
  RANGE (PORT_PROTOCOL_UDP, 21898, 21898);
  RANGE (PORT_PROTOCOL_UDP, 21902, 21902);
  RANGE (PORT_PROTOCOL_UDP, 21923, 21923);
  RANGE (PORT_PROTOCOL_UDP, 21948, 21948);
  RANGE (PORT_PROTOCOL_UDP, 21967, 21967);
  RANGE (PORT_PROTOCOL_UDP, 22029, 22029);
  RANGE (PORT_PROTOCOL_UDP, 22043, 22043);
  RANGE (PORT_PROTOCOL_UDP, 22045, 22045);
  RANGE (PORT_PROTOCOL_UDP, 22053, 22053);
  RANGE (PORT_PROTOCOL_UDP, 22055, 22055);
  RANGE (PORT_PROTOCOL_UDP, 22105, 22105);
  RANGE (PORT_PROTOCOL_UDP, 22109, 22109);
  RANGE (PORT_PROTOCOL_UDP, 22123, 22124);
  RANGE (PORT_PROTOCOL_UDP, 22341, 22341);
  RANGE (PORT_PROTOCOL_UDP, 22692, 22692);
  RANGE (PORT_PROTOCOL_UDP, 22695, 22695);
  RANGE (PORT_PROTOCOL_UDP, 22739, 22739);
  RANGE (PORT_PROTOCOL_UDP, 22799, 22799);
  RANGE (PORT_PROTOCOL_UDP, 22846, 22846);
  RANGE (PORT_PROTOCOL_UDP, 22914, 22914);
  RANGE (PORT_PROTOCOL_UDP, 22986, 22986);
  RANGE (PORT_PROTOCOL_UDP, 22996, 22996);
  RANGE (PORT_PROTOCOL_UDP, 23040, 23040);
  RANGE (PORT_PROTOCOL_UDP, 23176, 23176);
  RANGE (PORT_PROTOCOL_UDP, 23354, 23354);
  RANGE (PORT_PROTOCOL_UDP, 23531, 23531);
  RANGE (PORT_PROTOCOL_UDP, 23557, 23557);
  RANGE (PORT_PROTOCOL_UDP, 23608, 23608);
  RANGE (PORT_PROTOCOL_UDP, 23679, 23679);
  RANGE (PORT_PROTOCOL_UDP, 23781, 23781);
  RANGE (PORT_PROTOCOL_UDP, 23965, 23965);
  RANGE (PORT_PROTOCOL_UDP, 23980, 23980);
  RANGE (PORT_PROTOCOL_UDP, 24007, 24007);
  RANGE (PORT_PROTOCOL_UDP, 24279, 24279);
  RANGE (PORT_PROTOCOL_UDP, 24511, 24511);
  RANGE (PORT_PROTOCOL_UDP, 24594, 24594);
  RANGE (PORT_PROTOCOL_UDP, 24606, 24606);
  RANGE (PORT_PROTOCOL_UDP, 24644, 24644);
  RANGE (PORT_PROTOCOL_UDP, 24854, 24854);
  RANGE (PORT_PROTOCOL_UDP, 24910, 24910);
  RANGE (PORT_PROTOCOL_UDP, 25003, 25003);
  RANGE (PORT_PROTOCOL_UDP, 25157, 25157);
  RANGE (PORT_PROTOCOL_UDP, 25240, 25240);
  RANGE (PORT_PROTOCOL_UDP, 25280, 25280);
  RANGE (PORT_PROTOCOL_UDP, 25337, 25337);
  RANGE (PORT_PROTOCOL_UDP, 25375, 25375);
  RANGE (PORT_PROTOCOL_UDP, 25462, 25462);
  RANGE (PORT_PROTOCOL_UDP, 25541, 25541);
  RANGE (PORT_PROTOCOL_UDP, 25546, 25546);
  RANGE (PORT_PROTOCOL_UDP, 25709, 25709);
  RANGE (PORT_PROTOCOL_UDP, 25931, 25931);
  RANGE (PORT_PROTOCOL_UDP, 26407, 26407);
  RANGE (PORT_PROTOCOL_UDP, 26415, 26415);
  RANGE (PORT_PROTOCOL_UDP, 26720, 26720);
  RANGE (PORT_PROTOCOL_UDP, 26872, 26872);
  RANGE (PORT_PROTOCOL_UDP, 26966, 26966);
  RANGE (PORT_PROTOCOL_UDP, 27015, 27015);
  RANGE (PORT_PROTOCOL_UDP, 27195, 27195);
  RANGE (PORT_PROTOCOL_UDP, 27444, 27444);
  RANGE (PORT_PROTOCOL_UDP, 27473, 27473);
  RANGE (PORT_PROTOCOL_UDP, 27482, 27482);
  RANGE (PORT_PROTOCOL_UDP, 27707, 27707);
  RANGE (PORT_PROTOCOL_UDP, 27892, 27892);
  RANGE (PORT_PROTOCOL_UDP, 27899, 27899);
  RANGE (PORT_PROTOCOL_UDP, 28122, 28122);
  RANGE (PORT_PROTOCOL_UDP, 28369, 28369);
  RANGE (PORT_PROTOCOL_UDP, 28465, 28465);
  RANGE (PORT_PROTOCOL_UDP, 28493, 28493);
  RANGE (PORT_PROTOCOL_UDP, 28543, 28543);
  RANGE (PORT_PROTOCOL_UDP, 28547, 28547);
  RANGE (PORT_PROTOCOL_UDP, 28641, 28641);
  RANGE (PORT_PROTOCOL_UDP, 28840, 28840);
  RANGE (PORT_PROTOCOL_UDP, 28973, 28973);
  RANGE (PORT_PROTOCOL_UDP, 29078, 29078);
  RANGE (PORT_PROTOCOL_UDP, 29243, 29243);
  RANGE (PORT_PROTOCOL_UDP, 29256, 29256);
  RANGE (PORT_PROTOCOL_UDP, 29810, 29810);
  RANGE (PORT_PROTOCOL_UDP, 29823, 29823);
  RANGE (PORT_PROTOCOL_UDP, 29977, 29977);
  RANGE (PORT_PROTOCOL_UDP, 30263, 30263);
  RANGE (PORT_PROTOCOL_UDP, 30303, 30303);
  RANGE (PORT_PROTOCOL_UDP, 30365, 30365);
  RANGE (PORT_PROTOCOL_UDP, 30544, 30544);
  RANGE (PORT_PROTOCOL_UDP, 30656, 30656);
  RANGE (PORT_PROTOCOL_UDP, 30697, 30697);
  RANGE (PORT_PROTOCOL_UDP, 30704, 30704);
  RANGE (PORT_PROTOCOL_UDP, 30718, 30718);
  RANGE (PORT_PROTOCOL_UDP, 30975, 30975);
  RANGE (PORT_PROTOCOL_UDP, 31059, 31059);
  RANGE (PORT_PROTOCOL_UDP, 31073, 31073);
  RANGE (PORT_PROTOCOL_UDP, 31109, 31109);
  RANGE (PORT_PROTOCOL_UDP, 31189, 31189);
  RANGE (PORT_PROTOCOL_UDP, 31195, 31195);
  RANGE (PORT_PROTOCOL_UDP, 31335, 31335);
  RANGE (PORT_PROTOCOL_UDP, 31337, 31337);
  RANGE (PORT_PROTOCOL_UDP, 31365, 31365);
  RANGE (PORT_PROTOCOL_UDP, 31625, 31625);
  RANGE (PORT_PROTOCOL_UDP, 31681, 31681);
  RANGE (PORT_PROTOCOL_UDP, 31731, 31731);
  RANGE (PORT_PROTOCOL_UDP, 31891, 31891);
  RANGE (PORT_PROTOCOL_UDP, 32345, 32345);
  RANGE (PORT_PROTOCOL_UDP, 32385, 32385);
  RANGE (PORT_PROTOCOL_UDP, 32528, 32528);
  RANGE (PORT_PROTOCOL_UDP, 32768, 32780);
  RANGE (PORT_PROTOCOL_UDP, 32798, 32798);
  RANGE (PORT_PROTOCOL_UDP, 32815, 32815);
  RANGE (PORT_PROTOCOL_UDP, 32818, 32818);
  RANGE (PORT_PROTOCOL_UDP, 32931, 32931);
  RANGE (PORT_PROTOCOL_UDP, 33030, 33030);
  RANGE (PORT_PROTOCOL_UDP, 33249, 33249);
  RANGE (PORT_PROTOCOL_UDP, 33281, 33281);
  RANGE (PORT_PROTOCOL_UDP, 33354, 33355);
  RANGE (PORT_PROTOCOL_UDP, 33459, 33459);
  RANGE (PORT_PROTOCOL_UDP, 33717, 33717);
  RANGE (PORT_PROTOCOL_UDP, 33744, 33744);
  RANGE (PORT_PROTOCOL_UDP, 33866, 33866);
  RANGE (PORT_PROTOCOL_UDP, 33872, 33872);
  RANGE (PORT_PROTOCOL_UDP, 34038, 34038);
  RANGE (PORT_PROTOCOL_UDP, 34079, 34079);
  RANGE (PORT_PROTOCOL_UDP, 34125, 34125);
  RANGE (PORT_PROTOCOL_UDP, 34358, 34358);
  RANGE (PORT_PROTOCOL_UDP, 34422, 34422);
  RANGE (PORT_PROTOCOL_UDP, 34433, 34433);
  RANGE (PORT_PROTOCOL_UDP, 34555, 34555);
  RANGE (PORT_PROTOCOL_UDP, 34570, 34570);
  RANGE (PORT_PROTOCOL_UDP, 34577, 34580);
  RANGE (PORT_PROTOCOL_UDP, 34758, 34758);
  RANGE (PORT_PROTOCOL_UDP, 34796, 34796);
  RANGE (PORT_PROTOCOL_UDP, 34855, 34855);
  RANGE (PORT_PROTOCOL_UDP, 34861, 34862);
  RANGE (PORT_PROTOCOL_UDP, 34892, 34892);
  RANGE (PORT_PROTOCOL_UDP, 35438, 35438);
  RANGE (PORT_PROTOCOL_UDP, 35702, 35702);
  RANGE (PORT_PROTOCOL_UDP, 35777, 35777);
  RANGE (PORT_PROTOCOL_UDP, 35794, 35794);
  RANGE (PORT_PROTOCOL_UDP, 36108, 36108);
  RANGE (PORT_PROTOCOL_UDP, 36206, 36206);
  RANGE (PORT_PROTOCOL_UDP, 36384, 36384);
  RANGE (PORT_PROTOCOL_UDP, 36458, 36458);
  RANGE (PORT_PROTOCOL_UDP, 36489, 36489);
  RANGE (PORT_PROTOCOL_UDP, 36669, 36669);
  RANGE (PORT_PROTOCOL_UDP, 36778, 36778);
  RANGE (PORT_PROTOCOL_UDP, 36893, 36893);
  RANGE (PORT_PROTOCOL_UDP, 36945, 36945);
  RANGE (PORT_PROTOCOL_UDP, 37144, 37144);
  RANGE (PORT_PROTOCOL_UDP, 37212, 37212);
  RANGE (PORT_PROTOCOL_UDP, 37393, 37393);
  RANGE (PORT_PROTOCOL_UDP, 37444, 37444);
  RANGE (PORT_PROTOCOL_UDP, 37602, 37602);
  RANGE (PORT_PROTOCOL_UDP, 37761, 37761);
  RANGE (PORT_PROTOCOL_UDP, 37783, 37783);
  RANGE (PORT_PROTOCOL_UDP, 37813, 37813);
  RANGE (PORT_PROTOCOL_UDP, 37843, 37843);
  RANGE (PORT_PROTOCOL_UDP, 38037, 38037);
  RANGE (PORT_PROTOCOL_UDP, 38063, 38063);
  RANGE (PORT_PROTOCOL_UDP, 38293, 38293);
  RANGE (PORT_PROTOCOL_UDP, 38412, 38412);
  RANGE (PORT_PROTOCOL_UDP, 38498, 38498);
  RANGE (PORT_PROTOCOL_UDP, 38615, 38615);
  RANGE (PORT_PROTOCOL_UDP, 39213, 39213);
  RANGE (PORT_PROTOCOL_UDP, 39217, 39217);
  RANGE (PORT_PROTOCOL_UDP, 39632, 39632);
  RANGE (PORT_PROTOCOL_UDP, 39683, 39683);
  RANGE (PORT_PROTOCOL_UDP, 39714, 39714);
  RANGE (PORT_PROTOCOL_UDP, 39723, 39723);
  RANGE (PORT_PROTOCOL_UDP, 39888, 39888);
  RANGE (PORT_PROTOCOL_UDP, 40019, 40019);
  RANGE (PORT_PROTOCOL_UDP, 40116, 40116);
  RANGE (PORT_PROTOCOL_UDP, 40441, 40441);
  RANGE (PORT_PROTOCOL_UDP, 40539, 40539);
  RANGE (PORT_PROTOCOL_UDP, 40622, 40622);
  RANGE (PORT_PROTOCOL_UDP, 40708, 40708);
  RANGE (PORT_PROTOCOL_UDP, 40711, 40711);
  RANGE (PORT_PROTOCOL_UDP, 40724, 40724);
  RANGE (PORT_PROTOCOL_UDP, 40732, 40732);
  RANGE (PORT_PROTOCOL_UDP, 40805, 40805);
  RANGE (PORT_PROTOCOL_UDP, 40847, 40847);
  RANGE (PORT_PROTOCOL_UDP, 40866, 40866);
  RANGE (PORT_PROTOCOL_UDP, 40915, 40915);
  RANGE (PORT_PROTOCOL_UDP, 41058, 41058);
  RANGE (PORT_PROTOCOL_UDP, 41081, 41081);
  RANGE (PORT_PROTOCOL_UDP, 41308, 41308);
  RANGE (PORT_PROTOCOL_UDP, 41370, 41370);
  RANGE (PORT_PROTOCOL_UDP, 41446, 41446);
  RANGE (PORT_PROTOCOL_UDP, 41524, 41524);
  RANGE (PORT_PROTOCOL_UDP, 41638, 41638);
  RANGE (PORT_PROTOCOL_UDP, 41702, 41702);
  RANGE (PORT_PROTOCOL_UDP, 41774, 41774);
  RANGE (PORT_PROTOCOL_UDP, 41896, 41896);
  RANGE (PORT_PROTOCOL_UDP, 41967, 41967);
  RANGE (PORT_PROTOCOL_UDP, 41971, 41971);
  RANGE (PORT_PROTOCOL_UDP, 42056, 42056);
  RANGE (PORT_PROTOCOL_UDP, 42172, 42172);
  RANGE (PORT_PROTOCOL_UDP, 42313, 42313);
  RANGE (PORT_PROTOCOL_UDP, 42431, 42431);
  RANGE (PORT_PROTOCOL_UDP, 42434, 42434);
  RANGE (PORT_PROTOCOL_UDP, 42508, 42508);
  RANGE (PORT_PROTOCOL_UDP, 42557, 42557);
  RANGE (PORT_PROTOCOL_UDP, 42577, 42577);
  RANGE (PORT_PROTOCOL_UDP, 42627, 42627);
  RANGE (PORT_PROTOCOL_UDP, 42639, 42639);
  RANGE (PORT_PROTOCOL_UDP, 43094, 43094);
  RANGE (PORT_PROTOCOL_UDP, 43195, 43195);
  RANGE (PORT_PROTOCOL_UDP, 43370, 43370);
  RANGE (PORT_PROTOCOL_UDP, 43514, 43514);
  RANGE (PORT_PROTOCOL_UDP, 43686, 43686);
  RANGE (PORT_PROTOCOL_UDP, 43824, 43824);
  RANGE (PORT_PROTOCOL_UDP, 43967, 43967);
  RANGE (PORT_PROTOCOL_UDP, 44101, 44101);
  RANGE (PORT_PROTOCOL_UDP, 44160, 44160);
  RANGE (PORT_PROTOCOL_UDP, 44179, 44179);
  RANGE (PORT_PROTOCOL_UDP, 44185, 44185);
  RANGE (PORT_PROTOCOL_UDP, 44190, 44190);
  RANGE (PORT_PROTOCOL_UDP, 44253, 44253);
  RANGE (PORT_PROTOCOL_UDP, 44334, 44334);
  RANGE (PORT_PROTOCOL_UDP, 44508, 44508);
  RANGE (PORT_PROTOCOL_UDP, 44923, 44923);
  RANGE (PORT_PROTOCOL_UDP, 44946, 44946);
  RANGE (PORT_PROTOCOL_UDP, 44968, 44968);
  RANGE (PORT_PROTOCOL_UDP, 45247, 45247);
  RANGE (PORT_PROTOCOL_UDP, 45380, 45380);
  RANGE (PORT_PROTOCOL_UDP, 45441, 45441);
  RANGE (PORT_PROTOCOL_UDP, 45685, 45685);
  RANGE (PORT_PROTOCOL_UDP, 45722, 45722);
  RANGE (PORT_PROTOCOL_UDP, 45818, 45818);
  RANGE (PORT_PROTOCOL_UDP, 45928, 45928);
  RANGE (PORT_PROTOCOL_UDP, 46093, 46093);
  RANGE (PORT_PROTOCOL_UDP, 46532, 46532);
  RANGE (PORT_PROTOCOL_UDP, 46836, 46836);
  RANGE (PORT_PROTOCOL_UDP, 47624, 47624);
  RANGE (PORT_PROTOCOL_UDP, 47765, 47765);
  RANGE (PORT_PROTOCOL_UDP, 47772, 47772);
  RANGE (PORT_PROTOCOL_UDP, 47808, 47808);
  RANGE (PORT_PROTOCOL_UDP, 47915, 47915);
  RANGE (PORT_PROTOCOL_UDP, 47981, 47981);
  RANGE (PORT_PROTOCOL_UDP, 48078, 48078);
  RANGE (PORT_PROTOCOL_UDP, 48189, 48189);
  RANGE (PORT_PROTOCOL_UDP, 48255, 48255);
  RANGE (PORT_PROTOCOL_UDP, 48455, 48455);
  RANGE (PORT_PROTOCOL_UDP, 48489, 48489);
  RANGE (PORT_PROTOCOL_UDP, 48761, 48761);
  RANGE (PORT_PROTOCOL_UDP, 49152, 49163);
  RANGE (PORT_PROTOCOL_UDP, 49165, 49182);
  RANGE (PORT_PROTOCOL_UDP, 49184, 49202);
  RANGE (PORT_PROTOCOL_UDP, 49204, 49205);
  RANGE (PORT_PROTOCOL_UDP, 49207, 49216);
  RANGE (PORT_PROTOCOL_UDP, 49220, 49220);
  RANGE (PORT_PROTOCOL_UDP, 49222, 49222);
  RANGE (PORT_PROTOCOL_UDP, 49226, 49226);
  RANGE (PORT_PROTOCOL_UDP, 49259, 49259);
  RANGE (PORT_PROTOCOL_UDP, 49262, 49262);
  RANGE (PORT_PROTOCOL_UDP, 49306, 49306);
  RANGE (PORT_PROTOCOL_UDP, 49350, 49350);
  RANGE (PORT_PROTOCOL_UDP, 49360, 49360);
  RANGE (PORT_PROTOCOL_UDP, 49393, 49393);
  RANGE (PORT_PROTOCOL_UDP, 49396, 49396);
  RANGE (PORT_PROTOCOL_UDP, 49503, 49503);
  RANGE (PORT_PROTOCOL_UDP, 49640, 49640);
  RANGE (PORT_PROTOCOL_UDP, 49968, 49968);
  RANGE (PORT_PROTOCOL_UDP, 50099, 50099);
  RANGE (PORT_PROTOCOL_UDP, 50164, 50164);
  RANGE (PORT_PROTOCOL_UDP, 50497, 50497);
  RANGE (PORT_PROTOCOL_UDP, 50612, 50612);
  RANGE (PORT_PROTOCOL_UDP, 50708, 50708);
  RANGE (PORT_PROTOCOL_UDP, 50919, 50919);
  RANGE (PORT_PROTOCOL_UDP, 51255, 51255);
  RANGE (PORT_PROTOCOL_UDP, 51456, 51456);
  RANGE (PORT_PROTOCOL_UDP, 51554, 51554);
  RANGE (PORT_PROTOCOL_UDP, 51586, 51586);
  RANGE (PORT_PROTOCOL_UDP, 51690, 51690);
  RANGE (PORT_PROTOCOL_UDP, 51717, 51717);
  RANGE (PORT_PROTOCOL_UDP, 51905, 51905);
  RANGE (PORT_PROTOCOL_UDP, 51972, 51972);
  RANGE (PORT_PROTOCOL_UDP, 52144, 52144);
  RANGE (PORT_PROTOCOL_UDP, 52225, 52225);
  RANGE (PORT_PROTOCOL_UDP, 52503, 52503);
  RANGE (PORT_PROTOCOL_UDP, 53006, 53006);
  RANGE (PORT_PROTOCOL_UDP, 53037, 53037);
  RANGE (PORT_PROTOCOL_UDP, 53571, 53571);
  RANGE (PORT_PROTOCOL_UDP, 53589, 53589);
  RANGE (PORT_PROTOCOL_UDP, 53838, 53838);
  RANGE (PORT_PROTOCOL_UDP, 54094, 54094);
  RANGE (PORT_PROTOCOL_UDP, 54114, 54114);
  RANGE (PORT_PROTOCOL_UDP, 54281, 54281);
  RANGE (PORT_PROTOCOL_UDP, 54321, 54321);
  RANGE (PORT_PROTOCOL_UDP, 54711, 54711);
  RANGE (PORT_PROTOCOL_UDP, 54807, 54807);
  RANGE (PORT_PROTOCOL_UDP, 54925, 54925);
  RANGE (PORT_PROTOCOL_UDP, 55043, 55043);
  RANGE (PORT_PROTOCOL_UDP, 55544, 55544);
  RANGE (PORT_PROTOCOL_UDP, 55587, 55587);
  RANGE (PORT_PROTOCOL_UDP, 56141, 56141);
  RANGE (PORT_PROTOCOL_UDP, 57172, 57172);
  RANGE (PORT_PROTOCOL_UDP, 57409, 57410);
  RANGE (PORT_PROTOCOL_UDP, 57813, 57813);
  RANGE (PORT_PROTOCOL_UDP, 57843, 57843);
  RANGE (PORT_PROTOCOL_UDP, 57958, 57958);
  RANGE (PORT_PROTOCOL_UDP, 57977, 57977);
  RANGE (PORT_PROTOCOL_UDP, 58002, 58002);
  RANGE (PORT_PROTOCOL_UDP, 58075, 58075);
  RANGE (PORT_PROTOCOL_UDP, 58178, 58178);
  RANGE (PORT_PROTOCOL_UDP, 58419, 58419);
  RANGE (PORT_PROTOCOL_UDP, 58631, 58631);
  RANGE (PORT_PROTOCOL_UDP, 58640, 58640);
  RANGE (PORT_PROTOCOL_UDP, 58797, 58797);
  RANGE (PORT_PROTOCOL_UDP, 59193, 59193);
  RANGE (PORT_PROTOCOL_UDP, 59207, 59207);
  RANGE (PORT_PROTOCOL_UDP, 59765, 59765);
  RANGE (PORT_PROTOCOL_UDP, 59846, 59846);
  RANGE (PORT_PROTOCOL_UDP, 60172, 60172);
  RANGE (PORT_PROTOCOL_UDP, 60381, 60381);
  RANGE (PORT_PROTOCOL_UDP, 60423, 60423);
  RANGE (PORT_PROTOCOL_UDP, 61024, 61024);
  RANGE (PORT_PROTOCOL_UDP, 61142, 61142);
  RANGE (PORT_PROTOCOL_UDP, 61319, 61319);
  RANGE (PORT_PROTOCOL_UDP, 61322, 61322);
  RANGE (PORT_PROTOCOL_UDP, 61370, 61370);
  RANGE (PORT_PROTOCOL_UDP, 61412, 61412);
  RANGE (PORT_PROTOCOL_UDP, 61481, 61481);
  RANGE (PORT_PROTOCOL_UDP, 61550, 61550);
  RANGE (PORT_PROTOCOL_UDP, 61685, 61685);
  RANGE (PORT_PROTOCOL_UDP, 61961, 61961);
  RANGE (PORT_PROTOCOL_UDP, 62154, 62154);
  RANGE (PORT_PROTOCOL_UDP, 62287, 62287);
  RANGE (PORT_PROTOCOL_UDP, 62575, 62575);
  RANGE (PORT_PROTOCOL_UDP, 62677, 62677);
  RANGE (PORT_PROTOCOL_UDP, 62699, 62699);
  RANGE (PORT_PROTOCOL_UDP, 62958, 62958);
  RANGE (PORT_PROTOCOL_UDP, 63420, 63420);
  RANGE (PORT_PROTOCOL_UDP, 63555, 63555);
  RANGE (PORT_PROTOCOL_UDP, 64080, 64080);
  RANGE (PORT_PROTOCOL_UDP, 64481, 64481);
  RANGE (PORT_PROTOCOL_UDP, 64513, 64513);
  RANGE (PORT_PROTOCOL_UDP, 64590, 64590);
  RANGE (PORT_PROTOCOL_UDP, 64727, 64727);
}
