// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         The table widget (central widget of the application)
// ****************************************************************************



#ifndef __TABLE_H__
#define __TABLE_H__

#include <QtGui>      //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

#ifndef __DEVICE_H__
  #include "device.h"
#endif

class t_TableLocal;

class t_Table: public QTableView
{
   Q_OBJECT

   public:
      t_Table ();
      t_Table (QWidget *pParent, t_pDeviceList pDeviceList);
     ~t_Table ();

      APIRET AbortAllAcquisitions (void);
      APIRET GetDeviceUnderCursor (t_pDevice &pDevice);

   private:
      APIRET ShowDeviceInfo            (t_pcDevice pDevice);
      APIRET StartAcquisition          (t_pDevice  pDevice);
      APIRET AbortAcquisition0         (t_pDevice  pDevice);
      APIRET AbortAcquisition          (t_pDevice  pDevice);
      APIRET InfoAcquisitionStart      (t_pDevice  pDevice);
      APIRET InfoAcquisitionBadSectors (t_pDevice  pDevice, bool Verify);
      APIRET InfoAcquisitionEnd        (t_pDevice  pDevice);
      APIRET WakeWaitingThreads        (t_pDevice  pDevice);
      APIRET FinaliseThreadStructs     (t_pDevice  pDevice);

   protected:
      void   contextMenuEvent          (QContextMenuEvent *pEvent);

   private slots:
      void SlotMouseClick             (const QModelIndex & index);
      void SlotThreadReadFinished     (t_pDevice pDevice);
      void SlotThreadWriteFinished    (t_pDevice pDevice);
      void SlotThreadHashFinished     (t_pDevice pDevice);
      void SlotThreadCompressFinished (t_pDevice pDevice, int ThreadNr);

   signals:
      void SignalDeviceSelected (t_pDevice pDevice);

   private:
      t_TableLocal *pOwn;
};

typedef t_Table *t_pTable;


// ------------------------------------
//             Error codes
// ------------------------------------

   #ifdef __MODULES_H__
      enum
      {
         ERROR_TABLE_INVALID_ACTION = ERROR_BASE_TABLE + 1,
         ERROR_TABLE_THREADREAD_ALREADY_RUNNING,
         ERROR_TABLE_THREADHASH_ALREADY_RUNNING,
         ERROR_TABLE_THREADWRITE_ALREADY_RUNNING,
         ERROR_TABLE_THREADCOMPRESS_ALREADY_RUNNING,
         ERROR_TABLE_THREADREAD_DOESNT_EXIT,
         ERROR_TABLE_FIFO_EXISTS,
         ERROR_TABLE_CONSTRUCTOR_NOT_SUPPORTED,
         ERROR_TABLE_INVALID_FORMAT
      };
   #endif

#endif
