/*
 * Copyright (C) 2009, 2010 Hermann Meyer, James Warden, Andreas Degert
 * Copyright (C) 2011 Pete Shorthose
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * ---------------------------------------------------------------------------
 *
 *    This is the gx_head cabinet impulse response data file
 *
 * ----------------------------------------------------------------------------
 */


/**----------------------------- cabinet impulse response data --------------------------------**/
CabDesc_imp<1000> cab_data_4x12 __rt_data = {
    1000, 48000,
    { 0.0210554,0.0750885,0.139243,0.180713,0.184139,0.144903,0.0686037,-0.0185033,-0.0886042,-0.12552,
      -0.121363,-0.0787852,-0.0213013,0.0229356,0.0411458,0.0370145,0.0195269,-0.00133213,-0.0152812,-0.0145159,
      -0.00183383,0.0137818,0.0256187,0.0286779,0.0207782,0.0077942,-0.00120299,-0.0031918,-0.00206098,-0.00135227,
      -0.00140983,-0.00497816,-0.0130377,-0.0218103,-0.0277226,-0.0286464,-0.0215221,-0.00951618,-0.00086607,0.0013951,
      4.17435e-05,-0.00319773,-0.00740044,-0.00716618,-0.00255126,0.00219789,0.00519503,0.00521192,0.000273707,-0.00618929,
      -0.00908,-0.010311,-0.0123735,-0.0142287,-0.017697,-0.0241029,-0.0284137,-0.0277091,-0.0227469,-0.0152625,
      -0.00519387,0.00359817,0.00729039,0.00671523,0.00318916,-0.00156796,-0.0063908,-0.00976712,-0.0129904,-0.017544,
      -0.022616,-0.0259348,-0.0261542,-0.0244839,-0.0203182,-0.0130093,-0.00603727,-0.0032797,-0.00488236,-0.00846209,
      -0.0130562,-0.0172578,-0.019061,-0.0178728,-0.0150705,-0.0105603,-0.00434051,0.000776129,0.00313197,0.00289589,
      0.00099021,-0.00304687,-0.00856731,-0.0134404,-0.0173033,-0.019982,-0.0200995,-0.0189035,-0.0176908,-0.0158077,
      -0.0144982,-0.0144288,-0.0148401,-0.0143923,-0.0124568,-0.00914924,-0.00554664,-0.00161911,0.00204186,0.00466298,
      0.00609433,0.00586043,0.00444049,0.00230369,-0.000460247,-0.00331487,-0.00620476,-0.00860464,-0.00977339,-0.0103904,
      -0.010582,-0.010316,-0.00959965,-0.0079265,-0.00490751,-0.000773675,0.00326292,0.0060596,0.00712823,0.0062126,
      0.00304346,-0.00120159,-0.00554078,-0.00940086,-0.0116814,-0.0115473,-0.00920741,-0.00570695,-0.00192381,0.00131636,
      0.00313601,0.00310522,0.0019866,0.00024603,-0.00151895,-0.00254442,-0.00257635,-0.00162088,0.000189493,0.00233523,
      0.00431406,0.00546426,0.00550678,0.00412306,0.00163322,-0.00135299,-0.00397516,-0.00564887,-0.00616138,-0.00556616,
      -0.00411866,-0.00213908,-0.000414186,0.000858571,0.00146968,0.00134177,0.000706731,0.000101598,-2.74503e-05,0.000216126,
      0.000921334,0.00170689,0.00206986,0.00178904,0.00108999,0.000418435,-0.000329494,-0.00108679,-0.00160318,-0.00186207,
      -0.00184908,-0.00174925,-0.0017532,-0.00168678,-0.00128635,-0.000532894,0.000551346,0.00173037,0.00285549,0.00381329,
      0.00444954,0.00483888,0.00505528,0.00517976,0.00536394,0.00566848,0.00582878,0.00582337,0.00573454,0.00568407,
      0.005573,0.00543545,0.00536728,0.00536814,0.00553587,0.00596405,0.00663779,0.00725726,0.00749624,0.00707181,
      0.00588561,0.00408059,0.00192134,3.47446e-05,-0.00100598,-0.000915017,4.2448e-05,0.00134795,0.00249509,0.00322568,
      0.0035816,0.00386374,0.00451921,0.00540239,0.0062616,0.00694728,0.0072783,0.00703991,0.00629145,0.00535576,
      0.00433242,0.0032916,0.00256128,0.00234155,0.00256369,0.00301814,0.00356167,0.00389767,0.00377937,0.00333664,
      0.00305993,0.00308825,0.00323129,0.00347644,0.00368722,0.00369027,0.0035434,0.0033256,0.00313601,0.00318107,
      0.00358381,0.00415188,0.00472327,0.00508203,0.00512893,0.00469563,0.00385072,0.00285837,0.00193384,0.0011745,
      0.000625585,0.000444931,0.000447908,0.000509171,0.000766472,0.00131361,0.00198278,0.00252006,0.00288339,0.00305278,
      0.00301612,0.00284385,0.0027595,0.0028841,0.00307673,0.00335143,0.00374592,0.00420453,0.00472283,0.00537605,
      0.00605867,0.00667969,0.0071488,0.00726939,0.00694415,0.00626471,0.00550721,0.0049613,0.00471663,0.00477505,
      0.00498066,0.00516581,0.00520946,0.00505574,0.00483425,0.00468391,0.00466834,0.00471656,0.00470018,0.00453961,
      0.0042108,0.00375276,0.00315533,0.00236797,0.00148797,0.000770994,0.000356717,0.000263414,0.000411073,0.00065758,
      0.000956942,0.00116598,0.00118259,0.0010794,0.00090411,0.000730068,0.000713639,0.00101561,0.00158903,0.0022272,
      0.00269874,0.00283804,0.00266545,0.00230882,0.00195122,0.00177202,0.0018221,0.00198835,0.00219707,0.0024585,
      0.00262623,0.00258478,0.00247114,0.00236725,0.00229178,0.00227378,0.00223327,0.0020942,0.0018775,0.00165049,
      0.00145125,0.0013392,0.00133322,0.0013771,0.00146459,0.00154074,0.00148781,0.00131534,0.00115589,0.00110735,
      0.00111562,0.00117102,0.0011977,0.00112514,0.000940195,0.000626312,0.000241008,-0.000110301,-0.000294454,-0.00026455,
      -3.9153e-05,0.000364625,0.000848391,0.00124397,0.00133727,0.00111349,0.00081935,0.000737272,0.000979052,0.00152794,
      0.00229764,0.00300549,0.00349459,0.00378848,0.00383738,0.00362037,0.00319689,0.00261696,0.00202673,0.00153753,
      0.0010692,0.000529509,-3.48582e-05,-0.000518806,-0.000836461,-0.000893089,-0.000683757,-0.00041539,-0.000240531,-0.000199855,
      -0.00040037,-0.000829803,-0.00130214,-0.00175941,-0.00214005,-0.00239538,-0.00255126,-0.00260319,-0.00258167,-0.00258312,
      -0.00261625,-0.00257821,-0.00243703,-0.00224874,-0.002035,-0.0018443,-0.00177327,-0.00182376,-0.00196122,-0.00222559,
      -0.00246046,-0.0023872,-0.00200267,-0.00146368,-0.000895475,-0.000426638,-0.000116391,8.54413e-05,0.000229487,0.000434546,
      0.000783401,0.00125185,0.00170428,0.00195945,0.00191818,0.00165093,0.0013,0.000928947,0.00048422,-4.45158e-05,
      -0.000552028,-0.000942422,-0.00123235,-0.00149559,-0.00177645,-0.00204586,-0.00228739,-0.00245312,-0.00249216,-0.00238563,
      -0.00216864,-0.00195288,-0.00184076,-0.0018401,-0.00190445,-0.00195077,-0.0018578,-0.00162677,-0.00132209,-0.00103643,
      -0.000946898,-0.00112221,-0.00150406,-0.00195615,-0.00229437,-0.00239499,-0.00218277,-0.0017268,-0.00124285,-0.00091104,
      -0.000849391,-0.00104366,-0.00129184,-0.00138022,-0.00126944,-0.00107845,-0.000937854,-0.000922902,-0.00107965,-0.00139665,
      -0.00174952,-0.00198203,-0.00202984,-0.00187962,-0.0015708,-0.00124176,-0.00109158,-0.00130834,-0.0019349,-0.00284735,
      -0.00377169,-0.00432535,-0.00427272,-0.00367104,-0.00275803,-0.00184037,-0.00124326,-0.00112073,-0.00138117,-0.00175739,
      -0.00199908,-0.00197451,-0.00163986,-0.00107954,-0.000508739,-0.000136274,-2.69049e-05,-0.000195924,-0.000604997,-0.00107277,
      -0.00139074,-0.00147588,-0.00138458,-0.00119441,-0.00105561,-0.00112623,-0.00139983,-0.00174871,-0.00207738,-0.00232496,
      -0.00235838,-0.00213469,-0.00182601,-0.00162957,-0.00156907,-0.00164833,-0.00185294,-0.00208449,-0.002181,-0.00207736,
      -0.00181851,-0.00145291,-0.00105886,-0.000777402,-0.000693301,-0.000780538,-0.000966736,-0.00110846,-0.00100441,-0.000639605,
      -0.000167997,0.000278684,0.000595589,0.000718707,0.000677736,0.000535644,0.000359331,0.000214058,0.000116118,-2.04741e-05,
      -0.000248734,-0.000545983,-0.00088025,-0.00122061,-0.0015376,-0.00175523,-0.00175457,-0.00148886,-0.00107979,-0.000750293,
      -0.000715752,-0.00112187,-0.0019394,-0.0029335,-0.00377016,-0.00421975,-0.00417837,-0.00370331,-0.00304405,-0.00245053,
      -0.00210699,-0.00207797,-0.0022711,-0.00249086,-0.00253708,-0.00230403,-0.00181831,-0.00124433,-0.000780152,-0.000599361,
      -0.00073175,-0.00104361,-0.00127435,-0.00119859,-0.000762859,-8.26917e-05,0.000629675,0.00112308,0.00126592,0.0011715,
      0.00103854,0.000983915,0.00102964,0.00109781,0.00111035,0.000980961,0.000642923,0.000128366,-0.000457361,-0.000965123,
      -0.00129109,-0.00143212,-0.00144318,-0.0014024,-0.00139796,-0.00148234,-0.00166874,-0.00191579,-0.00211699,-0.00215912,
      -0.0020502,-0.00183696,-0.00155674,-0.00122281,-0.000867206,-0.000589227,-0.000474017,-0.000498718,-0.000541393,-0.000489083,
      -0.000283456,6.39901e-05,0.000442908,0.000769699,0.000966486,0.000987869,0.000807193,0.000472449,6.91029e-05,-0.000300749,
      -0.000520124,-0.000506989,-0.000277707,-7.49884e-07,0.000197924,0.000303067,0.000322268,0.000290614,0.000293023,0.000353695,
      0.000410527,0.000420457,0.000342197,0.000133297,-0.000165088,-0.000453839,-0.000679258,-0.000834689,-0.000952602,-0.00110901,
      -0.00138581,-0.00176734,-0.00213167,-0.00235534,-0.00238038,-0.0022105,-0.0018848,-0.00142392,-0.000878386,-0.000337561,
      0.000124526,0.000442113,0.000576183,0.000579069,0.000590295,0.000704595,0.000887021,0.00101477,0.0010045,0.000847664,
      0.000575138,0.000306771,0.000121299,3.08588e-05,9.36218e-06,-8.68729e-05,-0.000309611,-0.000568184,-0.000781879,-0.00090086,
      -0.000816373,-0.000530804,-0.00015868,0.000212172,0.000470813,0.000541848,0.000420117,0.000213262,5.74002e-05,5.44461e-05,
      0.000231169,0.000503149,0.000735295,0.000831939,0.000801057,0.00070564,0.000658602,0.000765108,0.00102202,0.00132866,
      0.00158623,0.00171223,0.00161877,0.00138119,0.00109374,0.000773789,0.000429865,0.000119368,-0.000121345,-0.000232623,
      -0.000125412,0.000170474,0.000515011,0.000714866,0.000659852,0.000381759,2.34736e-05,-0.000255279,-0.000353581,-0.00027348,
      -8.40097e-05,0.000180108,0.000442772,0.000595703,0.00059443,0.000443181,0.00020006,-4.72427e-05,-0.000237849,-0.000336152,
      -0.000260891,-1.77245e-06,0.000308816,0.000549233,0.000726773,0.000843596,0.000880568,0.000881363,0.000886135,0.000917471,
      0.000981234,0.00105438,0.00110092,0.0011346,0.00116191,0.00120611,0.00130918,0.00150924,0.00173518,0.00188839,
      0.0019312,0.00182619,0.00154596,0.00111546,0.000674054,0.000338175,0.000137615,6.37174e-05,9.953e-05,0.000188198,
      0.000251211,0.000265322,0.000236736,0.000180904,0.000111483,2.96318e-05,-4.73336e-05,-8.53731e-05,-1.88834e-05,0.000190425,
      0.000533576,0.000938581,0.00131834,0.00155549,0.00158925,0.00148725,0.0013572,0.00129875,0.00134022,0.00146789,
      0.00163836,0.00174532,0.00169876,0.00147691,0.00111449,0.000735204,0.000492014,0.000435092,0.000515761,0.000663783,
      0.000799262,0.00084905,0.000801557,0.000690779,0.000557527,0.000428524,0.000314815,0.00019497,5.04922e-05,-0.000104847,
      -0.000234282,-0.000318564,-0.000372079,-0.000385258,-0.00035599,-0.0003227,-0.000303067,-0.000293341,-0.000320655,-0.000354127,
      -0.000328881,-0.000232259,-0.000107938,1.18163e-05,0.000143091,0.000270049,0.000361626,0.000452498,0.00056314,0.000661147,
      0.000724365,0.000744134,0.000727273,0.00072107,0.000736863,0.000779379,0.000855094,0.000962941,0.00110471,0.00125183,
      0.001321,0.00125508,0.00107511,0.000815532,0.000494719,0.000180608,-4.70381e-05,-0.000147682,-0.000113164,2.06559e-05,
      0.000179654,0.000301226,0.00036008,0.000352877,0.000314178,0.000264527,0.000197424,0.000127707,7.75789e-05,3.03816e-05,
      -4.49248e-05,-0.000123981,-0.000188198,-0.000230032,-0.000205332,-9.22811e-05,8.61003e-05,0.000310111,0.000546188,0.00074752,
      0.000886044,0.000967781,0.000983915,0.000906905,0.000743066,0.000538462,0.000377373,0.000343151,0.000430569,0.000540598,
      0.000564958,0.000431751,0.000133502,-0.000251643,-0.000614836,-0.000844801,-0.00086966,-0.000704595,-0.000452021,-0.000232532,
      -0.00011021,-9.40536e-05,-0.000144818,-0.000166747,-0.000102916,5.03785e-05,0.000256278,0.000434682,0.000496309,0.000419026,
      0.000240804,4.47203e-05,-9.02133e-05,-0.000122117,-6.04452e-05,1.82926e-05,5.15602e-05,1.39297e-05,-0.00012089,-0.00033004,
      -0.000557345,-0.000726751,-0.000759268,-0.000650285,-0.000450657,-0.00021608,3.68579e-05,0.000297704,0.000538644,0.000710049,
      0.00077363,0.000723092,0.000614791,0.000532167,0.000514057,0.00058116,0.000682076,0.00072566,0.000673282,0.000508217,
      0.000270299,6.37401e-05,-5.79001e-05,-0.000104257,-9.17585e-05,-6.15359e-05,-5.7741e-05,-7.34204e-05,-8.94407e-05,-0.000104779,
      -0.00013891,-0.000166588,-0.000132638,-2.27237e-05,0.000174609,0.00045193,0.00072032,0.000864434,0.000871569,0.000768994,
      0.00059284,0.00041948,0.000294795,0.000222579,0.000194515,0.000144409,-1.60202e-05,-0.000275753,-0.000566662,-0.00085005,
      -0.00107913,-0.00119302,-0.00120593,-0.00115421,-0.00108797,-0.00107377,-0.00112567,-0.00117748,-0.00117754,-0.00112203,
      -0.00103152,-0.000931128,-0.000873637,-0.000869274,-0.000861684,-0.000822599,-0.000761041,-0.000649717,-0.000460974,-0.000247598,
      -6.14223e-05,9.10313e-05,0.000194265,0.000208968,0.000170814,0.000139069,0.000142114,0.000191107,0.000249529,0.000275162,
      0.000279048,0.000277048,0.000268231,0.000283933,0.000336425,0.000397711,0.000432933,0.0004093,0.00032804,0.000203196,
      6.06951e-05,-4.35841e-05,-8.5464e-05,-7.4602e-05,-3.88122e-05,-4.04483e-05,-0.000130343,-0.00030134,-0.000497514,-0.000679258,
      -0.000815623,-0.000864775,-0.000821327,-0.000721615,-0.000589863,-0.000465223,-0.000387599,-0.000366648,-0.000385849,-0.000436
    }
};

CabDesc_imp<256> cab_data_2x12 __rt_data = {
    256, 48000,
    { 0.000143433, -0.00176392, -0.00148621, -0.000708008, -0.00242004, -0.00015564, -0.00227661, 0.00195923, -0.000411987, -0.0011322, 0.00241699, -0.00110779, 0.00299988,
      -0.000100708, 0.000189209, 0.00255127, -0.00119019, 0.00362854, -0.000640869, 0.000799561, 0.00148926, -0.0009552, -0.000741577, 0.0017334, -0.00278931, -0.00083313, 
      0.000411987, -0.0014679, -0.00211182, -0.000662231, -0.00348206, -0.00157166, -0.00445557, -0.00551147, -0.00564575, -0.00552673, -0.00611267, -0.007901, -0.00586548, 
      -0.00760193, -0.00686646, -0.010202, -0.00746155, -0.00887146, -0.0119141, -0.0100189, -0.0115234, -0.0120728, -0.0124878, -0.0139679, -0.0155396, -0.0146942, 
      -0.0170868, -0.0169342, -0.0191925, -0.017276, -0.0189301, -0.0201874, -0.0189819, -0.0203156, -0.020752, -0.0187805, -0.019931, -0.0156586, -0.0159058, 
      -0.0126221, -0.0113953, -0.00873108, -0.00889282, -0.00210876, -0.0026825, 0.00179138, 0.00219421, 0.00495605, 0.00692444, 0.00840759, 0.0102356, 0.014975, 
      0.019455, 0.0266296, 0.0396606, 0.052948, 0.0664978, 0.0833435, 0.0918762, 0.0999908, 0.0972931, 0.0924927, 0.0758545, 0.054422, 0.0295898, 
      0.00602417, -0.0216614, -0.0355194, -0.0448547, -0.0399078, -0.0199615, 0.00698242, 0.0346191, 0.0591583, 0.0692841, 0.0647217, 0.0514526, 0.0332001, 
      0.0167999, 0.00681458, 0.00488281, 0.00647888, 0.0122345, 0.0148865, 0.0147125, 0.00926208, 0.00722961, 0.000537109, 0.00311279, 0.0019928, 0.00849304, 
      0.00611877, 0.00529175, 0.00500793, 0.00375671, 0.00472717, 0.00438538, 0.00638123, 0.0071991, 0.00927429, 0.0129761, 0.0149109, 0.0128357, 0.0157562, 
      0.0125854, 0.0104034, 0.00974121, 0.0106659, 0.0100616, 0.00920105, 0.0147186, 0.00974426, 0.0111176, 0.00884399, 0.00645752, 0.00431519, 0.00408325, 
      0.00221252, 0.000546265, 0.00363464, -0.00218201, 0.00339966, 0.00130615, 0.00484009, 0.002771, 0.00285339, 0.00342407, 0.00233765, 0.00296021, 0.00154114, 
      0.00496216, 0.00328369, 0.0069397, 0.00532227, 0.00668945, 0.00419006, 0.00760803, 0.00194397, 0.00585327, 0.00207825, 0.00577087, 0.00396423, 0.00489502, 
      0.00350037, 0.00200195, 0.00146179, 0.000360107, -0.00267944, -0.000491333, -0.00198975, -3.35693e-05, -0.00172119, -0.00174561, -0.00203552, -0.00316162, -0.00356445, 
      -0.00203552, -0.00137329, -0.000125122, -0.0014679, 0.00169983, -0.00302734, -0.000732422, -0.00154114, 0.00132141, 0.00317993, 0.00477905, 0.00530701, 0.00194397, 
      0.00465393, 0.00020752, -0.00163574, 0.00102844, 0.000671387, 0.00357056, 0.00527344, 0.00367432, 0.00550232, 0.000964355, 0.000823975, -0.0027832, -0.00310669, 
      -0.00472412, -0.00222473, -0.000158691, -0.00157166, 0.00230713, 0.00313721, 0.00281067, 0.0050415, 0.000247192, 0.00225525, 0.00065918, -0.00229492, -0.00158997, 
      -0.00288391, -0.00158081, -0.00151978, 0.000778198, -0.00110779, 0.0043457, 0.00118408, 0.00274353, 0.00305481, -0.00177917, 0.00302429, -0.00206604, -0.00274048, 
      -0.00111694, -0.00370483, -0.00282898, -0.00700989, -0.00551453, -0.00950012, -0.00652161, -0.00733643, -0.00209961, -0.00406799, -0.00316162, -0.00356445, -0.00203552, 
      -0.00137329, -0.000125122, -0.0014679, 0.00169983, -0.00302734, -0.000732422, -0.00154114, 0.00132141, 0.00317993
    }
};

CabDesc_imp<768> cab_data_1x12 __rt_data = {
    768, 48000,
    { -0.00323486, -0.0026062, -0.00215454, -0.00219116, -0.00232544, -0.00252686, -0.002948, -0.00360107, -0.00460205, -0.00614014, -0.00812988, -0.0102478, -0.0127991,
      -0.0177124, -0.02771, -0.0431702, -0.0599945, -0.0708221, -0.0681854, -0.0474915, -0.0095398, 0.0378418, 0.0806122, 0.0999969, 0.0999969, 0.0800568,
      0.0421997, -0.00293579, -0.0395203, -0.057785, -0.0583466, -0.0467346, -0.0289368, -0.0101624, 0.00603027, 0.0182739, 0.0267273, 0.0316956, 0.0329712,
      0.0304016, 0.0247803, 0.017749, 0.0108948, 0.00513916, 0.000915527, -0.0013855, -0.00125732, 0.00157471, 0.00671997, 0.0129822, 0.0184143, 0.0207336,
      0.0182556, 0.0109802, 0.000982666, -0.00841675, -0.0141663, -0.0147156, -0.0104309, -0.00318604, 0.00450439, 0.0104492, 0.013446, 0.0133362, 0.0107178, 
      0.00665894, 0.00249023, -0.000457764, -0.00115967, 0.000714111, 0.00458984, 0.00911255, 0.0126099, 0.0137512, 0.0121033, 0.00830078, 0.00375977, 8.54492e-05, 
      -0.0015564, -0.000823975, 0.00172729, 0.00490723, 0.00735474, 0.00796509, 0.00628052, 0.00263672, -0.00196533, -0.00614014, -0.00858765, -0.00855103, -0.0060852, 
      -0.00204468, 0.00221558, 0.00528564, 0.00625, 0.00495605, 0.00204468, -0.00131836, -0.00386353, -0.0046936, -0.00354004, -0.000854492, 0.00239258, 0.00506592, 
      0.0062561, 0.00559692, 0.00337524, 0.000402832, -0.00227051, -0.00375366, -0.00361328, -0.00202026, 0.00032959, 0.00247192, 0.00354004, 0.00303345, 0.00101929, 
      -0.00193481, -0.00493774, -0.00710449, -0.00784302, -0.00702515, -0.0050415, -0.0026123, -0.000579834, 0.000408936, 7.93457e-05, -0.00136108, -0.00332031, -0.00504761, 
      -0.00588989, -0.00551147, -0.0039978, -0.00186157, 0.000189209, 0.00145264, 0.00150757, 0.000341797, -0.00163574, -0.00372925, -0.0052124, -0.00556641, -0.00467529, 
      -0.00284424, -0.000726318, 0.000921631, 0.00150146, 0.000732422, -0.0012085, -0.00378418, -0.00626221, -0.00796509, -0.00845947, -0.00770874, -0.00604858, -0.00406494, 
      -0.00238647, -0.00150757, -0.00159912, -0.00249634, -0.00377808, -0.00490723, -0.00545044, -0.0052002, -0.00426025, -0.00296631, -0.00180054, -0.00115967, -0.00125122, 
      -0.00201416, -0.00314331, -0.00421143, -0.00482178, -0.00476074, -0.00404053, -0.00294189, -0.00186768, -0.00123291, -0.00127563, -0.00201416, -0.00321045, -0.00445557, 
      -0.00533447, -0.0055481, -0.00501099, -0.00392456, -0.00266113, -0.00166626, -0.00127563, -0.00162964, -0.0026062, -0.00388184, -0.0050354, -0.00567627, -0.00557861, 
      -0.00476685, -0.00348511, -0.00211182, -0.00106812, -0.000640869, -0.000897217, -0.00169067, -0.00269165, -0.00352173, -0.00388184, -0.0036499, -0.00292358, -0.00197754, 
      -0.00115356, -0.000726318, -0.000830078, -0.00140991, -0.00224609, -0.00305786, -0.00357056, -0.0036377, -0.00325928, -0.00257568, -0.00182495, -0.00125732, -0.0010498, 
      -0.00126343, -0.00178833, -0.0024292, -0.00292358, -0.00306396, -0.00276489, -0.0020752, -0.00120239, -0.000421143, 4.88281e-05, 7.32422e-05, -0.000317383, -0.000952148, 
      -0.00157471, -0.00195312, -0.00194702, -0.00155029, -0.000909424, -0.000244141, 0.000213623, 0.000305176, 1.2207e-05, -0.00055542, -0.00118408, -0.00163574, -0.00174561, 
      -0.00146484, -0.000878906, -0.000170898, 0.00043335, 0.000744629, 0.000683594, 0.000299072, -0.000256348, -0.000775146, -0.00106812, -0.00103149, -0.00067749, -0.00012207, 
      0.000445557, 0.000842285, 0.000958252, 0.00078125, 0.000396729, -3.66211e-05, -0.000341797, -0.000384521, -0.000134277, 0.000354004, 0.000927734, 0.00142212, 0.00168457, 
      0.00165405, 0.00136108, 0.000915527, 0.000482178, 0.000213623, 0.000189209, 0.000427246, 0.000836182, 0.00128174, 0.00162964, 0.00177612, 0.00169067, 0.00141602, 
      0.00106812, 0.000775146, 0.000634766, 0.000701904, 0.000952148, 0.00130005, 0.00164185, 0.00187988, 0.00195923, 0.00188599, 0.00172119, 0.00154419, 0.00145264, 
      0.00148926, 0.00164795, 0.00187988, 0.00209351, 0.00222778, 0.00223389, 0.00211182, 0.0019165, 0.00172729, 0.00162964, 0.00166626, 0.00184937, 0.00213013, 
      0.00241089, 0.0026123, 0.00265503, 0.00253296, 0.00227051, 0.00195923, 0.00169067, 0.0015625, 0.00160522, 0.00181885, 0.00213013, 0.00245972, 0.00270386, 
      0.00280762, 0.00275269, 0.00256958, 0.00234375, 0.00213623, 0.00202026, 0.00202637, 0.00213013, 0.00227661, 0.00241089, 0.00247803, 0.00245361, 0.00234375, 
      0.00219116, 0.00206299, 0.00201416, 0.00206909, 0.00221558, 0.00241699, 0.0026062, 0.00272217, 0.00272827, 0.00262451, 0.00244751, 0.0022522, 0.00209961, 
      0.00203857, 0.0020813, 0.00220947, 0.00236816, 0.00251465, 0.00259399, 0.00259399, 0.00252075, 0.00239868, 0.00229492, 0.00224609, 0.00227661, 0.00237427, 
      0.00251465, 0.00264282, 0.00272217, 0.00272217, 0.00263062, 0.00248413, 0.00231323, 0.00218506, 0.00211792, 0.00213013, 0.00219727, 0.00229492, 0.00238037, 
      0.00241089, 0.00238037, 0.00228271, 0.00216064, 0.00204468, 0.00197144, 0.00196533, 0.00202026, 0.00211182, 0.00219727, 0.0022522, 0.00223999, 0.00216675, 
      0.00205078, 0.0019165, 0.00181274, 0.00176392, 0.00176392, 0.00181885, 0.00188599, 0.00194702, 0.00196533, 0.00192871, 0.00184326, 0.0017395, 0.00164795, 
      0.00158691, 0.00158081, 0.00162354, 0.00169067, 0.00176392, 0.00180664, 0.00180664, 0.00175171, 0.00166626, 0.0015686, 0.00148926, 0.00145264, 0.00145264, 
      0.00148926, 0.00154419, 0.00158081, 0.00158081, 0.00154419, 0.00147095, 0.00137939, 0.00128784, 0.00122681, 0.00120239, 0.0012146, 0.00124512, 0.00128784, 
      0.00130005, 0.00128174, 0.00122681, 0.00114136, 0.0010498, 0.000976562, 0.000927734, 0.000915527, 0.000933838, 0.000964355, 0.000976562, 0.000970459, 0.000933838, 
      0.000860596, 0.000775146, 0.000689697, 0.000628662, 0.000598145, 0.000592041, 0.000610352, 0.000628662, 0.000628662, 0.000604248, 0.00055542, 0.000482178, 0.000402832, 
      0.000341797, 0.000299072, 0.000292969, 0.000299072, 0.000317383, 0.000323486, 0.000317383, 0.000286865, 0.000231934, 0.000164795, 9.76563e-05, 4.88281e-05, 2.44141e-05, 
      2.44141e-05, 3.66211e-05, 4.88281e-05, 4.88281e-05, 2.44141e-05, -1.83105e-05, -7.93457e-05, -0.000140381, -0.000195313, -0.000231934, -0.000244141, -0.000238037, -0.000231934, 
      -0.00022583, -0.000231934, -0.000262451, -0.000305176, -0.000360107, -0.000415039, -0.00045166, -0.000469971, -0.000469971, -0.000463867, -0.00045166, -0.00045166, -0.000463867, 
      -0.000500488, -0.000543213, -0.000598145, -0.000640869, -0.000665283, -0.00067749, -0.000683594, -0.00067749, -0.00067749, -0.000683594, -0.000714111, -0.000756836, -0.000805664, 
      -0.000848389, -0.000891113, -0.000915527, -0.000927734, -0.000927734, -0.000927734, -0.000933838, -0.000958252, -0.00098877, -0.0010376, -0.00108032, -0.00112305, -0.00114746, 
      -0.00116577, -0.00117188, -0.00117188, -0.00117188, -0.00118408, -0.0012085, -0.00124512, -0.00128174, -0.00132446, -0.00134888, -0.00136719, -0.00137329, -0.00137939, 
      -0.00137939, -0.0013855, -0.00139771, -0.00142212, -0.00145874, -0.00148926, -0.00151978, -0.00153809, -0.00155029, -0.00155029, -0.00155029, -0.00155029, -0.0015564, 
      -0.00157471, -0.00159302, -0.00162354, -0.00164795, -0.00166626, -0.00167847, -0.00167847, -0.00167236, -0.00166626, -0.00166016, -0.00166626, -0.00168457, -0.00170288, 
      -0.00172119, -0.0017334, -0.0017395, -0.00174561, -0.0017395, -0.00172729, -0.00172119, -0.00171509, -0.00171509, -0.0017334, -0.00174561, -0.00175781, -0.00176392, 
      -0.00176392, -0.00175781, -0.00175171, -0.0017395, -0.00172729, -0.00172729, -0.0017334, -0.0017395, -0.00174561, -0.00175171, -0.00175171, -0.00174561, -0.0017395, 
      -0.00172119, -0.00170898, -0.00170288, -0.00170288, -0.00170288, -0.00170898, -0.00170898, -0.00170898, -0.00170288, -0.00169678, -0.00167847, -0.00166626, -0.00165405, 
      -0.00164795, -0.00164185, -0.00164185, -0.00164795, -0.00164795, -0.00164185, -0.00162964, -0.00161743, -0.00160522, -0.00159302, -0.00158081, -0.00157471, -0.00157471, 
      -0.00157471, -0.00157471, -0.00157471, -0.0015625, -0.0015564, -0.00153809, -0.00152588, -0.00151367, -0.00150146, -0.00149536, -0.00149536, -0.00149536, -0.00148926, 
      -0.00148315, -0.00147095, -0.00145874, -0.00144653, -0.00143433, -0.00142212, -0.00141602, -0.00140991, -0.00140381, -0.00140381, -0.00139771, -0.0013916, -0.00137939, 
      -0.00136108, -0.00134888, -0.00133667, -0.00132446, -0.00131836, -0.00131836, -0.00131226, -0.00130615, -0.00129395, -0.00128784, -0.00127563, -0.00126343, -0.00125122, 
      -0.00123901, -0.00122681, -0.0012207, -0.0012146, -0.0012085, -0.00120239, -0.00119019, -0.00118408, -0.00116577, -0.00115356, -0.00114136, -0.00112915, -0.00112305, 
      -0.00111084, -0.00110474, -0.00109863, -0.00108643, -0.00107422, -0.00106201, -0.0010498, -0.0010376, -0.00102539, -0.00101318, -0.00100708, -0.000994873, -0.00098877, 
      -0.000976562, -0.000970459, -0.000952148, -0.000933838, -0.000921631, -0.000909424, -0.000897217, -0.00088501, -0.000872803, -0.000866699, -0.000854492, -0.000842285, -0.000830078, 
      -0.000817871, -0.000799561, -0.00078125, -0.000769043, -0.000756836, -0.000744629, -0.000738525, -0.000726318, -0.000708008, -0.000695801, -0.000683594, -0.000665283, -0.000646973, 
      -0.000634766, -0.000616455, -0.000604248, -0.000592041, -0.000579834, -0.000567627, -0.00055542, -0.000543213, -0.000524902, -0.000506592, -0.000488281, -0.000469971, -0.000457764, 
      -0.000445557, -0.000427246, -0.000415039, -0.0012085, -0.00120239, -0.00119019, -0.00118408, -0.00116577, -0.00115356, -0.00114136, -0.00112915, -0.00112305, -0.00111084, 
      -0.00110474, -0.00109863, -0.00108643, -0.00107422, -0.00106201, -0.0010498, -0.0010376, -0.00102539, -0.00101318, -0.00100708, -0.000994873, -0.00098877, -0.000976562, 
      -0.000970459, -0.000952148, -0.000933838, -0.000921631, -0.000909424, -0.000897217, -0.00088501, -0.000872803, -0.000866699, -0.000854492, -0.000842285, -0.000830078, -0.000817871, 
      -0.000799561, -0.00078125, -0.000769043, -0.000756836, -0.000744629, -0.000738525, -0.000726318, -0.000708008, -0.000695801, -0.000683594, -0.000665283, -0.000646973, -0.000634766, 
      -0.000616455
    }
};

CabDesc_imp<192> cab_data_4x10 __rt_data = {
    192, 48000,
    { -0.00127869, 0.00161743, 0.00407104, 0.00612183, 0.00762024, 0.00864563, 0.00959778, 0.0106781, 0.012323, 0.0140106, 0.0155396, 0.0171661, 0.0183319, 
      0.0191315, 0.0198395, 0.0205811, 0.0225037, 0.0254089, 0.0303925, 0.0372711, 0.0453613, 0.053598, 0.0605743, 0.0649933, 0.0650116, 0.0606659, 
      0.0507782, 0.0354889, 0.0160004, -0.00758972, -0.03237, -0.0576294, -0.0792542, -0.0948212, -0.0999908, -0.0914398, -0.068631, -0.0339661, 0.00720825, 
      0.0443512, 0.0698151, 0.0776123, 0.0687683, 0.0484406, 0.0240448, 0.00180359, -0.0130371, -0.0180328, -0.0166748, -0.0127258, -0.00917053, -0.0100311, 
      -0.012796, -0.0172699, -0.0201721, -0.0199005, -0.0164795, -0.0103485, -0.00448303, 0.00255737, 0.0116364, 0.0191681, 0.025708, 0.0295044, 0.02995, 
      0.0285522, 0.0245453, 0.0208923, 0.017215, 0.0149109, 0.0141632, 0.0138, 0.0138672, 0.011972, 0.0101074, 0.00586548, 0.000982666, -0.00349121, 
      -0.00653687, -0.00697937, -0.00524902, -0.00151367, 0.00343323, 0.00736694, 0.0103119, 0.0115204, 0.0104492, 0.00857239, 0.00618896, 0.00401306, 0.0024292, 
      0.00177307, 0.00161743, 0.00158081, 0.00184937, 0.00117493, 0.00020752, -0.00119629, -0.00360718, -0.00652771, -0.00944214, -0.0124268, -0.0143829, -0.0154663, 
      -0.0145752, -0.0119659, -0.00792542, -0.00200806, 0.00418396, 0.00961609, 0.0153625, 0.0190033, 0.0211456, 0.0216125, 0.0208405, 0.0193878, 0.017038, 
      0.0155701, 0.0131287, 0.0117371, 0.00980835, 0.00735779, 0.0049408, 0.00132751, -0.00110474, -0.00444031, -0.00651245, -0.00769653, -0.00765686, -0.00734558, 
      -0.00555115, -0.00413818, -0.00224304, -0.00125732, -5.79834e-05, -0.000350952, -0.00117188, -0.00144348, -0.0026062, -0.00310364, -0.00305481, -0.00302124, -0.00183411, 
      -0.000488281, 0.000585938, 0.00231934, 0.00340271, 0.00406494, 0.00453491, 0.00434265, 0.004245, 0.00285339, 0.00235901, 0.00172729, 0.00112305, 0.00126038, 
      0.00177307, 0.00145874, 0.0016449, 0.00185242, 0.000848389, -2.74658e-05, -0.000836182, -0.0020752, -0.0032196, -0.00380859, -0.00497742, -0.00567932, -0.00545349, 
      -0.00553589, -0.00474548, -0.00353088, -0.00265198, -0.000836182, 0.000234985, 0.0011322, 0.00188599, 0.00175476, 0.00196533, 0.000793457, 0.000292969, -0.000595093, 
      -0.00149841, -0.00177307, -0.00255737, -0.00216064, -0.00216675, -0.00181885, -0.000634766, -0.00444031, -0.00651245, -0.00769653
    }
};

CabDesc_imp<896> cab_data_2x10 __rt_data = {
    896, 48000,
    { 0.000701904, 0.000823975, 0.00101318, 0.0013916, 0.000299072, -0.00462647, -0.0127136, -0.0191956, -0.0182678, -0.00629272, 0.0156799, 0.041217, 0.0609344, 
      0.0665375, 0.0536774, 0.023584, -0.0168274, -0.0571197, -0.0869965, -0.0999969, -0.09534, -0.0768219, -0.0508453, -0.0246521, -0.0041687, 0.00806885, 
      0.0136108, 0.0166321, 0.0211365, 0.028302, 0.0363892, 0.0423523, 0.0434326, 0.0385742, 0.0293823, 0.0194702, 0.0121216, 0.00860596, 0.00822144, 
      0.00960693, 0.0114746, 0.0130127, 0.0138916, 0.0137878, 0.0119385, 0.00778198, 0.0020874, -0.00289307, -0.00475464, -0.00239258, 0.00332642, 0.0101624, 
      0.0153625, 0.0167786, 0.013739, 0.00699463, -0.00172729, -0.0103699, -0.0168518, -0.0196838, -0.0183411, -0.0133484, -0.00605469, 0.00200195, 0.00923462, 
      0.0139893, 0.0151001, 0.0125854, 0.00786743, 0.00292969, -0.000628662, -0.00247803, -0.00336304, -0.00439453, -0.00619507, -0.00830689, -0.00966187, -0.00929565, 
      -0.00700684, -0.00344238, 0.000524902, 0.00419312, 0.00692139, 0.00824585, 0.0081604, 0.00713501, 0.00574341, 0.00414429, 0.00217896, -0.000311279, -0.00321655, 
      -0.00609131, -0.00819702, -0.00891113, -0.00831909, -0.00726929, -0.00689697, -0.00792236, -0.0101624, -0.0124634, -0.0132263, -0.0112366, -0.00629272, 0.000640869, 
      0.00797119, 0.0139648, 0.0171448, 0.0166016, 0.0124878, 0.00604248, -0.00100098, -0.00710449, -0.011322, -0.0135254, -0.0142273, -0.0141541, -0.0136902, 
      -0.0127991, -0.0111633, -0.00863647, -0.00557861, -0.00278931, -0.00119019, -0.00130005, -0.00289307, -0.0052063, -0.00730591, -0.00861816, -0.00912476, -0.00928345, 
      -0.00953369, -0.00999756, -0.0102722, -0.00982056, -0.00823364, -0.00562744, -0.00252686, 0.000286865, 0.00222778, 0.00302734, 0.00269165, 0.0015625, 0.000164795, 
      -0.000964355, -0.00169067, -0.0022522, -0.00305176, -0.00438232, -0.00618286, -0.00800781, -0.00917358, -0.00906982, -0.00733032, -0.00408936, 0.00012207, 0.00445557, 
      0.00794678, 0.0098999, 0.010022, 0.00843506, 0.00561523, 0.0020752, -0.00162354, -0.00493164, -0.00724487, -0.00803223, -0.00710449, -0.00487671, -0.0022644, 
      -0.000372314, 6.10352e-05, -0.000927734, -0.00263062, -0.0039917, -0.00420532, -0.00299072, -0.000665283, 0.00198975, 0.00418091, 0.00532837, 0.00530396, 0.00439453, 
      0.00308838, 0.00186157, 0.00107422, 0.000836182, 0.00106201, 0.00157471, 0.00223999, 0.00307617, 0.00406494, 0.00514526, 0.00615845, 0.00682983, 0.00684204, 
      0.00596924, 0.00418091, 0.00161133, -0.0013916, -0.00432739, -0.00655518, -0.00755615, -0.00717163, -0.00557861, -0.00325317, -0.000726318, 0.00158691, 0.00351562, 
      0.00510254, 0.00646973, 0.00783081, 0.00927124, 0.0106628, 0.0116882, 0.0118774, 0.0109497, 0.00900879, 0.00653076, 0.00420532, 0.00264282, 0.00215454, 
      0.00262451, 0.00362549, 0.00461426, 0.00509033, 0.00480347, 0.00383911, 0.00262451, 0.00167847, 0.00132446, 0.00151367, 0.00186157, 0.00192871, 0.00146484, 
      0.000463867, -0.000787353, -0.00187378, -0.00234985, -0.00200195, -0.000811768, 0.000952148, 0.00287476, 0.00452881, 0.00567017, 0.00630493, 0.00655518, 0.0065918, 
      0.00655518, 0.00646973, 0.00637207, 0.0062439, 0.0060791, 0.00592041, 0.00579224, 0.00563355, 0.00536499, 0.00487671, 0.00414429, 0.00327759, 0.00240479, 
      0.00166626, 0.0012146, 0.00116577, 0.00162354, 0.00245361, 0.00321655, 0.00341797, 0.0027771, 0.00145264, -0.000109863, -0.00142822, -0.00228882, -0.00276489, 
      -0.00311279, -0.00361328, -0.00431519, -0.00496826, -0.00514526, -0.00450439, -0.00291748, -0.000610352, 0.00196533, 0.00422974, 0.00567017, 0.00617065, 0.00600586, 
      0.00562744, 0.00543213, 0.00563355, 0.00619507, 0.00686646, 0.00720825, 0.00698242, 0.00618286, 0.00507812, 0.00397949, 0.00303955, 0.0022522, 0.00150146, 
      0.000628662, -0.000402832, -0.00150146, -0.00232544, -0.00256348, -0.00211182, -0.00116577, -9.76563e-05, 0.000653076, 0.000848389, 0.000476074, -0.000152588, -0.000622559, 
      -0.000598145, -8.54492e-05, 0.000628662, 0.00119019, 0.00123901, 0.000665283, -0.000335693, -0.00137939, -0.00212402, -0.0024292, -0.00246582, -0.00240479, -0.00237427, 
      -0.00233765, -0.00222778, -0.00198975, -0.00162354, -0.00114136, -0.000640869, -0.000152588, 0.000274658, 0.000628662, 0.000915527, 0.00107422, 0.00111084, 0.00101318, 
      0.000811768, 0.000585938, 0.000390625, 0.000286865, 0.000262451, 0.000250244, 0.000213623, 0.00022583, 0.000299072, 0.0003479, 0.000177002, -0.000335693, -0.00122681, 
      -0.00233765, -0.00340576, -0.0041687, -0.00438232, -0.0039917, -0.00315552, -0.00221558, -0.00153809, -0.0013916, -0.00182495, -0.00266724, -0.00366821, -0.00457764, 
      -0.00526733, -0.00568237, -0.00579224, -0.00549316, -0.00475464, -0.00362549, -0.0022644, -0.00098877, -0.000128174, 9.76563e-05, -0.000189209, -0.000750732, -0.00117798, 
      -0.00123901, -0.000836182, -0.000128174, 0.000561523, 0.000915527, 0.000689697, -0.000201416, -0.00157471, -0.0029541, -0.00390625, -0.00412598, -0.00360107, -0.00265503, 
      -0.0017395, -0.00131226, -0.00158691, -0.00253906, -0.00380249, -0.00488281, -0.00540771, -0.00534058, -0.00494385, -0.00462647, -0.00460205, -0.00484009, -0.0050293, 
      -0.00484009, -0.00412598, -0.00302734, -0.0019165, -0.00116577, -0.000939941, -0.00112305, -0.00144043, -0.00164185, -0.00161133, -0.00137329, -0.00111084, -0.000976562, 
      -0.00107422, -0.00136108, -0.00169067, -0.0019043, -0.00196533, -0.00200195, -0.00220337, -0.00271606, -0.003479, -0.00425415, -0.00471802, -0.00460205, -0.00389404, 
      -0.00282593, -0.00178833, -0.00116577, -0.00109863, -0.00146484, -0.00198975, -0.00236206, -0.00233765, -0.00187988, -0.00107422, -0.000177002, 0.000512695, 0.000811768, 
      0.000622559, 3.66211e-05, -0.000775146, -0.00158691, -0.00219116, -0.00252686, -0.00263062, -0.00267944, -0.00278931, -0.00302734, -0.00340576, -0.00388184, -0.00431519, 
      -0.00454102, -0.00436401, -0.00375366, -0.00283813, -0.00186157, -0.00112305, -0.000799561, -0.000872803, -0.00116577, -0.00144043, -0.00153809, -0.00140381, -0.00111084, 
      -0.000750732, -0.000378418, -8.54492e-05, 9.76563e-05, 0.000201416, 0.000213623, 0.000140381, -1.2207e-05, -0.000274658, -0.00057373, -0.000836182, -0.00101318, -0.00112305, 
      -0.0012146, -0.00141602, -0.00182495, -0.0024292, -0.00307617, -0.00360107, -0.0038269, -0.00372925, -0.00338135, -0.00303955, -0.00287476, -0.00297852, -0.00326538, 
      -0.003479, -0.00336304, -0.00272827, -0.00165405, -0.000378418, 0.000787353, 0.00167847, 0.0022522, 0.0026123, 0.00287476, 0.00305176, 0.0031311, 0.00303955, 
      0.0027771, 0.00239258, 0.00202637, 0.00178833, 0.00176392, 0.0019043, 0.0020752, 0.0020874, 0.00180054, 0.00115356, 0.000250244, -0.000714111, -0.00148926, 
      -0.00184937, -0.0017395, -0.00127563, -0.00067749, -0.000152588, 0.000189209, 0.000427246, 0.000653076, 0.000927734, 0.00126343, 0.00157471, 0.00181274, 0.00194092, 
      0.00196533, 0.00189209, 0.00180054, 0.00176392, 0.00186157, 0.00209961, 0.00238037, 0.00257568, 0.00258789, 0.00241699, 0.00216675, 0.00197754, 0.00194092, 
      0.00203857, 0.00220337, 0.00230103, 0.00221558, 0.00192871, 0.00151367, 0.00112305, 0.000878906, 0.000811768, 0.000775146, 0.000610352, 0.000262451, -0.000164795, 
      -0.000439453, -0.000274658, 0.000488281, 0.00180054, 0.00331421, 0.00461426, 0.00534058, 0.00536499, 0.00480347, 0.00394287, 0.00307617, 0.00244141, 0.00211182, 
      0.00200195, 0.00198975, 0.00200195, 0.00201416, 0.00206299, 0.00217896, 0.00238037, 0.00258789, 0.00266724, 0.00253906, 0.00214233, 0.00162354, 0.00111084, 
      0.000714111, 0.000500488, 0.000463867, 0.000585938, 0.000836182, 0.00114136, 0.00146484, 0.00171509, 0.00183716, 0.00177612, 0.00151367, 0.00109863, 0.000640869, 
      0.000427246, 0.000653076, 0.00137939, 0.00244141, 0.00351562, 0.00427856, 0.00458984, 0.00449219, 0.00413208, 0.00372925, 0.00341797, 0.00317993, 0.00290527, 
      0.00249023, 0.0019043, 0.00127563, 0.000726318, 0.000390625, 0.000311279, 0.000415039, 0.000585938, 0.000665283, 0.000598145, 0.000378418, 9.76563e-05, -9.76563e-05, 
      -0.000189209, -0.000164795, -0.00012207, -9.76563e-05, -0.000140381, -0.00022583, -0.000262451, -0.000177002, 1.2207e-05, 0.000274658, 0.000476074, 0.000500488, 0.000323486, 
      -2.44141e-05, -0.000390625, -0.000598145, -0.000488281, -1.2207e-05, 0.000738525, 0.00159912, 0.00231323, 0.00271606, 0.00272827, 0.00240479, 0.00189209, 0.0013916, 
      0.00108643, 0.00102539, 0.00115356, 0.00134888, 0.00146484, 0.00146484, 0.00136108, 0.00126343, 0.00126343, 0.00133667, 0.00137329, 0.00123901, 0.000915527, 
      0.000463867, 0, -0.0003479, -0.000549316, -0.000610352, -0.000610352, -0.000640869, -0.000775146, -0.000952148, -0.00108643, -0.00108643, -0.000915527, -0.000610352, 
      -0.000238037, 9.76563e-05, 0.000372314, 0.000585938, 0.000762939, 0.000915527, 0.0010498, 0.00114136, 0.0012146, 0.00128784, 0.00134888, 0.00134888, 0.00122681, 
      0.000927734, 0.000488281, 2.44141e-05, -0.000335693, -0.000561523, -0.000628662, -0.000628662, -0.000610352, -0.000622559, -0.000665283, -0.000701904, -0.000689697, -0.000628662, 
      -0.000610352, -0.00067749, -0.000891113, -0.00119019, -0.00144043, -0.00153809, -0.00137939, -0.0010498, -0.000640869, -0.000299072, -8.54492e-05, 4.88281e-05, 0.000152588, 
      0.000262451, 0.000360107, 0.000390625, 0.000311279, 0.000109863, -0.000152588, -0.000372314, -0.000402832, -0.000213623, 0.000152588, 0.000610352, 0.0010498, 0.0013916, 
      0.00161133, 0.00171509, 0.00172729, 0.00169067, 0.00161133, 0.00147705, 0.00133667, 0.0012146, 0.00109863, 0.000939941, 0.000714111, 0.000372314, -6.10352e-05, 
      -0.000561523, -0.0010498, -0.00147705, -0.00178833, -0.00198975, -0.0020874, -0.00211182, -0.00206299, -0.00195312, -0.00181274, -0.00162964, -0.00145264, -0.00131226, 
      -0.00122681, -0.00117798, -0.00114136, -0.00106201, -0.00090332, -0.000689697, -0.000488281, -0.000323486, -0.000201416, -0.00012207, -4.88281e-05, 1.2207e-05, 9.76563e-05, 
      0.000164795, 0.000201416, 0.000140381, 0, -0.000164795, -0.000323486, -0.000427246, -0.000476074, -0.000500488, -0.000549316, -0.000640869, -0.000762939, -0.000860596, 
      -0.000878906, -0.000823975, -0.000689697, -0.000585938, -0.000537109, -0.000585938, -0.000689697, -0.000811768, -0.000915527, -0.00101318, -0.00109863, -0.00114136, -0.00114136, 
      -0.00108643, -0.000939941, -0.000726318, -0.000476074, -0.000238037, -6.10352e-05, 1.2207e-05, -2.44141e-05, -0.000189209, -0.000439453, -0.000689697, -0.000811768, -0.000738525, 
      -0.000500488, -0.000152588, 0.00012207, 0.000250244, 0.000164795, -4.88281e-05, -0.000335693, -0.000561523, -0.000738525, -0.000891113, -0.00106201, -0.00126343, -0.00142822, 
      -0.00150146, -0.00147705, -0.00142822, -0.00146484, -0.00162964, -0.00186157, -0.00205078, -0.0020874, -0.00192871, -0.00159912, -0.00115356, -0.000726318, -0.000378418, 
      -0.000128174, 0, 6.10352e-05, 8.54492e-05, 6.10352e-05, -2.44141e-05, -0.000189209, -0.000427246, -0.00067749, -0.000848389, -0.00090332, -0.000872803, -0.000860596, 
      -0.000915527, -0.00108643, -0.00128784, -0.0013916, -0.00132446, -0.0010498, -0.000665283, -0.000299072, -3.66211e-05, 1.2207e-05, -0.000109863, -0.000311279, -0.000439453, 
      -0.00045166, -0.000372314, -0.0003479, -0.000488281, -0.000799561, -0.00117798, -0.00147705, -0.00153809, -0.00131226, -0.000823975, -0.000262451, 0.000189209, 0.000427246, 
      -0.000152588, 0.00012207, 0.000250244, 0.000164795, -4.88281e-05, -0.000335693, -0.000561523, -0.000738525, -0.000891113, -0.00106201, -0.00126343, -0.00142822, -0.00150146, 
      -0.00147705, -0.00142822, -0.00146484, -0.00162964, -0.00186157, -0.00205078, -0.0020874, -0.00192871, -0.00159912, -0.00115356, -0.000726318, -0.000378418
    }
};

CabDesc_imp<192> cab_data_HighGain __rt_data = {
    192, 48000,
    { 0.00032959, 0.00110474, 0.00174866, 0.00374451, 0.00339966, 0.00570374, 0.00650635, 0.007901, 0.00887451, 0.00844727, 0.00891724, 0.0078064, 0.00594177, 
      0.0055481, 0.0041687, 0.00488892, 0.00620117, 0.0124329, 0.0188995, 0.0307892, 0.0434265, 0.0538727, 0.0629425, 0.0670319, 0.0642609, 0.0613708, 
      0.0476685, 0.0340912, 0.0156799, -0.00499878, -0.0286621, -0.0470245, -0.0614594, -0.0639069, -0.050943, -0.0213898, 0.0180359, 0.0591553, 0.0882782, 
      0.0999878, 0.0933716, 0.0748993, 0.0485596, 0.0243927, 0.00559082, -0.00264282, -0.00406189, -0.00350952, -0.000479126, -0.00288696, -0.00631104, -0.0085022, 
      -0.00808411, -0.00162659, 0.0054718, 0.0124481, 0.016925, 0.018985, 0.021817, 0.0227966, 0.0195587, 0.0171906, 0.0145905, 0.0119293, 0.0100006, 
      0.0102203, 0.0121643, 0.0122253, 0.0153259, 0.0164856, 0.0168152, 0.0190826, 0.0167175, 0.017569, 0.0177979, 0.0159973, 0.0181549, 0.0170044, 
      0.017804, 0.0166077, 0.0160339, 0.0148193, 0.0127563, 0.0115234, 0.010498, 0.00991211, 0.00990906, 0.0108978, 0.0107941, 0.0128723, 0.0131317, 
      0.0149048, 0.0146576, 0.0157776, 0.0161285, 0.0144958, 0.01427, 0.013147, 0.013031, 0.0113892, 0.0124176, 0.0117218, 0.0116425, 0.0126251, 
      0.0116333, 0.0139832, 0.0114685, 0.0122986, 0.0123199, 0.0116974, 0.0128113, 0.0123077, 0.0133728, 0.0128326, 0.013092, 0.011087, 0.0111206, 
      0.0101166, 0.00730591, 0.00813904, 0.006604, 0.00711975, 0.00916138, 0.00787659, 0.0107483, 0.0104248, 0.0112549, 0.0108429, 0.0116791, 0.0100769, 
      0.00967102, 0.00880432, 0.00714722, 0.00682373, 0.00731201, 0.00651855, 0.00796509, 0.00784302, 0.00800171, 0.00681763, 0.00851746, 0.00774231, 0.00804443, 
      0.00783997, 0.00748291, 0.00765991, 0.00597534, 0.00496826, 0.00350037, 0.00386353, 0.00370178, 0.00481873, 0.00638123, 0.00687561, 0.00679626, 0.00562439, 
      0.00476074, 0.00483093, 0.00283203, 0.00483093, 0.0037323, 0.00445862, 0.00479431, 0.00435486, 0.00232544, 0.00246887, 0.00234375, 0.00329285, 0.00221863, 
      0.00398865, 0.00241394, 0.00315552, 0.00190735, 0.00125427, 0.00116882, 1.52588e-05, 0.00204468, 0.0020752, 0.00277405, 0.00267334, 0.00133972, 0.00083313, 
      -0.00125122, -0.00235596, -0.00281372, -0.00326233, -0.00215759, -0.000927734, 0.0107483, 0.0104248, 0.0112549, 0.0108429
    }
};

CabDesc_imp<192> cab_data_Twin __rt_data = {
    192, 48000,
    { -0.00248718, 0.00213013, 0.00604248, 0.0112091, 0.0163269, 0.021521, 0.0275574, 0.0338104, 0.0412903, 0.0489868, 0.0579742, 0.0658875, 0.0735504, 
      0.0774078, 0.0771973, 0.07229, 0.0630219, 0.051239, 0.0374146, 0.021994, 0.00320129, -0.0183258, -0.0423828, -0.0672119, -0.0882599, -0.0995728, 
      -0.0971954, -0.0775452, -0.0434357, 0.000286865, 0.0402557, 0.0653076, 0.0661804, 0.0455444, 0.0165436, -0.0072052, -0.0144287, -0.00848083, 0.00375977, 
      0.0146698, 0.0196289, 0.0180511, 0.011264, 0.00258789, -0.00515747, -0.00702209, -0.00657959, -0.00658569, -0.0059082, -0.0061554, -0.00519714, -0.00263672, 
      -0.000387573, -0.000177002, -0.000402832, -0.0019165, -0.00285645, -0.002771, -0.00153198, 0.000860596, 0.00449524, 0.00925903, 0.0124573, 0.0158722, 0.0168488, 
      0.01828, 0.0172485, 0.0160065, 0.015097, 0.0136658, 0.0133423, 0.0126892, 0.0120972, 0.0106384, 0.00811462, 0.00519104, 0.00170593, -0.00169983, 
      -0.00419006, -0.00576782, -0.00625916, -0.00639343, -0.00591431, -0.00499573, -0.00469971, -0.00328674, -0.00227661, -0.00125732, -0.0006073, -0.000317383, -0.00134888, 
      -0.00276184, -0.00381775, -0.00519714, -0.00510254, -0.00422974, -0.00214844, 0.000784302, 0.00391541, 0.00646362, 0.00923157, 0.0100983, 0.0102875, 0.0102692, 
      0.00893555, 0.00744934, 0.006427, 0.00488892, 0.0039093, 0.00360718, 0.00300903, 0.00233154, 0.00245972, 0.00163574, 0.00125732, 0.000762939, 0.000540161, 
      0.000210571, -0.000256348, 0.000112915, -0.000436401, 0.000650024, 0.000924683, 0.00168457, 0.00215454, 0.00183105, 0.00153809, 0.000708008, -0.000939941, -0.000753784, 
      -0.00201416, -0.000750732, -0.000592041, 0.000344849, 0.00183105, 0.00214233, 0.00311279, 0.0032074, 0.0024231, 0.00189209, 0.000485229, -0.00122375, -0.00232239, 
      -0.003479, -0.00364075, -0.00359192, -0.00312195, -0.00229492, -0.00212708, -0.000912476, -0.00114746, -0.00125732, -0.0006073, -0.000317383, -0.00134888, -0.00276184, 
      -0.00381775, -0.00519714, -0.00510254, -0.00422974, -0.00214844, 0.000784302, 0.00391541, 0.00646362, 0.00923157, 0.0100983, 0.0102875, 0.0102692, 0.00893555, 
      0.00744934, 0.006427, 0.00488892, 0.0039093, 0.00360718, 0.00300903, 0.00233154, 0.00245972, 0.00163574, 0.00125732, 0.000762939, 0.000540161, 0.000210571, 
      -0.000256348, 0.000112915, -0.000436401, 0.000650024, 0.000924683, 0.00168457, 0.00215454, 0.00183105, 0.00153809, 0.000708008
    }
};

CabDesc_imp<192> cab_data_Bassman __rt_data = {
    192, 48000,
    { -0.0135193, -0.0170654, -0.0122955, -0.0142334, -0.0131775, -0.0132965, -0.0127258, -0.0152039, -0.01138, -0.016806, -0.011557, -0.0141876, -0.00864258, 
      -0.0124908, -0.0108978, -0.00955811, -0.0157318, -0.0183807, -0.0201386, -0.0251465, -0.0209259, -0.0262756, -0.0199371, -0.0149078, -0.00731201, 0.00153503, 
      0.0135101, 0.0243683, 0.0322968, 0.0433075, 0.0503571, 0.0568634, 0.0703674, 0.0783051, 0.0914154, 0.0999908, 0.0980591, 0.0955383, 0.0794281, 
      0.0597534, 0.031485, -0.00279541, -0.0304779, -0.0540436, -0.0625885, -0.0501495, -0.0274353, 0.0180267, 0.0631134, 0.0926331, 0.098819, 0.0706421, 
      0.0196289, -0.0225616, -0.0428589, -0.0351105, -0.0119171, 0.0210815, 0.0415833, 0.0480377, 0.0494293, 0.0368988, 0.0178253, 0.000698853, -0.0044281, 
      -0.00349731, 0.00496216, 0.0109161, 0.0185181, 0.0168701, 0.0179718, 0.0142792, 0.0111298, 0.0111786, 0.00481567, 0.00551453, 0.00521545, 0.00835266, 
      0.00484619, 0.0102722, 0.0072998, 0.0072937, 0.00602112, 0.00800476, 0.000827026, 0.00921326, 0.00395813, 0.00715942, 0.00660706, 0.00912476, 0.00556641, 
      0.00999451, 0.0117157, 0.00827637, 0.00951843, 0.00418091, 0.00426025, 0.00639343, 0.00884705, 0.0105438, 0.0115021, 0.0123657, 0.011795, 0.00934143, 
      0.00721741, 0.0111633, 0.00832214, 0.0115936, 0.0131409, 0.0116516, 0.0109802, 0.00982666, 0.0116791, 0.00919495, 0.010733, 0.00323791, 0.00908508, 
      0.00430908, 0.00735168, 0.00718994, 0.00866394, 0.00606079, 0.0063324, 0.00391541, 0.00143738, 0.00595398, 0.00281677, 0.00145569, 0.00218201, -0.0025238, 
      0.00496216, 0.0109161, 0.0185181, 0.0168701, 0.0179718, 0.0142792, 0.0111298, 0.0111786, 0.00481567, 0.00551453, 0.00521545, 0.00835266, 0.00484619, 
      0.0102722, 0.0072998, 0.0072937, 0.00602112, 0.00800476, 0.000827026, 0.00921326, 0.00395813, 0.00715942, 0.00660706, 0.00912476, 0.00556641, 0.00999451, 
      0.0117157, 0.00827637, 0.00951843, 0.00418091, 0.00426025, 0.00639343, 0.00884705, 0.0105438, 0.0115021, 0.0123657, 0.011795, 0.00934143, 0.00721741, 
      0.0111633, 0.00832214, 0.0115936, 0.0131409, 0.0116516, 0.0109802, 0.00982666, 0.0116791, 0.00919495, 0.010733, 0.00323791, 0.00908508, 0.00430908, 
      0.00735168, 0.00718994, 0.00866394, 0.00606079, 0.0063324, 0.00391541, 0.00143738, 0.00595398, 0.00281677, 0.00145569
    }
};

CabDesc_imp<128> cab_data_Marshall __rt_data = {
    128, 48000,
    { -0.00922852, -0.000869751, -0.00532837, -0.00475159, -0.00434875, -0.00599976, -0.0036438, -0.00747681, -0.00713806, -0.00734558, -0.00646667, -0.00988159, -0.00717163, 
      -0.00905151, -0.00700378, -0.011731, -0.00480042, -0.0109528, -0.0086792, -0.0108398, -0.00987549, -0.0137299, -0.0147949, -0.0119843, -0.0141663, -0.0177155, 
      -0.0137268, -0.0164459, -0.0175385, -0.0167175, -0.019162, -0.0172638, -0.0205505, -0.018927, -0.0181885, -0.0179016, -0.0175201, -0.0201355, -0.0151581, 
      -0.0188446, -0.0123016, -0.0148804, -0.0123779, -0.0107971, -0.00960693, -0.00480652, -0.0113129, -0.00471497, -0.00960999, -0.00814209, -0.00911865, -0.0100708, 
      -0.00626221, -0.00363464, -0.000796509, 0.00978088, 0.0198669, 0.0354034, 0.0467163, 0.0613586, 0.0724426, 0.0775299, 0.0783203, 0.0739441, 0.0577087, 
      0.0450623, 0.0213287, -0.00122681, -0.0259857, -0.0394531, -0.0557007, -0.0592163, -0.0440796, -0.0175262, 0.0151337, 0.0574036, 0.0825256, 0.0999908, 
      0.0945892, 0.0780121, 0.0545349, 0.0327698, 0.0138306, 0.00717773, 0.00252686, 0.0059906, 0.00020752, 0.00678711, -0.00795288, -0.0052002, -0.0121521, 
      -0.00639038, -0.000817871, 0.00512085, 0.0132019, 0.0107941, 0.0124298, 0.0182343, 0.0077301, 0.00911865, 0.00447083, 0.00140686, 0.0047699, -0.00120239, 
      0.00215454, 0.00669556, 0.00773926, 0.00705566, 0.0143951, 0.00919189, 0.0128448, 0.0135773, 0.0109131, 0.0156006, 0.0113739, 0.0148926, 0.0125732, 
      0.0139496, 0.0113159, 0.00896912, 0.00815125, 0.0354034, 0.0467163, 0.0613586, 0.0724426, 0.0775299, 0.0783203, 0.0739441
    }
};

CabDesc_imp<192> cab_data_AC30 __rt_data = {
    192, 48000,
    { 7.32422e-05, 0.00015564, 0.00302429, 0.0057251, 0.00652466, 0.00614014, 0.00662537, 0.00419922, 0.00424194, -0.00379334, -0.00308838, -0.0103577, -0.0165436, 
      -0.0208832, -0.0206482, -0.027774, -0.0240204, -0.0231415, -0.0195801, -0.0178253, -0.015921, -0.0149628, -0.0164642, -0.0195465, -0.0218109, -0.0230652, 
      -0.0246216, -0.0256104, -0.0260925, -0.0210358, -0.0207489, -0.015863, -0.0106201, -0.0106628, -0.00259705, 0.00690613, 0.0146484, 0.026236, 0.0348633, 
      0.0506409, 0.0615387, 0.0747467, 0.0847351, 0.0917419, 0.0999908, 0.0957062, 0.093335, 0.0774262, 0.0564789, 0.0312073, 0.00177002, -0.0296539, 
      -0.047522, -0.0584259, -0.0557098, -0.0279785, 0.00585632, 0.0454926, 0.0777039, 0.0871948, 0.0838074, 0.0664886, 0.039389, 0.0180054, 0.00166931, 
      -0.00537415, 0.00290527, 0.00549622, 0.0210938, 0.0162201, 0.0135376, 0.00706482, 0.00458679, -0.00133667, 0.00446777, 0.00727539, 0.0085144, 0.00765076, 
      0.00744324, 0.00810852, 0.011911, 0.0117432, 0.00995789, 0.0141144, 0.0146301, 0.01651, 0.0221497, 0.0218842, 0.0201477, 0.0221466, 0.0210632, 
      0.0162018, 0.0183746, 0.0163727, 0.0168152, 0.0135895, 0.013208, 0.013208, 0.0101379, 0.0105713, 0.0109039, 0.0103699, 0.00718689, 0.0068634, 
      0.00429993, 0.0033844, 0.00050354, -9.15527e-05, 0.00460815, 0.00307617, 0.00213318, 0.00421143, 0.00546875, 0.00121155, 0.00124817, 0.0053894, 0.00281677, 
      0.0017395, 0.00368652, 0.00334778, 0.00233459, 0.00368347, 0.000366211, 0.00219727, 0.00175476, -0.00145874, 0.0006073, -0.000961304, -0.000509644, 0.00078125, 
      -0.00332336, 0.00331726, 0.000183105, -0.000747681, 0.00293274, -0.000637817, 0.000924683, -0.00149231, -0.00195312, -0.000564575, -0.00177917, 0.000491333, 0.00137024, 
      0.00274353, -0.000256348, 0.0024353, -0.00281372, -0.00131531, -0.00141602, -0.00289307, 0.000964355, 0.00017395, 0.00233765, -0.000726318, -0.000454712, -0.00398254, 
      -0.00518494, 0.000839233, 0.0168152, 0.0135895, 0.013208, 0.013208, 0.0101379, 0.0105713, 0.0109039, 0.0103699, 0.00718689, 0.0068634, 0.00429993, 
      0.0033844, 0.00050354, -9.15527e-05, 0.00460815, 0.00307617, 0.00213318, 0.00421143, 0.00546875, 0.00121155, 0.00124817, 0.0053894, 0.00281677, 0.0017395, 
      0.00368652, 0.00334778, 0.00233459, 0.00368347, 0.000366211, 0.00219727, 0.00175476, -0.00145874, 0.0006073, -0.000961304
    }
};

CabDesc_imp<768> cab_data_Princeton __rt_data = {
    768, 48000,
    { -0.00309448, -0.00641479, -0.0076355, -0.00684204, -0.0046814, -0.00162964, 0.0022644, 0.00679321, 0.0110474, 0.0140808, 0.0159912, 0.0153442, 0.0124268, 
      0.00848389, 0.00452881, 0.00045166, -0.00389404, -0.00841675, -0.0115479, -0.0121704, -0.0108582, -0.00772095, -0.00272827, 0.00341187, 0.00960693, 0.0144775, 
      0.0154358, 0.0115173, 0.00429688, -0.00339355, -0.00940552, -0.0124878, -0.0122437, -0.00877686, -0.00349731, 0.0017395, 0.00515137, 0.00681152, 0.00726929, 
      0.00681152, 0.00482788, 0.00195312, -0.00167847, -0.00560913, -0.00799561, -0.00747681, -0.00460205, -0.000897217, 0.00301514, 0.00552368, 0.00639038, 0.00568848, 
      0.00362549, 1.83105e-05, -0.00333862, -0.00494995, -0.00473022, -0.00341797, -0.00162964, 0.00032959, 0.00178223, 0.00244751, 0.00177612, -0.000164795, -0.00247192, 
      -0.00488892, -0.00692139, -0.00699463, -0.00483398, -0.00162964, 0.00135498, 0.00333862, 0.00326538, 0.00117798, -0.00202026, -0.00481567, -0.00576782, -0.00505371, 
      -0.00369873, -0.00270996, -0.00230103, -0.00228271, -0.00197144, -0.00152588, -0.00117188, -0.000958252, -0.000878906, -0.000891113, -0.000952148, -0.000708008, -0.00043335, 
      -0.000598145, -0.00152588, -0.00267944, -0.00366821, -0.00380859, -0.00317383, -0.00262451, -0.00256958, -0.0020813, -0.0017334, -0.00195923, -0.00197754, -0.00133667, 
      -0.0003479, 0.00045166, 0.000518799, -0.000701904, -0.00256348, -0.00449219, -0.00578613, -0.00565796, -0.00393066, -0.0015686, 4.27246e-05, 0.000262451, -0.000518799, 
      -0.00183105, -0.00301514, -0.00285645, -0.00114746, 0.000854492, 0.00175781, 0.00129395, -0.00043335, -0.00250854, -0.00425415, -0.0048645, -0.00410156, -0.00268555, 
      -0.00133057, -6.71387e-05, 0.000872803, 0.000848389, 4.88281e-05, -0.00067749, -0.000701904, -0.000262451, 1.2207e-05, -0.000140381, -0.000262451, -0.000720215, -0.000854492, 
      -0.000396729, 0.000634766, 0.00177612, 0.00266724, 0.00252686, 0.000854492, -0.00150146, -0.00365601, -0.00440063, -0.00342407, -0.00135498, 0.000665283, 0.00183716, 
      0.00183716, 0.000952148, -0.000506592, -0.00196533, -0.00281372, -0.00274048, -0.00161133, -1.2207e-05, 0.00133057, 0.00203247, 0.00227051, 0.00213013, 0.00145264, 
      0.000512695, -0.00045166, -0.00119629, -0.00192261, -0.0024353, -0.00222778, -0.00145874, -0.000915527, -0.00067749, -6.10352e-05, 0.000689697, 0.0010437, 0.0010376, 
      0.0013855, 0.00198975, 0.00247803, 0.0020752, 0.00117798, 0.000140381, -0.000598145, -0.00122681, -0.00144043, -0.00106812, -0.000292969, 0.000402832, 0.0010376, 
      0.00160522, 0.00194092, 0.0019043, 0.00161743, 0.00126953, 0.00118408, 0.00101929, 0.000561523, -6.10352e-06, -0.000408936, -0.000531006, -0.000152588, 0.00043335, 
      0.00126953, 0.00234985, 0.00358887, 0.00419312, 0.00410156, 0.00321655, 0.00201416, 0.000610352, -0.000274658, -0.000585938, -0.000299072, 0.000299072, 0.00106201, 
      0.00162354, 0.00160522, 0.00123901, 0.00067749, 0.000134277, -6.71387e-05, 0.000274658, 0.00106812, 0.00177002, 0.00203247, 0.00174561, 0.00164795, 0.0017395, 
      0.0020874, 0.00219116, 0.00220947, 0.0020752, 0.00170898, 0.000762939, -0.000164795, -0.00043335, -7.93457e-05, 0.00043335, 0.00123901, 0.00217285, 0.00265503, 
      0.00253906, 0.00205078, 0.00184937, 0.0015686, 0.00147705, 0.00136108, 0.00152588, 0.00189209, 0.00239258, 0.00265503, 0.0026062, 0.0024292, 0.00214844, 
      0.00180664, 0.00134277, 0.00088501, 0.000769043, 0.000982666, 0.00114746, 0.0010437, 0.000787353, 0.000415039, 0.000219727, 0.000128174, -9.15527e-05, -0.000360107, 
      -0.000408936, -3.05176e-05, 0.000390625, 0.00090332, 0.00110474, 0.00115356, 0.00111694, 0.00123291, 0.00146484, 0.0015564, 0.00122681, 0.000793457, 0.000384521, 
      0.000213623, 0.000244141, 0.000244141, 0.000500488, 0.0010498, 0.00174561, 0.00201416, 0.00170288, 0.000970459, 0.000305176, 3.05176e-05, -0.000231934, -0.000469971, 
      -0.000531006, -0.000109863, 0.000311279, 0.000640869, 0.000671387, 0.000762939, 0.000964355, 0.00106812, 0.00119629, 0.0010437, 0.00065918, 5.49316e-05, -0.000286865, 
      -0.000177002, 0.00020752, 0.000488281, 0.000469971, 0.000311279, 0.00010376, -0.000262451, -0.000476074, -0.000604248, -0.000390625, -6.10352e-05, 0.000305176, 0.000567627, 
      0.000640869, 0.000640869, 0.000341797, 8.54492e-05, -0.000292969, -0.000585938, -0.00100708, -0.00115967, -0.00115356, -0.00078125, -0.000372314, 0.000128174, 0.000494385, 
      0.000823975, 0.000842285, 0.000585938, -3.05176e-05, -0.000714111, -0.00133057, -0.00147705, -0.00137329, -0.0010437, -0.000836182, -0.000592041, -0.000372314, -0.000115967, 
      3.66211e-05, -7.93457e-05, -0.000262451, -0.000378418, -0.000469971, -0.000793457, -0.00107422, -0.00128784, -0.00113525, -0.000823975, -0.000488281, -0.000262451, -0.000201416, 
      -0.000286865, -0.000372314, -0.000469971, -0.000592041, -0.000726318, -0.000726318, -0.000701904, -0.000634766, -0.000683594, -0.000701904, -0.000775146, -0.000708008, -0.000537109, 
      -0.00045166, -0.000543213, -0.000823975, -0.00105591, -0.00108643, -0.000915527, -0.000708008, -0.00055542, -0.000305176, 8.54492e-05, 0.000244141, 0.000170898, -0.000213623, 
      -0.000543213, -0.000762939, -0.000811768, -0.000830078, -0.000805664, -0.000866699, -0.000878906, -0.000769043, -0.000634766, -0.000738525, -0.0010498, -0.00131836, -0.00134888, 
      -0.0010498, -0.000726318, -0.000378418, -0.000140381, 9.15527e-05, 0.000146484, -2.44141e-05, -0.000494385, -0.000897217, -0.0012146, -0.00129395, -0.00133667, -0.00139771, 
      -0.00147095, -0.00153809, -0.00137939, -0.00119629, -0.00088501, -0.000817871, -0.000732422, -0.000628662, -0.000512695, -0.000469971, -0.00055542, -0.000622559, -0.000628662, 
      -0.00043335, -0.000134277, -0.00010376, -0.000262451, -0.00057373, -0.000750732, -0.00090332, -0.000964355, -0.000939941, -0.000817871, -0.000616455, -0.000543213, -0.000628662, 
      -0.000854492, -0.0010376, -0.00101318, -0.000946045, -0.000750732, -0.000701904, -0.000592041, -0.000543213, -0.000341797, -9.76563e-05, 0.000189209, 0.000323486, 0.00043335, 
      0.000311279, 9.15527e-05, -0.000384521, -0.000909424, -0.00137939, -0.00145264, -0.00130615, -0.000921631, -0.000585938, -0.000286865, -0.000177002, -6.10352e-05, 1.2207e-05, 
      7.93457e-05, 6.71387e-05, 4.88281e-05, -1.2207e-05, -7.32422e-05, -0.000231934, -0.000402832, -0.000683594, -0.000726318, -0.000634766, -0.000457764, -0.000311279, -0.000201416, 
      -0.000109863, -4.88281e-05, 4.27246e-05, 0.000115967, 0.000140381, 9.76563e-05, 6.10352e-05, 4.27246e-05, 2.44141e-05, -6.10352e-06, -0.000140381, -0.000177002, 0, 
      9.76563e-05, 0.000213623, 0.000170898, 0.000274658, 0.000317383, 0.000390625, 0.000274658, 0.000109863, -6.10352e-06, -6.10352e-06, 8.54492e-05, 0.000299072, 0.000421143, 
      0.000488281, 0.000372314, 0.000292969, 4.88281e-05, -9.15527e-05, -0.000354004, -0.000341797, -0.000256348, -2.44141e-05, 5.49316e-05, 7.93457e-05, -6.10352e-06, -6.10352e-05, 
      7.93457e-05, 0.000219727, 0.00045166, 0.000628662, 0.000854492, 0.00098877, 0.00101318, 0.000836182, 0.000500488, 0.000250244, 0.000115967, 0.000201416, 0.000317383, 
      0.000469971, 0.000653076, 0.00090332, 0.000976562, 0.000891113, 0.000683594, 0.000415039, 0.00022583, 0.000177002, 0.000292969, 0.000384521, 0.000488281, 0.000402832, 
      0.000335693, 0.000305176, 0.000268555, 0.000280762, 0.000262451, 0.000286865, 0.000372314, 0.000384521, 0.000250244, 0.000146484, 0.000183105, 0.000274658, 0.000274658, 
      0.000158691, 0.000134277, 0.000152588, 0.000256348, 0.000390625, 0.000427246, 0.000366211, 0.000268555, 0.000219727, 0.000231934, 0.000311279, 0.000390625, 0.00045166, 
      0.00045166, 0.000457764, 0.000408936, 0.000299072, 0.000262451, 0.000384521, 0.000585938, 0.000799561, 0.000952148, 0.000915527, 0.000836182, 0.000634766, 0.000531006, 
      0.000311279, 0.000201416, 0.00012207, 9.15527e-05, 9.15527e-05, 8.54492e-05, 4.88281e-05, 7.93457e-05, 0.000195313, 0.000439453, 0.000665283, 0.000805664, 0.000769043, 
      0.000653076, 0.000524902, 0.000274658, 0.000170898, 1.83105e-05, -1.83105e-05, -6.10352e-05, 7.32422e-05, 0.000244141, 0.000469971, 0.000634766, 0.000750732, 0.000848389, 
      0.000860596, 0.000683594, 0.000421143, 0.000128174, -1.83105e-05, -0.000170898, -0.000292969, -0.000390625, -0.000390625, -0.000231934, -0.00010376, 0.000152588, 0.000323486, 
      0.000506592, 0.000512695, 0.000256348, 0.000390625, 0.000427246, 0.000366211, 0.000268555, 0.000219727, 0.000231934, 0.000311279, 0.000390625, 0.00045166, 0.00045166, 
      0.000457764, 0.000408936, 0.000299072, 0.000262451, 0.000384521, 0.000585938, 0.000799561, 0.000952148, 0.000915527, 0.000836182, 0.000634766, 0.000531006, 0.000311279, 
      0.000201416, 0.00012207, 9.15527e-05, 9.15527e-05, 8.54492e-05, 4.88281e-05, 7.93457e-05, 0.000195313, 0.000439453, 0.000665283, 0.000805664, 0.000769043, 0.000653076, 
      0.000524902, 0.000274658, 0.000170898, 1.83105e-05, -1.83105e-05, -6.10352e-05, 7.32422e-05, 0.000244141, 0.000469971, 0.000634766, 0.000750732, 0.000848389, 0.000860596, 
      0.000683594
    }
};


CabDesc_imp<896> cab_data_A2 __rt_data = {
    896, 48000,
    { -0.0529144, -0.0479034, -0.0443909, -0.0402527, -0.0356598, -0.0326569, -0.0296112, -0.027478, -0.0252869, -0.0243713, -0.0245483, -0.0250519, -0.0316956, 
      -0.0375, -0.0475891, -0.054834, -0.0614899, -0.0598389, -0.0492432, -0.031076, -0.00463562, 0.0245972, 0.0523651, 0.0742096, 0.0906158, 0.0986084, 
      0.0998169, 0.0968109, 0.0876556, 0.073114, 0.0524231, 0.0241486, -0.0106567, -0.0450958, -0.074826, -0.0859497, -0.0783478, -0.0476959, -0.00476685, 
      0.0396454, 0.0748657, 0.0915741, 0.0869782, 0.0698364, 0.0443329, 0.0224701, 0.0104736, 0.0111023, 0.0213318, 0.0341736, 0.0478607, 0.0530609, 
      0.0539948, 0.0461121, 0.0386505, 0.0266724, 0.0157532, 0.00790405, 0.00315247, 0.00385742, 0.00796204, 0.0162231, 0.025296, 0.0306305, 0.0341583, 
      0.032486, 0.027005, 0.0206573, 0.0136871, 0.010434, 0.00934753, 0.0117798, 0.0170197, 0.0238831, 0.0290863, 0.0350616, 0.0365356, 0.0372101, 
      0.0332214, 0.0315613, 0.0275024, 0.0247528, 0.0232635, 0.0236572, 0.0259705, 0.0284668, 0.030603, 0.0323486, 0.0328583, 0.0320679, 0.0320465, 
      0.0298767, 0.028064, 0.0275421, 0.0267883, 0.02836, 0.0295868, 0.0299622, 0.0310699, 0.0302277, 0.0294617, 0.0279388, 0.0251892, 0.0236664, 
      0.0224976, 0.0215881, 0.0242401, 0.0265137, 0.0285675, 0.0320282, 0.0341431, 0.033963, 0.0343628, 0.033551, 0.0312256, 0.0286102, 0.0273499, 
      0.025174, 0.0240295, 0.0246643, 0.0255219, 0.0254639, 0.0282379, 0.0270447, 0.0291656, 0.0298737, 0.0294098, 0.0306946, 0.0306793, 0.0294708, 
      0.0314697, 0.0287659, 0.0296326, 0.029248, 0.0274231, 0.0282806, 0.0250031, 0.026355, 0.024527, 0.0249908, 0.0267944, 0.0259766, 0.0289978, 
      0.0292084, 0.0299225, 0.0305664, 0.029895, 0.0294006, 0.0276978, 0.0268372, 0.0244751, 0.0237549, 0.0233612, 0.0215912, 0.0229034, 0.0222595, 
      0.0237579, 0.0240692, 0.0244843, 0.0260498, 0.025351, 0.0255707, 0.0264252, 0.0249664, 0.0260742, 0.0249573, 0.0254272, 0.0250488, 0.0253021, 
      0.024704, 0.0244568, 0.0238892, 0.0225952, 0.0227386, 0.0219788, 0.0209106, 0.0211761, 0.0206909, 0.0202667, 0.0208862, 0.020752, 0.0207489, 
      0.0204803, 0.0209015, 0.0211609, 0.020752, 0.021347, 0.0219574, 0.0220947, 0.0223267, 0.0230286, 0.0234741, 0.023291, 0.0236664, 0.0232819, 
      0.0226013, 0.0224518, 0.0214294, 0.0208282, 0.0196045, 0.0183136, 0.0183411, 0.0162109, 0.0165375, 0.0154266, 0.015033, 0.0162201, 0.0157043, 
      0.01633, 0.0170349, 0.0174377, 0.0192993, 0.0185577, 0.019812, 0.0210022, 0.0193665, 0.0211151, 0.0203613, 0.0192688, 0.0202515, 0.0180481, 
      0.0181213, 0.0177551, 0.0170502, 0.0158295, 0.0163635, 0.0157715, 0.0146362, 0.0152283, 0.0148773, 0.0144073, 0.0142456, 0.014447, 0.0135223, 
      0.0142914, 0.0139069, 0.0137085, 0.0135712, 0.0133514, 0.0139191, 0.0133026, 0.0133484, 0.0124786, 0.0126434, 0.013562, 0.0123688, 0.0123962, 
      0.0119141, 0.0123077, 0.0109009, 0.0125153, 0.0108459, 0.0108429, 0.0121002, 0.0100281, 0.0108154, 0.0100311, 0.0104431, 0.00927124, 0.0097229, 
      0.00894775, 0.00927429, 0.00845337, 0.00889282, 0.00801392, 0.00801392, 0.00853272, 0.00733032, 0.00804138, 0.00750122, 0.00792847, 0.0078949, 0.0072052, 
      0.00724792, 0.0080719, 0.00771179, 0.00656738, 0.00707703, 0.00711975, 0.00601501, 0.00680542, 0.00595093, 0.00546875, 0.00603333, 0.00518188, 0.00521851, 
      0.0058136, 0.00343323, 0.00556946, 0.00406189, 0.00440369, 0.004599, 0.00409851, 0.00404968, 0.00427246, 0.00317993, 0.00413818, 0.00297852, 0.00404663, 
      0.00250244, 0.00359802, 0.00262451, 0.00320435, 0.00259705, 0.00259399, 0.00205078, 0.00288086, 0.00170593, 0.00252075, 0.00186462, 0.00166626, 0.00179443, 
      0.00112305, 0.00148926, 0.00123901, 0.000543213, 0.000991821, 0.00103455, -0.000622559, 0.000445557, 0.000344849, -0.000375366, -0.000921631, -0.000119019, -0.00141907, 
      -0.00157471, -0.00127563, -0.00145874, -0.00209045, -0.00232544, -0.00178833, -0.00217896, -0.0020874, -0.00308533, -0.00164185, -0.00281067, -0.0024292, -0.00241699, 
      -0.00281982, -0.00231628, -0.00263367, -0.0028595, -0.00203247, -0.00267639, -0.00242004, -0.00263062, -0.0027771, -0.00229797, -0.00282593, -0.00250549, -0.00267944, 
      -0.00236816, -0.00252686, -0.00345764, -0.00202026, -0.00357361, -0.00281067, -0.00358582, -0.00300598, -0.00319519, -0.00390015, -0.00323791, -0.00479736, -0.00389099, 
      -0.00461426, -0.00447388, -0.00520935, -0.00515442, -0.00564575, -0.00582275, -0.00641174, -0.00584412, -0.00709839, -0.00662537, -0.00800171, -0.00722656, -0.00827026, 
      -0.00877991, -0.00858154, -0.00940552, -0.00977478, -0.00999145, -0.0107666, -0.0108704, -0.0113251, -0.0119659, -0.0117432, -0.0128754, -0.0129791, -0.0127625, 
      -0.0137848, -0.0142517, -0.0140839, -0.0148437, -0.0146057, -0.0148163, -0.0158417, -0.0154694, -0.015448, -0.0159851, -0.0161133, -0.0160217, -0.016217, 
      -0.0162781, -0.0159485, -0.0171326, -0.0157166, -0.0169403, -0.0160461, -0.0164703, -0.0164185, -0.0160095, -0.0160645, -0.0160858, -0.0164093, -0.0152191, 
      -0.0164886, -0.0151093, -0.0154968, -0.0154938, -0.0155151, -0.0143921, -0.0155151, -0.0141724, -0.0155151, -0.0134735, -0.0150238, -0.0146545, -0.0129944, 
      -0.015329, -0.0133484, -0.0137482, -0.0146027, -0.0132294, -0.0142151, -0.0138397, -0.0142059, -0.0138092, -0.0138947, -0.0140686, -0.0138763, -0.0148499, 
      -0.0134979, -0.0143219, -0.014798, -0.013855, -0.0151398, -0.0137909, -0.0160828, -0.0138245, -0.0164886, -0.0144775, -0.0163696, -0.0154266, -0.0161621, 
      -0.0162598, -0.0162537, -0.0166504, -0.0166809, -0.0172241, -0.0173462, -0.0174561, -0.017691, -0.0177521, -0.0187469, -0.0179474, -0.0189636, -0.0188995, 
      -0.0187897, -0.0196259, -0.019931, -0.0191498, -0.019989, -0.0206665, -0.0200256, -0.0210602, -0.0203705, -0.0206268, -0.0216705, -0.0211761, -0.0207367, 
      -0.022467, -0.0210968, -0.0216644, -0.0223053, -0.0217224, -0.0225677, -0.0221924, -0.0222198, -0.0221497, -0.0228607, -0.0222839, -0.0222961, -0.0228333, 
      -0.0224121, -0.02211, -0.0225311, -0.0226898, -0.0221771, -0.0224426, -0.0221924, -0.022467, -0.0215393, -0.0226563, -0.0212494, -0.0224213, -0.0214966, 
      -0.0217743, -0.0212158, -0.0209595, -0.0216644, -0.0201111, -0.0213074, -0.0201386, -0.0203735, -0.0195312, -0.0198486, -0.0194397, -0.0192261, -0.0195129, 
      -0.0185547, -0.0181, -0.0187256, -0.0177155, -0.0178223, -0.0170929, -0.0171448, -0.0166595, -0.016748, -0.016214, -0.0157806, -0.015625, -0.0154236, 
      -0.0148437, -0.0142029, -0.0144989, -0.0140594, -0.0136505, -0.012915, -0.0129883, -0.0129181, -0.0121765, -0.0127411, -0.0111694, -0.0120392, -0.0101746, 
      -0.011084, -0.0107819, -0.00974426, -0.0102814, -0.0097168, -0.00907593, -0.00925903, -0.00843506, -0.00874329, -0.00804749, -0.0083313, -0.00707092, -0.00776062, 
      -0.00654602, -0.00692444, -0.0065033, -0.00602112, -0.00585022, -0.00679016, -0.00492859, -0.00537109, -0.00489197, -0.0050293, -0.00384521, -0.00466919, -0.00414124, 
      -0.00358887, -0.00398865, -0.00309753, -0.00323181, -0.00274963, -0.00351868, -0.00221558, -0.00262146, -0.00177917, -0.00304871, -0.00111389, -0.0019928, -0.00140381, 
      -0.00163574, -0.000762939, -0.00186768, -0.000765991, -0.0011261, -0.000460815, -0.000610352, -0.000253296, -0.000527954, -5.49316e-05, -7.32422e-05, -0.000308228, 0.000402832, 
      0.000131226, 0.000561523, 0.000674438, 0.000219727, 0.000473022, 0.00139465, 0.000497437, 0.000439453, 0.00133057, 0.000595093, 0.00108948, 0.000759888, 0.00157776, 
      0.000561523, 0.00187988, 0.00144043, 0.000976562, 0.00134277, 0.00134888, 0.00142517, 0.00111694, 0.0019165, 0.000650024, 0.00181274, 0.00108337, 0.00181885, 
      0.000964355, 0.00148926, 0.00209045, 0.000595093, 0.00195618, 0.00113831, 0.00119019, 0.00160522, 0.00088501, 0.000985718, 0.00184326, 0.00065918, 0.001828, 
      0.000204468, 0.00169678, 0.000622559, 0.00128479, 0.000857544, 0.000714111, 0.00100098, 0.000457764, 0.001297, 0.000582886, 0.000198364, 0.000494385, 0.000515747, 
      0.00078125, 0.000454712, -0.000323486, 2.44141e-05, 0.000262451, 0.000234985, 0.000100708, -0.000592041, 0.000241089, -0.000964355, 0.000210571, -0.000253296, -0.000811768, 
      0.00027771, -0.00175171, -0.00010376, -0.00115051, -0.000558472, -0.000958252, -0.000909424, -0.00159607, -0.000967407, -0.000979614, -0.00145264, -0.000759888, -0.00224304, 
      -0.00124817, -0.0020813, -0.00142517, -0.00115662, -0.00259094, -0.00107727, -0.00309448, -0.00182495, -0.00234375, -0.00194092, -0.00209351, -0.00295715, -0.00179749, 
      -0.0027771, -0.00310364, -0.00252686, -0.00259094, -0.00271912, -0.00289917, -0.00324097, -0.00242615, -0.00427551, -0.00278015, -0.00322876, -0.00387878, -0.00259094, 
      -0.00414734, -0.0035675, -0.00411072, -0.00362854, -0.00419006, -0.00325928, -0.00406494, -0.00432434, -0.00355835, -0.00458374, -0.00379334, -0.00516968, -0.00374146, 
      -0.00458679, -0.00444641, -0.0045105, -0.00450439, -0.00531006, -0.00496216, -0.00504456, -0.00452881, -0.00476685, -0.00530701, -0.00492554, -0.00472717, -0.00536499, 
      -0.0053772, -0.00533142, -0.00585022, -0.00506287, -0.0053009, -0.00613403, -0.00461121, -0.00552063, -0.00648193, -0.00557861, -0.00544739, -0.00595703, -0.00599365, 
      -0.00575562, -0.00596313, -0.00621338, -0.00548096, -0.00636292, -0.00589905, -0.00645142, -0.00596008, -0.00639038, -0.00620422, -0.0060852, -0.00692139, -0.0059082, 
      -0.00614624, -0.00646057, -0.00671997, -0.00586243, -0.0071106, -0.00628662, -0.00688782, -0.00625305, -0.00632935, -0.00701599, -0.00573425, -0.00686646, -0.00613098, 
      -0.00646362, -0.00684204, -0.00596924, -0.0066925, -0.00647583, -0.00724182, -0.00605164, -0.00651245, -0.00662231, -0.00670776, -0.00567627, -0.00691528, -0.00636292, 
      -0.00577087, -0.00639343, -0.00601501, -0.00705261, -0.00613709, -0.00581055, -0.00655823, -0.00646057, -0.0063324, -0.00587463, -0.00585632, -0.00609131, -0.00537109, 
      -0.00675964, -0.00549316, -0.00585632, -0.00619812, -0.00517578, -0.00635071, -0.00561523, -0.00570984, -0.00603027, -0.00499268, -0.00581665, -0.00520325, -0.00509338, 
      -0.00570068, -0.004599, -0.00605774, -0.00427246, -0.00534668, -0.00588074, -0.00450134, -0.0052063, -0.00545349, -0.00462647, -0.00487671, -0.00500488, -0.00424805, 
      -0.00521545, -0.00376282, -0.00480042, -0.00346985, -0.00529785, -0.00290833, -0.004599, -0.00418701, -0.00404053, -0.0041687, -0.00411377, -0.00405273, -0.00403442, 
      -0.00378418, -0.00343018, -0.00403748, -0.00315857, -0.00348206, -0.00335083, -0.00279541, -0.00335083, -0.00300293, -0.00249023, -0.00306702, -0.00220947, -0.00322571, 
      -0.00209961, -0.00278625, -0.00257263, -0.00223999, -0.002771, -0.00263672, -0.00133057, -0.00270081, -0.00180969, -0.00234985, -0.000891113, -0.00273743, -0.000973511, 
      -0.00144043, -0.000881958, -0.00140686, -0.00090332, -0.00039978, -0.00139465, -0.000735474, -0.000930786, -0.000427246, -0.000756836, -0.00100403, -0.00017395, -0.000366211, 
      -0.000180054, -0.00039978, -3.05176e-06, -7.01904e-05, 0.000299072, -0.00450134, -0.0052063, -0.00545349, -0.00462647, -0.00487671, -0.00500488, -0.00424805, -0.00521545, 
      -0.00376282, -0.00480042, -0.00346985, -0.00529785, -0.00290833, -0.004599, -0.00418701, -0.00404053, -0.0041687, -0.00411377, -0.00405273, -0.00403442
    }
};

CabDesc_imp<511> cab_data_1x15 __rt_data = {
    511, 48000,
    { 0.000134277, 0.000299072, 0.000500488, 0.000701904, 0.000897217, 0.00107422, 0.0012207, 0.00134277, 0.00166016, 0.00279541, 0.00596924, 0.0129211, 0.0255066, 
      0.0450439, 0.0717041, 0.103967, 0.138361, 0.169751, 0.192133, 0.199994, 0.189673, 0.160516, 0.115253, 0.0595947, 0.00111084, -0.0523376, 
      -0.09422, -0.120544, -0.130334, -0.125336, -0.109198, -0.0863647, -0.0610535, -0.036554, -0.015033, 0.00230103, 0.0147949, 0.0221741, 0.0244629, 
      0.0220886, 0.015863, 0.00692749, -0.00336914, -0.0137573, -0.0232178, -0.0311218, -0.0372253, -0.041571, -0.0443298, -0.0456299, -0.0454651, -0.0437683, 
      -0.0405396, -0.0360168, -0.0307495, -0.0255127, -0.0211731, -0.018396, -0.0174988, -0.0183716, -0.0206116, -0.0236694, -0.0270508, 0, -0.0337097, 
      -0.0368042, -0.0396301, -0.0419495, -0.0433411, -0.0432739, -0.0412781, -0.0371643, -0.0311523, -0.0238831, -0.016272, -0.00932617, -0.00390625, -0.000634766, 
      0.000219727, -0.00123291, -0.0045166, -0.00890503, -0.013562, -0.0176819, -0.0205872, -0.021814, -0.0211914, -0.0188721, -0.0152954, -0.0111328, -0.00716553, 
      -0.00413818, -0.00258789, -0.00273437, -0.00445557, -0.00733032, -0.0107849, -0.0142944, -0.0174927, -0.0202332, -0.0226074, -0.0248291, -0.027124, -0.0295776, 
      -0.0320679, -0.0342712, -0.0357727, -0.0361938, -0.0352844, -0.0329712, -0.0293701, -0.0247498, -0.0194946, -0.0140198, -0.00877075, -0.00415649, -0.00057373, 
      0.00169678, 0.00249634, 0.00189209, 0.000170898, -0.00219727, -0.0046814, -0.0067749, -0.00814209, -0.0086731, -0.00847778, 0, -0.00687866, -0.00581055, 
      -0.0045227, -0.0027832, -0.000341797, 0.00289307, 0.0067627, 0.0108215, 0.0144226, 0.0168823, 0.017688, 0.0166565, 0.0139832, 0.010199, 0.00598755, 
      0.00205688, -0.0010376, -0.00300293, -0.00379028, -0.00352173, -0.00244141, -0.000805664, 0.00119019, 0.00338745, 0.00569458, 0.00802002, 0.0102478, 0.0122314, 
      0.0138184, 0.0148865, 0.0153687, 0.0152466, 0.014563, 0.0133667, 0.0117493, 0.00982056, 0.00775146, 0.00578003, 0.00420532, 0.003302, 0.00330811, 
      0.00438232, 0.00649414, 0.00944214, 0.0127869, 0.0159607, 0.0184021, 0.0197144, 0.0197632, 0.0186768, 0.0167664, 0.0143921, 0.0118164, 0.00919189, 
      0.00656738, 0.00415039, 0.00236816, 0.00170288, 0.00239258, 0.00419922, 0.00649414, 0.00848999, 0.00963135, 0, 0.00950928, 0.00913696, 0.00916748, 
      0.00994873, 0.0114441, 0.0129517, 0.0133057, 0.0118164, 0.00891113, 0.00587769, 0.00390625, 0.00344238, 0.00426636, 0.00597534, 0.00808716, 0.0100098, 
      0.011261, 0.0118774, 0.0124756, 0.0137451, 0.0159851, 0.0189636, 0.0220642, 0.0245972, 0.0260681, 0.0262634, 0.0252197, 0.0232483, 0.0209595, 
      0.0191345, 0.018335, 0.0185791, 0.0194336, 0.0203552, 0.0208679, 0.0206482, 0.0198303, 0.0189514, 0.0185608, 0.0187256, 0.0190613, 0.0190186, 
      0.0180847, 0.0159729, 0.0129333, 0.00982666, 0.00770264, 0.00709839, 0.00768433, 0.00869141, 0.009552, 0.0102844, 0.0112671, 0.0126709, 0.0141357, 
      0.0149963, 0.0149658, 0.0143555, 0.0136536, 0.0131897, 0.0129456, 0.0123962, 0.01073, 0, 0.003302, -0.00055542, -0.00249023, -0.00183716, 
      0.000653076, 0.00330811, 0.00470581, 0.00438232, 0.00276489, 0.000653076, -0.00116577, -0.00214233, -0.00214233, -0.00164795, -0.00159912, -0.00278931, -0.00516357, 
      -0.0078186, -0.00956421, -0.00946655, -0.00714111, -0.00299683, 0.00181885, 0.00605469, 0.00899658, 0.010614, 0.0112976, 0.0117004, 0.0124268, 0.0136475, 
      0.0148865, 0.0155334, 0.0153259, 0.0143738, 0.0128174, 0.0107178, 0.00843506, 0.00675659, 0.00626831, 0.00688477, 0.00808716, 0.00939941, 0.0105408, 
      0.0111877, 0.0109558, 0.00969238, 0.00762939, 0.00519409, 0.00283203, 0.000946045, -0.000274658, -0.00098877, -0.00159302, -0.00229492, -0.00292969, -0.00309448, 
      -0.00252686, -0.00139771, -0.000219727, 0.000463867, 0.000421143, -0.000146484, -0.000793457, 0, -0.00114136, -0.000982666, -0.000830078, -0.000634766, -0.000286865, 
      0.000250244, 0.00090332, 0.00143433, 0.00161133, 0.00128174, 0.000592041, -0.000128174, -0.000628662, -0.00098877, -0.00145874, -0.00221558, -0.0032898, -0.00459595, 
      -0.00594482, -0.00700684, -0.00742798, -0.0071106, -0.00638428, -0.00586548, -0.00601807, -0.00681152, -0.00780029, -0.00846558, -0.00839844, -0.00752563, -0.00609741, 
      -0.00449829, -0.00308838, -0.00220947, -0.00217285, -0.00292969, -0.0039978, -0.00477905, -0.00494995, -0.0045105, -0.0036377, -0.00254517, -0.00152588, -0.000872803, 
      -0.000720215, -0.000958252, -0.00129395, -0.00142212, -0.00125122, -0.00102539, -0.00112915, -0.00167236, -0.00245972, -0.00327759, -0.00406494, -0.00474854, -0.00515747, 
      -0.00513916, -0.00465698, -0.00377808, -0.00269775, -0.00169678, -0.0010437, 0, -0.00129395, -0.00206299, -0.00284424, -0.00324097, -0.00306396, -0.0024292, 
      -0.00175171, -0.0015686, -0.00222778, -0.00378418, -0.00597534, -0.00823975, -0.00977173, -0.00990601, -0.00860596, -0.00648804, -0.00442505, -0.00300903, -0.0024292, 
      -0.00257568, -0.00314331, -0.00378418, -0.00437622, -0.0050293, -0.00586548, -0.00681763, -0.00765991, -0.0081604, -0.00825195, -0.00813599, -0.00806274, -0.00805664, 
      -0.00791626, -0.00751343, -0.00697632, -0.006604, -0.00667725, -0.00727539, -0.00825195, -0.00933228, -0.0102417, -0.01073, -0.0106934, -0.0101929, -0.00941772, 
      -0.00853272, -0.00772705, -0.00722046, -0.0071167, -0.00734253, -0.00775757, -0.00819702, -0.00848389, -0.0085022, -0.00836792, -0.00825806, -0.00820312, -0.00802002, 
      -0.00759277, -0.00710449, -0.00682373, -0.00691528, -0.00737305, 0, -0.00810547, -0.00736694, -0.00585938, -0.00427246, -0.00317993, -0.00258789, -0.00221558, 
      -0.00192871, -0.00171509, -0.00146484, -0.00110474, -0.000738525, -0.00057373, -0.000805664, -0.0015564, -0.00251465, -0.00287476, -0.00202026, -0.000274658, 0.00140381, 
      0.00223389, 0.00211182, 0.00143433, 0.000683594, 7.93457e-05, -0.000537109, -0.00145874, -0.00272217, -0.00408325, -0.00528564, -0.00620117, -0.00673828, -0.00682373, 
      -0.006427, -0.00548706, -0.0039917, -0.00223999, -0.000958252, -0.000842285, -0.00187988, -0.00343628, -0.00494385, -0.00612793, -0.00692139, -0.00733032, -0.00742798, 
      -0.00737305, -0.00731201, -0.00737305, -0.00758667, -0.00773926, -0.00747681, -0.00657959, -0.0052002, -0.00383911, -0.00291748, -0.00247192, -0.00231934, -0.00227661, 
      -0.00219116, -0.00198364, -0.00184937, -0.0019043
    }
};

CabDesc_imp<998> cab_data_mesa __rt_data = {
    998, 48000,
    { 0.00020752, 0.000354004, 0.000421143, 0.000354004, 0.000213623, 3.05176e-05, 0.00010376, 0.00178223, 0.00993652, 0.0342224, 0.0856934, 0.154669, 0.199994, 
      0.186456, 0.115784, 0.0149719, -0.0793213, -0.134674, -0.144513, -0.121069, -0.0771423, -0.0290222, 0.00469971, 0.0174072, 0.0143616, 0.00430908, 
      -0.00318604, -0.00372925, 0.00308228, 0.014386, 0.0227295, 0.0225159, 0.0127075, -0.000439453, -0.00760498, -0.00966797, -0.0125916, -0.015387, -0.0153625, 
      -0.0173401, -0.0275513, -0.0406067, -0.044635, -0.0366638, -0.0249084, -0.0157288, -0.00880737, -0.00385742, 0.000500488, 0.00552368, 0.0072937, 0.00379639, 
      -0.000646973, -0.00421143, -0.011554, -0.0231873, -0.0317993, -0.0343262, -0.0347473, -0.0345398, -0.0317749, -0.0270691, -0.0201294, 0, 0.00819702, 
      0.0214722, 0.0278442, 0.0240112, 0.010791, -0.00495605, -0.0165405, -0.0211426, -0.0202087, -0.0174377, -0.0157532, -0.0155273, -0.0153198, -0.0130981, 
      -0.00821533, -0.00350952, -0.00205688, -0.00298462, -0.00479736, -0.00900879, -0.0153992, -0.0206055, -0.0214661, -0.0169678, -0.00876465, 0.000488281, 0.00910034, 
      0.0159668, 0.0195923, 0.0187073, 0.0139221, 0.0071228, -0.000280762, -0.00716553, -0.012561, -0.0164307, -0.0199951, -0.0237122, -0.0257385, -0.0239319, 
      -0.0181946, -0.00994263, -0.00133057, 0.00576782, 0.010498, 0.0131409, 0.0147278, 0.0158875, 0.0163879, 0.0148132, 0.00995483, 0.00288696, -0.00346069, 
      -0.00641479, -0.00625, -0.00564575, -0.00671997, -0.00940552, -0.0114258, -0.01026, -0.00533447, 0.00151367, 0.0074646, 0, 0.0127625, 0.0132996, 
      0.0135132, 0.0130554, 0.0112, 0.00772705, 0.00321655, -0.00134888, -0.00551147, -0.00891724, -0.0106873, -0.0100708, -0.00715332, -0.00227051, 0.00411987, 
      0.0107239, 0.016272, 0.0203125, 0.022467, 0.0223083, 0.0198242, 0.0156982, 0.0109863, 0.00653687, 0.00307007, 0.000872803, -0.000744629, -0.00249634, 
      -0.00411987, -0.00512085, -0.00524902, -0.00421753, -0.00172119, 0.00222168, 0.00689087, 0.010907, 0.0132263, 0.0137146, 0.0125244, 0.0100891, 0.00727539, 
      0.00509033, 0.00405273, 0.00396118, 0.0043396, 0.00493164, 0.00542603, 0.00534058, 0.00458984, 0.00357666, 0.00273437, 0.0024231, 0.00309448, 0.00482178, 
      0.00687866, 0.00841064, 0.00910645, 0.00899658, 0.00805054, 0.006427, 0.00455933, 0.00275269, 0.00125732, 0, 0.000964355, 0.00222168, 0.00396729, 
      0.0059021, 0.0078064, 0.009552, 0.0110535, 0.0121948, 0.0128662, 0.0129578, 0.012384, 0.0112732, 0.00984497, 0.00819092, 0.00645752, 0.00488892, 
      0.00383301, 0.00350952, 0.00369263, 0.00373535, 0.0032898, 0.00265503, 0.00245361, 0.00301514, 0.00424194, 0.0057251, 0.00699463, 0.00770874, 0.00772095, 
      0.00706177, 0.00592041, 0.00457764, 0.00320435, 0.00202026, 0.0015625, 0.00206299, 0.00321655, 0.00463257, 0.00596924, 0.00702515, 0.00765381, 0.00772705, 
      0.0072937, 0.00652466, 0.00553589, 0.00446167, 0.0034668, 0.00252686, 0.00158691, 0.000775146, 0.000366211, 0.000671387, 0.00159912, 0.00280151, 0.00404663, 
      0.00512695, 0.00581055, 0.00594482, 0.00556641, 0.00476074, 0.00366211, 0.00255737, 0.00169678, 0, 1.83105e-05, -0.00131226, -0.00247803, -0.00265503, 
      -0.00128174, 0.00134277, 0.00421143, 0.00625, 0.00690918, 0.00640869, 0.00543823, 0.00447388, 0.00372314, 0.00337524, 0.00349121, 0.00390015, 0.00432129, 
      0.00459595, 0.00484009, 0.0052002, 0.00544434, 0.00530396, 0.00480957, 0.00409546, 0.00325317, 0.00251465, 0.00203857, 0.00178833, 0.00170288, 0.00159302, 
      0.000994873, -0.000476074, -0.0026123, -0.00474854, -0.00640259, -0.00733032, -0.00740356, -0.00665894, -0.00523682, -0.00335083, -0.00142822, -6.71387e-05, 0.000408936, 
      0.000183105, -0.0003479, -0.000793457, -0.000964355, -0.000891113, -0.000732422, -0.000738525, -0.000964355, -0.00133057, -0.00180054, -0.00220337, -0.00218506, -0.00158081, 
      -0.000720215, -7.93457e-05, 0.000146484, -6.71387e-05, -0.000610352, -0.00110474, -0.00126953, 0, -0.00128784, -0.0015564, -0.00216064, -0.00307617, -0.00404053, 
      -0.00465088, -0.00470581, -0.00445557, -0.00430298, -0.00430908, -0.00435791, -0.00424805, -0.00397339, -0.00395508, -0.00460815, -0.00584717, -0.00720825, -0.00813599, 
      -0.00832519, -0.00797729, -0.00750732, -0.00708618, -0.00664063, -0.00593872, -0.00474854, -0.0031311, -0.00148315, -0.000238037, 0.000390625, 0.000585938, 0.000726318, 
      0.000933838, 0.000982666, 0.000683594, 0.000134277, -0.000610352, -0.00168457, -0.00303955, -0.00440063, -0.00553589, -0.00634155, -0.00675659, -0.0067749, -0.00652466, 
      -0.00618896, -0.00598755, -0.00613403, -0.00653687, -0.00679932, -0.00665283, -0.00618896, -0.00574951, -0.00565186, -0.00585327, -0.00618286, -0.0065979, -0.0069519, 
      -0.00705566, -0.00687866, -0.0065979, -0.00651245, -0.0067688, -0.00722046, 0, -0.0078064, -0.00776367, -0.00752563, -0.00704346, -0.00639648, -0.00576782, 
      -0.00524292, -0.00474243, -0.0041748, -0.0034729, -0.00264282, -0.00183716, -0.00136108, -0.00144043, -0.00202637, -0.00288086, -0.0036438, -0.00405884, -0.00415649, 
      -0.00408325, -0.00391846, -0.00388184, -0.00430298, -0.00526123, -0.00645142, -0.00740356, -0.00783691, -0.0078186, -0.00752563, -0.0071228, -0.0067749, -0.00652466, 
      -0.00638428, -0.00629883, -0.00604248, -0.00536499, -0.00426025, -0.00298462, -0.00195312, -0.00154419, -0.00193481, -0.00302734, -0.00447388, -0.00574341, -0.00636597, 
      -0.00614014, -0.00529175, -0.00437622, -0.00377197, -0.003479, -0.00327759, -0.00300903, -0.00270386, -0.00245972, -0.00234985, -0.0024353, -0.00270996, -0.00309448, 
      -0.00352173, -0.00393677, -0.00419312, -0.00418701, -0.0039978, 0, -0.00402832, -0.00458374, -0.00532837, -0.005896, -0.00601807, -0.0057312, -0.00526123, 
      -0.00478516, -0.00427246, -0.00363159, -0.00289917, -0.00217896, -0.00143433, -0.000671387, -0.000115967, 4.88281e-05, -0.000170898, -0.000628662, -0.00112305, -0.00148315, 
      -0.00166016, -0.00158691, -0.00130005, -0.0010498, -0.00102539, -0.00118408, -0.00130615, -0.00123901, -0.0010376, -0.000842285, -0.000750732, -0.000866699, -0.00122681, 
      -0.00176392, -0.00228882, -0.00263062, -0.00264893, -0.00224609, -0.00150757, -0.000787353, -0.000402832, -0.00032959, -0.000372314, -0.000372314, -0.000292969, -0.000256348, 
      -0.000335693, -0.000579834, -0.00102539, -0.00154419, -0.00183105, -0.00153809, -0.000518799, 0.000946045, 0.00230713, 0.00316162, 0.00335693, 0.00296631, 0.00222778, 
      0.00140381, 0.000646973, 7.93457e-05, -0.000170898, 0, 0.000274658, 0.000653076, 0.000897217, 0.000958252, 0.000909424, 0.000769043, 0.000439453, -6.71387e-05, 
      -0.000585938, -0.00101318, -0.00117798, -0.00098877, -0.000537109, 7.93457e-05, 0.000738525, 0.00130615, 0.00176392, 0.00203247, 0.0020874, 0.00213623, 0.00238037, 
      0.00283203, 0.00335083, 0.00372314, 0.00384521, 0.00388184, 0.00405884, 0.00445557, 0.0050293, 0.00566406, 0.00620117, 0.00649414, 0.00648804, 0.00636597, 
      0.00634155, 0.00631714, 0.00599976, 0.00523071, 0.00402832, 0.00261841, 0.00146484, 0.000964355, 0.00115967, 0.00184937, 0.00275269, 0.00346069, 0.00374146, 
      0.00368042, 0.00341187, 0.00301514, 0.00268555, 0.00259399, 0.00274658, 0.0031189, 0.00361328, 0.00412598, 0.00467529, 0.00530396, 0.00591431, 0.00632935, 
      0.00639038, 0.00603027, 0.0053772, 0, 0.00407715, 0.00383301, 0.00391846, 0.00430908, 0.00491943, 0.00549927, 0.00586548, 0.00602417, 0.00604858, 
      0.00595703, 0.00576782, 0.00549927, 0.00517578, 0.00482178, 0.00442505, 0.00401001, 0.00368042, 0.00354004, 0.00357666, 0.00366821, 0.00357666, 0.00313721, 
      0.00250244, 0.00204468, 0.00209961, 0.00266724, 0.00348511, 0.00422363, 0.00466309, 0.00472412, 0.00450439, 0.00418701, 0.00392456, 0.00380249, 0.00386353, 
      0.00403442, 0.00414429, 0.00406494, 0.00377197, 0.00343018, 0.00335083, 0.00368042, 0.00422363, 0.00473022, 0.00508423, 0.00529175, 0.00541992, 0.00542603, 
      0.00516357, 0.00466309, 0.00414429, 0.00379639, 0.00368042, 0.00370483, 0.0036377, 0.00335693, 0.00293579, 0.00256958, 0.00245972, 0.00263672, 0.00300903, 
      0.00341797, 0.00365601, 0, 0.00307617, 0.00255127, 0.00218506, 0.00219727, 0.00264893, 0.00332031, 0.00391846, 0.0041687, 0.00391235, 0.003125, 
      0.00195923, 0.000811768, 4.27246e-05, -0.00020752, -1.2207e-05, 0.000360107, 0.000640869, 0.000836182, 0.00111694, 0.00157471, 0.00203857, 0.00219116, 0.00186157, 
      0.00125732, 0.000714111, 0.000439453, 0.000439453, 0.000628662, 0.000939941, 0.00133057, 0.00170288, 0.00184326, 0.00162354, 0.00111084, 0.000567627, 0.000268555, 
      0.000402832, 0.00100708, 0.00194702, 0.00292969, 0.00361328, 0.00385132, 0.00372925, 0.00351562, 0.00337524, 0.00336304, 0.00350952, 0.00374146, 0.00383301, 
      0.00354614, 0.00275879, 0.00159302, 0.000384521, -0.000482178, -0.000805664, -0.000689697, -0.000463867, -0.000354004, -0.000396729, -0.000531006, -0.00057373, -0.000396729, 
      -5.49316e-05, 0, 0.000469971, 0.000543213, 0.000585938, 0.00057373, 0.000549316, 0.000640869, 0.000933838, 0.00141602, 0.00189819, 0.0020752, 0.00189209, 
      0.00155029, 0.00125122, 0.00108643, 0.000970459, 0.000750732, 0.000415039, -2.44141e-05, -0.000592041, -0.00117188, -0.00150146, -0.00147095, -0.0012146, -0.000878906, 
      -0.000488281, -0.00012207, 0, -0.000292969, -0.000915527, -0.00164185, -0.00223389, -0.00253296, -0.00244141, -0.00209351, -0.00177002, -0.00170288, -0.00192261, 
      -0.0022644, -0.00248413, -0.00239868, -0.00198975, -0.00142212, -0.000860596, -0.000415039, -0.000158691, -0.00012207, -0.000256348, -0.000482178, -0.000695801, -0.000848389, 
      -0.000927734, -0.000946045, -0.000939941, -0.0010437, -0.00131836, -0.00169067, -0.00202637, -0.00227051, -0.00241699, -0.00246582, -0.00250244, -0.00266724, -0.00296021, 
      0, -0.00341187, -0.00338745, -0.00332642, -0.00344849, -0.00390015, -0.00459595, -0.00522461, -0.00548096, -0.00523682, -0.0045227, -0.0034668, -0.00231934, 
      -0.00135498, -0.000799561, -0.000775146, -0.00130615, -0.0022522, -0.00331421, -0.00413818, -0.00449829, -0.00435791, -0.00378418, -0.00299072, -0.00223389, -0.00169678, 
      -0.00142822, -0.00144043, -0.00167236, -0.00197754, -0.00217285, -0.00220337, -0.00216064, -0.00215454, -0.00221558, -0.00228882, -0.00228882, -0.00217896, -0.00213623, 
      -0.00233765, -0.00270996, -0.00301514, -0.00308228, -0.00292358, -0.00275269, -0.0027771, -0.00298462, -0.003302, -0.00374756, -0.00420532, -0.00446777, -0.00442505, 
      -0.00404663, -0.0034668, -0.00297852, -0.00267334, -0.00245361, -0.00227051, -0.00206299, -0.00181885, -0.00161133, -0.00145874, -0.00135498, -0.00132446, 0, 
      -0.00187378, -0.00247803, -0.00302734, -0.003302, -0.00321045, -0.00291138, -0.00266724, -0.00250244, -0.00241089, -0.00245972, -0.00256958, -0.00256348, -0.00234985, 
      -0.00192261, -0.00144043, -0.00112305, -0.00112915, -0.00136108, -0.00153809, -0.00159302, -0.00164795, -0.0017395, -0.00180664, -0.00184937, -0.00197754, -0.00223999, 
      -0.00251465, -0.00269165, -0.00288086, -0.00316772, -0.00349121, -0.00375977, -0.00385742, -0.00371094, -0.00339966, -0.00303955, -0.00262451, -0.00217896, -0.00176392, 
      -0.00141602, -0.00116577, -0.00111084, -0.00134888, -0.00174561, -0.0020752, -0.00227661, -0.00241699, -0.00247192, -0.00234985, -0.0020752, -0.00184326, -0.00172119, 
      -0.00158691, -0.0013855, -0.0012085, -0.00117188, -0.00127563, -0.00143433, -0.00153198, -0.00150146, -0.0013855, -0.00123901, -0.00100708, 0, -0.000286865, 
      -1.83105e-05, 2.44141e-05, -9.15527e-05, -0.000158691, 1.2207e-05, 0.000415039, 0.000878906, 0.00119019, 0.00124512, 0.00113525, 0.000933838, 0.000610352, 0.000189209, 
      -0.00020752, -0.000457764, -0.00055542, -0.000561523, -0.000488281, -0.0003479, -0.000152588, 4.88281e-05, 0.000201416, 0.000262451, 0.000250244, 0.000189209, 0.000140381, 
      0.00010376, 7.32422e-05, 4.88281e-05, 6.71387e-05, 0.000146484, 0.000262451, 0.000323486, 0.000262451, 0.000115967, -5.49316e-05, -0.000201416, -0.000244141, -0.000146484, 
      -1.83105e-05, 1.83105e-05, -2.44141e-05, -4.27246e-05, -4.27246e-05, -5.49316e-05, -3.05176e-05, 0.00010376, 0.000335693, 0.000592041, 0.000823975, 0.0010437, 0.00131836, 
      0.00168457, 0.0020874, 0.00249634, 0.00282593, 0.00292358, 0.0027771, 0.00250854, 0.00221558, 0.00195923, 0.00170288, 0, 0.000933838, 0.000415039, 
      -1.83105e-05, -0.000213623, -0.000146484, 0.00012207, 0.000463867, 0.000720215, 0.000805664, 0.000756836, 0.00065918, 0.000561523, 0.000506592, 0.000500488, 0.00055542, 
      0.000683594, 0.000848389, 0.00103149, 0.0012207, 0.00142212, 0.00163574, 0.0019104, 0.00223389, 0.00251465, 0.00263062, 0.00249634, 0.00221558, 0.00200806, 
      0.00203247, 0.00227051, 0.00252686, 0.00252686, 0.00219116, 0.00170898, 0.00132446, 0.00119019, 0.00130615, 0.00154419
    }
};

CabDesc_imp<841> cab_data_briliant __rt_data = {
    841, 48000,
    { 0.000482178, 0.00043335, 0.000439453, 0.000421143, 0.000463867, 0.000500488, 0.000640869, 0.000683594, 0.000811768, 0.000793457, 0.00088501, 0.000787353, 0.000811768, 
      0.000982666, 0.00252075, 0.00623779, 0.0139893, 0.0277832, 0.0537781, 0.093512, 0.146436, 0.178247, 0.117297, -0.0167236, -0.115887, -0.14679, 
      -0.142633, -0.116064, -0.0726257, -0.0275269, 0.00512695, 0.0515442, 0.072113, 0.0563171, 0, 0.0566284, 0.0562561, 0.0503174, 0.0129578, 
      -0.0316345, -0.0648743, -0.0805237, -0.0483643, -0.0144958, 0.00458984, 0.00944824, 0.014856, 0.0198914, 0.00804443, -0.0026062, -0.0223633, -0.0235962, 
      0.00594482, 0.0248108, 0.0348694, 0.0258179, -0.00292969, -0.0217041, -0.0262939, -0.0175049, -0.00540771, -0.00526123, -0.00762939, -0.0148499, -0.0190247, 
      -0.0238525, -0.027417, -0.0233521, -0.00477905, 0.0248596, 0.039032, 0.0333923, 0.0225159, 0.00825195, -0.00351562, -0.0138855, -0.0213684, -0.0242859, 
      -0.0281677, -0.0273193, -0.0261353, -0.0251953, -0.019989, -0.00855103, 0.00524902, 0.0155762, 0.0175964, 0.0115051, 0.000958252, -0.00958252, -0.0187195, 
      -0.0190308, -0.0161255, -0.0147461, -0.0102844, -0.00829468, -0.00565796, -0.00269165, 0, 0.00249023, 0.00302734, 0.00223999, -0.00163574, -0.00375366, 
      -0.00883179, -0.0200806, -0.0300903, -0.0328064, -0.0301819, -0.0252625, -0.018396, -0.00964355, 1.2207e-05, 0.0085022, 0.0127197, 0.0113403, 0.00792847, 
      0.00335693, -0.00170288, -0.00737305, -0.0113586, -0.0134766, -0.0163574, -0.0159851, -0.0112915, -0.00338135, 0.00411377, 0.00782471, 0.00733643, 0.00357056, 
      -0.00240479, -0.00739746, -0.00960693, -0.0105652, -0.00952148, -0.00513306, -0.00196533, -0.0019043, -0.00330811, -0.00599976, -0.010144, -0.0137268, -0.0151672, 
      -0.0133728, -0.00734253, 0.000292969, 0.00736694, 0.0119507, 0.0138428, 0.0126465, 0.00895996, 0.00510864, 0.00193481, -0.00162964, -0.00593262, -0.00997314, 
      -0.0123901, -0.0121277, -0.00897217, -0.00412598, 0.000640869, 0.00338135, 0, 0.00311279, 0.00162964, 0.000701904, 0.000842285, 0.00146484, 0.00219727, 
      0.00212402, 7.93457e-05, -0.00328369, -0.00634155, -0.00761719, -0.0072937, -0.00584106, -0.00375977, -0.00124512, 0.00134888, 0.00351562, 0.00368042, 0.00163574, 
      -0.000854492, -0.00252075, -0.00349121, -0.00348511, -0.00258179, -0.00126953, 0.000512695, 0.00236816, 0.00263672, 0.00159302, 0.00108032, 0.00145264, 0.00215454, 
      0.00270996, 0.00305176, 0.00326538, 0.0038208, 0.00461426, 0.00512085, 0.00541382, 0.00565186, 0.00577393, 0.00552979, 0.00476685, 0.00344849, 0.00185547, 
      0.00043335, -0.000720215, -0.00119019, -0.00100098, -0.000585938, -3.66211e-05, 0.000854492, 0.00212402, 0.00379028, 0.00557861, 0.00741577, 0.00864868, 0.00892944, 
      0.00809937, 0.00599976, 0.00393677, 0.00253296, 0.0017395, 0, 0.00230713, 0.00323486, 0.0041626, 0.00544434, 0.006427, 0.0064209, 0.00609131, 
      0.00587158, 0.0057251, 0.00584106, 0.00626221, 0.00634155, 0.00559082, 0.00437012, 0.00283203, 0.00137939, 0.000549316, -9.15527e-05, -0.000640869, -0.000848389, 
      -0.000427246, 0.000592041, 0.00215454, 0.00371094, 0.00456543, 0.00495605, 0.00524902, 0.00523071, 0.00488892, 0.00448608, 0.00412598, 0.00410156, 0.0043396, 
      0.00447388, 0.00420532, 0.00383911, 0.00350952, 0.00331421, 0.00338745, 0.00367432, 0.00415039, 0.00480957, 0.00551147, 0.00626221, 0.00689087, 0.00742798, 
      0.00778198, 0.00771484, 0.00737305, 0.00680542, 0.0059082, 0.00482178, 0.0039978, 0.00397339, 0.00461426, 0.00521851, 0.00548706, 0.00566406, 0.00592651, 
      0.00613403, 0.00617065, 0.00601807, 0.00565796, 0, 0.00448608, 0.00404053, 0.00389404, 0.00391846, 0.00363159, 0.00259399, 0.00152588, 0.00103149, 
      0.00100708, 0.00172729, 0.00325317, 0.00502319, 0.00634155, 0.0071228, 0.00752563, 0.00719605, 0.00609131, 0.00492554, 0.00449829, 0.00479736, 0.00510864, 
      0.0048584, 0.00404663, 0.00308228, 0.00206909, 0.00112305, 0.000640869, 0.000665283, 0.000933838, 0.00111694, 0.00130615, 0.00166626, 0.00195923, 0.00215454, 
      0.00236816, 0.00263672, 0.00284424, 0.00288086, 0.00256348, 0.00175781, 0.000811768, 0.000292969, 0.00022583, 0.000256348, 0.000201416, 0.000189209, 0.000469971, 
      0.0010498, 0.00171509, 0.00219727, 0.00270386, 0.00330811, 0.00360107, 0.00326538, 0.00249023, 0.00153198, 0.000616455, 0.00020752, 0.000311279, 0.000653076, 
      0.00111694, 0.00177612, 0.00239258, 0, 0.00216064, 0.00164795, 0.00126343, 0.00153198, 0.00227051, 0.00250244, 0.00203857, 0.0013855, 0.000653076, 
      -0.000164795, -0.000646973, -0.000567627, -0.000244141, 6.10352e-05, 6.10352e-06, -0.00067749, -0.00144043, -0.00168457, -0.00144653, -0.000878906, -0.00022583, 0.000140381, 
      0.00012207, -0.000140381, -0.00057373, -0.00078125, -0.00045166, 0.000250244, 0.000958252, 0.00134888, 0.00112305, 3.05176e-05, -0.00161743, -0.00317383, -0.0041748, 
      -0.00452881, -0.00431519, -0.00375977, -0.00314941, -0.00269775, -0.00262451, -0.00281372, -0.00283813, -0.00247803, -0.0020752, -0.00178833, -0.00176392, -0.00219116, 
      -0.0026001, -0.00245972, -0.00196533, -0.00153198, -0.00117798, -0.00114746, -0.00135498, -0.00152588, -0.00187988, -0.00263062, -0.00344238, -0.00397339, -0.00419312, 
      -0.00409546, -0.00386353, 0, -0.00374146, -0.00299072, -0.00170898, -0.000506592, 0.000396729, 0.000891113, 0.000872803, 0.00055542, 0.000177002, -0.000396729, 
      -0.0012146, -0.00200806, -0.0026062, -0.00285034, -0.0027771, -0.00255737, -0.00237427, -0.00220947, -0.00218506, -0.00228271, -0.00235596, -0.00250854, -0.00290527, 
      -0.00339966, -0.00370483, -0.00373535, -0.00338135, -0.00292358, -0.00267944, -0.00256958, -0.00245972, -0.00227051, -0.00194092, -0.00142822, -0.00100708, -0.000756836, 
      -0.000714111, -0.000860596, -0.00129395, -0.00187378, -0.00248413, -0.00317383, -0.0036499, -0.0038208, -0.00387573, -0.00408325, -0.00444946, -0.00476074, -0.00471802, 
      -0.00430908, -0.00405884, -0.00401611, -0.00378418, -0.003302, -0.00283203, -0.00239868, -0.00197144, -0.00177612, -0.00175781, -0.00175781, -0.00185547, -0.00220337, 
      -0.00263062, 0, -0.00299072, -0.00247803, -0.00155029, -0.000769043, -0.000634766, -0.00108643, -0.00169067, -0.00222778, -0.00244141, -0.00245361, -0.00250244, 
      -0.00247192, -0.00252075, -0.00255127, -0.00237427, -0.00209351, -0.00177002, -0.00159302, -0.00153809, -0.00166626, -0.00186768, -0.00151367, -0.000689697, 0.00010376, 
      0.000549316, 0.000592041, 0.000238037, -0.000628662, -0.00166016, -0.00244141, -0.00296021, -0.00327759, -0.0034729, -0.00334473, -0.00282593, -0.00227661, -0.00164795, 
      -0.00115356, -0.000860596, -0.000476074, -4.88281e-05, 0.000262451, 0.000219727, -9.15527e-05, -0.000256348, -0.000311279, -0.000494385, -0.000915527, -0.00154419, -0.0020813, 
      -0.00223999, -0.00210571, -0.00193481, -0.00155029, -0.00102539, -0.000634766, -0.000482178, -0.000701904, -0.00108032, -0.0013855, -0.00153198, -0.00147705, -0.00131226, 
      0, -0.00130615, -0.00145874, -0.00144653, -0.00119629, -0.000915527, -0.000701904, -0.000610352, -0.000762939, -0.00115967, -0.00167847, -0.00198364, -0.00172119, 
      -0.00116577, -0.000506592, 0.000238037, 0.000811768, 0.00116577, 0.00134277, 0.0012085, 0.000830078, 0.000439453, 0.000109863, 1.83105e-05, 0.000201416, 0.000402832, 
      0.000366211, 8.54492e-05, -2.44141e-05, 0.000170898, 0.000360107, 0.000628662, 0.00110474, 0.00145264, 0.00141602, 0.00111694, 0.000708008, 0.00032959, 0.000250244, 
      0.00055542, 0.00101318, 0.00145874, 0.0015564, 0.00131226, 0.00103149, 0.00067749, 0.000292969, 0.00020752, 0.00045166, 0.000634766, 0.000457764, 1.2207e-05, 
      -0.000366211, -0.000280762, 0.000177002, 0.000744629, 0.0013916, 0.00209961, 0.00267944, 0.00300903, 0.00310669, 0.00286255, 0.00241699, 0.0019165, 0, 
      0.00117188, 0.000909424, 0.000506592, -5.49316e-05, -0.000482178, -0.000720215, -0.000756836, -0.000439453, 0.000109863, 0.000482178, 0.00067749, 0.000854492, 0.000952148, 
      0.000964355, 0.000976562, 0.00102539, 0.00112305, 0.00130615, 0.00141602, 0.0012146, 0.000811768, 0.000549316, 0.000671387, 0.00107422, 0.00160522, 0.00203247, 
      0.00216064, 0.00215454, 0.00187988, 0.00133057, 0.00098877, 0.00112915, 0.00161133, 0.0022583, 0.00281982, 0.00283203, 0.00223999, 0.00167236, 0.00162354, 
      0.00188599, 0.00221558, 0.00249634, 0.00253906, 0.00231934, 0.00205688, 0.0017334, 0.00137939, 0.00131836, 0.00165405, 0.00202637, 0.00205688, 0.00184326, 
      0.00143433, 0.000909424, 0.000457764, 0.000213623, 0.00020752, 0.000488281, 0.00108032, 0.00169678, 0.00205688, 0.00215454, 0.00223389, 0, 0.00264282, 
      0.00270996, 0.00250854, 0.00199585, 0.00134277, 0.000744629, 0.000299072, 0.000134277, 0.000372314, 0.000842285, 0.00119629, 0.0012085, 0.000793457, 2.44141e-05, 
      -0.000738525, -0.00114136, -0.00111694, -0.000927734, -0.000689697, -0.000299072, 0.000201416, 0.00057373, 0.000732422, 0.000811768, 0.000976562, 0.00123901, 0.00149536, 
      0.00159912, 0.00142212, 0.00114746, 0.000958252, 0.000744629, 0.000335693, -7.32422e-05, -0.000177002, 9.15527e-05, 0.00055542, 0.000976562, 0.00117798, 0.00126953, 
      0.00136719, 0.0015625, 0.00187988, 0.00210571, 0.00220337, 0.00209351, 0.00166016, 0.00102539, 0.000415039, 8.54492e-05, 0.000164795, 0.000494385, 0.000775146, 
      0.000915527, 0.00100098, 0.000854492, 0.000408936, -0.000170898, -0.000714111, -0.000976562, -0.000866699, -0.000585938, -0.000482178, 0, -0.000482178, -0.000323486, 
      -0.000201416, -8.54492e-05, 5.49316e-05, 0.000317383, 0.000708008, 0.00098877, 0.00115356, 0.00133667, 0.00150757, 0.00152588, 0.00137939, 0.0010498, 0.000549316, 
      -0.000134277, -0.000854492, -0.00147095, -0.00196533, -0.0022522, -0.00210571, -0.00146484, -0.000732422, -0.000317383, -0.000183105, -0.000177002, -0.000262451, -0.000384521, 
      -0.000500488, -0.000646973, -0.000854492, -0.00106812, -0.00122681, -0.00135498, -0.00153809, -0.00172729, -0.00181885, -0.00164185, -0.00109863, -0.000372314, 0.00022583, 
      0.000421143, 0.000360107, 0.000262451, 0.000256348, 0.0003479, 0.000390625, 0.000213623, -0.000189209, -0.000628662, -0.000927734, -0.0010437, -0.000952148, -0.000701904, 
      -0.000195313, 0.000439453, 0.000958252, 0.00123291, 0.00117798, 0.000817871, 0.000317383, -0.000292969, -0.00090332, 0, -0.00168457, -0.00196533, -0.00211792, 
      -0.0019043, -0.00154419, -0.00119019, -0.000756836, -0.000189209, 0.0003479, 0.00065918, 0.000585938, 0.000140381, -0.000500488, -0.00117188, -0.00176392, -0.00214233, 
      -0.00227661, -0.00214233, -0.00175171, -0.00117188, -0.000537109, -3.66211e-05, 0.000189209, 0.000128174, -7.93457e-05, -0.00032959, -0.000561523, -0.000805664, -0.00107422, 
      -0.00133057, -0.00152588, -0.00159302, -0.00145874, -0.00111694, -0.00078125, -0.000689697, -0.000866699, -0.00108643
    }
};

CabDesc_imp<133> cab_data_vitalize __rt_data = {
    133, 48000,
    {0.000488281, -0.0020752, 0.000561523, -0.00231934, 0.000634766, -0.00247803, 0.000512695, -0.00247803, 0.000146484, -0.00219727, -0.000622559, -0.00145264, -0.00202637, 
    -2.44141e-05, -0.00438232, 0.00247803, -0.00822754, 0.00706787, -0.0159546, 0.0202148, -0.0471558, 0.0953003, -0.208582, 0.312427, 0.75, -0.26803, 
    0.399963, 0.200696, -0.146655, -0.29303, -0.222168, -0.113098, 0.0267334, 0.0312134, 0.164685, 0.0443481, 0.186621, 0.0540039, 0.123303, 
    0.0805054, 0.0739868, 0.0591797, 0.0661743, 0.0400391, 0.0429932, 0.0339844, 0.0320557, 0.02323, 0.0217285, 0.0182007, 0.0157227, 0.0130005, 
    0.0103882, 0.00942383, 0.00718994, 0.0067749, 0.00458984, 0.00455322, 0.00272217, 0.00294189, 0.00140381, 0.00170898, 0.000402832, 0.000720215, -0.000354004, 
    -2.44141e-05, -0.000915527, -0.000610352, -0.00134277, -0.0010498, -0.00166016, -0.0013916, -0.0019043, -0.00166016, -0.0020874, -0.00187988, -0.00224609, -0.00203857, 
    -0.00235596, -0.00217285, -0.0024292, -0.0022583, -0.00247803, -0.00233154, -0.00252686, -0.00238037, -0.00256348, -0.0024292, 0.75, -0.00246582, -0.0026001, 
    -0.00247803, -0.0026001, -0.00249023, -0.0026001, -0.00250244, -0.0026001, -0.00251465, -0.0026001, -0.00251465, -0.0026001, -0.00251465, -0.0026001, -0.00252686, 
    -0.00258789, -0.00252686, -0.00258789, -0.00251465, -0.00257568, -0.00251465, -0.00256348, -0.00251465, -0.00256348, -0.00251465, -0.00256348, -0.00251465, -0.00256348, 
    -0.00251465, -0.00256348, -0.00251465, -0.00256348, -0.00252686, -0.00256348, -0.00252686, -0.00255127, -0.00252686, -0.00255127, -0.00252686, -0.00255127, -0.00252686, 
    -0.00255127, -0.00252686, -0.00256348
    }
};

CabDesc_imp<68> cab_data_charisma __rt_data = {
    68, 48000,
    {-0.0041626, 0.000817871, -0.00541992, 0.00203857, -0.00721436, 0.00386963, -0.00977783, 0.00655518, -0.0135254, 0.0107056, -0.019397, 0.0179687, -0.0306763, 
    0.0349365, -0.060791, 0.0839355, -0.121387, 0.0738403, 0, -0.399963, 0.177356, 0.284045, 0.041626, -0.2479, -0.224634, -0.212317, 
    -0.0146851, -0.028186, 0.13606, 0.0628052, 0.142847, 0.111206, 0.0892456, 0.113098, 0.0713745, 0.0726318, 0.0624023, 0.0565918, 0.0397461, 
    0.0431152, 0.0320679, 0.0316284, 0.0222412, 0.0241821, 0.0174805, 0.0184692, 0.0128052, 0.0139893, 0.0098999, 0.0109619, 0.00759277, 0.00843506, 
    0.00577393, 0.00654297, 0.00443115, 0.00511475, 0.00335693, 0.00395508, 0.00250244, 0.00305176, 0.00181885, 0.00230713, 0.00124512, 0.00170898, 0.000805664, 
    0.0012207, 0.000427246, 0.000805664
    }
};

CabDesc_imp<192> contrast_ir_desc __rt_data = {
    192, 48000,
    { 0.147081, 0.208808, 0.208996, 0.163228, 0.0858905, -0.0119104, -0.0932825, -0.121011, -0.0999426, -0.071073, -0.0403973, -0.00214844, 0.0287018, 
      0.0381079, 0.0372284, 0.0330389, 0.0252979, 0.0141394, 0.00118835, -0.00764709, -0.00751953, 0.00262512, 0.0143475, 0.0174762, 0.0168384, 0.0179126, 
      0.00738525, -0.0114069, -0.0192352, -0.0145825, -0.0179932, -0.0244049, -0.0173956, -0.00357178, 0.00643188, 0.0108966, 0.0132935, 0.0123737, 0.00680786, 
      -0.000214844, -0.0040686, -0.00533752, -0.00738525, -0.00539124, -0.00171875, 0.00156433, 0.00481384, 0.0038739, -0.00666016, -0.018866, -0.0216522, -0.0171606, 
      -0.00717712, 0.00770081, 0.0209003, 0.0251971, 0.0221222, 0.0157977, 0.00453857, -0.0107892, -0.022478, -0.029165, -0.0303467, 0, -0.0169592, 
      -0.00966125, -0.00163147, 0.00273254, 0.000436401, -0.00282654, -0.00791565, -0.0136493, -0.0128436, -0.00564636, 0.00298096, 0.0090033, 0.00841248, 0.00201416, 
      -0.00579407, -0.0119171, -0.0145624, -0.0128436, -0.00741211, 0.000543823, 0.00414917, 0.00414917, 0.00114136, -0.00778809, -0.021377, -0.0325623, -0.0386584, 
      -0.038974, -0.0333679, -0.0221289, -0.0107825, -0.00453186, -0.00127563, -0.000261841, 0.000631104, 0.000537109, 0.000355835, 0.00114136, 0.00174561, 0.00104065, 
      -0.000100708, -0.00128906, -0.00083252, 0.00146362, 0.00234314, 0.000443115, -0.00245056, -0.00782165, -0.0164423, -0.0250092, -0.0309644, -0.0314343, -0.0265063, 
      -0.0176508, -0.00496155, 0.00805664, 0.0157843, 0.0171069, 0.0131055, 0.00613647, -0.00216187, -0.00804321, -0.0117157, 0, -0.015321, -0.0154352, 
      -0.013374, -0.00994995, -0.00672058, -0.00353821, -0.00110779, 0.000678101, 0.00250427, -0.00564636, 0.00298096, 0.0090033, 0.00841248, 0.00201416, -0.00579407, 
      -0.0119171, -0.0145624, -0.0128436, -0.00741211, 0.000543823, 0.00414917, 0.00414917, 0.00114136, -0.00778809, -0.021377, -0.0325623, -0.0386584, -0.038974, 
      -0.0333679, -0.0221289, -0.0107825, -0.00453186, -0.00127563, -0.000261841, 0.000631104, 0.000537109, 0.000355835, 0.00114136, 0.00174561, 0.00104065, -0.000100708, 
      -0.00128906, -0.00083252, 0.00146362, 0.00234314, 0.000443115, -0.00245056, -0.00782165, -0.0164423, -0.0250092, -0.0309644, -0.0314343, -0.0265063, -0.0176508, 
      -0.00496155, 0.00805664, 0.0157843, 0.0171069, 0.0131055, 0.00613647, -0.00216187, -0.00804321, -0.0117157, 0
    }
};
