/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_EVENT_INFO_H
#define GF_EVENT_INFO_H

typedef struct _GfEventInfo GfEventInfo;

typedef enum _GfEventType {
	GF_EVENT_TYPE_UNKNOWN = 0,
	GF_EVENT_TYPE_BUDDY,
	GF_EVENT_TYPE_CONVERSATION,
	GF_EVENT_TYPE_ACCOUNT,
	GF_EVENT_TYPE_MISC
} GfEventType;

#include <glib.h>

#include <account.h>
#include <blist.h>
#include <conversation.h>

#include "gf_event.h"
#include "gf_notification.h"

G_BEGIN_DECLS

GfEventInfo *gf_event_info_new(const gchar *notification_type);
void gf_event_info_destroy(GfEventInfo *info);

GfEvent *gf_event_info_get_event(GfEventInfo *info);

void gf_event_info_set_account(GfEventInfo *info, GaimAccount *account);
GaimAccount *gf_event_info_get_account(GfEventInfo *info);
void gf_event_info_set_buddy(GfEventInfo *info, GaimBuddy *buddy);
GaimBuddy *gf_event_info_get_buddy(GfEventInfo *info);
void gf_event_info_set_conversation(GfEventInfo *info, GaimConversation *conv);
GaimConversation *gf_event_info_get_conversation(GfEventInfo *info);

void gf_event_info_set_target(GfEventInfo *info, const gchar *target);
const gchar *gf_event_info_get_target(GfEventInfo *info);
void gf_event_info_set_message(GfEventInfo *info, const gchar *message);
const gchar *gf_event_info_get_message(GfEventInfo *info);
void gf_event_info_set_extra(GfEventInfo *info, const gchar *extra);
const gchar *gf_event_info_get_extra(GfEventInfo *info);
void gf_event_info_set_components(GfEventInfo *info, const GHashTable *components);
const GHashTable *gf_event_info_get_components(GfEventInfo *info);
void gf_event_info_set_timeout_id(GfEventInfo *info, guint timeout_id);
guint gf_event_info_get_timeout_id(GfEventInfo *info);
void gf_event_info_set_conv_chat_buddy_flags(GfEventInfo *info, GaimConvChatBuddyFlags flags);
GaimConvChatBuddyFlags gf_event_info_get_chat_buddy_flags(GfEventInfo *info);
void gf_event_info_set_is_contact(GfEventInfo *info, gboolean value);
gboolean gf_event_info_get_is_contact(GfEventInfo *info);
void gf_event_info_set_open_action(GfEventInfo *info, GCallback open_action);
GCallback gf_event_info_get_open_action(const GfEventInfo *info);

G_END_DECLS

#endif /* GF_EVENT_INFO_H */
