/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2004 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <stdio.h>

/* MinGW has unistd.h!!! */
#include <unistd.h>

#include "gf_file.h"
#include "gf_internal.h"

gboolean
gf_file_copy_file(const gchar *source, const gchar *destination) {
	FILE *src, *dest;
	gint chr = EOF;

	if(!(src = g_fopen(source, "rb")))
		return FALSE;
	if(!(dest = g_fopen(destination, "wb")))
		return FALSE;

	while((chr = fgetc(src)) != EOF) {
		fputc(chr, dest);
	}

	fclose(dest);
	fclose(src);

	return TRUE;
}

gboolean
gf_file_copy_directory(const gchar *source, const gchar *destination) {
	GDir *dir;
	const gchar *filename;
	gchar *oldfile, *newfile;

	g_return_val_if_fail(source, FALSE);
	g_return_val_if_fail(destination, FALSE);

	dir = g_dir_open(source, 0, NULL);
	if(!dir)
		return FALSE;

	while((filename = g_dir_read_name(dir))) {
		oldfile = g_build_filename(source, filename, NULL);
		newfile = g_build_filename(destination, filename, NULL);

		gf_file_copy_file(oldfile, newfile);

		g_free(oldfile);
		g_free(newfile);
	}

	g_dir_close(dir);

	return TRUE;
}

void
gf_file_remove_dir(const gchar *directory) {
	GDir *dir;
	gchar *path;
	const gchar *file = NULL;

	g_return_if_fail(directory);

	dir = g_dir_open(directory, 0, NULL);

	while((file = g_dir_read_name(dir))) {
		path = g_build_filename(directory, file, NULL);
		g_remove(path);
		g_free(path);
	}

	g_dir_close(dir);
	g_rmdir(directory);
}

gint
gf_file_access(const gchar *filename, gint mode) {
#ifdef _WIN32
	return _access(filename, mode);
#else
	return access(filename, mode);
#endif
}
