# Gufw 9.10.4 - http://gufw.tuxfamily.org
# Copyright (C) 2009 Marcos Alvarez Costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.


from FrontEnd import Frontend
from Log      import Log
from Variable import Variable


class Firewall:

    def __init__(self):
    
        self.rules_list = []
        
        self.frontend = Frontend()
        self.log      = Log()
        self.variable = Variable()
        
        self.status    = self.frontend.get_status()
        self.default   = self.frontend.get_default()
        self.ufw_log   = self.frontend.get_ufw_log()
        self.gufw_log  = self.frontend.get_gufw_log()
        self.wrap      = self.log.get_wrapping()
        self.maximized = False


    # Return status ufw
    def set_status(self, status):
        self.status = self.frontend.set_status(status)
        self.log.add_log(self.gufw_log, self.variable.get_command(status))
        

    # Get status ufw
    def get_status(self):
        return self.status


    # Return status ufw
    def set_default(self, default):
        self.default = self.frontend.set_default(default)
        self.log.add_log(self.gufw_log, self.variable.get_command(default))


    # Get status ufw 
    def get_default(self):
        return self.default
        

    # Get actual rules split by Action
    def get_rules_list(self):
        self.rules_list = []
        
        rules = self.frontend.get_rules()
        
        for rule in rules:
            self.rules_list.append(self.get_rule_split_by_action(rule))
            
        return self.rules_list


    # Refresh Log
    def refresh_log(self):
        self.log.refresh_log()


    # Get Log
    def get_log(self):
        return self.log.get_log()
        

    # Get Wrapping
    def get_wrap(self):
        return self.log.get_wrapping()
        
        
    # Set Wrapping
    def set_wrap(self, wrapping):
        self.wrap = self.log.set_wrapping(wrapping)

    
    # Get ufw log
    def get_ufw_log(self):
        return self.ufw_log
        
        
    # Set ufw log
    def set_ufw_log(self, status):
        self.ufw_log = self.frontend.set_ufw_log(status)
        self.log.add_log(self.gufw_log, self.variable.get_command(status))
    
    
    # Get Gufw log
    def get_gufw_log(self):
        return self.gufw_log
        
        
    # Set Gufw log
    def set_gufw_log(self, status):
        self.gufw_log = self.frontend.set_gufw_log(status)
        if self.gufw_log == self.variable.get_constant("gufw_log_on"):
            self.log.add_log(self.gufw_log, self.variable.get_text("004"))
        else:
            self.log.add_log("gufw_log_on", self.variable.get_text("005"))
    
     
    # Add rule to ufw
    def add_rule(self, service, action, protocol, fromip, fromport, toip, toport):
        rule = self.frontend.add_rule_component(service, action, protocol, fromip, fromport, toip, toport)
        self.log.add_log(self.gufw_log, rule)
        return self.frontend.add_rule(rule)
        

    # Remove rule from ufw
    def remove_rule(self, rule_to, action, rule_from):
        rule = self.frontend.remove_rule_component(rule_to, action, rule_from)
        self.log.add_log(self.gufw_log, rule)
        return self.frontend.remove_rule(rule)


    # Split rule by action
    def get_rule_split_by_action(self, rule):

        return_split_rule = []
        
        # Deny?
        if rule.find(self.variable.get_constant("deny_upper")) != -1:
            split_rule = rule.split(self.variable.get_constant("deny_upper"))
            return_split_rule.append(split_rule[0].strip())
            return_split_rule.append(self.variable.get_constant("deny_upper"))
            return_split_rule.append(split_rule[1].strip())

        # Allow?
        elif rule.find(self.variable.get_constant("allow_upper")) != -1:
            split_rule = rule.split(self.variable.get_constant("allow_upper"))
            return_split_rule.append(split_rule[0].strip())
            return_split_rule.append(self.variable.get_constant("allow_upper"))
            return_split_rule.append(split_rule[1].strip())
            
        # Limit?
        elif rule.find(self.variable.get_constant("limit_upper")) != -1:
            split_rule = rule.split(self.variable.get_constant("limit_upper"))
            return_split_rule.append(split_rule[0].strip())
            return_split_rule.append(self.variable.get_constant("limit_upper"))
            return_split_rule.append(split_rule[1].strip())
            
        # Reject?
        elif rule.find(self.variable.get_constant("reject_upper")) != -1:
            split_rule = rule.split(self.variable.get_constant("reject_upper"))
            return_split_rule.append(split_rule[0].strip())
            return_split_rule.append(self.variable.get_constant("reject_upper"))
            return_split_rule.append(split_rule[1].strip())
            
        return return_split_rule


    # Size Gufw window
    def get_old_size_window(self):
        width,height = self.frontend.get_old_size_window()
        return width,height
        
        
    # Save actual size window
    def save_size_window(self, win_width, win_height):
        self.frontend.save_size_window(win_width, win_height)
