# GUI For ufw (Uncomplicated FireWall) - Version 0.20.7
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Imports
import gtk
import gobject
import sys
import os
import locale
import gettext

from variables_paths_messages import *

_ = gettext.gettext




# -------------------------- MESSAGES ---------------------------------
text_001 = _("You must run Gufw as root => gksudo --preserve-env /path/gufw.py")
text_002 = _("ufw not found in the system")
text_003 = _("Changed status firewall")
text_004 = _("Error changing status firewall")
text_005 = _("Enabled")
text_006 = _("Disabled")
text_007 = _("Working")
text_008 = _("Enable/disable firewall")
text_009 = _("Firewall Log Window")
text_010 = _("Edit preferences")
text_011 = _("Working, please wait...")
text_012 = _("Firewall working...")
text_014 = _("Firewall disabled")
text_016 = _("Firewall enabled - Deny all")
text_018 = _("Firewall enabled - Allow all")
text_019 = _("To")
text_020 = _("Action")
text_021 = _("From")
text_022 = _("Error: Insert a port number")
text_023 = _("Operation done")
text_024 = _("Start operations...")
text_025 = _("...Finish operation")
text_026 = _("About Dialog")
text_027 = _("Error: Select rule(s)")
text_028 = _("Error: There aren't rules")
text_033 = _("Error: You must enter the complete range of ports")
text_034 = _("Error: Fields filled out incorrectly")
text_037 = _("Error: Port is an invalid number")
text_043 = _("Error performing operation")
text_048 = _("Changed policy")
text_049 = _("Error changing policy")
text_060 = _("Action canceled")
text_063 = _("translator-credits")
text_064 = _("Help not found.")
text_066 = _("Edit preferences")
text_070 = _("Open rules from file ")
text_071 = _("Save rules to file ")
text_072 = _("Banning specific ip addresses from file with format: text:IP-text")
text_074 = _("You are going to overwrite the file.")
text_076 = _("Error overwriting file.")
text_081 = _("You are going add more rules.")
text_083 = _("Error opening file.")
text_085 = _("Error in format file.")
text_088 = _("You are going to add new banning IP addresses.\nThe format must be \"text:IP-text\"\n")
text_091 = _("Error in format file, line ")
text_092 = _(".\nAll lines should have this format: \"text:IP-text\"\nVisit http://www.bluetack.co.uk for download files.")
text_097 = _("--- Log start ---\n")
text_098 = _("--- Log end ---")
text_099 = _("Clear Firewall Log")




# ---------------------------- PATHS ----------------------------------
# Icons
path_icon_tray     = "/usr/share/icons/hicolor/16x16/apps/gufw_working.png"
path_icon_disabled = "/usr/share/icons/hicolor/16x16/apps/gufw_disable.png"
path_icon_deny     = "/usr/share/icons/hicolor/16x16/apps/gufw_enable_deny_all.png"
path_icon_allow    = "/usr/share/icons/hicolor/16x16/apps/gufw_enable_allow_all.png"

# Images
path_gufw_default  = "/usr/share/pixmaps/gufw/gufw.png"
path_gufw_disabled = "/usr/share/pixmaps/gufw/disable.png"
path_gufw_deny     = "/usr/share/pixmaps/gufw/enable_deny_all.png"
path_gufw_allow    = "/usr/share/pixmaps/gufw/enable_allow_all.png"

# Paths glades files
path_gufw_glade   = sys.path[0] + "/glade/gufw.glade"
path_about        = sys.path[0] + "/glade/about.glade"
path_preferences  = sys.path[0] + "/glade/preferences.glade"
path_gufw_logging = sys.path[0] + "/glade/gufw_log.glade"

# Paths configurations
path_locale_check       = sys.path[0] + "/locale-langpack/es/LC_MESSAGES/gufw.mo"
path_locale1            = sys.path[0] + "/locale-langpack"

path_gufw_log           = "/var/log/gufw_log.txt"
path_gufw_config        = "/var/lib/gufw/cfg_files/gufw.cfg"
path_gufw_services      = "/var/lib/gufw/cfg_files/services.cfg"
path_gufw_programs      = "/var/lib/gufw/cfg_files/programs.cfg"
path_rules_ipv4_compare = "/var/lib/gufw/cfg_files/user.rules_compare"
path_rules_ipv6_compare = "/var/lib/gufw/cfg_files/user6.rules_compare"
path_app_help           = sys.path[0] + "/gnome/help/gufw/C/gufw.xml"

# Paths environment
home_app           = sys.path[0]
homedir            = os.environ["HOME"]
path_amule         = homedir + "/.aMule/amule.conf"
path_transmission1 = homedir + "/.config/transmission/settings.json"
path_transmission2 = homedir + "/.config/transmission/gtk/prefs.ini"
path_transmission3 = homedir + "/.transmission/gtk/prefs.ini"
path_nicotine      = homedir + "/.nicotine/config"
path_deluge1       = homedir + "/.config/deluge/prefs.state"
path_deluge2       = homedir + "/.config/deluge/core.conf"
path_zuve          = homedir + "/.azureus/azureus.config"

# System paths
path_system_root     = "/usr/share/"
path_locale2         = "/usr/share/locale-langpack"
path_ufw_status      = "/etc/ufw/ufw.conf"
path_ufw_config      = "/etc/default/ufw"
path_ufw_rules_ipv4  = "/var/lib/ufw/user.rules"
path_ufw_rules_ipv6  = "/var/lib/ufw/user6.rules"
file_autostart       = "/gufw.desktop"

path_autostart_gnome = homedir + "/.config/autostart"
path_autostart_kde   = homedir + "/.kde/Autostart"
path_gufw_autostart  = "/var/lib/gufw/cfg_files/gufw.desktop"





# ------------------------- COMMANDS --------------------------------
cmd_prefix      = "LANG=en "
cmd_allow       = cmd_prefix + "ufw allow "
cmd_deny        = cmd_prefix + "ufw deny "
cmd_limit       = cmd_prefix + "ufw limit "
cmd_status      = cmd_prefix + "ufw status verbose"
cmd_enable      = cmd_prefix + "ufw enable"
cmd_disable     = cmd_prefix + "ufw disable"
cmd_deny_all    = cmd_prefix + "ufw default deny all"
cmd_allow_all   = cmd_prefix + "ufw default allow all"
cmd_logging_on  = cmd_prefix + "ufw logging on"
cmd_logging_off = cmd_prefix + "ufw logging off"
c_vnc           = "vnc"
c_vnc_rule      = "5900/tcp"





# ------------------------- TRANSLATES --------------------------------
APP     = "gufw"
l_error = " "

try:
    l_file = open(path_locale_check, "r") 
except IOError:
    l_error = "X"

if l_error != "X":
    DIR = path_locale1
else:
    DIR = path_locale2

_ = gettext.gettext
gettext.bindtextdomain(APP, DIR)
gettext.textdomain(APP)
gtk.glade.bindtextdomain(APP, DIR)
gtk.glade.textdomain(APP)



# ---------------------- VARIABLES/CONSTANTS --------------------------
# Constants
c_version_app               = "0.20.7"
c_name_app                  = "gufw"
c_found                     = "X"
c_not_found                 = " "
c_enabled                   = 1
c_disabled                  = 0
c_error                     = 2
c_working                   = 5
c_not_working               = 6
c_finish_working            = 7
c_ok                        = 0

# Texts constants:
c_ufw_enabled_infile        = "ENABLED=yes"
c_deny_all_infile           = 'DEFAULT_INPUT_POLICY=\"DROP\"'
c_tuple                     = "### TUPLE ###"
c_allow                     = "Allow"
c_deny                      = "Deny"
c_limit                     = "Limit"
c_default                   = "Default:"
c_ipv6_infile               = "IPV6=yes"
c_not_ipv6_infile           = "IPV6=no"
c_none                      = "None"
c_on                        = "On"
c_off                       = "Off"
c_logging_on                = "Logging: On"
c_logging_off               = "Logging: Off"
c_minimize_no               = "minimize_close=no"
c_minimize_yes              = "minimize_close=yes"
c_gufw_log_yes              = "gufw_log=yes"
c_gufw_log_no               = "gufw_log=no"
c_show_tray_yes             = "show_tray=yes"
c_show_tray_no              = "show_tray=no"
c_gufw_header_import_export = "Gufw rules 0200\n"
c_any                       = "Any"
c_enabled_txt               = "Enabled"
c_disabled_txt              = "Disabled"
c_working_txt               = "Working"

c_anywhere                  = "Anywhere"
c_not_select_all            = "1"
c_select_all                = "2"
c_delete                    = "delete "
c_blank_ipv4                = "0.0.0.0/0"
c_blank_ipv6                = "::/0"
c_replace                   = "++++"

c_new_profiles               = "New profiles"


# Color & font constants:
c_color_working             = "#2954b5" #Blue
c_color_disabled            = "#b0b0b0" #Gray
c_color_deny                = "#28ab2b" #Green
c_color_allow               = "#e31818" #Red
c_color_limit               = "#e57f1b" #Orange
c_font_rules                = "monospace 10"
c_font_text                 = "FreeSans 24"

# Configuration constants:
c_amule                     = "amule"
c_transmission              = "transmission"
c_nicotine                  = "nicotine"
c_deluge                    = "deluge"
c_vuze                      = "vuze"
c_tcp                       = "tcp"
c_udp                       = "udp"



# Global Variables:
v_rules_model    = gtk.ListStore (gobject.TYPE_INT, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING) # Model rules
t_programs       = []               # Programs + Ports
tray_icon        = gtk.StatusIcon() # Icon tray
menu             = gtk.Menu()		# Menu Icon tray
v_coordx         = [" "]            # Position X Window
v_coordy         = [" "]            # Position Y window
t_handlers_block = []               # Handlers to block/unblock



