# GUI For ufw (Uncomplicated FireWall) - Version 0.20.7
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import commands
import os
import locale
import gettext
_ = gettext.gettext

from file_operations          import file_search_string,list_search_string
from variables_paths_messages import *





# Check status (Enable/Disable)		
def check_gufw_status():	
    if file_search_string(path_ufw_status, c_ufw_enabled_infile) == c_found:
    	return c_enabled
    else:
        return c_disabled
            
            

# Hide Tray icon?
def check_show_tray():
    if file_search_string(path_gufw_config, c_show_tray_yes) == c_found:
        return c_enabled
    else:
        return c_disabled


# Is status to deny all?
def check_deny_all():
    if file_search_string(path_ufw_config, c_deny_all_infile) == c_found:
        return c_enabled
    else:
        return c_disabled



# Check if logging is on/off/or not found (None)
def check_ufw_log():
    l_command = commands.getstatusoutput(cmd_status)
    
    if list_search_string(l_command,c_logging_off) == c_found:
    	return c_off
    elif list_search_string(l_command,c_logging_on) == c_found:
        return c_on
    else:
    	return c_none


# Check if configuration file is for minimize on close.
def check_minimize_on_close():
    if file_search_string(path_gufw_config, c_minimize_yes) == c_found:
    	return c_enabled
    else:
    	return c_disabled


# Check autostart with session.
def check_autostart():
    l_found = "X"
    
    # Exits folder?
    if os.path.exists(path_autostart_gnome) == False:
        if os.path.exists(path_autostart_kde) == False:
            return c_none
        else: l_path_autostart = path_autostart_kde + file_autostart
    else: l_path_autostart = path_autostart_gnome + file_autostart
    
    # Exits file?
    try:
        l_file = open(l_path_autostart, "r")
    except IOError:
        l_found = " "
            
    if l_found == "X":
        l_file.close()
        return c_enabled
    else:
        return c_disabled



# Activates gufw log?		
def check_gufw_log():
    if file_search_string(path_gufw_config, c_gufw_log_yes) == c_found:
        return c_enabled
    else:
        return c_disabled



# Check IPv6
def check_ipv6():
    if file_search_string(path_ufw_config, c_ipv6_infile) == c_found:
        return c_enabled
    else:
        return c_disabled



# Run as root?
def check_gufw_root():
    if os.geteuid() != 0:
        dlg = gtk.MessageDialog(None, buttons=gtk.BUTTONS_CLOSE, message_format=_(text_001))
        dlg.run()
        dlg.destroy()
        return False
    else:
        return True


# Exist ufw?
def check_ufw_exist():
    l_is_ufw = commands.getstatusoutput("which ufw")
    
    if l_is_ufw[0] == 0:
        return True
    else:
        dlg = gtk.MessageDialog(None, buttons=gtk.BUTTONS_CLOSE, message_format=_(text_002))
        dlg.run()
        dlg.destroy()
        return False
