# GUI For ufw (Uncomplicated FireWall) - Version 0.20.6
# Web: http://gufw.tuxfamily.org
# Licenced by GPL 3 or (at your option) any later version.
# Copyright (C) 2008 Marcos Alvarez Costales

# Gufw is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public Licence as published
# by the Free Software Foundation; either version 3 of the Licence,
# or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Imports
import sys
import string
import gtk
import locale
import gettext
_ = gettext.gettext

from events_gufw              import enable_disable, allow_deny_all, simple_add1, preconf_add1, advanced_add1, advanced_clear, remove_one, select_all
from events_menu              import import_rules, export_rules, edit_preferences, see_gufw_log, about, add_rules, help, show_hide_close_button
from file_operations          import file_to_list
from general_rutines          import change_preconf_type, click_from_ip, click_to_ip
from tray_icon                import show_hide_tray_close_button

from variables_paths_messages import *




# Connects
def link_connects(p_gufw):
    # General
    t_handlers_block.append(p_gufw.window.connect(         'delete_event',       show_hide_tray_close_button,p_gufw))
    t_handlers_block.append(p_gufw.quit_menu.connect(      'activate',           lambda w: gtk.main_quit()))
    # Menu
    t_handlers_block.append(p_gufw.import_menu.connect(    'activate',           import_rules,p_gufw))
    t_handlers_block.append(p_gufw.export_menu.connect(    'activate',           export_rules,p_gufw))
    t_handlers_block.append(p_gufw.edit_pref.connect(      'activate',           edit_preferences,p_gufw))
    t_handlers_block.append(p_gufw.gufw_log.connect(       'activate',           see_gufw_log,p_gufw))
    t_handlers_block.append(p_gufw.about_menu.connect(     'activate',           about,p_gufw))
    t_handlers_block.append(p_gufw.help_menu.connect(      'activate',           help))
    t_handlers_block.append(p_gufw.add_menu.connect(       'activate',           add_rules,p_gufw))
    # Main
    t_handlers_block.append(p_gufw.firewall.connect(       'clicked',            enable_disable,p_gufw))
    t_handlers_block.append(p_gufw.allow_all.connect(      'clicked',            allow_deny_all,p_gufw))
    # Simple
    t_handlers_block.append(p_gufw.simple_add1.connect(    'clicked',            simple_add1,p_gufw))
    # Preconfigured
    t_handlers_block.append(p_gufw.preconf_add1.connect(   'clicked',            preconf_add1,p_gufw))
    t_handlers_block.append(p_gufw.preconf_type.connect(   'changed',            change_preconf_type,p_gufw))
    # Advanced
    t_handlers_block.append(p_gufw.advanced_add1.connect(  'clicked',            advanced_add1,p_gufw))
    t_handlers_block.append(p_gufw.advanced_clear.connect( 'clicked',            advanced_clear,p_gufw))
    t_handlers_block.append(p_gufw.advanced_fromip.connect('button-press-event', click_from_ip,p_gufw))
    t_handlers_block.append(p_gufw.advanced_toip.connect(  'button-press-event', click_to_ip,p_gufw))
    # Remove one/all
    t_handlers_block.append(p_gufw.remove_one.connect(     'clicked',            remove_one,p_gufw))
    t_handlers_block.append(p_gufw.select_all.connect(     'clicked',            select_all,p_gufw))
    t_handlers_block.append(p_gufw.close_app.connect(      'clicked',            show_hide_close_button,p_gufw))



# Alias
def alias(p_gufw):
    # General
    p_gufw.window                  = p_gufw.get_widget("main")
    p_gufw.firewall                = p_gufw.get_widget("cb_firewall")
    p_gufw.shield_image            = p_gufw.get_widget("shield_image")
    p_gufw.label_status            = p_gufw.get_widget("label_status")
    # Menu
    p_gufw.help_menu               = p_gufw.get_widget("menu_help")
    p_gufw.about_menu              = p_gufw.get_widget("menu_about")
    p_gufw.edit_pref               = p_gufw.get_widget("menu_edit_pref")
    p_gufw.import_menu             = p_gufw.get_widget("menu_import")
    p_gufw.export_menu             = p_gufw.get_widget("menu_export")
    p_gufw.add_menu                = p_gufw.get_widget("menu_add")
    p_gufw.gufw_log                = p_gufw.get_widget("menu_gufw_log")
    p_gufw.quit_menu               = p_gufw.get_widget("menu_quit")
    # Main
    p_gufw.deny_all                = p_gufw.get_widget("rb_deny_all")
    p_gufw.allow_all               = p_gufw.get_widget("rb_allow_all")
    p_gufw.progress                = p_gufw.get_widget("progressbar")
    p_gufw.status                  = p_gufw.get_widget("sb_status")
    p_gufw.rules                   = p_gufw.get_widget("tv_rules")
    # Simple tab
    p_gufw.simple_action           = p_gufw.get_widget("cb_simple_action")
    p_gufw.simple_port             = p_gufw.get_widget("entry_simple_port")
    p_gufw.simple_proto            = p_gufw.get_widget("cb_simple_proto")
    p_gufw.simple_add1             = p_gufw.get_widget("btn_simple_add")
    # Preconfigured tab
    p_gufw.preconf_action          = p_gufw.get_widget("cb_preconf_action")
    p_gufw.preconf_type            = p_gufw.get_widget("cb_preconf_type")
    p_gufw.preconf_service         = p_gufw.get_widget("cb_preconf_service")
    p_gufw.preconf_add1            = p_gufw.get_widget("btn_preconf_add")
    p_gufw.preconf_program         = p_gufw.get_widget("cb_preconf_program")
    # Advanced tab
    p_gufw.advanced_action         = p_gufw.get_widget("cb_advanced_action")
    p_gufw.advanced_proto          = p_gufw.get_widget("cb_advanced_proto")
    p_gufw.advanced_fromip         = p_gufw.get_widget("entry_advanced_fromip")
    p_gufw.advanced_fromport       = p_gufw.get_widget("entry_advanced_fromport")
    p_gufw.advanced_fromport_range = p_gufw.get_widget("entry_advanced_fromport_range")
    p_gufw.advanced_toip           = p_gufw.get_widget("entry_advanced_toip")
    p_gufw.advanced_toport         = p_gufw.get_widget("entry_advanced_portto")
    p_gufw.advanced_toport_range   = p_gufw.get_widget("entry_advanced_portto_range")
    p_gufw.advanced_add1           = p_gufw.get_widget("btn_advanced_add")
    p_gufw.advanced_clear          = p_gufw.get_widget("btn_advanced_clear")
    # Delete one/all
    p_gufw.remove_one              = p_gufw.get_widget("btn_remove_one")
    p_gufw.select_all              = p_gufw.get_widget("btn_select_all")
    p_gufw.close_app               = p_gufw.get_widget("btn_close_app")
    p_gufw.flg_status              = p_gufw.get_widget("flg_status_app")

    

# Header Rules
def create_header_rules(p_gufw):
    
    # Mode
    p_gufw.rules.set_model(v_rules_model)
    p_gufw.rules.get_selection().set_mode(gtk.SELECTION_MULTIPLE)

    # Font
    l_render = gtk.CellRendererText()
    l_render.set_property("font", c_font_rules)

    # The format columns
    l_tree_header = gtk.TreeViewColumn (_(text_019), l_render, text=1, foreground=4)
    l_tree_header.set_resizable(True)
    p_gufw.rules.append_column (l_tree_header)
    l_tree_header = gtk.TreeViewColumn (_(text_020), l_render, text=2, foreground=4)
    l_tree_header.set_resizable(True)
    p_gufw.rules.append_column (l_tree_header)
    l_tree_header = gtk.TreeViewColumn (_(text_021), l_render, text=3, foreground=4)
    p_gufw.rules.append_column (l_tree_header)


# Set initial values of combo box.
def set_initial_values_combo_box(p_gufw):
    # Services + Programs    
    load_services(p_gufw)
    load_programs(p_gufw)

    # Protocols
    p_gufw.simple_proto.set_active(2)
    p_gufw.preconf_type.set_active(0)
    p_gufw.preconf_service.set_active(0)
    p_gufw.advanced_proto.set_active(2)

    # Allow/Deny/Limit action
    p_gufw.simple_action.set_active(0)
    p_gufw.preconf_action.set_active(0)
    p_gufw.advanced_action.set_active(0)
    
    
    


# ----------------------- LOAD SERVICES/PROGRAMS ----------------------
# Load services from file
def load_services(p_gufw):
    l_services = []
    if file_to_list(path_gufw_services,l_services) != c_error:
    
        for l_line in l_services:
            l_line = l_line.replace("\n","")
            p_gufw.preconf_service.append_text(l_line)
    


# Load programs from file
def load_programs(p_gufw):
    
    l_program = []
    
    if file_to_list(path_gufw_programs,l_program) != c_error:
    
        for l_line in l_program:

            l_line = l_line.replace("\n","")
            
            # Program?
            if   l_line == c_amule:
                program_amule(t_programs)
            elif l_line == c_transmission:
                program_transmission(t_programs)
            elif l_line == c_nicotine:
                program_nicotine(t_programs)
            elif l_line == c_deluge:
                program_deluge(t_programs)
            elif l_line == c_vuze:
                program_zuve(t_programs)
                               
    # Component drowbox programs
    l_program_old = " "
    l_one_append  = " "
    
    for program in t_programs:
        if l_one_append == " ":
            l_one_append = "X"
                
        if program[0] != l_program_old:
            p_gufw.preconf_program.append_text(program[0])
            l_program_old = program[0]			

# Not programs? Hide programs.
    if l_one_append == " ":
        p_gufw.preconf_type.hide()
    else:
        p_gufw.preconf_program.set_active(0)

        
        

# Append if amule exist to programs preconfigured.
def program_amule(p_programs):
    
    l_found = " "
    
    try:
        l_file = open(path_amule, "r") 
    except IOError:
        return

    # Search in config file
    while True:

        l_line = l_file.readline()
        if not l_line: break
        
        l_line = l_line.upper()                
        if ( l_line.find("PORT=") != -1 ) and ( l_found == " "):
            l_found = "X"
            l_line = l_line.replace("PORT=","")
            l_line = l_line.replace("\n","")
            p_programs.append([c_amule,l_line,c_tcp])
        elif l_line.find("UDPPORT=") != -1:
            l_line = l_line.replace("UDPPORT=","")
            l_line = l_line.replace("\n","")
            p_programs.append([c_amule,l_line,c_udp])            
            
    l_file.close()



# Append if transmission exist to programs preconfigured.
def program_transmission(p_programs):
    
    try:
        l_file = open(path_transmission1, "r") 
    except IOError:
        try:
            l_file = open(path_transmission2, "r")
        except IOError:
            try:
                l_file = open(path_transmission3, "r") 
            except IOError:
                return
    
    # Search in config file
    while True:

        l_line = l_file.readline()
        if not l_line: break
        
        l_line = l_line.upper()
        if l_line.find("LISTENING-PORT=") != -1:
            l_line = l_line.replace("LISTENING-PORT=","")
            l_line = l_line.replace("\n","")
            p_programs.append([c_transmission,l_line,c_tcp])   
        if l_line.find("PEER-PORT") != -1:
            l_line = l_line.strip()
            l_line = l_line.replace("\"PEER-PORT\": ","")
            l_line = l_line.replace(",","")
            p_programs.append([c_transmission,l_line,c_tcp])   
    
    l_file.close()

# Append if nicotine exist to programs preconfigured.
def program_nicotine(p_programs):
    
    l_num1  = 0
    l_num2  = 0
    
    try:
        l_file = open(path_nicotine, "r") 
    except IOError:
        return
    
    # Search in config file
    while True:

        l_line = l_file.readline()
        if not l_line: break
        
        l_line = l_line.upper()
        # Component first & second port
        if l_line.find("PORTRANGE = (") != -1:
            l_line    = l_line.replace("PORTRANGE = (","")
            l_line    = l_line.replace(")\n","")
            l_numbers = string.split(l_line,", ")

            try:
                l_num1 = int(l_numbers[0])
            except:
                l_num1 = 0
                
            try:
                l_num2 = int(l_numbers[1])
            except:
                l_num2 = 0
             
            # For port 1 to port 2, add rule
            if ( l_num1 != 0 ) and ( l_num2 != 0 ):
                if l_num1 > l_num2:
                    l_aux = l_num1
                    l_num1 = l_num2
                    l_num2 = l_aux
                    
                # Add ports        
                while l_num1 <= l_num2:
                    p_programs.append([c_nicotine,l_num1,c_tcp])
                    l_num1 += 1        
    
    l_file.close()

# Append if deluge exist to programs preconfigured.
def program_deluge(p_programs):
    
    l_found = " "
    l_num1  = 0
    l_num2  = 0
    
    try:
        l_file = open(path_deluge, "r") 
    except IOError:
        return
    
    # Search in config file
    while True:

        l_line = l_file.readline()
        if not l_line: break
        
        l_line = l_line.upper()
        # Found ports in the next lines file.
        if l_line.find("LISTEN_ON") != -1:
            l_found = "X"

        # Found port2 (port1 founded)
        if l_found == "X" and ( ( l_line.find("AF") != -1 ) or ( l_line.find("AI") != -1 ) ):
            l_found = " "
            l_line  = l_line.replace("AF","")
            l_line  = l_line.replace("AI","")
            l_line  = l_line.replace(".0\n","")
            
            if l_num1 != 0:

                try:
                    l_num2  = int(l_line)
                except:
                    l_num2 = 0
                
                if ( l_num1 != 0 ) and ( l_num2 != 0 ):
                    if l_num1 > l_num2:
                        l_aux = l_num1
                        l_num1 = l_num2
                        l_num2 = l_aux
                        
                # Add ports
                while l_num1 <= l_num2:
                    p_programs.append([c_deluge,l_num1,c_tcp])
                    l_num1 = l_num1 + 1       

        # Found port1
        elif l_found == "X" and ( ( l_line.find("F") != -1 ) or ( l_line.find("I") != -1 ) ):
            l_line = l_line.replace("F","")
            l_line = l_line.replace("I","")
            l_line = l_line.replace(".0\n","")
            try:
                l_num1 = int(l_line)
            except:
                l_num1 = 0

    
    l_file.close()

# Append if zuve exist to programs preconfigured.
def program_zuve(p_programs):
    
    try:
        l_file = open(path_zuve, "r") 
    except IOError:
        return
    
    # Search in config file
    while True:

        l_line = l_file.readline()
        if not l_line: break
        
        l_line = l_line.upper()
        # Found port (TCP = UDP)
        if l_line.find("TCP.LISTEN.PORT") != -1:
            l_line = l_line.split("TCP.LISTEN.PORTI")
            l_port = l_line[1].split("E")
            p_programs.append([c_vuze,l_port[0],c_tcp])
            p_programs.append([c_vuze,l_port[0],c_udp])
            
    l_file.close()
