#ifndef PARSER_H
#define PARSER_H

/*
 * Common facilities used by test data parsers
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
#include "Exception.h"
#include "Scans.h"
#include "nettypes.h"

class ParserException: public ContextException
{
protected:
	std::string _file;
	int _line;

public:
	ParserException(const std::string& file, int line, const std::string& message) throw ()
		: ContextException(message), _file(file), _line(line) {}
	ParserException(int line, const std::string& message) throw ()
		: ContextException(message), _line(line) {}
	ParserException(const std::string& message) throw ()
		: ContextException(message), _line(-1) {}
	~ParserException() throw () {}

	int line() const throw () { return _line; }
	int line(int line) throw () { return _line = line; }

	const std::string& file() const throw () { return _file; }
	std::string file() throw () { return _file; }
	std::string file(const std::string file) throw () { return _file = file; }

	virtual const char* type() const throw ()
	{
		return "ParserException";
	}

	virtual std::string desc() const throw ();
};


// vim:set ts=4 sw=4:
#endif
