using System;
using System.Net;
using System.IO;
using System.Text;
using System.Xml;

namespace gtwitter
{
	
	
	public class GetTwitterData
	{
		
		public GetTwitterData()
		{
		}
		
		public bool GetTwitterFriendsData(string TwitterFriendsUrl, string TwitterName, string TwitterPass, string configDir)
		{
			try {
				//HTTP BasicAuth
				HttpWebRequest request = (HttpWebRequest)WebRequest.Create(TwitterFriendsUrl);
			    /* setup authentication */
			    request.PreAuthenticate = true;
			    NetworkCredential creds = new NetworkCredential(TwitterName, TwitterPass, null);
			    request.Credentials = creds;
			    /* setup request paras */
			   	request.ProtocolVersion = HttpVersion.Version10;
			   	request.PreAuthenticate = true;
			   	request.Method = "POST";
			   	request.ContentType = "text/xml";
			   	request.AllowWriteStreamBuffering = true;
			   	/* send response */
			   	Stream stream = request.GetRequestStream();
			   	XmlTextWriter xWriter = new XmlTextWriter(stream, Encoding.ASCII);
			   	xWriter.WriteStartDocument(true);
				xWriter.Flush();
				xWriter.Close();
				/* receive response and parse */
				HttpWebResponse response = (HttpWebResponse)request.GetResponse();
				Stream responseStream = response.GetResponseStream();
				StreamReader input = new StreamReader(responseStream, Encoding.UTF8);

				string temp = input.ReadToEnd();
				
				//save XML
				using (TextWriter textwrite = File.CreateText(configDir + "friendsXML")) {
			
					textwrite.WriteLine(temp);
				}
				
				input.Close();
				response.Close();
				
				return true;
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Get data exception: GetTwitterData.cs - GetTwitterFriendsData()");
					Console.WriteLine(ex.StackTrace);
				}
				
				return false;
			}
		}
		
		public bool GetTwitterDirectData(string TwitterDirectUrl, string TwitterName, string TwitterPass, string configDir)
		{
			try {
				//HTTP BasicAuth
				HttpWebRequest request = (HttpWebRequest)WebRequest.Create(TwitterDirectUrl);
			    /* setup authentication */
			    request.PreAuthenticate = true;
			    NetworkCredential creds = new NetworkCredential(TwitterName, TwitterPass, null);
			    request.Credentials = creds;
			    /* setup request paras */
			   	request.ProtocolVersion = HttpVersion.Version10;
			   	request.PreAuthenticate = true;
			   	request.Method = "POST";
			   	request.ContentType = "text/xml";
			   	request.AllowWriteStreamBuffering = true;
			   	/* send response */
			   	Stream stream = request.GetRequestStream();
			   	XmlTextWriter xWriter = new XmlTextWriter(stream, Encoding.ASCII);
			   	xWriter.WriteStartDocument(true);
				xWriter.Flush();
				xWriter.Close();
				/* receive response and parse */
				HttpWebResponse response = (HttpWebResponse)request.GetResponse();
				Stream responseStream = response.GetResponseStream();
				StreamReader input = new StreamReader(responseStream, Encoding.UTF8);

				string temp = input.ReadToEnd();
				
				//save XML
				using (TextWriter textwrite = File.CreateText(configDir + "directXML")) {
			
					textwrite.WriteLine(temp);
				}
				
				input.Close();
				response.Close();
				
				return true;
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Get data exception: GetTwitterData.cs - GetTwitterDirectData()");
					Console.WriteLine(ex.StackTrace);
				}
				
				return false;
			}
		}
		
		public bool GetTwitterPublicData(string TwitterPublicUrl, string configDir)
		{
			try {
				//HTTP
				HttpWebRequest request = (HttpWebRequest)WebRequest.Create(TwitterPublicUrl);
			    /* setup request paras */
			   	request.ProtocolVersion = HttpVersion.Version10;
			   	//request.PreAuthenticate = true;
			   	request.Method = "POST";
			   	request.ContentType = "text/xml";
			   	request.AllowWriteStreamBuffering = true;
			   	/* send response */
			   	Stream stream = request.GetRequestStream();
			   	XmlTextWriter xWriter = new XmlTextWriter(stream, Encoding.ASCII);
			   	xWriter.WriteStartDocument(true);
				xWriter.Flush();
				xWriter.Close();
				/* receive response and parse */
				HttpWebResponse response = (HttpWebResponse)request.GetResponse();
				Stream responseStream = response.GetResponseStream();
				StreamReader input = new StreamReader(responseStream, Encoding.UTF8);
				
				//save XML
				using (TextWriter textwrite = File.CreateText(configDir + "publicXML")) {
			
					textwrite.Write(input.ReadToEnd());
				}
				
				response.Close ();
				input.Close();
				
				return true;
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Get data exception: GetTwitterData.cs - GetTwitterFriendsData()");
					Console.WriteLine(ex.StackTrace);
				}
				
				return false;
			}
		}
		
		public Gdk.Pixbuf GetUserImage(string imageUrl)
		{
			Gdk.Pixbuf pix1;
			
			try {

				/* read image */
				HttpWebRequest req = (HttpWebRequest) WebRequest.Create (imageUrl);
				req.KeepAlive = false;
				req.Timeout = 10000;	
				WebResponse resp = null;
				resp = req.GetResponse ();
				Stream s = resp.GetResponseStream ();
				pix1 = new Gdk.Pixbuf (s);
				resp.Close ();
				
				return pix1;
			}
			catch (Exception ex) {
				if (MainClass.debug) {
					Console.WriteLine("Get user image exception: GetTwitterData.cs - GetUserImage()");
					Console.WriteLine(ex.StackTrace);
				}
				return null;
			}
		}
	}
}

//ghaefb