/* Time-stamp: <2003-10-04 15:04:08 jcs>
|
|  Copyright (C) 2002-2003 Jorg Schuler <jcsjcs at users.sourceforge.net>
|  Part of the gtkpod project.
| 
|  URL: http://gtkpod.sourceforge.net/
| 
|  This program is free software; you can redistribute it and/or modify
|  it under the terms of the GNU General Public License as published by
|  the Free Software Foundation; either version 2 of the License, or
|  (at your option) any later version.
| 
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  You should have received a copy of the GNU General Public License
|  along with this program; if not, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
| 
|  iTunes and iPod are trademarks of Apple
| 
|  This product is not supported/written/published by Apple!
|
|  $Id: display_private.h,v 1.10 2004/01/17 09:37:48 jcsjcs Exp $
*/

#ifndef __DISPLAY_PRIVATE_H__
#define __DISPLAY_PRIVATE_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "display.h"

/* print some timing info for tuning purposes */
#define DEBUG_TIMING 0
/* print info when callbacks are initialized */
#define DEBUG_CB_INIT 0
/* print info when adding tracks */
#define DEBUG_ADD_TRACK 0

/* used for stopping of display refresh */
typedef void (*br_callback)(gpointer user_data1, gpointer user_data2);
void block_selection (gint inst);
void release_selection (gint inst);
void add_selection_callback (gint inst, br_callback brc, gpointer user_data1, gpointer user_data2);
gboolean selection_callback_timeout (gpointer data);
extern gint stop_add;

/* used for display organization */
void pm_create_treeview (void);
void pm_set_selected_playlist(Playlist *pl);
void pm_remove_all_playlists (gboolean clear_sort);
void tm_create_treeview (void);
void tm_track_changed (Track *track);
void tm_remove_track (Track *track);
void tm_remove_all_tracks (gboolean clear_sort);
void st_remove_all_entries_from_model (guint32 inst);
void st_track_changed (Track *track, gboolean removed, guint32 inst);
void st_add_track (Track *track, gboolean final, gboolean display, guint32 inst);
void st_create_tabs (void);
void st_remove_track (Track *track, guint32 inst);
void st_init (ST_CAT_item new_category, guint32 inst);
void st_create_notebook (gint inst);
void st_redisplay (guint32 inst);
void st_cleanup (void);
void st_set_default_sizes (void);
void st_update_default_sizes (void);
void st_adopt_order_in_playlist (void);
void tm_update_default_sizes (void);
void st_show_hide_tooltips (void);
GList *st_get_selected_members (guint32 inst);


/* Drag and drop definitions */
#define TGNR(a) (guint)(sizeof(a)/sizeof(GtkTargetEntry))
#define DND_GTKPOD_IDLIST_TYPE "application/gtkpod-idlist"
#define DND_GTKPOD_TM_PATHLIST_TYPE "application/gtkpod-tm_pathlist"
#define DND_GTKPOD_PM_PATHLIST_TYPE "application/gtkpod-pm_pathlist"
struct asf_data
{
    GtkTreeIter *to_iter;
    GtkTreeViewDropPosition pos;
};

typedef enum
{
    TRACK_TREEVIEW,
    PLAYLIST_TREEVIEW,
    SORTTAB_TREEVIEW
} TreeViewType;

void  tm_list_store_move_before (GtkListStore *store,
				 GtkTreeIter  *iter,
				 GtkTreeIter  *position);
void  tm_list_store_move_after (GtkListStore *store,
				GtkTreeIter  *iter,
				GtkTreeIter  *position);
void  pm_list_store_move_before (GtkListStore *store,
				 GtkTreeIter  *iter,
				 GtkTreeIter  *position);
void  pm_list_store_move_after (GtkListStore *store,
				GtkTreeIter  *iter,
				GtkTreeIter  *position);
gboolean pmtm_move_pathlist (GtkTreeView *treeview,
			     gchar *data,
			     GtkTreePath *path,
			     GtkTreeViewDropPosition pos,
			     TreeViewType tvt);

#endif /* __DISPLAY_PRIVATE_H__ */
