#ifndef INCLUDE_SESSION_H
#define INCLUDE_SESSION_H
/* ----------------------------------------------------------------------------
 * pbbuttons_gtk.c
 * Daemon to put the Apple Powerbook special keys into action.
 * This version has an GTK interface and needs X.
 * 
 * session.h
 * Definitions and prototypes for session.c
 *
 * Copyright 2004 Sven Herzberg (herzi@gnome-de.org).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef ENABLE_GNOME
#include <glib.h>
#include <libgnomeui/libgnomeui.h>

typedef struct {
	int	* argc;
	char	***argv;
} GtkPbArgv;

/* prototypes */
void session_init (int argc, char *argv[]);
void session_die (GnomeClient *client, gpointer user_data);
gboolean session_save (GnomeClient *client, int phase, GnomeSaveStyle save_style, int end, GnomeInteractStyle interact_style, int fast, gpointer user_data);

#endif /* ENABLE_GNOME */
#endif /* INCLUDE_SESSION_H */
