#ifndef INCLUDE_GTKPBINIT_H
#define INCLUDE_GTKPBINIT_H
/* ----------------------------------------------------------------------------
 * gtkpbinit.h
 * prototypes and definitions for gtkpbinit.c.
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <signal.h>
#include <gtk/gtk.h>
#include "audio.h"
#include "themes.h"

/* short options for optarg */
#define ARG_ALL			"hvd::a:t:"
#define ARG_HELP		'h'		/* no arg */
#define ARG_VERSION		'v'		/* no arg */
#define ARG_DETACH		'd'		/* no arg */
#define ARG_AUDIODEV	'a'		/* arg = audio device */
#define ARG_THEME		't'		/* arg = themename */

#define DEFAULT_PIDFILE "/var/run/" PACKAGE ".pid"
#define DEFAULT_THEME "Classic"

struct init {
	char *themename;		/* name of theme to use */
	struct theme *themedata;
	GtkWidget *window;
	struct dspdata dsp;		/* data for sound player */
	int timeout;			/* timeout value for closing popup windows */
};

/* prototypes */
int prg_init(struct init *md);
void signalhandler (int signum);
int install_sighandler();
int evaluate_args(struct init *md, int argc, char *argv[]);
void init_init(struct init *md);
int check_path (char *source, int type);

#endif    /* INCLUDE_GTKPBINIT_H */
