/* ----------------------------------------------------------------------------
 * pbbuttons_gtk.c
 * Daemon to put the Apple Powerbook special keys into action.
 * This version has an GTK interface and needs X.
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <gtk/gtk.h>

#include <pbb.h>

#ifdef ENABLE_NLS
#  include <locale.h>
#endif

#include "gtkinterface.h"
#include "gettext_macros.h"

volatile int prgexit = 0;

int main(int argc, char *argv[])
{
	struct init masterdata, *md = &masterdata;
	int rc = 1;

#ifdef ENABLE_NLS
	setlocale(LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
#endif

	init_init(md);
	init_libpbb ();
	if((rc = evaluate_args(md, argc, argv)) == 0) {		/* evaluate command line */
		if ((create_daemon ()) == 0) {
#ifdef ENABLE_NLS
			bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
			gtk_set_locale ();
			gtk_init (&argc, &argv);
			if ((rc = prg_init(md)) == 0)
				if (! install_sighandler()) {
					gtk_timeout_add(POLLTIME, timeout_callback, md);
					gtk_main();
					rc = 0;
				}
			ipc_exit();   /* clean up IPC subsystem for clients */
#ifdef HAVE_SOUND
			cleanup_audio(&md->dsp);  /* does validity check inside */
#endif
			theme_exit(md->themedata);
		}
	}
	exit_libpbb();            /* cleanup library */
	if (rc == E_INFO) rc = 0;         /* E_INFO isn't a real error */
	exit (rc);
}

/* debug function in libpbb.a, if compiled with --enable-debug */
void peep_ipc (struct tagitem *taglist) { }
