/* ----------------------------------------------------------------------------
 * gtkinterface.c
 * code for GTK interface.
 *
 * Copyright 2002 Matthias Grimm (joker@cymes.de).
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <linux/input.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <pbb.h>

#include "gtkpbinit.h"
#include "gtkinterface.h"
#include "audio.h"
#include "gettext_macros.h"

#define TAG_TIMEREMAINING2  MOD_LAPTOP | 4

extern volatile int prgexit;

gint timeout_callback(gpointer data)
{
	struct init *md = (struct init *) data;
	char *msgbuffer[100];
	struct tagitem *taglist;
	int popup;
	long arg = 0;

	struct pbbmessage *msg = (struct pbbmessage *) msgbuffer;

	if (prgexit == 1) {
		gtk_main_quit();
		return FALSE;		/* fini */
	}

	if ((ipc_receive (msgbuffer, sizeof(msgbuffer))) == 0) {
		switch (msg->action) {
		case REGFAILED:
			print_error (_("ERROR: Can't register client at server.\n"));
			gtk_main_quit();
			break;
		case CLIENTEXIT:
			gtk_main_quit();
			break;
		case CHANGEVALUE:
		case WARNING:
			if ((taglist = find_tagitem(msg->taglist, TAG_LCDBRIGHTNESS))) {
				popup = POPUP_BRIGHTNESS;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_VOLUME))) {
				popup = taglist->data != -1 ? POPUP_VOLUME : POPUP_NOAUDIO;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_MUTE))) {
				popup = taglist->data != -1 ? POPUP_MUTE : POPUP_NOAUDIO;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_TPMODE))) {
				popup = POPUP_MOUSE;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_CURRENTBWL))) {
				if (taglist->data == 0)
					break;              /* ignore warnlevel 0 */
				popup = POPUP_BATTERY;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_SLEEPINSECONDS))) {
				popup = POPUP_SLEEP;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_KBDBRIGHTNESS))) {
				popup = POPUP_KBDILLU;
			} else if ((taglist = find_tagitem(msg->taglist, TAG_EJECTCD))) {
				popup = POPUP_CDROM;
			} else
				break;  /* catch unknown warnings */

			if (md->themedata->popup_active[popup]) { /* is popup active? */
				if (taglist->tag == (TAG_CURRENTBWL))
					if ((arg = tagfind (msg->taglist, TAG_TIMEREMAINING, -1)) == -1)
						arg = tagfind (msg->taglist, TAG_TIMEREMAINING2, -1);
				md->themedata->layout_update(md->themedata, md->window, popup, taglist->data, arg);

#ifdef HAVE_SOUND
				if (popup == POPUP_BATTERY)
					trigger_beep(&md->dsp, md->themedata->warnsound);
				if (popup == POPUP_VOLUME)
					trigger_beep(&md->dsp, md->themedata->volsound);
#endif
				if (!GTK_WIDGET_VISIBLE(GTK_WIDGET(md->window)) && GTK_WIDGET_REALIZED(GTK_WIDGET(md->window)))
					popup_update_background (md->window, md->themedata);

				gtk_widget_show_all (md->window); /* show window and all widgets */
				md->timeout = POPTO(md->themedata->popup_time[popup]); /* timer reset */
			}
			break;
		}
	}

	if (GTK_WIDGET_VISIBLE(GTK_WIDGET(md->window))) {
		if (md->timeout) {
			md->timeout--;
		} else {
			gtk_widget_hide(md->window);
		}
	}
	return TRUE;    /* keep timeout always running */
}

GtkWidget*
popup_create_window (struct theme *td)
{
	GtkWidget	*window;
	int			err;

	if ((window = gtk_window_new (GTK_WINDOW_POPUP))) {
		gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
		gtk_window_set_decorated (GTK_WINDOW (window), FALSE);
		gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
		gtk_widget_set_app_paintable(GTK_WIDGET(window), TRUE);
		g_signal_connect_after((gpointer) window, "realize",
			G_CALLBACK(popup_update_background), td);

		if ((err = td->layout_attach (td, window)) != 0) {
			gtk_widget_destroy (window);
			return NULL;
		}
	}
	return window;
}

void
popup_update_background (GtkWidget *window, struct theme *td)
{
	GdkPixbuf *bgpixbuf, *tmp_pixbuf;
	GdkPixmap *pixmap;
	GdkBitmap *bgmask;
	gint WinPosX, WinPosY, WinWidth, WinHeight;

	if (td->bgimage) {
		if ((bgpixbuf = gtk_image_get_pixbuf (GTK_IMAGE(td->bgimage)))) {
			WinWidth = gdk_pixbuf_get_width (bgpixbuf);
			WinHeight = gdk_pixbuf_get_height (bgpixbuf);
			gtk_window_set_default_size(GTK_WINDOW(window), WinWidth, WinHeight);
			gtk_window_get_position(GTK_WINDOW(window), &WinPosX, &WinPosY);
			gtk_widget_set_size_request(GTK_WIDGET(window), WinWidth, WinHeight);
			tmp_pixbuf = gdk_pixbuf_get_from_drawable(NULL,
				gdk_get_default_root_window(), gdk_colormap_get_system(),
				WinPosX, WinPosY, 0, 0, WinWidth, WinHeight);

			/* combine the transparent background image with the
		 	 * root window background image tmp_pixbuf = combined pixmap
			 */
			gdk_pixbuf_composite(bgpixbuf, tmp_pixbuf, 0, 0, WinWidth,
				WinHeight, 0, 0, 1, 1, GDK_INTERP_NEAREST, td->bgalpha);

			/* render the combined pixbuf to a pixmap with alpha control */
			pixmap = gdk_pixmap_new(GTK_WIDGET(window)->window, WinWidth, WinHeight, -1);
 			gdk_draw_pixbuf (pixmap, NULL, tmp_pixbuf, 0, 0, 0, 0,
				WinWidth, WinHeight, GDK_RGB_DITHER_NONE, 0, 0);
			g_object_unref(tmp_pixbuf);

			/* set the pixmap as new window background */
			gdk_window_set_back_pixmap(GTK_WIDGET(window)->window, pixmap, FALSE);
			g_object_unref(pixmap);

			/* set mask for window */
			gdk_pixbuf_render_pixmap_and_mask (bgpixbuf, NULL, &bgmask, 100);
			gdk_window_shape_combine_mask(GTK_WIDGET(window)->window,
		    	bgmask, 0, 0);
			g_object_unref(bgmask);
		} else {
			g_object_unref(td->bgimage);
			td->bgimage = NULL;
		}
	}
}
