#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

#include <dirent.h>

#include <gtk/gtk.h>
#include <cups/cups.h>
#include <cups/http.h>
#include <cups/language.h>
#include <X11/Xlib.h>

#include <gettext.h>
#include <defaults.h>

#include "libgtklp.h"

#include "info.xpm"
#include "error.xpm"
#include "myfault.xpm"
#include "warn.xpm"

#define GTKLPACCEPTDIR "accept"
#define GTKLPDENYDIR "deny"

int DEBUG;
int nox;

int PrinterChoice;
int PrinterNum;
int lastPrinterChoice;
int passActive=0;
char passWord[MAX_PASSLEN+1];
char ServerName[MAX_SERVER_NAME+1];
unsigned char DEF_PRN[DEF_PRN_LEN+1];
unsigned char PrinterBannerStart[MAX_PRT][MAXLINE+1];
unsigned char PrinterBannerEnd[MAX_PRT][MAXLINE+1];
unsigned char PrinterInfos[MAX_PRT][MAXLINE+1];
unsigned char PrinterLocations[MAX_PRT][MAXLINE+1];
unsigned char PrinterNames[MAX_PRT][DEF_PRN_LEN+1];

GtkWidget *mainWindow;
GtkWidget *passEntry;
GtkWidget *loginEntry;

cups_lang_t *cupsLanguage;
http_t *cupsHttp;

int maxPassTry=0;

extern int hasAskedPWD;
extern GtkWidget *dialog;

char UserName[MAX_USERNAME+1];

void quick_message(gchar *message, int which) 
{
  GtkWidget *label, *okay_button, *pixmapwid, *vbox, *hbox;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;

	if(nox == 1) {
		printf("%s\n",message);
		return;
	}
        while (gtk_events_pending())
                gtk_main_iteration();

        dialog = gtk_dialog_new();
        gtk_window_set_modal(GTK_WINDOW(dialog),TRUE);
        gtk_window_set_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);
	gtk_window_activate_default(GTK_WINDOW(dialog));

	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(mainWindow));

	okay_button = gtk_button_new_with_label(_("Ok"));
  gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",GTK_SIGNAL_FUNC (gtk_widget_destroy), (gpointer)dialog);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area), okay_button);

	vbox=gtk_vbox_new(FALSE,0);
	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, MESSAGE_SPACING_V);

	switch(which)
	{
		case 1:		/*--- Info ---*/
			gtk_window_set_title(GTK_WINDOW(dialog),_("Message"));
			style = gtk_widget_get_style(dialog);
			pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_info );
			pixmapwid = gtk_pixmap_new( pixmap, mask );
			gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
		break;
		case 2:		/*--- Error ---*/
			gtk_window_set_title(GTK_WINDOW(dialog),_("Error"));
                        style = gtk_widget_get_style(dialog);
                        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_error );
                        pixmapwid = gtk_pixmap_new( pixmap, mask );
                        gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
		break;
                case 3:         /*--- MyFault ---*/
                        gtk_window_set_title(GTK_WINDOW(dialog),_("Fehlerteufel"));
                        style = gtk_widget_get_style(dialog);
                        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_myfault );
                        pixmapwid = gtk_pixmap_new( pixmap, mask );
                        gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
                break;
                case 4:         /*--- Warning ---*/
                        gtk_window_set_title(GTK_WINDOW(dialog),_("Warning!"));
                        style = gtk_widget_get_style(dialog);
                        pixmap = gdk_pixmap_create_from_xpm_d(mainWindow->window,  &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)pixmap_warn );
                        pixmapwid = gtk_pixmap_new( pixmap, mask );
                        gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, MESSAGE_SPACING_H);
                break;
		default:
			if(DEBUG)
				printf("Unknown Quick-message !\n");
			emergency();
		break;
	}

        label = gtk_label_new (message);
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, MESSAGE_SPACING_H);

        gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), vbox);
        gtk_widget_show_all (dialog);
}

void getPrinters(int loop)
{
  int i1;
	cups_dest_t *dests;
	ipp_t *request,*response;
	ipp_attribute_t *attr;
	char URI[MAX_URI+1];
	char tmpprn[DEF_PRN_LEN+1];
	unsigned droppedPrinters;
	char TMPPATH[MAXPATH+1];
	DIR *testdir;
	DIR *testdir2;
	DIR *testdir3;
	FILE *testfile;
	FILE *testfile2;
	FILE *testfile3;
	unsigned char ShowAllPrinter;

	droppedPrinters=0;
	ShowAllPrinter=TRUE;

	PrinterChoice=-1;
	lastPrinterChoice=-1;

	PrinterNum=cupsGetDests(&dests);
	if(PrinterNum > MAX_PRT)
	{
		if(DEBUG)
			printf("PROG-ERROR: Too many printers: %u !\n",PrinterNum);
		g_error(_("You have installed too many printers or templates !"));
		exit(-3);
		//emergency();
	}
	PrinterNum--;
	if(DEBUG)
        	printf("Number of Printers: %i\n",PrinterNum+1);

snprintf(TMPPATH,(size_t)MAXPATH,"%s/%s/",DEF_GTKLPRC,GTKLPDENYDIR);
testdir=opendir(TMPPATH);
//printf("Search:%s\n",TMPPATH);
if (testdir != (DIR *)NULL) {
  ShowAllPrinter=FALSE;
  closedir(testdir); }
snprintf(TMPPATH,(size_t)MAXPATH,"%s/%s/%s/",getenv("HOME"),GTKLPRC_USER,GTKLPACCEPTDIR);
testdir2=opendir(TMPPATH);
//printf("Search:%s\n",TMPPATH);
if (testdir2 != (DIR *)NULL) {
  ShowAllPrinter=FALSE;
  closedir(testdir2); }
snprintf(TMPPATH,(size_t)MAXPATH,"%s/%s/",DEF_GTKLPRC,GTKLPACCEPTDIR);
testdir3=opendir(TMPPATH);
//printf("Search:%s\n",TMPPATH);
if (testdir3 != (DIR *)NULL) {
  ShowAllPrinter=FALSE;
  closedir(testdir3); }
	for(i1=0;i1<=PrinterNum;i1++)
        {
					//printf("Num: %i\n",i1);
		if(DEBUG) {
			if(dests[i1].instance == (char *)NULL)
    		printf("Name: %s - (NULL) (%i)\n",dests[i1].name,dests[i1].is_default);
			else
				printf("Name: %s - %s (%i)\n",dests[i1].name,dests[i1].instance,dests[i1].is_default);
		}
		if(dests[i1].instance == (char *)NULL)
			snprintf(PrinterNames[i1-droppedPrinters],(size_t)DEF_PRN_LEN,"%s",dests[i1].name);
		else
			snprintf(PrinterNames[i1-droppedPrinters],(size_t)DEF_PRN_LEN,"%s/%s",dests[i1].name,dests[i1].instance);

			
snprintf(TMPPATH,(size_t)MAXPATH,"%s/%s/%s",DEF_GTKLPRC,GTKLPDENYDIR,PrinterNames[i1-droppedPrinters]);
//printf("Search:%s\n",TMPPATH);
testfile3=fopen(TMPPATH,"r");
snprintf(TMPPATH,(size_t)MAXPATH,"%s/%s/%s/%s",getenv("HOME"),GTKLPRC_USER,GTKLPACCEPTDIR,PrinterNames[i1-droppedPrinters]);
//printf("Search:%s\n",TMPPATH);
testfile2=fopen(TMPPATH,"r");
snprintf(TMPPATH,(size_t)MAXPATH,"%s/%s/%s",DEF_GTKLPRC,GTKLPACCEPTDIR,PrinterNames[i1-droppedPrinters]);
//printf("Search:%s\n",TMPPATH);
testfile=fopen(TMPPATH,"r");
if((((!ShowAllPrinter) && ((testfile == (FILE *)NULL) && (testfile2 == (FILE *)NULL))) || (testfile3 != (FILE *)NULL) )) {
	droppedPrinters++;
	if(testfile != (FILE *) NULL) fclose(testfile);
	if(testfile2 != (FILE *) NULL) fclose(testfile2);
	if(testfile3 != (FILE *) NULL) fclose(testfile3);
} else {
	if(testfile != (FILE *) NULL) fclose(testfile);
	if(testfile2 != (FILE *) NULL) fclose(testfile2);
	if(testfile3 != (FILE *) NULL) fclose(testfile3);
			
//printf("Found:%s\n",TMPPATH);


		if((dests[i1].is_default == 1) & (DEF_PRN[0] == (unsigned char)NULL))
		{
			if(DEBUG)
				printf("---->Default-Printer\n");
			if(dests[i1].instance == (unsigned char)NULL) { 
				strncpy(DEF_PRN,dests[i1].name,(size_t)DEF_PRN_LEN);
			}
			else {
				snprintf(DEF_PRN,(size_t)DEF_PRN_LEN,"%s/%s",dests[i1].name,dests[i1].instance);
			}		
		}
		if(DEF_PRN[0] != (unsigned char)NULL)
		{
			if(dests[i1].instance != NULL)
				snprintf(tmpprn,(size_t)DEF_PRN_LEN,"%s/%s",dests[i1].name,dests[i1].instance);
			else
				snprintf(tmpprn,(size_t)DEF_PRN_LEN,"%s",dests[i1].name);
			if(strcmp(DEF_PRN,tmpprn) == 0)
				PrinterChoice=i1-droppedPrinters;
		}
		snprintf(URI,(size_t)MAX_URI,"ipp://%s/printers/%s",ServerName,dests[i1].name);
		request=ippNew();
		request->request.op.operation_id=IPP_GET_PRINTER_ATTRIBUTES;
		request->request.op.request_id=1;
		ippAddString(request,IPP_TAG_OPERATION,IPP_TAG_CHARSET,"attributes-charset",NULL,cupsLangEncoding(cupsLanguage));
		ippAddString(request,IPP_TAG_OPERATION,IPP_TAG_LANGUAGE,"attributes-natural-language",NULL,cupsLanguage->language);
		ippAddString(request,IPP_TAG_OPERATION,IPP_TAG_URI,"printer-uri",NULL,URI);
		if((response=cupsDoRequest(cupsHttp,request,"/")) == NULL)
		{
			if(DEBUG)
				printf("PROG-ERROR: unable for doing cupsDoRequest !\n");
			emergency();
		}
		if((attr=ippFindAttribute(response,"job-sheets-default",IPP_TAG_ZERO)) != NULL)
		{
			if(DEBUG)
				printf("Job-Sheets-Default for %s\n  Start: %s\n  Stop: %s\n",dests[i1].name,attr->values[0].string.text,attr->values[1].string.text);
			strncpy(PrinterBannerStart[i1-droppedPrinters],attr->values[0].string.text,(size_t)MAXLINE);
			strncpy(PrinterBannerEnd[i1-droppedPrinters],attr->values[1].string.text,(size_t)MAXLINE);
		}
		else
		{
			if(DEBUG)
				printf("No Default Banners found for %s\n",dests[i1].name);
			strncpy(PrinterBannerStart[i1-droppedPrinters],"none",(size_t)MAXLINE);
			strncpy(PrinterBannerEnd[i1-droppedPrinters],"none",(size_t)MAXLINE);
		}
		if((attr=ippFindAttribute(response,"printer-location",IPP_TAG_ZERO)) != NULL)
		{
			if(DEBUG)
				printf("Location: %s\n",attr->values[0].string.text);
			strncpy(PrinterLocations[i1-droppedPrinters],attr->values[0].string.text,(size_t)MAXLINE);
		}
		else
		{
			if(DEBUG)
				printf("Location not found !\n");
		}
		if((attr=ippFindAttribute(response,"printer-info",IPP_TAG_ZERO)) != NULL)
		{
			if(DEBUG)
				printf("Info: %s\n",attr->values[0].string.text);	
			strncpy(PrinterInfos[i1-droppedPrinters],attr->values[0].string.text,(size_t)MAXLINE);
		}
		else
		{
			if(DEBUG)
				printf("Info not found !\n");
		}
		ippDelete(response);
        }

}

	if(PrinterNum < 0)
	{
		if(DEBUG)
			printf("PROG-ERROR: No Printers found !\n");
		g_error(_("No printers found !"));
		exit(-2);
		//emergency();
	}
	if(DEF_PRN[0]==(unsigned char)NULL)
	{
		if(DEBUG)
			printf("No Default Printer yet, using %s\n",PrinterNames[0]);
		strncpy(DEF_PRN,PrinterNames[0],(size_t)DEF_PRN_LEN);
		PrinterChoice=0;
	}
	if(PrinterChoice==-1)
	{
		if(loop==1)		/* Called this function recursively */
		{
			gtklp_fatal_end(_("The given printer does not exist!"));
		}
		quick_message(_("The given printer does not exist!"),2);
		DEF_PRN[0]=(unsigned char)NULL;
		getPrinters(loop+1);
	}

PrinterNum-=droppedPrinters;
}

void gtklp_fatal_end(char *text)
{
	cupsLangFree(cupsLanguage);
	httpClose(cupsHttp);
	printf("\n%s\n\n",text);
	exit(-3);
}

void emergency(void)
{
	g_print("===========================\n");
	g_print("An Programm-Error occured !\n");
	g_print("===========================\n");
	g_print("Try it again, if the problem persists,\n");
	g_print("please ask your Administrator, or if this is you, try DEBUG-Mode !\n");
	g_print("If you have can`t find whats wrong, mail me at\n");
	g_print(MY_MAIL);
	g_print("\nor visit my Homepage:\n");
	g_print(MY_HOME);
	g_print("\n\nHave a nice day, exiting...\n");
	g_error(_("Internal program error !"));
	exit(-3);
}
	
void passDestroy(void)
{
	passActive=0;
}

void passNO(GtkWidget *dialog)
{
	gtk_entry_set_text(GTK_ENTRY(passEntry),"");
	gtk_widget_destroy(dialog);
}

void passChanged (GtkEditable *editable, gpointer data)
{
		strncpy(passWord,(char *)gtk_entry_get_text(GTK_ENTRY(passEntry)), (size_t)MAX_USERNAME);
}

void loginChanged (GtkEditable *editable, gpointer data)
{   
    strncpy(UserName,(char *)gtk_entry_get_text(GTK_ENTRY(loginEntry)), (size_t)MAX_PASSLEN);
}   


const char *getPass (const char *prompt)
{
  GtkWidget *passwin, *vbox, *hbox, *hbox1, *vbox1, *vbox2, *labell, *labelp, *yes, *no;
#if GTK_MAJOR_VERSION == 1
	GtkWidget *sep;
#endif

	hasAskedPWD=1;

	if(passWord[0] != (char)NULL)
	{
		if(DEBUG)
			printf("Password already set to %s\n",passWord);
		maxPassTry++;
		if(DEBUG)
			printf("%i try by Cups-Server !\n",maxPassTry);
		if(maxPassTry < MAX_PASSTRY)
		{
			return((const char *)passWord);
		}
		else
		{
			if(DEBUG)
				printf("Too many Password-requests from Server. Maybe the User entered it wrong !\n");
			maxPassTry=0;
		}
		
	}

	while (gtk_events_pending())
		gtk_main_iteration();

#if GTK_MAJOR_VERSION == 1
  passwin = gtk_window_new (GTK_WINDOW_DIALOG);
#else
	passwin = gtk_dialog_new();
#endif

  gtk_window_set_title (GTK_WINDOW (passwin), _("Password verification"));
  gtk_window_set_policy (GTK_WINDOW (passwin), FALSE, FALSE, TRUE);
	gtk_widget_show(passwin);
	gtk_window_set_transient_for(GTK_WINDOW(passwin),GTK_WINDOW(mainWindow));

	gtk_window_set_position(GTK_WINDOW(passwin),GTK_WIN_POS_CENTER);
	gtk_window_set_modal(GTK_WINDOW(passwin),TRUE);
	gtk_widget_grab_focus (passwin);

	vbox = gtk_vbox_new (FALSE, INFRAME_SPACING_V);
#if GTK_MAJOR_VERSION == 1
	gtk_container_add (GTK_CONTAINER(passwin), vbox);
#else
	gtk_container_add (GTK_CONTAINER(GTK_DIALOG(passwin)->vbox), vbox);
#endif
	gtk_widget_show (vbox);

  hbox=gtk_hbox_new (FALSE, INFRAME_SPACING_H);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, INFRAME_SPACING_H);
  gtk_widget_show(hbox);

	vbox1=gtk_vbox_new (FALSE, INFRAME_SPACING_H);
	gtk_box_pack_start (GTK_BOX (hbox), vbox1, FALSE, FALSE, INFRAME_SPACING_H);
	gtk_widget_show(vbox1);

	vbox2=gtk_vbox_new (FALSE, INFRAME_SPACING_H);
	gtk_box_pack_start (GTK_BOX (hbox), vbox2, FALSE, FALSE, INFRAME_SPACING_H);
	gtk_widget_show(vbox2);

  labell = gtk_label_new (_("Login:"));
  gtk_box_pack_start (GTK_BOX (vbox1), labell, FALSE, FALSE, 0*INFRAME_SPACING_V);
  gtk_widget_show (labell);

	labelp = gtk_label_new (_("Password:"));
	gtk_box_pack_start (GTK_BOX (vbox1), labelp, FALSE, FALSE, 0*INFRAME_SPACING_V);
	gtk_widget_show (labelp);

	loginEntry = gtk_entry_new();
	gtk_entry_set_text(GTK_ENTRY(loginEntry), (char *)cupsUser());
	gtk_entry_set_max_length(GTK_ENTRY(loginEntry),MAX_USERNAME);
	gtk_entry_set_visibility(GTK_ENTRY(loginEntry),TRUE);
	gtk_box_pack_start (GTK_BOX (vbox2), loginEntry, FALSE, FALSE, 0*INFRAME_SPACING_V);
	gtk_widget_show (loginEntry);

  passEntry = gtk_entry_new ();
	gtk_entry_set_max_length(GTK_ENTRY(passEntry),MAX_PASSLEN);
	gtk_entry_set_visibility(GTK_ENTRY(passEntry),FALSE);
  gtk_box_pack_start (GTK_BOX (vbox2), passEntry, FALSE, FALSE, 0*INFRAME_SPACING_V);
	gtk_widget_grab_focus (passEntry);
  gtk_widget_show (passEntry);

#if GTK_MAJOR_VERSION == 1
  sep = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), sep, FALSE, FALSE, 0);
  gtk_widget_show (sep);
#endif

  hbox1= gtk_hbox_new (FALSE, INFRAME_SPACING_H);
  gtk_box_set_homogeneous (GTK_BOX (hbox1), TRUE);
#if GTK_MAJOR_VERSION == 1
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, TRUE, TRUE, INFRAME_SPACING_V);
#else
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(passwin)->action_area), hbox1);
#endif
  gtk_widget_show (hbox1);

  yes = gtk_button_new_with_label (_("Ok"));
  gtk_box_pack_start (GTK_BOX (hbox1), yes, FALSE, FALSE, BUTTON_SPACING_H);
  gtk_widget_show (yes);

  no = gtk_button_new_with_label (_("Cancel"));
  gtk_box_pack_start (GTK_BOX (hbox1), no, FALSE, FALSE, BUTTON_SPACING_H);
  gtk_widget_show (no);

  gtk_signal_connect_object (GTK_OBJECT (yes), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),GTK_OBJECT(passwin));
	gtk_signal_connect_object (GTK_OBJECT (no), "clicked", GTK_SIGNAL_FUNC (passNO),GTK_OBJECT(passwin));

	gtk_signal_connect (GTK_OBJECT (passwin), "destroy",GTK_SIGNAL_FUNC (passDestroy), NULL);
	gtk_signal_connect (GTK_OBJECT (passEntry), "changed",GTK_SIGNAL_FUNC (passChanged),NULL);
	gtk_signal_connect (GTK_OBJECT (loginEntry), "changed",GTK_SIGNAL_FUNC (loginChanged),NULL);
	gtk_signal_connect_object (GTK_OBJECT (passEntry), "activate",GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT(passwin));


	passActive=1;

	while(passActive==1)
	{
		while (gtk_events_pending())
    	      gtk_main_iteration();
	}
	if(DEBUG)
		printf("Passwort set to:%s\n",passWord);

	if(UserName[0] != (char)NULL)
		cupsSetUser(UserName);

	return(passWord);

}

int noX(void)
{
	Display *display;
	int ret;

	ret=0;

	if(getenv("DISPLAY") == NULL) {
		ret=1;
	}
	else {
		display=XOpenDisplay(getenv("DISPLAY"));
		if(display == NULL) {
			ret=1;
		}
		else {
			XCloseDisplay(display);
		}
	}

	if(DEBUG)
		printf("No-X: %i\n",ret);

	return(ret);
}

int max(int a, int b) {
	if(a > b)
		return(a);
	else
		return(b);
}

void button_pad(GtkWidget  *widget)
{
	GtkWidget *lab = GTK_BIN(widget)->child;
	if (GTK_IS_LABEL(lab))
		gtk_misc_set_padding(GTK_MISC(lab), BUTTON_PAD, 0);
}


void hello( GtkWidget *widget,gpointer   data )
{
				        g_print ("Hello World\n");
}



