#include <config.h>

#include "ppd.h"

#include <string.h>
#include <gtk/gtk.h>
#include <cups/ppd.h>

#include <gettext.h>
#include <defaults.h>
#include <libgtklp.h>

#include "gtklp.h"
#include "gtklp_functions.h"

GtkWidget *FrameHBox, *FrameVBox;
GtkWidget *ppdTab, *ppdFrame;

int ppd_entry_count;


int togglePPDOption(ppd_group_t *group,int ct,int nummer, int enable) {
	int i1,i2;
	ppd_option_t *option;
	ppd_choice_t *choice;
	ppd_group_t *subgroup;

	for(i1=group->num_options, option=group->options; i1*ct>0; i1--, option++)
	{
		if((strcmp(option->keyword,"PageSize") != 0) &&
		   (strcmp(option->keyword,"InputSlot") != 0) &&
		   (strcmp(option->keyword,"MediaType") != 0) &&
		   (strcmp(option->keyword,"Duplex") != 0))
		{
			for(i2=option->num_choices, choice=option->choices; i2*ct>0; i2--, choice++)
			{
				if(nummer == ct)
				{
					printf("\nChanged(enable=%i): %i: %s(%s)=%s(%s)\n",
					       enable,ct,option->keyword, option->text, choice->choice, choice->text);
					if(enable == 1)
					{
						constraints(ppdMarkOption(printerPPD,option->keyword,choice->choice));
					}
					else
					{
						choice->marked=0;
						constraints(ppdConflicts(printerPPD));
					}
					ct=-1;
				}
				else
				{
					ct++;
				}
			}
		}
	}

	for(i1=group->num_subgroups, subgroup=group->subgroups; i1*ct>0; i1--, subgroup++)
		ct=togglePPDOption(group,ct,nummer,enable);

	return(ct);
}

void enablePPDOption(int nummer) {
	int i1;
	int ct;
	ppd_group_t *group;

	printf("Enable %i\n",nummer);

	ct=1;
	for(i1=printerPPD->num_groups, group=printerPPD->groups; i1*ct>0; i1--, group++)
		ct=togglePPDOption(group,ct,nummer,1);

}

void disablePPDOption(int nummer) {
	int i1;
	int ct;
	ppd_group_t *group;

	printf("Disable %i\n",nummer);

	ct=1;
	for(i1=printerPPD->num_groups, group=printerPPD->groups; i1*ct>0; i1--, group++)
		ct=togglePPDOption(group,ct,nummer,0);

}

void PPD_Multi_changed(GtkWidget  *widget, int  data)
{
	printf("PPD_Multi changed %s -> %i\n",
	       gtk_widget_get_name(widget), data);
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)))
		enablePPDOption(data);
	else
		disablePPDOption(data);
}


void addPPDGroup(ppd_group_t *group)
{
    int			 i1,i2;
    int			 marked_choice, default_choice;
	ppd_option_t *option;
	ppd_choice_t *choice;
	ppd_group_t *subgroup;
    GtkWidget		*option_box, *label=NULL, *group_frame, *group_box;
    GtkWidget		*ppdWidget, *frame=NULL, *vbox=NULL;
	GList *list;

	/* Option types: PPD_UI_BOOLEAN PPD_UI_PICKONE PPD_UI_PICKMANY */

			if(DEBUG)
	printf("--- Adding Group %s: \n", group->text);
		
    group_frame = gtk_frame_new(group->text);
    gtk_box_pack_start(GTK_BOX(FrameVBox), group_frame, FALSE, FALSE, FRAME_SPACING_V);
    /* gtk_container_set_border_width(GTK_CONTAINER(group_frame), 5); */
    gtk_widget_show(group_frame);

    group_box = gtk_vbox_new(FALSE, 1);
    gtk_container_add(GTK_CONTAINER(group_frame), group_box);
    gtk_container_set_border_width(GTK_CONTAINER(group_box), VBOX_BORDER);
    gtk_widget_show(group_box);

    for(i1 = 0, option = group->options;
	i1 < group->num_options;
	i1++, option++)
    {
	if((strcmp(option->keyword,"PageSize") != 0) &&
	   (strcmp(option->keyword,"InputSlot") != 0) &&
	   (strcmp(option->keyword,"MediaType") != 0) &&
	   (strcmp(option->keyword,"Duplex") != 0))
	{
	    if(DEBUG)
		printf("Creating widget for <%s> - '%s' from type %i\n",
		       option->keyword, option->text, option->ui);

	    option_box = gtk_hbox_new(FALSE, 8);
	    gtk_box_pack_start(GTK_BOX(group_box), option_box, FALSE, FALSE, 1);
	    gtk_widget_show(option_box);

	    list = NULL;
		
	    marked_choice = -1;
	    default_choice = -1;

	    for(i2 = 0, choice = option->choices;
		i2 < option->num_choices;
		i2++, choice++)
			{
				ppd_entry_count++;

				switch(option->ui)
				{
					case PPD_UI_BOOLEAN:
					case PPD_UI_PICKONE:
						/* eventuell mit g_locale_to_utf8(variable,-1,NULL,NULL,NULL)) */
						if(choice->text == NULL)
			    list = g_list_append(list,choice->choice);
						else
			    list = g_list_append(list,choice->text);

			if (strcmp(choice->text, option->defchoice) == 0)
			    default_choice = i2;

			if (choice->marked)
			    marked_choice = i2;

					break;
					case PPD_UI_PICKMANY:
			if((strcmp(choice->text, "None") == 0) ||
			   (strcmp(choice->choice, "None") == 0))
								break;

			if (vbox == NULL)
			{
			    vbox = gtk_vbox_new(FALSE, INFRAME_SPACING_V);
			    gtk_container_set_border_width(GTK_CONTAINER(vbox), VBOX_BORDER);
			    gtk_widget_show(vbox);
			}

							if(choice->text == NULL)
			    ppdWidget = gtk_check_button_new_with_label(choice->choice);
							else
			    ppdWidget = gtk_check_button_new_with_label(choice->text);

							if(choice->marked)
			    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ppdWidget), TRUE);

			gtk_box_pack_start(GTK_BOX(vbox), ppdWidget, FALSE, FALSE, 0);
			gtk_signal_connect(GTK_OBJECT(ppdWidget), "toggled",
					   GTK_SIGNAL_FUNC(PPD_Multi_changed),
					   (int *) ppd_entry_count);
							gtk_widget_show(ppdWidget);
					break;
					default:
						if(DEBUG)
							printf("Unknown OpenGroup-Type at 1 !\n");
						emergency();
					break;
				}

				if(choice->marked)
				{
					if(DEBUG)
						printf("Default: %s\n",choice->choice);
				}
			}

			switch(option->ui)
			{
				case PPD_UI_BOOLEAN:
				case PPD_UI_PICKONE:
		    label = gtk_label_new(option->text);
		    gtk_box_pack_start(GTK_BOX(option_box), label, TRUE, TRUE, 1);
		    gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
		    gtk_widget_show(label);

		    ppdWidget = gtk_combo_new();

		    if(list == (GList *) NULL)
			list=g_list_append(list, "");

		    gtk_combo_set_popdown_strings (GTK_COMBO(ppdWidget), list);	
		    gtk_combo_set_value_in_list(GTK_COMBO(ppdWidget), TRUE, FALSE);
		    gtk_list_set_selection_mode(GTK_LIST(GTK_COMBO(ppdWidget)->list), 
						GTK_SELECTION_SINGLE);
		    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(ppdWidget)->entry), FALSE);

		    if(default_choice >= 0)
			gtk_list_select_item(GTK_LIST(GTK_COMBO(ppdWidget)->list), default_choice);

		    if(marked_choice >= 0)
			gtk_list_select_item(GTK_LIST(GTK_COMBO(ppdWidget)->list), marked_choice);

		    gtk_box_pack_start(GTK_BOX(option_box), ppdWidget, FALSE, FALSE, 0);
		    gtk_signal_connect(GTK_OBJECT(GTK_COMBO(ppdWidget)->entry), "changed",
				       GTK_SIGNAL_FUNC(PPD_DropDown_changed), option->keyword);
					gtk_widget_show(ppdWidget);
				break;
				case PPD_UI_PICKMANY:
		    /* label = gtk_label_new(option->text); */
		    /* gtk_box_pack_start(GTK_BOX(option_box), label, TRUE, TRUE, 1); */
		    /* gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5); */
		    /* gtk_widget_show(label); */

		    /* gtk_box_pack_start(GTK_BOX(option_box), vbox, FALSE, FALSE, 0); */

		    frame = gtk_frame_new(option->text);
		    gtk_container_set_border_width(GTK_CONTAINER(frame), 5);
		    gtk_box_pack_start(GTK_BOX(option_box), frame, TRUE, TRUE, 1);
		    gtk_widget_show(frame);

		    gtk_container_add(GTK_CONTAINER(frame), vbox);
		    vbox = NULL;
				break;
				default:
					if(DEBUG)
						printf("Unknown OpenGroup-Type at 2 !\n");
					emergency();
				break;
			}

		}
		else
		{
			if(DEBUG)
				printf("Ignoring: %s\n",option->keyword);
		}
	}

	for(i1=group->num_subgroups, subgroup=group->subgroups; i1>0; i1--, subgroup++)
		addPPDGroup(subgroup);
}


void ppdTabSetDefaults(void)
{
	int i1;
	ppd_group_t *group;

	if(DEBUG)
		printf("Get ppdDefaults\n");
	gtk_widget_destroy(FrameVBox);
	FrameVBox=gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(FrameHBox), FrameVBox, TRUE, TRUE, FRAME_SPACING_V);
	gtk_widget_show(FrameVBox);

	ppd_entry_count=0;

	if(printerPPD != NULL) 
	{
		for(i1=printerPPD->num_groups, group=printerPPD->groups; i1>0; i1--, group++)
			addPPDGroup(group);
	}
}

void PPDFrame(GtkWidget *container)
{
	GtkWidget *frameScrolled;

	frameScrolled=gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(frameScrolled),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(container), frameScrolled, TRUE, TRUE, 0);
	gtk_widget_show(frameScrolled);

        FrameHBox=gtk_hbox_new(FALSE,0);
        gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(frameScrolled), FrameHBox);
        gtk_widget_show(FrameHBox);    

        FrameVBox=gtk_vbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(FrameHBox), FrameVBox, FALSE,FALSE,FRAME_SPACING_V);
        gtk_widget_show(FrameVBox);

}

void PPDTab(void)
{
	ppdTab=gtk_vbox_new(FALSE,0);
	gtk_notebook_append_page(GTK_NOTEBOOK(tabs), ppdTab, gtk_label_new(_("PPD")));
	PPDFrame(ppdTab);

}
