// osziview.cc
//
//    oszi - widget for gtk--
//
//    Copyright (C) 1999  Florian Berger
//    Email: florian.berger@jk.uni-linz.ac.at
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License Version 2 as
//    published by the Free Software Foundation;
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

#include <stdio.h>
#include <string.h>

#include <math.h>

#include "resources.h"

#include "osziview.h"

#include <gtk--/style.h>
#include <gdk--/color.h>
#include <math.h>

#define xscr 20
#define yscr 5
#define wscr (width()-xscr*2)
#define hscr (height()-yscr-20)

OsziView::OsziView() : Gtk::DrawingArea()
{
    i_col_bg.   set("black");         get_colormap().alloc(i_col_bg   );
    i_col_trig. set("cyan" );         get_colormap().alloc(i_col_trig );
    i_col_mark. set("red"  );         get_colormap().alloc(i_col_mark );
    i_col_data. set("green");         get_colormap().alloc(i_col_data );
    i_col_scale.set("rgb:B8/B8/B8");  get_colormap().alloc(i_col_scale);
    i_col_ticks.set("rgb:6/6/6");     get_colormap().alloc(i_col_ticks);
    i_col_zero. set("gray" );         get_colormap().alloc(i_col_zero );
    trigfact=0.6;
    i_adaptive_scale=1;
}


OsziView::~OsziView() {};


void OsziView::calc_minmax(void)
{
    int i;
    unsigned char * samp_uc;
    short int *     samp_s16le;

    samp_s16le =     (short int *) samp;
    samp_uc    = (unsigned char *) samp;

    if(i_sampfmt == U8){
        i_minsamp=255;
        i_maxsamp=0;
        for(i=0;i<sampnr;i++){
            if ( samp_uc[i-1] > i_maxsamp ) i_maxsamp = samp_uc[i-1];
            if ( samp_uc[i-1] < i_minsamp ) i_minsamp = samp_uc[i-1];
        }
        if ( !i_adaptive_scale ){
            i_divisor = 0x100;
        } else {
            i_divisor = 8;
            if ( 2*Abs(i_maxsamp-128) > i_divisor ) i_divisor=2*Abs(i_maxsamp-128);
            if ( 2*Abs(i_minsamp-128) > i_divisor ) i_divisor=2*Abs(i_minsamp-128);
        }
    } else if(i_sampfmt == S16_LE){
        i_minsamp= 33000;
        i_maxsamp=-33000;
        for(i=0;i<sampnr;i++){
            if ( samp_s16le[i-1] > i_maxsamp ) i_maxsamp = samp_s16le[i-1];
            if ( samp_s16le[i-1] < i_minsamp ) i_minsamp = samp_s16le[i-1];
        }
        if ( !i_adaptive_scale ){
            i_divisor = 0x10000;
        } else {
            i_divisor = 2048;
            if ( 2*Abs(i_maxsamp) > i_divisor ) i_divisor=2*Abs(i_maxsamp);
            if ( 2*Abs(i_minsamp) > i_divisor ) i_divisor=2*Abs(i_minsamp);
        }
    }
}


void OsziView::paintSample(void)
{
    int i,x1,x2,y1,y2;
    unsigned char * samp_uc;
    short int *     samp_s16le;
    //erase();
    samp_s16le =     (short int *) samp;
    samp_uc    = (unsigned char *) samp;

    if (!i_GC){
        Gdk_Window win = get_window();
        i_GC = Gdk_GC( win );
    }

    i_GC.set_foreground(i_col_bg);
    get_window().
        draw_rectangle( i_GC, true, xscr,yscr,wscr+1,hscr+1 );

    i_GC.set_foreground(i_col_zero);
    get_window().
        draw_line( i_GC, xscr,yscr+hscr/2,xscr+wscr-1,yscr+hscr/2);

    i_GC.set_foreground(i_col_data);
    for(i=1;i<sampnr;i++){
        x1=xscr+(i-1)*wscr/sampnr;
        x2=xscr+i*wscr/sampnr;
        if(i_sampfmt == U8){
            y1=yscr+(samp_uc[i-1]-128+i_divisor/2)*hscr/i_divisor;
            y2=yscr+(samp_uc[i]-128+i_divisor/2)*hscr/i_divisor;
        } else if(i_sampfmt == S16_LE){
            y1=yscr+((int)samp_s16le[i-1]+i_divisor/2)*hscr/i_divisor;
            y2=yscr+((int)samp_s16le[i]  +i_divisor/2)*hscr/i_divisor;
        }
        get_window().draw_line( i_GC,  x1, y1, x2, y2 );
    }
    //printf("hallo\n");
}


double OsziView::getfreq(void)
   /* in units of sampfreq */
{
    int endpoint, tc, i;
    double freq;
    
    if (!i_GC){
        Gdk_Window win = get_window();
        i_GC = Gdk_GC( win );
    }

     endpoint=0;
    for( i=1, tc=0; i<sampnr; i++ )
        if( POSTRIG(samp,i) ) { endpoint=i; tc++; }
    freq = (double)tc/(double)endpoint;
    
    i_GC.set_foreground(i_col_mark);
    get_window().draw_line( i_GC, xscr+endpoint*wscr/sampnr,yscr,
                                  xscr+endpoint*wscr/sampnr,yscr+hscr );
    
    return(freq);
}


double OsziView::getfreq2(void)
/* in units of sampfreq */
{
    int endpoint, startpoint, t1, t2, A1, A2, tc, i, schmitt_triggered;
    double freq;
    short int *     samp_s16le;
    unsigned char * samp_uc;

    samp_s16le =     (short int *) samp;
    samp_uc    = (unsigned char *) samp;
    
    if(i_sampfmt==U8){
        for(i=0,A1=0;i<sampnr;i++)
            if (A1<Abs(samp_uc[i]-128) && samp_uc[i]-128>0) A1=Abs(samp_uc[i]-128);
        for(i=0,A2=0;i<sampnr;i++)
            if (A2<Abs(samp_uc[i]-128) && samp_uc[i]-128<0) A2=Abs(samp_uc[i]-128);
    } else if(i_sampfmt==S16_LE){
        for(i=0,A1=0;i<sampnr;i++)
            if (A1<Abs(samp_s16le[i]) && samp_s16le[i]>0) A1=Abs(samp_s16le[i]);
        for(i=0,A2=0;i<sampnr;i++)
            if (A2<Abs(samp_s16le[i]) && samp_s16le[i]<0) A2=Abs(samp_s16le[i]);
    }
//      A1 = (int)( (double)A*M_PI/2.0/(double)sampnr+0.5 );
//      A1 = (int)( (double)A*M_PI/2.0/(double)sampnr+0.5 );
    if(i_sampfmt==U8){
        t1 = 128 + (int)( A1 * trigfact + 0.5 );
        t2 = 128 - (int)( A2 * trigfact + 0.5 );
    } else if(i_sampfmt==S16_LE){
        t1 =   (int)( A1 * trigfact + 0.5 );
        t2 = - (int)( A2 * trigfact + 0.5 );
    }
    startpoint=0;
    if(i_sampfmt==U8){
        for( i=1; samp_uc[i]<=t1 && i<sampnr; i++ );
        for( ; !LEVTRIGN(samp_uc,i,t2) && i<sampnr; i++ );
    } else if(i_sampfmt==S16_LE){
        for( i=1; samp_s16le[i]<=t1 && i<sampnr; i++ );
        for( ; !LEVTRIGN(samp_s16le,i,t2) && i<sampnr; i++ );
    }
    startpoint=i;
    schmitt_triggered=NO;
    endpoint=startpoint+1;
    tc=0;
    if(i_sampfmt==U8){
        for( i=startpoint, tc=0; i<sampnr; i++ ) {
            if( !schmitt_triggered )
                schmitt_triggered = (samp_uc[i]>=t1);
            else if( LEVTRIGN(samp_uc,i,t2) ) {
                endpoint=i; tc++;
                schmitt_triggered = NO;
            }
        }
    } else if(i_sampfmt==S16_LE){
        for( i=startpoint, tc=0; i<sampnr; i++ ) {
            if( !schmitt_triggered )
                schmitt_triggered = (samp_s16le[i]>=t1);
            else if( LEVTRIGN(samp_s16le,i,t2) ) {
                endpoint=i; tc++;
                schmitt_triggered = NO;
            }
        }
    }
    if (endpoint==startpoint) endpoint++;
    freq = (double)tc/(double)(endpoint-startpoint);
    if (freq<1E-15) freq = 1E-15;

    i_GC.set_foreground(i_col_mark);
    get_window().draw_line( i_GC, xscr+endpoint*wscr/sampnr,yscr,
                                  xscr+endpoint*wscr/sampnr,yscr+hscr   );
    get_window().draw_line( i_GC, xscr+startpoint*wscr/sampnr,yscr,
                                  xscr+startpoint*wscr/sampnr,yscr+hscr );
    
    i_GC.set_foreground(i_col_trig);
    if(i_sampfmt==U8){
        get_window().
            draw_line( i_GC, xscr,yscr+(t1-128+i_divisor/2)*hscr/i_divisor,xscr+wscr,yscr+(t1-128+i_divisor/2)*hscr/i_divisor );
        get_window().
            draw_line( i_GC, xscr,yscr+(t2-128+i_divisor/2)*hscr/i_divisor,xscr+wscr,yscr+(t2-128+i_divisor/2)*hscr/i_divisor );
    } else if(i_sampfmt==S16_LE){
        get_window().
            draw_line( i_GC, xscr,yscr+(t1+i_divisor/2)*hscr/i_divisor,xscr+wscr,yscr+(t1+i_divisor/2)*hscr/i_divisor );
        get_window().
            draw_line( i_GC, xscr,yscr+(t2+i_divisor/2)*hscr/i_divisor,xscr+wscr,yscr+(t2+i_divisor/2)*hscr/i_divisor );
    }

    return(freq);
}


void OsziView::setSamplePtr(unsigned char *s) { samp = (short int *)s; i_sampfmt=U8;     calc_minmax(); }
void OsziView::setSamplePtr(short int *s)     { samp = (short int *)s; i_sampfmt=S16_LE; calc_minmax(); }


void OsziView::setSampleFreq(double f) { sampfreq = f; /*repaint();*/ }


void OsziView::setSampleNr(int nr) { sampnr = nr; /*repaint();*/ }


void OsziView::setAdaptive(int active) { i_adaptive_scale = active; /*repaint();*/ }


void OsziView::setTrigFact(double fact) { trigfact=fact; /*repaint();*/ }


double OsziView::getTrigFact() { return(trigfact); }


void OsziView::drawScale()
{
    double i,j;
    double di,dj;
    double dim; //mantissa of di
    char str[100];
//       printf("nr=%d, freq=%lf\n",nr,f);

    if (!i_GC){
        Gdk_Window win = get_window();
        i_GC = Gdk_GC( win );
    }

    i_GC.set_foreground(i_col_bg);
    get_window().
        draw_rectangle( i_GC, true, 0,0,width(),height() );
    
    di = (double)sampnr/sampfreq/10.0;
    for(dim=di;dim>=10.0;dim/=10.0);
    for(;dim<1.0;dim*=10.0);
    if (dim<=5.0)
    { di=di/dim*5.0; dim=5.0; }
    else
    { di=di/dim*10.0; dim=10.0;}
    dj=di/10.0;
    
    i_GC.set_foreground(i_col_ticks);
    for( j=0.0; j<(double)sampnr/sampfreq; j+=dj ){
        get_window().
            draw_line( i_GC, xscr+(j*sampfreq)*wscr/sampnr,yscr+hscr,
                             xscr+(j*sampfreq)*wscr/sampnr,yscr+hscr+3 );
    }
    
    if (dim!=5.0){
        dj=di/2.0;
        i_GC.set_foreground(i_col_scale);
        for( j=0.0; j<(double)sampnr/sampfreq; j+=dj ){
            get_window().
                draw_line( i_GC, xscr+(j*sampfreq)*wscr/sampnr,yscr+hscr,
                                 xscr+(j*sampfreq)*wscr/sampnr,yscr+hscr+5 );
        }
    }
    
//         paint.eraseRect(xscr,yscr+hscr,wscr,7);
    i_GC.set_foreground(i_col_scale);
    Gdk_Font font("5x8");
    i_GC.set_font( font );
    
    for( i=0.0; i<(double)sampnr/sampfreq; i+=di ){
        
        get_window().
            draw_line( i_GC, xscr+(i*sampfreq)*wscr/sampnr,yscr+hscr,
                             xscr+(i*sampfreq)*wscr/sampnr,yscr+hscr+7 );
        
        sprintf(str,"%.0f",i*1000); // in ms

        get_window().
            draw_string(
                        font,
                        i_GC,
                        xscr+(i*sampfreq)*wscr/sampnr-
                        font.string_width(str)/2,
                        yscr+hscr+7+font.ascent(),
                        str
                       );
    }
}


gint OsziView::expose_event_impl(GdkEventExpose* p0)
{
    printf("executing OsziView::expose_event_impl(p0)\n");
    Gtk::DrawingArea::expose_event_impl(p0);
    drawScale();
}

/*
void OsziView::draw_default_impl()
{
    printf("executing OsziView::draw_default_impl()\n");
    Gtk::DrawingArea::draw_default_impl();
    drawScale();
}
*/
/*
void OsziView::draw_impl(GdkRectangle* p0)
{
    printf("executing OsziView::draw_impl(p0)\n");
    Gtk::DrawingArea::draw_impl(p0);
    drawScale();
}
*/